﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Amonestacion
{
    public class CtAmonestacionController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: CtAmonestacion
        public ActionResult Index()
        {
            return View(db.Juridico_ctAmonestacion.ToList());
        }

        // GET: CtAmonestacion/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_ctAmonestacion juridico_ctAmonestacion = db.Juridico_ctAmonestacion.Find(id);
            if (juridico_ctAmonestacion == null)
            {
                return HttpNotFound();
            }
            return View(juridico_ctAmonestacion);
        }

        // GET: CtAmonestacion/Create
        [HttpPost]
        public ActionResult Crear()
        {
            return View("Create");
        }

        // POST: CtAmonestacion/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdAmonestacion,Inciso,Descripcion,Ley,Vigente,Año")] Juridico_ctAmonestacion juridico_ctAmonestacion)
        {
            if (ModelState.IsValid)
            {
                db.Juridico_ctAmonestacion.Add(juridico_ctAmonestacion);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(juridico_ctAmonestacion);
        }

        // GET: CtAmonestacion/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_ctAmonestacion juridico_ctAmonestacion = db.Juridico_ctAmonestacion.Find(id);
            if (juridico_ctAmonestacion == null)
            {
                return HttpNotFound();
            }
            return View(juridico_ctAmonestacion);
        }

        // POST: CtAmonestacion/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdAmonestacion,Inciso,Descripcion,Ley,Vigente,Año")] Juridico_ctAmonestacion juridico_ctAmonestacion)
        {
            if (ModelState.IsValid)
            {
                db.Entry(juridico_ctAmonestacion).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(juridico_ctAmonestacion);
        }

        // GET: CtAmonestacion/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_ctAmonestacion juridico_ctAmonestacion = db.Juridico_ctAmonestacion.Find(id);
            if (juridico_ctAmonestacion == null)
            {
                return HttpNotFound();
            }
            return View(juridico_ctAmonestacion);
        }

        // POST: CtAmonestacion/Delete/5
        [HttpPost, ActionName("DeleteConfirmed")]
        //[ValidateAntiForgeryToken]
        public JsonResult DeleteConfirmed(short id)
        {
            Juridico_ctAmonestacion juridico_ctAmonestacion = db.Juridico_ctAmonestacion.Find(id);
            db.Juridico_ctAmonestacion.Remove(juridico_ctAmonestacion);
            db.SaveChanges();
            return new JsonResult() { Data = "Registro eliminado exitosamente" };
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
