﻿using Nova.Libraries;
using Nova.Models;
using Rotativa;
using System;
using System.Collections.Generic;
using System.Data.Linq.SqlClient;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Script.Serialization;
using System.Data.SqlClient;
using System.Data;
using Dapper;

namespace Nova.Controllers.Asignaturas
{
    
    public class AsignaturasController : Controller
    {
        //
        // GET: /Alumnos/
        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult Index()
        {
            return View();
        }

        // GET: /Alumnos/
        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult Aprovechamiento()
        {


            return View();
        }


        // GET: /Alumnos/
        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult TopRanking()
        {
            var x = Usuario.Alumno();
            ViewBag.RankingCampus = Nova.Models.Alumnos.getRankingCampus(x.Curp, x.Matricula);
            ViewBag.RankingCarrera = Nova.Models.Alumnos.getRankingCarrera(x.Curp, x.Matricula);

            return View();
        }




        [AllowAnonymous]

        public JsonResult getAprovechamiento()
        {

            var x = Usuario.Alumno();


            //var t = Json(Nova.Models.Alumnos.getAprovechamiento(x.Curp, x.Matricula), JsonRequestBehavior.AllowGet);
            var t = Nova.Models.Alumnos.getAprovechamiento(x.Curp, x.Matricula);

            JavaScriptSerializer js = new JavaScriptSerializer();
            var y = js.Serialize(t);

            return Json(y, JsonRequestBehavior.AllowGet);

        }

        [AllowAnonymous]
        public JsonResult getAprovechamientoArea()
        {

            var x = Usuario.Alumno();


            //var t = Json(Nova.Models.Alumnos.getAprovechamiento(x.Curp, x.Matricula), JsonRequestBehavior.AllowGet);
            var t = Nova.Models.Alumnos.getAprovechamientoArea(x.Curp, x.Matricula);

            JavaScriptSerializer js = new JavaScriptSerializer();
            var y = js.Serialize(t);

            return Json(y, JsonRequestBehavior.AllowGet);

        }

        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult HorarioVigente()
        {
            var x = Usuario.Alumno();

            ViewBag.Layout = "~/Views/Shared/_Alumnos2017.cshtml";
            return View("_HorarioVigente", Nova.Models.Alumnos.getHorarioVigente(x.Curp, x.Matricula));

        }

        [Authorize]
        public ActionResult HorarioDocenteVigente(int id,int anio,short qna,int idcltc=0)
        {
            ViewBag.TipoHorario = "";
            bdNovaEntities bd = new bdNovaEntities();
            vwDatosAspirantesTrabajadoresHistorial datostrabajador = new vwDatosAspirantesTrabajadoresHistorial();
            if (idcltc>0)
                datostrabajador = bd.vwDatosAspirantesTrabajadoresHistorial.Where(z => z.IdTrabajador == id && z.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();
            else
                datostrabajador = bd.vwDatosAspirantesTrabajadoresHistorial.Where(z => z.IdTrabajador == id).FirstOrDefault();

            var x = Usuario.Alumno();
            // var h = new List<HorarioVigente>();

            var listadehorarios = new HorariosVigentes();
            var h = new List<HorarioVigente>();

            bool esdocente = false;
            bool existeHorarioAnterior = false;
            if (datostrabajador.RelacionLaboral == "DOCENTE")
            {
                esdocente = true;
                
                //h = Nova.Models.Alumnos.getHorarioDocenteVigente(datostrabajador.IdKardex);

                ///var x = Usuario.Alumno();
                var mes = bd.Catalogos_ctQuincenaMes.Where(z => z.IdQuincenaMes == qna).FirstOrDefault();

                int daysInMonth = System.DateTime.DaysInMonth(anio, mes.IdMes);
                var fecha = DateTime.Parse(anio.ToString() + "-" + mes.IdMes + "-" + daysInMonth.ToString());

                listadehorarios = Nova.Models.Alumnos.getHorarioDocenteVigente(datostrabajador.IdKardex, fecha.ToString("yyyyMMdd"));
                h = listadehorarios.Vigente;
                if (h.Count() == 0)
                {
                    h = Nova.Models.Alumnos.getHorarioEspecialVigente(datostrabajador.IdKardex);
                    if (h.Count() == 0)
                    {
                        h = Nova.Models.Alumnos.getHorarioConvenioVigente(datostrabajador.IdKardex);
                        if (h.Count > 0)
                        {
                            ViewBag.TipoHorario = "Convenio Laboral";
                        }
                        return PartialView("_HorarioAdministrativo", h);
                    }
                    else
                    {
                        ViewBag.TipoHorario = "Especial";
                        return PartialView("_HorarioAdministrativo", h);
                    }


                }
                else {
                    if (listadehorarios.Anterior.Count > 0)
                    {
                        existeHorarioAnterior = true;
                    }
                }

               ViewBag.esdocente= esdocente;
                ViewBag.existeHorarioAnterior = existeHorarioAnterior;
                ViewBag.horarioAnterior = listadehorarios.Anterior;
                return PartialView("_HorarioDocente", h);
            }
            else
            {
                h = Nova.Models.Alumnos.getHorarioEspecialVigente(datostrabajador.IdKardex);
                if (h.Count() == 0)
                {
                    h = Nova.Models.Alumnos.getHorarioConvenioVigente(datostrabajador.IdKardex);
                    if (h.Count() > 0)
                    {
                        ViewBag.TipoHorario = "Convenio Laboral";
                    }
                    return PartialView("_HorarioAdministrativo", h);
                }
                ViewBag.TipoHorario = "Especial";
                return PartialView("_HorarioAdministrativo", h);
            }

        }


        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult HorarioAsignatura(long Id)
        {

            return PartialView("_HorarioAsignatura", Nova.Models.Alumnos.getHorarioAsignatura(Id));

        }

        [HttpPost]
        [AllowAnonymous]
        public JsonResult getCalificacionesHorarios(long Id)
        {
            var t = Json(Nova.Models.Alumnos.getCalificaciones(Id), JsonRequestBehavior.AllowGet);
            return t;

        }

        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult Kardex()
        {
            var x = Usuario.Alumno();
            return View(Nova.Models.Alumnos.getKardex(x.Curp, x.Matricula));


        }



        [AllowAnonymous]
        public ActionResult Boletas(short idgruponombre, short idcicloescolar, short idcampus, string periodo)
        {
            ViewBag.Layout = null;
            string namefile = "Boleta_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);

            var listaalumnos = Nova.Models.Alumnos.getAlumnosPorGrupo(idgruponombre, idcampus, idcicloescolar);
            List<List<KardexAlumno>> alumnos = new List<List<KardexAlumno>>();

            foreach (var item in listaalumnos)
            {
                alumnos.Add(Nova.Models.Alumnos.getBoleta(item.Curp, item.Matricula, item.IdCicloEscolar, periodo));
            }

            ViewBag.Periodo = periodo;
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 15;
            m.Right = 15;
            m.Top = 5;
            return new ViewAsPdf("ImprimirBoleta", alumnos) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = namefile };

            //return View("Boleta",alumnos);


        }



        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult Boleta()
        {

            ViewBag.Layout = " ~/Views/Shared/_Alumnos2017.cshtml";
            //return new ViewAsPdf(Nova.Models.Alumnos.getBoleta(curp, matricula, cicloescolar, "Extraordinario")) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = modalidad };

            var listaalumnos = Nova.Models.Alumnos.getAlumnosCiclos(Usuario.Alumno().Curp, Usuario.Alumno().Matricula);
            List<List<KardexAlumno>> alumnos = new List<List<KardexAlumno>>();

            foreach (var item in listaalumnos)
            {
                alumnos.Add(Nova.Models.Alumnos.getBoleta(item.Curp, item.Matricula, item.IdCicloEscolar, item.Periodo));
            }




            return View(alumnos);


        }
        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult TestBoleta(string curp, string matricula)
        {

            ViewBag.Layout = " ~/Views/Shared/_Alumnos2017.cshtml";
            //return new ViewAsPdf(Nova.Models.Alumnos.getBoleta(curp, matricula, cicloescolar, "Extraordinario")) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = modalidad };

            var listaalumnos = Nova.Models.Alumnos.getAlumnosCiclos(curp, matricula);
            List<List<KardexAlumno>> alumnos = new List<List<KardexAlumno>>();

            foreach (var item in listaalumnos)
            {
                alumnos.Add(Nova.Models.Alumnos.getBoleta(item.Curp, item.Matricula, item.IdCicloEscolar, item.Periodo));
            }




            return View("Boleta",alumnos);


        }

        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult ImprimirBoleta(string curp, string matricula, short cicloescolar, string periodo)
        {

            string modalidad = "Boleta_" + curp + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 15;
            m.Right = 15;
            m.Top = 5;



            List<List<KardexAlumno>> alumnos = new List<List<KardexAlumno>>();
            alumnos.Add(Nova.Models.Alumnos.getBoleta(curp, matricula, cicloescolar, periodo));

            return new ViewAsPdf(alumnos) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = modalidad };

        }

        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
        public ActionResult Perfil()
        {
            return View();
        }

        //[AllowAnonymous]
        //public ActionResult getFotografiaDocenteasdsd(string id)
        //{

        //    bdNovaEntities bd = new bdNovaEntities();
        //    List<Kardex_ctDatosPersonales> foto = bd.Kardex_ctDatosPersonales.Where(e => e.CURP == id).ToList();
        //    string tipo = "jpg";
        //    byte[] image = Nova.Models.Alumnos.getFotografiaDocente(id, ref tipo, foto);
        //    //string tipo = PortalNovaAries.getTipoFotografia(id);
        //    if (image != null)
        //        return File(image, tipo);
        //    else
        //        return null;
        //}

        [HttpPost]
        [AllowAnonymous]
        public virtual JsonResult getFotografiaDocente(string id)
        {
            //var filePath = "~/Images/PngExampleImag.png";
            //var ImageBytes = System.IO.File.ReadAllBytes(Server.MapPath(filePath));

            //var data = Convert.ToBase64String(ImageBytes);
            //return Json(data);

            bdNovaEntities bd = new bdNovaEntities();
            var c = id.Substring(0, 10);
            Kardex_ctDatosPersonalesFotografias foto = bd.Kardex_ctDatosPersonalesFotografias.Where(e => e.IdKardex==ConvertToInt.ConvertToInt32(id)).FirstOrDefault();
            string tipo = "jpg";
            byte[] image = Nova.Models.Alumnos.getFotografiaDocente(id, ref tipo, foto);
            //string tipo = PortalNovaAries.getTipoFotografia(id);
            var data = "";
            if (image != null)
                data = Convert.ToBase64String(image);

            return Json(new { Image = data, JsonRequestBehavior.AllowGet });
            // return Json(data);
        }

        [AllowAnonymous]
        public ActionResult getFotografia(string id)
        {

            

            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;

            query = @"select Curp
      ,Foto
      ,TipoImagen
      ,QrCodigo
from stAlumnosFotos
where Curp='" + id + "' ";




            var foto = (List<stAlumnosFotos>)dp.connection.Query<stAlumnosFotos>(query);
            dp.Close();

            string tipo = "jpg";
            byte[] image = Nova.Models.Alumnos.getFotografia(id, ref tipo, foto);
            //string tipo = PortalNovaAries.getTipoFotografia(id);
            if (image != null)
                return File(image, tipo);
            else
                return null;
        }


    }


}