﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Text;
using System.Web;
using System.Web.Mvc;
using System.Web.Script.Serialization;

namespace Nova.Controllers.Alumnos
{
    public class ServiciosSiox
    {

        public string Clave { get; set; }
        public string Servicio { get; set; }
        public int Cantidad { get; set; }
        public decimal Importe { get; set; }
        public decimal Descuento{ get; set; }

        
    }

    public class LineaCapturaSiox
    {

        public string Documento { get; set; }
        public string LineaCaptura { get; set; }
        public decimal Importe { get; set; }
        public string Vigencia { get; set; }


    }
    public class AlumnosIngresosController : Controller
    {
        //
        // GET: /AlumnosIngresos/
        bdAriesEntities bd = new bdAriesEntities();
        List<ctPagoServicio> listadeServicio = new List<ctPagoServicio>();

        private void alumnoactual(string curp=null)
        {
            AlumnosIngresos ingreso = new AlumnosIngresos();
            string curpalumno="";
             
            var infoalumno= new ctAlumnos();

            if (curp == null)
            {
                curpalumno = Usuario.Alumno().Curp;
                 infoalumno = ingreso.InformacionAlumno(Usuario.Alumno().Curp);

            }
            else
            {
                
                curpalumno = curp;
                infoalumno = ingreso.InformacionAlumno(curpalumno);
                if (infoalumno == null)
                    throw new ApplicationException("El Alumno no existe en nuestra base de datos");
            }

            
             ViewBag.Alumno = infoalumno;
             ViewBag.UltimoPromedioAlumno = ingreso.UltimoPromedioAlumno(curpalumno);

             ViewBag.Exento = ingreso.AlumnoExento(curpalumno);

            ViewBag.CatalogoServicios = bd.ctPagoServicio.ToList();
            ViewBag.ServiciosDisponibles = ingreso.ServiciosDisponibles(curpalumno);
        }
        [AllowAnonymous]
        public ActionResult Pagos(string id)
        {
            ViewBag.layout = "No";
            alumnoactual(id);

            return View("Index");
        }

        [AlumnosAuthorize]
        [HasPermission("Alumnos")]
      
        public ActionResult Index()
        {
            ViewBag.layout = "Si";
            //AlumnosIngresos ingreso = new AlumnosIngresos();
            //ViewBag.Alumno = ingreso.InformacionAlumno(Usuario.Alumno().Curp);
            //ViewBag.UltimoPromedioAlumno = ingreso.UltimoPromedioAlumno(Usuario.Alumno().Curp);

            //ViewBag.Exento = ingreso.AlumnoExento(Usuario.Alumno().Curp);
            
            //ViewBag.CatalogoServicios = bd.ctPagoServicio.ToList();
            //ViewBag.ServiciosDisponibles = ingreso.ServiciosDisponibles(Usuario.Alumno().Curp, Usuario.Alumno().IdPlanEstudio);
            alumnoactual();
            return View();
        }

        private  string[] decodificacadena(string id)
    {
        var datos = id.Split(new string[] { "|" }, StringSplitOptions.None).Where(f => f.Trim().Length > 0).ToArray();
        string[] ArrayClaves = new string[datos.Count()];

        for (int i = 0; i < datos.Count(); i++)
        {
            var datosinternos = datos[i].Split(new string[] { "," }, StringSplitOptions.None).Where(f => f.Trim().Length > 0).ToArray();

            int idservicio = Libraries.ConvertToInt.ConvertToInt16(datosinternos[0]);
            var Servicio = bd.ctPagoServicio.Where(f => f.IdPagoServicio == idservicio).FirstOrDefault();
           // ArrayClaves.SetValue(Servicio.cveServicio + "|" + datosinternos[1] + "|" + datosinternos[2], i);
            var descto =0;
            var desctsolicitado = Libraries.ConvertToInt.ConvertToInt16(datosinternos[2]);
            if (desctsolicitado > 0 && desctsolicitado < 100)
                descto = 100 - desctsolicitado;
            else 
                if (desctsolicitado == 100)
                descto = 100;

            ArrayClaves.SetValue(Servicio.cveServicio + "|" + datosinternos[1] + "|" + descto.ToString(), i);
        }

        return ArrayClaves;
        }

        [AllowAnonymous]
        
        public JsonResult Presupuesto(string id)
        {

            var ArrClavestempo =decodificacadena(id);

            var ArrClaves = ArrClavestempo.Where(f => !f.Contains("|100")).ToArray();
            var ArrClavesenCeros = ArrClavestempo.Where(f => f.Contains("|100")).ToArray();

 

            List<ServiciosSiox> Servicios = new List<ServiciosSiox>();

            Siox.CecyteClient swsiox = new Siox.CecyteClient();
          
            try
            {
                if (ArrClaves.Count() > 0)
                {
                    swsiox.Open();
                    var resultado = swsiox.presupuesto(ArrClaves);
                    var registrosSiox = resultado.Split('|');
                    //string SubtotalSap = "";
                    //string ImporteSap = "";
                    //string ImpuestoSap = "";


                    if (resultado != "")
                    {
                        string[] elementosSiox;
                        string[] ColumnasSiox;


                        for (int i = 0; i < 1; i++)
                        {
                            elementosSiox = registrosSiox[i].Split(new string[] { "%%" }, StringSplitOptions.None);

                            for (int e = 0; e < ArrClaves.Count() + 2; e++)
                            {
                                ColumnasSiox = elementosSiox[e].Split(new string[] { "@@" }, StringSplitOptions.None);

                                ServiciosSiox siox = new ServiciosSiox();

                                siox.Clave = ColumnasSiox[0];
                                siox.Servicio = ColumnasSiox[1];
                                siox.Cantidad = Libraries.ConvertToInt.ConvertToInt16(ColumnasSiox[2]);
                                siox.Importe = Convert.ToDecimal(ColumnasSiox[3]);
                                var desc = Convert.ToDecimal(ColumnasSiox[4]);
                                if (desc > 0)
                                    siox.Descuento = 100 - desc;
                                else
                                    siox.Descuento = desc;

                                Servicios.Add(siox);
                            }

                        }

                    }

                }
                if (ArrClavesenCeros.Count() > 0)
                {
                    var catalogoServicio = bd.ctPagoServicio.ToList();

                    for (int e = 0; e < ArrClavesenCeros.Count() ; e++)
                    {
                        ServiciosSiox siox = new ServiciosSiox();
                       string[] datosarreglo;
                      datosarreglo = ArrClavesenCeros[e].Split(new string[] { "|" }, StringSplitOptions.None);
                      var servicio = catalogoServicio.Where(r => r.cveServicio == datosarreglo[0]).FirstOrDefault();
                      siox.Clave = servicio.cveServicio;
                      siox.Servicio = servicio.Nombre;
                      siox.Cantidad = Libraries.ConvertToInt.ConvertToInt16(datosarreglo[1]);
                        siox.Importe = 0;
        siox.Descuento = 100 ;
                        Servicios.Add(siox);
                    }

                    ServiciosSiox sioxt = new ServiciosSiox();

                    sioxt.Clave = "";
                    sioxt.Servicio = "Total";
                    sioxt.Cantidad = 0;
                    sioxt.Importe = 0;
                    sioxt.Descuento = 0;
                    Servicios.Add(sioxt);
                }

            }
            catch (Exception ex)
            {


            }

            var t = Json(Servicios, JsonRequestBehavior.AllowGet);
            return t;
        }

        [AllowAnonymous]

        public ActionResult Recibo(string id,string sv="")
        {
            var resultadourl = "";
            string valida = "0";
            if (sv == "1")
                valida = "1";

            string requestUrl = "https://impresionsiox.finanzasoaxaca.gob.mx/impresion-formato-java/" + id + "/1/" + valida + ".Htm";
            try
            {


                //var request = (HttpWebRequest)WebRequest.Create("http://www.example.com/recepticle.aspx");

                //var postData = "thing1=hello";
                //postData += "&thing2=world";
                //var data = Encoding.ASCII.GetBytes(postData);

                //request.Method = "POST";
                //request.ContentType = "application/x-www-form-urlencoded";
                //request.ContentLength = data.Length;

                //using (var stream = request.GetRequestStream())
                //{
                //    stream.Write(data, 0, data.Length);
                //}

                //var response = (HttpWebResponse)request.GetResponse();

                //var responseString = new StreamReader(response.GetResponseStream()).ReadToEnd();


                ////////
                HttpWebRequest request = WebRequest.Create(requestUrl) as HttpWebRequest;

               // request.Method = "POST";

                using (HttpWebResponse response = request.GetResponse() as HttpWebResponse)

                {
                    if (response.StatusCode != HttpStatusCode.OK)
                    {
                        throw new Exception(String.Format("Server error (HTTP {0}: {1}).", response.StatusCode, response.StatusDescription));
                    }

                    JavaScriptSerializer serializer = new JavaScriptSerializer();
                  //  var responseObject = serializer.Deserialize<string>(response);

                 //   return responseObject;

                    Stream receiveStream = response.GetResponseStream();
                    StreamReader readStream = new StreamReader(receiveStream, Encoding.UTF8);
                    resultadourl = readStream.ReadToEnd();
                    // Force HTTPS connection
                    if (!Request.IsSecureConnection)
                    {
                        var uri = new Uri(Request.Url.ToString());
                       // var redirectUrl = Settings.CanonicalDomain + uri.PathAndQuery;
                        Response.Status = "301 Moved Permanently";
                        Response.AddHeader("Location", resultadourl);
                        Response.End();
                    }
                }
            }
            catch (Exception e)
            {
                throw new ApplicationException("EL sistema de la secretaria de finanzas no responde intente de nuevo pro favor");
            }

            return View();
        }

        public ActionResult Reciboeee()
        {

            HttpClient httpClient = new HttpClient();

            //specify to use TLS 1.2 as default connection
            System.Net.ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12 | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls;

            //httpClient.BaseAddress = new Uri("https://foobar.com/");
            //httpClient.DefaultRequestHeaders.Accept.Clear();
            //httpClient.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/xml"));

            //var task = httpClient.PostAsXmlAsync<DeviceRequest>("api/SaveData", request);


            HttpClient client = new HttpClient();
       

            client.BaseAddress = new Uri("​http://www.qimpresionsiox.finanzasoaxaca.gob.mx:9014/impresion-formato-java/31701609402/1/0.Htm");
            // Add an Accept header for JSON format.
            client.DefaultRequestHeaders.Accept.Add(
                new MediaTypeWithQualityHeaderValue("application/json"));

            HttpResponseMessage response = client.GetAsync("api/User").Result;

            if (response.IsSuccessStatusCode)
            {
                var users = response.Content.ReadAsStreamAsync().Result;
                

            }

            return View();
        }

        [AllowAnonymous]

        public JsonResult LineaCaptura(string id,string curp)
        {
                  AlumnosIngresos ingreso = new AlumnosIngresos();
                  var ArrClavestempo = decodificacadena(id);


            var ArrClaves = ArrClavestempo.Where(f => !f.Contains("|100")).ToArray();
            var ArrClavesenCeros = ArrClavestempo.Where(f => f.Contains("|100")).ToArray();


            LineaCapturaSiox linea = new LineaCapturaSiox();


            List<ServiciosSiox> Servicios = new List<ServiciosSiox>();

            Siox.CecyteClient swsiox = new Siox.CecyteClient();

            var alumno =SeguridadAlumnos.Alumnos.Instance.ctAlumnos.Where(g=> g.Curp==curp ).FirstOrDefault();
            string ImpuestoSap = "";
            int totalRegistros = 0;

            bool nohayerror = true;
            try
            {
                if (ArrClaves.Count() > 0)
                {
                    swsiox.Open();

                    string ciclovigente = ingreso.NombreCicloEscolarVigente(alumno.IdModalidadEstudio);
                    string detallesFinazas = alumno.Campus + ", " + alumno.Carrera + ", " + ciclovigente + ", Semestre " + alumno.IdValorCiclo;

                    var resultado = swsiox.genera_linea(alumno.Nombre + " " + alumno.ApPaterno + " " + alumno.ApMaterno, "Conocido", alumno.Curp, detallesFinazas, "0", "0", ArrClaves);

                    var registrosSiox = resultado.Split('|');
                  



                    if (resultado != "")
                    {
                        string[] elementosSiox;
                        string[] LineaSiox;
                        string[] DatosLineaSiox;
                        string[] ColumnasSiox;


                        for (int i = 2; i < 3; i++)
                        {
                            elementosSiox = registrosSiox[i].Split(new string[] { "%%" }, StringSplitOptions.None);
                            totalRegistros = elementosSiox.Count();
                            for (int e = 0; e < elementosSiox.Count(); e++)
                            {
                                ColumnasSiox = elementosSiox[e].Split(new string[] { "@@" }, StringSplitOptions.None);

                                ServiciosSiox siox = new ServiciosSiox();

                                siox.Clave = ColumnasSiox[0];
                                siox.Servicio = ColumnasSiox[1];
                                siox.Cantidad = Libraries.ConvertToInt.ConvertToInt16(ColumnasSiox[2]);
                                siox.Importe = Convert.ToDecimal(ColumnasSiox[3]);
                                siox.Descuento = Convert.ToDecimal(ColumnasSiox[4]);

                                Servicios.Add(siox);
                            }

                            ImpuestoSap = elementosSiox[totalRegistros - 1];

                            LineaSiox = registrosSiox[0].Split(new string[] { "%%" }, StringSplitOptions.None);


                            DatosLineaSiox = LineaSiox[0].Split(new string[] { "@@" }, StringSplitOptions.None);


                            linea.Documento = DatosLineaSiox[0];
                            linea.LineaCaptura = DatosLineaSiox[1];
                            linea.Importe = Convert.ToDecimal(DatosLineaSiox[2]);
                            linea.Vigencia = DatosLineaSiox[3];

                        }

                    }
                }

                if (ArrClavesenCeros.Count() > 0)
                {
                    var catalogoServicio = bd.ctPagoServicio.ToList();

                    for (int e = 0; e < ArrClavesenCeros.Count(); e++)
                    {
                        ServiciosSiox siox = new ServiciosSiox();
                        string[] datosarreglo;
                        datosarreglo = ArrClavesenCeros[e].Split(new string[] { "|" }, StringSplitOptions.None);
                        var servicio = catalogoServicio.Where(r => r.cveServicio == datosarreglo[0]).FirstOrDefault();
                        siox.Clave = servicio.cveServicio;
                        siox.Servicio = servicio.Nombre;
                        siox.Cantidad = Libraries.ConvertToInt.ConvertToInt16(datosarreglo[1]);
                        siox.Importe = 0;
                        siox.Descuento = 100;
                        Servicios.Add(siox);
                    }

                    ServiciosSiox sioxt = new ServiciosSiox();

                    sioxt.Clave = "";
                    sioxt.Servicio = "Total";
                    sioxt.Cantidad = 0;
                    sioxt.Importe = 0;
                    sioxt.Descuento = 0;
                    Servicios.Add(sioxt);
                }

            }
            catch (Exception ex)
            {

                nohayerror = false;
            }

            if (nohayerror)
            {
          

                var catalogoServicio = bd.ctPagoServicio.ToList();

                var lineaaries = ingreso.GrabaOrden(alumno.IdCampus, alumno.Curp, alumno.IdCicloEscolar, alumno.IdValorCiclo, Servicios[totalRegistros - 1].Importe, linea.Importe, 0, 9M, linea.LineaCaptura, linea.Documento, ImpuestoSap, linea.Vigencia);
                int filasvalidas = 0;
                foreach (var item in Servicios)
                {
                    filasvalidas++;
                            if (Servicios.Count() - 1 >= filasvalidas)
                            {
                                short idservicio = catalogoServicio.Where(f => f.cveServicio == item.Clave).FirstOrDefault().IdPagoServicio;
                                var descitem = ArrClaves.Where(v => v.Contains(item.Clave)).FirstOrDefault();
                                var descregistros = descitem.Split('|');
                                var desctotal= System.Convert.ToDecimal(descregistros[2]);
                                if (desctotal > 0)
                                    desctotal = 100 - desctotal;
                                var resultadoitem = ingreso.GrabaItem(lineaaries, alumno.IdCampus, idservicio, item.Importe, desctotal, item.Importe, item.Cantidad);
                            }
                          
	                    }

               
            }
            var t = Json(linea, JsonRequestBehavior.AllowGet);
            return t;
        }
    }
}