﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class RolAplicacionsController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: RolAplicacions
        public ActionResult Index()
        {
            var rolAplicacion = db.RolAplicacion.Include(r => r.Aplicacion).Include(r => r.Rol);
            return View(rolAplicacion.ToList());
        }

        // GET: RolAplicacions/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            RolAplicacion rolAplicacion = db.RolAplicacion.Find(id);
            if (rolAplicacion == null)
            {
                return HttpNotFound();
            }
            return View(rolAplicacion);
        }

        // GET: RolAplicacions/Create
        public ActionResult Create()
        {
            ViewBag.IdAplicacion = new SelectList(db.Aplicacion, "IdAplicacion", "Aplicacion1");
            ViewBag.IdRol = new SelectList(db.Rol, "IdRol", "Rol1");
            return View();
        }

        // POST: RolAplicacions/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdRolAplicacion,IdRol,IdAplicacion")] RolAplicacion rolAplicacion)
        {
            if (ModelState.IsValid)
            {
                db.RolAplicacion.Add(rolAplicacion);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdAplicacion = new SelectList(db.Aplicacion, "IdAplicacion", "Aplicacion1", rolAplicacion.IdAplicacion);
            ViewBag.IdRol = new SelectList(db.Rol, "IdRol", "Rol1", rolAplicacion.IdRol);
            return View(rolAplicacion);
        }

        // GET: RolAplicacions/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            RolAplicacion rolAplicacion = db.RolAplicacion.Find(id);
            if (rolAplicacion == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdAplicacion = new SelectList(db.Aplicacion, "IdAplicacion", "Aplicacion1", rolAplicacion.IdAplicacion);
            ViewBag.IdRol = new SelectList(db.Rol, "IdRol", "Rol1", rolAplicacion.IdRol);
            return View(rolAplicacion);
        }

        // POST: RolAplicacions/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdRolAplicacion,IdRol,IdAplicacion")] RolAplicacion rolAplicacion)
        {
            if (ModelState.IsValid)
            {
                db.Entry(rolAplicacion).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdAplicacion = new SelectList(db.Aplicacion, "IdAplicacion", "Aplicacion1", rolAplicacion.IdAplicacion);
            ViewBag.IdRol = new SelectList(db.Rol, "IdRol", "Rol1", rolAplicacion.IdRol);
            return View(rolAplicacion);
        }

        // GET: RolAplicacions/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            RolAplicacion rolAplicacion = db.RolAplicacion.Find(id);
            if (rolAplicacion == null)
            {
                return HttpNotFound();
            }
            return View(rolAplicacion);
        }

        // POST: RolAplicacions/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            RolAplicacion rolAplicacion = db.RolAplicacion.Find(id);
            db.RolAplicacion.Remove(rolAplicacion);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
