﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class GrupoRolAplicacionsController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: GrupoRolAplicacions
        public ActionResult Index()
        {
            var grupoRolAplicacion = db.GrupoRolAplicacion.Include(g => g.Grupo).Include(g => g.AccesoRolAplicacion);
            return View(grupoRolAplicacion.ToList());
        }

        // GET: GrupoRolAplicacions/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacion grupoRolAplicacion = db.GrupoRolAplicacion.Find(id);
            if (grupoRolAplicacion == null)
            {
                return HttpNotFound();
            }
            return View(grupoRolAplicacion);
        }

        // GET: GrupoRolAplicacions/Create
        public ActionResult Create()
        {
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1");
            //ViewBag.IdAccesoRolAplicacion = new SelectList(db.AccesoRolAplicacion, "IdAccesoRolAplicacion", "IdAccesoRolAplicacion");
            ViewBag.IdAccesoRolAplicacion = new SelectList((from s in db.AccesoRolAplicacion.ToList() select new { IdAccesoRolAplicacion = s.IdAccesoRolAplicacion, AccesoRolAplicacion = s.ControladorAccion.Controlador.Controlador1 + "|" + s.ControladorAccion.Accion.Accion1 + "|" + s.RolAplicacion.Rol.Rol1 + "|" + s.RolAplicacion.Aplicacion.Aplicacion1 }), "IdAccesoRolAplicacion", "AccesoRolAplicacion");

            return View();
        }

        // POST: GrupoRolAplicacions/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdGrupoRolAplicacion,IdGrupo,IdAccesoRolAplicacion")] GrupoRolAplicacion grupoRolAplicacion)
        {
            if (ModelState.IsValid)
            {
                db.GrupoRolAplicacion.Add(grupoRolAplicacion);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", grupoRolAplicacion.IdGrupo);
            ViewBag.IdAccesoRolAplicacion = new SelectList(db.AccesoRolAplicacion, "IdAccesoRolAplicacion", "IdAccesoRolAplicacion", grupoRolAplicacion.IdAccesoRolAplicacion);
            return View(grupoRolAplicacion);
        }

        // GET: GrupoRolAplicacions/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacion grupoRolAplicacion = db.GrupoRolAplicacion.Find(id);
            if (grupoRolAplicacion == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", grupoRolAplicacion.IdGrupo);
            ViewBag.IdAccesoRolAplicacion = new SelectList((from s in db.AccesoRolAplicacion.ToList() select new { IdAccesoRolAplicacion = s.IdAccesoRolAplicacion, AccesoRolAplicacion = s.ControladorAccion.Controlador.Controlador1 + "|" + s.ControladorAccion.Accion.Accion1 + "|" + s.RolAplicacion.Rol.Rol1 + "|" + s.RolAplicacion.Aplicacion.Aplicacion1 }), "IdAccesoRolAplicacion", "AccesoRolAplicacion");

            //ViewBag.IdAccesoRolAplicacion = new SelectList(db.AccesoRolAplicacion, "IdAccesoRolAplicacion", "IdAccesoRolAplicacion", grupoRolAplicacion.IdAccesoRolAplicacion);
            return View(grupoRolAplicacion);
        }

        // POST: GrupoRolAplicacions/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdGrupoRolAplicacion,IdGrupo,IdAccesoRolAplicacion")] GrupoRolAplicacion grupoRolAplicacion)
        {
            if (ModelState.IsValid)
            {
                db.Entry(grupoRolAplicacion).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", grupoRolAplicacion.IdGrupo);
            ViewBag.IdAccesoRolAplicacion = new SelectList(db.AccesoRolAplicacion, "IdAccesoRolAplicacion", "IdAccesoRolAplicacion", grupoRolAplicacion.IdAccesoRolAplicacion);
            return View(grupoRolAplicacion);
        }

        // GET: GrupoRolAplicacions/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacion grupoRolAplicacion = db.GrupoRolAplicacion.Find(id);
            if (grupoRolAplicacion == null)
            {
                return HttpNotFound();
            }
            return View(grupoRolAplicacion);
        }

        // POST: GrupoRolAplicacions/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            GrupoRolAplicacion grupoRolAplicacion = db.GrupoRolAplicacion.Find(id);
            db.GrupoRolAplicacion.Remove(grupoRolAplicacion);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
