﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class GrupoRolAplicacionConvenioLaboralController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /GrupoRolAplicacionConvenioLaboral/
        public ActionResult Index()
        {
            var gruporolaplicacionconveniolaboral = db.GrupoRolAplicacionConvenioLaboral.Include(g => g.Catalogos_ctConvenioLaboral).Include(g => g.Grupo).Include(g => g.GrupoRolAplicacion);
            return View(gruporolaplicacionconveniolaboral.ToList());
        }

        // GET: /GrupoRolAplicacionConvenioLaboral/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionConvenioLaboral gruporolaplicacionconveniolaboral = db.GrupoRolAplicacionConvenioLaboral.Find(id);
            if (gruporolaplicacionconveniolaboral == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacionconveniolaboral);
        }

        // GET: /GrupoRolAplicacionConvenioLaboral/Create
        public ActionResult Create()
        {
            ViewBag.IdConvenioLaboral = new SelectList(db.Catalogos_ctConvenioLaboral, "IdConvenioLaboral", "ConvenioLaboral");
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1");
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion");
            return View();
        }

        // POST: /GrupoRolAplicacionConvenioLaboral/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include="IdGrupoRolAplicacionConvenioLaboral,IdGrupo,IdConvenioLaboral")] GrupoRolAplicacionConvenioLaboral gruporolaplicacionconveniolaboral)
        {
            if (ModelState.IsValid)
            {
                db.GrupoRolAplicacionConvenioLaboral.Add(gruporolaplicacionconveniolaboral);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdConvenioLaboral = new SelectList(db.Catalogos_ctConvenioLaboral, "IdConvenioLaboral", "ConvenioLaboral", gruporolaplicacionconveniolaboral.IdConvenioLaboral);
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionconveniolaboral.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionconveniolaboral.IdGrupo);
            return View(gruporolaplicacionconveniolaboral);
        }

        // GET: /GrupoRolAplicacionConvenioLaboral/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionConvenioLaboral gruporolaplicacionconveniolaboral = db.GrupoRolAplicacionConvenioLaboral.Find(id);
            if (gruporolaplicacionconveniolaboral == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdConvenioLaboral = new SelectList(db.Catalogos_ctConvenioLaboral, "IdConvenioLaboral", "ConvenioLaboral", gruporolaplicacionconveniolaboral.IdConvenioLaboral);
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionconveniolaboral.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionconveniolaboral.IdGrupo);
            return View(gruporolaplicacionconveniolaboral);
        }

        // POST: /GrupoRolAplicacionConvenioLaboral/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include="IdGrupoRolAplicacionConvenioLaboral,IdGrupo,IdConvenioLaboral")] GrupoRolAplicacionConvenioLaboral gruporolaplicacionconveniolaboral)
        {
            if (ModelState.IsValid)
            {
                db.Entry(gruporolaplicacionconveniolaboral).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdConvenioLaboral = new SelectList(db.Catalogos_ctConvenioLaboral, "IdConvenioLaboral", "ConvenioLaboral", gruporolaplicacionconveniolaboral.IdConvenioLaboral);
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionconveniolaboral.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionconveniolaboral.IdGrupo);
            return View(gruporolaplicacionconveniolaboral);
        }

        // GET: /GrupoRolAplicacionConvenioLaboral/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionConvenioLaboral gruporolaplicacionconveniolaboral = db.GrupoRolAplicacionConvenioLaboral.Find(id);
            if (gruporolaplicacionconveniolaboral == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacionconveniolaboral);
        }

        // POST: /GrupoRolAplicacionConvenioLaboral/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            GrupoRolAplicacionConvenioLaboral gruporolaplicacionconveniolaboral = db.GrupoRolAplicacionConvenioLaboral.Find(id);
            db.GrupoRolAplicacionConvenioLaboral.Remove(gruporolaplicacionconveniolaboral);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
