﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class GrupoRolAplicacionClasificacionLaboralController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /GrupoRolAplicacionClasificacionLaboral/
        public ActionResult Index()
        {
            var gruporolaplicacionclasificacionlaboral = db.GrupoRolAplicacionClasificacionLaboral.Include(g => g.Catalogos_ctClasificacionLaboral).Include(g => g.Grupo).Include(g => g.GrupoRolAplicacion);
            return View(gruporolaplicacionclasificacionlaboral.ToList());
        }

        // GET: /GrupoRolAplicacionClasificacionLaboral/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionClasificacionLaboral gruporolaplicacionclasificacionlaboral = db.GrupoRolAplicacionClasificacionLaboral.Find(id);
            if (gruporolaplicacionclasificacionlaboral == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacionclasificacionlaboral);
        }

        // GET: /GrupoRolAplicacionClasificacionLaboral/Create
        public ActionResult Create()
        {
            ViewBag.IdClasificacionLaboral = new SelectList(db.Catalogos_ctClasificacionLaboral, "IdClasificacionLaboral", "ClasificacionLaboral");
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1");
            ////ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion");
            return View();
        }

        // POST: /GrupoRolAplicacionClasificacionLaboral/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include="IdGrupoRolAplicacionClasificacionLaboral,IdClasificacionLaboral,IdGrupo")] GrupoRolAplicacionClasificacionLaboral gruporolaplicacionclasificacionlaboral)
        {
            if (ModelState.IsValid)
            {
                db.GrupoRolAplicacionClasificacionLaboral.Add(gruporolaplicacionclasificacionlaboral);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdClasificacionLaboral = new SelectList(db.Catalogos_ctClasificacionLaboral, "IdClasificacionLaboral", "ClasificacionLaboral", gruporolaplicacionclasificacionlaboral.IdClasificacionLaboral);
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionclasificacionlaboral.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionclasificacionlaboral.IdGrupo);
            return View(gruporolaplicacionclasificacionlaboral);
        }

        // GET: /GrupoRolAplicacionClasificacionLaboral/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionClasificacionLaboral gruporolaplicacionclasificacionlaboral = db.GrupoRolAplicacionClasificacionLaboral.Find(id);
            if (gruporolaplicacionclasificacionlaboral == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdClasificacionLaboral = new SelectList(db.Catalogos_ctClasificacionLaboral, "IdClasificacionLaboral", "ClasificacionLaboral", gruporolaplicacionclasificacionlaboral.IdClasificacionLaboral);
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionclasificacionlaboral.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionclasificacionlaboral.IdGrupo);
            return View(gruporolaplicacionclasificacionlaboral);
        }

        // POST: /GrupoRolAplicacionClasificacionLaboral/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include="IdGrupoRolAplicacionClasificacionLaboral,IdClasificacionLaboral,IdGrupo")] GrupoRolAplicacionClasificacionLaboral gruporolaplicacionclasificacionlaboral)
        {
            if (ModelState.IsValid)
            {
                db.Entry(gruporolaplicacionclasificacionlaboral).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdClasificacionLaboral = new SelectList(db.Catalogos_ctClasificacionLaboral, "IdClasificacionLaboral", "ClasificacionLaboral", gruporolaplicacionclasificacionlaboral.IdClasificacionLaboral);
            ViewBag.IdGrupo = new SelectList(db.Grupo, "IdGrupo", "Grupo1", gruporolaplicacionclasificacionlaboral.IdGrupo);
            //ViewBag.IdGrupo = new SelectList(db.GrupoRolAplicacion, "IdGrupoRolAplicacion", "IdGrupoRolAplicacion", gruporolaplicacionclasificacionlaboral.IdGrupo);
            return View(gruporolaplicacionclasificacionlaboral);
        }

        // GET: /GrupoRolAplicacionClasificacionLaboral/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            GrupoRolAplicacionClasificacionLaboral gruporolaplicacionclasificacionlaboral = db.GrupoRolAplicacionClasificacionLaboral.Find(id);
            if (gruporolaplicacionclasificacionlaboral == null)
            {
                return HttpNotFound();
            }
            return View(gruporolaplicacionclasificacionlaboral);
        }

        // POST: /GrupoRolAplicacionClasificacionLaboral/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            GrupoRolAplicacionClasificacionLaboral gruporolaplicacionclasificacionlaboral = db.GrupoRolAplicacionClasificacionLaboral.Find(id);
            db.GrupoRolAplicacionClasificacionLaboral.Remove(gruporolaplicacionclasificacionlaboral);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
