﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class ControladorsController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: Controladors
        public ActionResult Index()
        {
            return View(db.Controlador.ToList());
        }

        // GET: Controladors/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Controlador controlador = db.Controlador.Find(id);
            if (controlador == null)
            {
                return HttpNotFound();
            }
            return View(controlador);
        }

        // GET: Controladors/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: Controladors/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdControlador,Controlador1")] Controlador controlador)
        {
            if (ModelState.IsValid)
            {
                db.Controlador.Add(controlador);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(controlador);
        }

        // GET: Controladors/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Controlador controlador = db.Controlador.Find(id);
            if (controlador == null)
            {
                return HttpNotFound();
            }
            return View(controlador);
        }

        // POST: Controladors/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdControlador,Controlador1")] Controlador controlador)
        {
            if (ModelState.IsValid)
            {
                db.Entry(controlador).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(controlador);
        }

        // GET: Controladors/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Controlador controlador = db.Controlador.Find(id);
            if (controlador == null)
            {
                return HttpNotFound();
            }
            return View(controlador);
        }

        // POST: Controladors/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Controlador controlador = db.Controlador.Find(id);
            db.Controlador.Remove(controlador);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
