﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class ControladorAccionUsuarioKardexExcluidoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /ControladorAccionUsuarioKardexExcluido/
        public ActionResult Index()
        {
            var controladoraccionusuariokardexexcluido = db.ControladorAccionUsuarioKardexExcluido.Include(c => c.ControladorAccion).Include(c => c.UsuarioKardex);
            return View(controladoraccionusuariokardexexcluido.ToList());
        }

        // GET: /ControladorAccionUsuarioKardexExcluido/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ControladorAccionUsuarioKardexExcluido controladoraccionusuariokardexexcluido = db.ControladorAccionUsuarioKardexExcluido.Find(id);
            if (controladoraccionusuariokardexexcluido == null)
            {
                return HttpNotFound();
            }
            return View(controladoraccionusuariokardexexcluido);
        }

        // GET: /ControladorAccionUsuarioKardexExcluido/Create
        public ActionResult Create()
        {
            //ViewBag.IdControladorAccion = new SelectList(db.ControladorAccion, "IdControladorAccion", "Id");
            //ViewBag.IdUsuarioKardex = new SelectList(db.UsuarioKardex, "IdUsuarioKardex", "Id");
            ViewBag.IdControladorAccion = new SelectList((from s in db.ControladorAccion.ToList() select new { IdControladorAccion = s.IdControladorAccion, Id =s.IdControladorAccion + "|"+ s.Controlador.Controlador1 + "|" + s.Accion.Accion1 }), "IdControladorAccion", "Id");
            ViewBag.IdUsuarioKardex = new SelectList((from s in db.UsuarioKardex.ToList() select new { IdUsuarioKardex = s.IdUsuarioKardex, Id = s.Kardex_ctDatosPersonales.Nombre + "|" + s.Kardex_ctDatosPersonales.ApellidoPaterno + "|" + s.Kardex_ctDatosPersonales.ApellidoMaterno + "|" + s.AspNetUsers.Email }), "IdUsuarioKardex", "Id");


            return View();
        }

        // POST: /ControladorAccionUsuarioKardexExcluido/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include="IdControladorAccionUsuarioKardexExcluido,IdControladorAccion,IdUsuarioKardex")] ControladorAccionUsuarioKardexExcluido controladoraccionusuariokardexexcluido)
        {
            if (ModelState.IsValid)
            {
                db.ControladorAccionUsuarioKardexExcluido.Add(controladoraccionusuariokardexexcluido);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdControladorAccion = new SelectList((from s in db.ControladorAccion.ToList() select new { IdControladorAccion = s.IdControladorAccion, Id = s.IdControladorAccion + "|" + s.Controlador.Controlador1 + "|" + s.Accion.Accion1 }), "IdControladorAccion", "Id");
            ViewBag.IdUsuarioKardex = new SelectList((from s in db.UsuarioKardex.ToList() select new { IdUsuarioKardex = s.IdUsuarioKardex, Id = s.Kardex_ctDatosPersonales.Nombre + "|" + s.Kardex_ctDatosPersonales.ApellidoPaterno + "|" + s.Kardex_ctDatosPersonales.ApellidoMaterno + "|" + s.AspNetUsers.Email }), "IdUsuarioKardex", "Id");
            return View(controladoraccionusuariokardexexcluido);
        }

        // GET: /ControladorAccionUsuarioKardexExcluido/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ControladorAccionUsuarioKardexExcluido controladoraccionusuariokardexexcluido = db.ControladorAccionUsuarioKardexExcluido.Find(id);
            if (controladoraccionusuariokardexexcluido == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdControladorAccion = new SelectList((from s in db.ControladorAccion.ToList() select new { IdControladorAccion = s.IdControladorAccion, Id = s.IdControladorAccion + "|" + s.Controlador.Controlador1 + "|" + s.Accion.Accion1 }), "IdControladorAccion", "Id");
            ViewBag.IdUsuarioKardex = new SelectList((from s in db.UsuarioKardex.ToList() select new { IdUsuarioKardex = s.IdUsuarioKardex, Id = s.Kardex_ctDatosPersonales.Nombre + "|" + s.Kardex_ctDatosPersonales.ApellidoPaterno + "|" + s.Kardex_ctDatosPersonales.ApellidoMaterno + "|" + s.AspNetUsers.Email }), "IdUsuarioKardex", "Id");
            return View(controladoraccionusuariokardexexcluido);
        }

        // POST: /ControladorAccionUsuarioKardexExcluido/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include="IdControladorAccionUsuarioKardexExcluido,IdControladorAccion,IdUsuarioKardex")] ControladorAccionUsuarioKardexExcluido controladoraccionusuariokardexexcluido)
        {
            if (ModelState.IsValid)
            {
                db.Entry(controladoraccionusuariokardexexcluido).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdControladorAccion = new SelectList((from s in db.ControladorAccion.ToList() select new { IdControladorAccion = s.IdControladorAccion, Id = s.Controlador.Controlador1 + "|" + s.Accion.Accion1 }), "IdControladorAccion", "Id");
            ViewBag.IdUsuarioKardex = new SelectList((from s in db.UsuarioKardex.ToList() select new { IdUsuarioKardex = s.IdUsuarioKardex, Id = s.Kardex_ctDatosPersonales.Nombre + "|" + s.Kardex_ctDatosPersonales.ApellidoPaterno + "|" + s.Kardex_ctDatosPersonales.ApellidoMaterno + "|" + s.AspNetUsers.Email }), "IdUsuarioKardex", "Id");
            return View(controladoraccionusuariokardexexcluido);
        }

        // GET: /ControladorAccionUsuarioKardexExcluido/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ControladorAccionUsuarioKardexExcluido controladoraccionusuariokardexexcluido = db.ControladorAccionUsuarioKardexExcluido.Find(id);
            if (controladoraccionusuariokardexexcluido == null)
            {
                return HttpNotFound();
            }
            return View(controladoraccionusuariokardexexcluido);
        }

        // POST: /ControladorAccionUsuarioKardexExcluido/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            ControladorAccionUsuarioKardexExcluido controladoraccionusuariokardexexcluido = db.ControladorAccionUsuarioKardexExcluido.Find(id);
            db.ControladorAccionUsuarioKardexExcluido.Remove(controladoraccionusuariokardexexcluido);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
