﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.AdminSeguridad
{

    public class UsuarioRoles
    {
        public string EstatusTrabajador { get; set; }
        public string EsSuperUsuario { get; set; }
        public string Tipo { get; set; }
        public string IdKardex { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Categoria { get; set; }
        public string UbicacionFisica { get; set; }
        public string ConvenioLaboral { get; set; }
        public string RelacionLaboral { get; set; }
        public string ClasificacionLaboral { get; set; }
        public string Grupo { get; set; }

    }

    public class AdminSeguridadController : Controller
    {
        // GET: AdminSeguridad
        public ActionResult Index()
        {

            return View();
        }

        public ActionResult Usuarios()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");


            string sql = @"       select EstatusTrabajador, case when EsSuperUsuario is null then 'Sin Cuenta' else case when EsSuperUsuario=1 then 'SuperUsuario' else '' end end as EsSuperUsuario,
Tipo, q.IdKardex,Nombre,ApellidoPaterno,ApellidoMaterno,Categoria,UbicacionFisica,
                ConvenioLaboral,RelacionLaboral,ClasificacionLaboral,
                Grupo
                from(
                select c.EstatusTrabajador, 'Asignación Directa' Tipo, b.IdKardex, c.Nombre, ApellidoPaterno, ApellidoMaterno, Categoria, UbicacionFisica,
                ConvenioLaboral, RelacionLaboral, ClasificacionLaboral,
                Grupo
                  FROM[bdNova2018].[dbo].[GrupoRolAplicacionUsuarioKardex] a
                  inner join UsuarioKardex b on b.IdUsuarioKardex = a.IdUsuarioKardex
                  inner join vwDatosAspirantesTrabajadores c on b.IdKardex = c.IdKardex
                  inner join Grupo d on a.IdGrupo = d.IdGrupo
                union all
                select c.EstatusTrabajador,'Por Categoria' Tipo, c.IdKardex, c.Nombre, ApellidoPaterno, ApellidoMaterno, Categoria, UbicacionFisica,
                ConvenioLaboral, RelacionLaboral, ClasificacionLaboral,
                Grupo
                  FROM GrupoRolAplicacionCategoria a
	                inner join vwDatosAspirantesTrabajadores c on a.IdCategoria = c.IdCategoria
                  inner join Grupo d on a.IdGrupo = d.IdGrupo
                union all
	                select c.EstatusTrabajador,'Por  Clasificacion Laboral' Tipo, c.IdKardex, c.Nombre, ApellidoPaterno, ApellidoMaterno, Categoria, UbicacionFisica,
                ConvenioLaboral, RelacionLaboral, ClasificacionLaboral,
                Grupo
                  FROM GrupoRolAplicacionClasificacionLaboral a
	                inner join vwDatosAspirantesTrabajadores c on a.IdClasificacionLaboral = c.IdClasificacionLaboral
                  inner join Grupo d on a.IdGrupo = d.IdGrupo
		                union all
	                select c.EstatusTrabajador,'Por Relacion Laboral' Tipo, c.IdKardex, c.Nombre, ApellidoPaterno, ApellidoMaterno, Categoria, UbicacionFisica,
                ConvenioLaboral, RelacionLaboral, ClasificacionLaboral,
                Grupo
                  FROM GrupoRolAplicacionRelacionLaboral a
	                inner join vwDatosAspirantesTrabajadores c on a.IdRelacionLaboral = c.IdRelacionLaboral
                  inner join Grupo d on a.IdGrupo = d.IdGrupo

                union all
	                select c.EstatusTrabajador,'Por Convenio Laboral' Tipo, c.IdKardex, c.Nombre, ApellidoPaterno, ApellidoMaterno, Categoria, UbicacionFisica,
                ConvenioLaboral, RelacionLaboral, ClasificacionLaboral,
                Grupo
                  FROM GrupoRolAplicacionConvenioLaboral a
	                inner join vwDatosAspirantesTrabajadores c on a.IdConvenioLaboral = c.IdConvenioLaboral
                  inner join Grupo d on a.IdGrupo = d.IdGrupo

	                ) as q
	                left join UsuarioKardex t on t.IdKardex = q.IdKardex   order by 3,1";

            var t = (List<UsuarioRoles>)dp.connection.Query<UsuarioRoles>(sql);

            return View(t);
        }


    }
}