﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class AccesoRolAplicacionsController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: AccesoRolAplicacions
        public ActionResult Index()
        {
            var accesoRolAplicacion = db.AccesoRolAplicacion.Include(a => a.ControladorAccion).Include(a => a.RolAplicacion);
            return View(accesoRolAplicacion.ToList());
        }

        // GET: AccesoRolAplicacions/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            AccesoRolAplicacion accesoRolAplicacion = db.AccesoRolAplicacion.Find(id);
            if (accesoRolAplicacion == null)
            {
                return HttpNotFound();
            }
            return View(accesoRolAplicacion);
        }

        // GET: AccesoRolAplicacions/Create
        public ActionResult Create()
        {
            //ViewBag.IdControladorAccion = new SelectList(db.ControladorAccion, "IdControladorAccion", "TextoMenu");

            //ViewBag.IdRolAplicacion = new SelectList(db.RolAplicacion, "IdRolAplicacion", "IdRolAplicacion");
            ViewBag.IdControladorAccion = new SelectList((from s in db.ControladorAccion.ToList() select new { IdControladorAccion = s.IdControladorAccion, ControladorAccionName = s.Controlador.Controlador1 + "|" + s.Accion.Accion1 }), "IdControladorAccion", "ControladorAccionName");
            ViewBag.IdRolAplicacion = new SelectList((from s in db.RolAplicacion.ToList() select new { IdRolAplicacion = s.IdRolAplicacion, RoleAplicationName = s.Rol.Rol1 + "|" + s.Aplicacion.Aplicacion1 }), "IdRolAplicacion", "RoleAplicationName");

            return View();
        }

        // POST: AccesoRolAplicacions/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdAccesoRolAplicacion,IdRolAplicacion,IdControladorAccion")] AccesoRolAplicacion accesoRolAplicacion)
        {
            if (ModelState.IsValid)
            {
                db.AccesoRolAplicacion.Add(accesoRolAplicacion);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdControladorAccion = new SelectList(db.ControladorAccion, "IdControladorAccion", "TextoMenu", accesoRolAplicacion.IdControladorAccion);
            ViewBag.IdRolAplicacion = new SelectList(db.RolAplicacion, "IdRolAplicacion", "IdRolAplicacion", accesoRolAplicacion.IdRolAplicacion);
            return View(accesoRolAplicacion);
        }

        // GET: AccesoRolAplicacions/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            AccesoRolAplicacion accesoRolAplicacion = db.AccesoRolAplicacion.Find(id);
            if (accesoRolAplicacion == null)
            {
                return HttpNotFound();
            }
            //ViewBag.IdControladorAccion = new SelectList(db.ControladorAccion, "IdControladorAccion", "TextoMenu", accesoRolAplicacion.IdControladorAccion);
            //ViewBag.IdRolAplicacion = new SelectList(db.RolAplicacion, "IdRolAplicacion", "IdRolAplicacion", accesoRolAplicacion.IdRolAplicacion);
            ViewBag.IdControladorAccion = new SelectList((from s in db.ControladorAccion.ToList() select new { IdControladorAccion = s.IdControladorAccion, ControladorAccionName = s.Controlador.Controlador1 + "|" + s.Accion.Accion1 }), "IdControladorAccion", "ControladorAccionName");
            ViewBag.IdRolAplicacion = new SelectList((from s in db.RolAplicacion.ToList() select new { IdRolAplicacion = s.IdRolAplicacion, RoleAplicationName = s.Rol.Rol1 + "|" + s.Aplicacion.Aplicacion1 }), "IdRolAplicacion", "RoleAplicationName");

            return View(accesoRolAplicacion);
        }

        // POST: AccesoRolAplicacions/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdAccesoRolAplicacion,IdRolAplicacion,IdControladorAccion")] AccesoRolAplicacion accesoRolAplicacion)
        {
            if (ModelState.IsValid)
            {
                db.Entry(accesoRolAplicacion).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdControladorAccion = new SelectList(db.ControladorAccion, "IdControladorAccion", "TextoMenu", accesoRolAplicacion.IdControladorAccion);
            ViewBag.IdRolAplicacion = new SelectList(db.RolAplicacion, "IdRolAplicacion", "IdRolAplicacion", accesoRolAplicacion.IdRolAplicacion);
            return View(accesoRolAplicacion);
        }

        // GET: AccesoRolAplicacions/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            AccesoRolAplicacion accesoRolAplicacion = db.AccesoRolAplicacion.Find(id);
            if (accesoRolAplicacion == null)
            {
                return HttpNotFound();
            }
            return View(accesoRolAplicacion);
        }

        // POST: AccesoRolAplicacions/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            AccesoRolAplicacion accesoRolAplicacion = db.AccesoRolAplicacion.Find(id);
            db.AccesoRolAplicacion.Remove(accesoRolAplicacion);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
