﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;

namespace Nova
{
    public class RouteConfig
    {
        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");
            routes.IgnoreRoute("{resource}.ashx/{*pathInfo}");
            routes.IgnoreRoute("{*favicon}", new { favicon = @"(.*/)?favicon.ico(/.*)?" });
            routes.MapMvcAttributeRoutes();

            routes.MapRoute(
                name: "Default",
                url: "{controller}/{action}/{id}",
                defaults: new { controller = "Home", action = "Index", id = UrlParameter.Optional }
                //defaults: new { controller = "Trabajadores", action = "Login", id = UrlParameter.Optional }
            );

            routes.MapRoute(
                               name: "Default",
                               url: "{controller}/{action}/{id}",
                               defaults: new { controller = "Home", action = "Index", id = UrlParameter.Optional }
                           ).RouteHandler = new MyCustomRouteHandler(); // Usar un RouteHandler personalizado para manejar la autorización

        }
    }

    public class MyCustomRouteHandler : MvcRouteHandler
    {
        protected override IHttpHandler GetHttpHandler(RequestContext requestContext)
        {
            if (!requestContext.HttpContext.User.Identity.IsAuthenticated)
            {
                // Redirigir al inicio de sesión si el usuario no está autenticado
                requestContext.HttpContext.Response.Redirect("~/Trabajadores/Login");
            }
            return base.GetHttpHandler(requestContext);
        }
    }
}
