﻿using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;
using System.Web;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.EntityFramework;
using Microsoft.AspNet.Identity.Owin;
using Microsoft.Owin;
using Microsoft.Owin.Security;
using Nova.Models;
using System.Net.Mail;
using System.Net;
using SeguridadAlumnos.Models;
using SeguridadAlumnos;
using SeguridadTutores.Models;
using SeguridadTutores;
//using IdentityAlumnos.DataModel;

namespace Nova
{
    public class EmailService : IIdentityMessageService
    {
        public async Task SendAsync(IdentityMessage message)
        {
            // Conecte su servicio de correo electrónico aquí para enviar correo electrónico.
        
            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            msg.To.Add(message.Destination);
            msg.Subject = message.Subject;
            msg.IsBodyHtml = true;
            

            

            msg.Body = message.Body;


            //  msg.Priority = MailPriority.High;

            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false;

            //try
            //{
            //    client.Send(msg);

            //}
            //catch (Exception)
            //{
                
            //    // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            //}

            await client.SendMailAsync(msg);

            //return Task.FromResult(0);
        }
    }

    public class SmsService : IIdentityMessageService
    {
        public Task SendAsync(IdentityMessage message)
        {
            // Conecte el servicio SMS aquí para enviar un mensaje de texto.
            return Task.FromResult(0);
        }
    }

  
    public class ApplicationUserManager : UserManager<ApplicationUser>
    {
        public ApplicationUserManager(IUserStore<ApplicationUser> store)
            : base(store)
        {
        }

        public static ApplicationUserManager Create(IdentityFactoryOptions<ApplicationUserManager> options, IOwinContext context)
        {
            var manager = new ApplicationUserManager(new UserStore<ApplicationUser>(context.Get<ApplicationDbContext>()));
            // Configure la lógica de validación de nombres de usuario
            manager.UserValidator = new UserValidator<ApplicationUser>(manager)
            {
                AllowOnlyAlphanumericUserNames = false,
                RequireUniqueEmail = true
            };

            // Configure la lógica de validación de contraseñas
            manager.PasswordValidator = new PasswordValidator
            {
                RequiredLength = 6,
                RequireNonLetterOrDigit = true,
                RequireDigit = true,
                RequireLowercase = true,
                RequireUppercase = true,
            };

            // Configurar valores predeterminados para bloqueo de usuario
            manager.UserLockoutEnabledByDefault = true;
            manager.DefaultAccountLockoutTimeSpan = TimeSpan.FromMinutes(5);
            manager.MaxFailedAccessAttemptsBeforeLockout = 5;

            // Registre proveedores de autenticación en dos fases. Esta aplicación usa los pasos Teléfono y Correo electrónico para recibir un código para comprobar el usuario
            // Puede escribir su propio proveedor y conectarlo aquí.
            manager.RegisterTwoFactorProvider("Código telefónico", new PhoneNumberTokenProvider<ApplicationUser>
            {
                MessageFormat = "Su código de seguridad es {0}"
            });
            manager.RegisterTwoFactorProvider("Código de correo electrónico", new EmailTokenProvider<ApplicationUser>
            {
                Subject = "Código de seguridad",
                BodyFormat = "Su código de seguridad es {0}"
            });
            manager.EmailService = new EmailService();
            manager.SmsService = new SmsService();
            var dataProtectionProvider = options.DataProtectionProvider;
            if (dataProtectionProvider != null)
            {
                manager.UserTokenProvider =
                    new DataProtectorTokenProvider<ApplicationUser>(dataProtectionProvider.Create("ASP.NET Identity"));
            }
            return manager;
        }
    }

    // Configure el administrador de inicios de sesión que se usa en esta aplicación.
    public class ApplicationSignInManager : SignInManager<ApplicationUser, string>
    {
        public ApplicationSignInManager(ApplicationUserManager userManager, IAuthenticationManager authenticationManager)
            : base(userManager, authenticationManager)
        {
        }

        public override Task<ClaimsIdentity> CreateUserIdentityAsync(ApplicationUser user)
        {
            return user.GenerateUserIdentityAsync((ApplicationUserManager)UserManager);
        }

        public static ApplicationSignInManager Create(IdentityFactoryOptions<ApplicationSignInManager> options, IOwinContext context)
        {
            return new ApplicationSignInManager(context.GetUserManager<ApplicationUserManager>(), context.Authentication);
        }
    }


    //// Configure el administrador de usuarios de aplicación que se usa en esta aplicación. UserManager se define en ASP.NET Identity y se usa en la aplicación.
    //public class ApplicationUserManager : UserManager<ApplicationUser>
    //{


    //    public ApplicationUserManager(IUserStore<ApplicationUser> store)
    //        : base(store)
    //    {
    //    }
    //    //public static async Task<ApplicationUserManager> FindByNameOrEmailAsync
    //    //    (this UserManager<ApplicationUserManager> userManager, string usernameOrEmail)
    //    //{
    //    //    var username = usernameOrEmail;
    //    //    if (usernameOrEmail.Contains("@"))
    //    //    {
    //    //        var userForEmail = await userManager.FindByEmailAsync(usernameOrEmail);
    //    //        if (userForEmail != null)
    //    //        {
    //    //            username = userForEmail;
    //    //        }
    //    //    }
    //    //    return await userManager.FindAsync(username, password);
    //    //}

    //    //public static async Task<ApplicationUserManager> FindByEmailAsync(String email, bdNovaEntities bd)
    //    //{



    //    //    var query = bd.AspNetUsers.Where(w => w.Email == email).ToListAsync().Result.ToArray().GetValue(0);
    //    //   // context.Database.SqlQuery(typeof(ApplicationUser), commandText, new SqlParameter("@email", email));
    //    //    //var result = query.ToListAsync().Result.ToArray().GetValue(0);
    //    //    return await query as ApplicationUserManager;
    //    //}
    //    public static ApplicationUserManager Create(IdentityFactoryOptions<ApplicationUserManager> options, IOwinContext context) 
    //    {
    //        var manager = new ApplicationUserManager(new UserStore<ApplicationUser>(context.Get<ApplicationDbContext>()));
    //        // Configure la lógica de validación de nombres de usuario
    //        manager.UserValidator = new UserValidator<ApplicationUser>(manager)
    //        {
    //            AllowOnlyAlphanumericUserNames = false,
    //            RequireUniqueEmail = true
    //        };

    //        // Configure la lógica de validación de contraseñas
    //        manager.PasswordValidator = new PasswordValidator
    //        {
    //            RequiredLength = 6,
    //            RequireNonLetterOrDigit = true,
    //            RequireDigit = true,
    //            RequireLowercase = true,
    //            RequireUppercase = true,
    //        };

    //        // Configurar valores predeterminados para bloqueo de usuario
    //        manager.UserLockoutEnabledByDefault = true;
    //        manager.DefaultAccountLockoutTimeSpan = TimeSpan.FromMinutes(5);
    //        manager.MaxFailedAccessAttemptsBeforeLockout = 5;

    //        // Registre proveedores de autenticación en dos fases. Esta aplicación usa los pasos Teléfono y Correo electrónico para recibir un código para comprobar el usuario
    //        // Puede escribir su propio proveedor y conectarlo aquí.
    //        manager.RegisterTwoFactorProvider("Código telefónico", new PhoneNumberTokenProvider<ApplicationUser>
    //        {
    //            MessageFormat = "Su código de seguridad es {0}"
    //        });
    //        manager.RegisterTwoFactorProvider("Código de correo electrónico", new EmailTokenProvider<ApplicationUser>
    //        {
    //            Subject = "Código de seguridad",
    //            BodyFormat = "Su código de seguridad es {0}"
    //        });
    //        manager.EmailService = new EmailService();
    //        manager.SmsService = new SmsService();
    //        var dataProtectionProvider = options.DataProtectionProvider;
    //        if (dataProtectionProvider != null)
    //        {
    //            manager.UserTokenProvider = 
    //                new DataProtectorTokenProvider<ApplicationUser>(dataProtectionProvider.Create("ASP.NET Identity"));
    //        }
    //        return manager;
    //    }
    //}

    //// Configure el administrador de inicios de sesión que se usa en esta aplicación.
    //public class ApplicationSignInManager : SignInManager<ApplicationUser, string>
    //{
    //    public ApplicationSignInManager(ApplicationUserManager userManager, IAuthenticationManager authenticationManager)
    //        : base(userManager, authenticationManager)
    //    {
    //    }

    //    public override Task<ClaimsIdentity> CreateUserIdentityAsync(ApplicationUser user)
    //    {
    //        return user.GenerateUserIdentityAsync((ApplicationUserManager)UserManager);
    //    }

    //    public static ApplicationSignInManager Create(IdentityFactoryOptions<ApplicationSignInManager> options, IOwinContext context)
    //    {
    //        return new ApplicationSignInManager(context.GetUserManager<ApplicationUserManager>(), context.Authentication);
    //    }
    //}

    //// Configure the application user manager used in this application. UserManager is defined in ASP.NET Identity and is used by the application.
    //public class ApplicationUserAlumnosManager : UserManager<ApplicationUserAlumnos>
    //{
    //    public ApplicationUserAlumnosManager(IUserStore<ApplicationUserAlumnos> store)
    //        : base(store)
    //    {
    //    }


    //    public static ApplicationUserAlumnosManager Create(IdentityFactoryOptions<ApplicationUserAlumnosManager> options, IOwinContext context)
    //    {
    //        /* var manager = new ApplicationUserManager(new UserStore<ApplicationUser>(context.Get<ApplicationDbContext>()));*/

    //        var manager = new ApplicationUserAlumnosManager(
    //                                new IdentityAlumnos.UserStore<ApplicationUserAlumnos>(
    //                                context.Get<ApplicationAlumnosDbContext>() as DatabaseAlumnosContext));
    //        // Configure validation logic for usernames
    //        manager.UserValidator = new UserValidator<ApplicationUserAlumnos>(manager)
    //        {
    //            AllowOnlyAlphanumericUserNames = false,
    //            RequireUniqueEmail = true
    //        };

    //        // Configure validation logic for passwords
    //        manager.PasswordValidator = new PasswordValidator
    //        {
    //            RequiredLength = 6,
    //            RequireNonLetterOrDigit = true,
    //            RequireDigit = true,
    //            RequireLowercase = true,
    //            RequireUppercase = true,
    //        };

    //        // Configure user lockout defaults
    //        manager.UserLockoutEnabledByDefault = true;
    //        manager.DefaultAccountLockoutTimeSpan = TimeSpan.FromMinutes(5);
    //        manager.MaxFailedAccessAttemptsBeforeLockout = 5;

    //        // Register two factor authentication providers. This application uses Phone and Emails as a step of receiving a code for verifying the user
    //        // You can write your own provider and plug it in here.
    //        manager.RegisterTwoFactorProvider("Phone Code", new PhoneNumberTokenProvider<ApplicationUserAlumnos>
    //        {
    //            MessageFormat = "Your security code is {0}"
    //        });
    //        manager.RegisterTwoFactorProvider("Email Code", new EmailTokenProvider<ApplicationUserAlumnos>
    //        {
    //            Subject = "Security Code",
    //            BodyFormat = "Your security code is {0}"
    //        });
    //        manager.EmailService = new EmailService();
    //        manager.SmsService = new SmsService();
    //        var dataProtectionProvider = options.DataProtectionProvider;
    //        if (dataProtectionProvider != null)
    //        {
    //            manager.UserTokenProvider =
    //                new DataProtectorTokenProvider<ApplicationUserAlumnos>(dataProtectionProvider.Create("ASP.NET Identity"));
    //        }
    //        return manager;
    //    }
    //}

    //// Configure the application sign-in manager which is used in this application.
    //public class ApplicationAlumnosSignInManager : SignInManager<ApplicationUserAlumnos, string>
    //{
    //    public ApplicationAlumnosSignInManager(ApplicationUserAlumnosManager userManager, IAuthenticationManager authenticationManager)
    //        : base(userManager, authenticationManager)
    //    {
    //    }

    //    public override Task<ClaimsIdentity> CreateUserIdentityAsync(ApplicationUserAlumnos user)
    //    {
    //        return user.GenerateUserIdentityAsync((ApplicationUserAlumnosManager)UserManager);

    //    }

    //    public static ApplicationAlumnosSignInManager Create(IdentityFactoryOptions<ApplicationAlumnosSignInManager> options, IOwinContext context)
    //    {
    //        return new ApplicationAlumnosSignInManager(context.GetUserManager<ApplicationUserAlumnosManager>(), context.Authentication);
    //    }
    //}

    //public class ApplicationUserTutoresManager : UserManager<ApplicationUserTutores>
    //{
    //    public ApplicationUserTutoresManager(IUserStore<ApplicationUserTutores> store)
    //        : base(store)
    //    {
    //    }

    //    public static ApplicationUserTutoresManager Create(IdentityFactoryOptions<ApplicationUserTutoresManager> options, IOwinContext context)
    //    {
    //        /* var manager = new ApplicationUserManager(new UserStore<ApplicationUser>(context.Get<ApplicationDbContext>()));*/

    //        var manager = new ApplicationUserTutoresManager(
    //                                new IdentityTutores.UserStore<ApplicationUserTutores>(
    //                                context.Get<ApplicationTutoresDbContext>() as IdentityTutores.DataModel.DatabaseTutoresContext));
    //        // Configure validation logic for usernames
    //        manager.UserValidator = new UserValidator<ApplicationUserTutores>(manager)
    //        {
    //            AllowOnlyAlphanumericUserNames = false,
    //            RequireUniqueEmail = true
    //        };

    //        // Configure validation logic for passwords
    //        manager.PasswordValidator = new PasswordValidator
    //        {
    //            RequiredLength = 6,
    //            RequireNonLetterOrDigit = true,
    //            RequireDigit = true,
    //            RequireLowercase = true,
    //            RequireUppercase = true,
    //        };

    //        // Configure user lockout defaults
    //        manager.UserLockoutEnabledByDefault = true;
    //        manager.DefaultAccountLockoutTimeSpan = TimeSpan.FromMinutes(5);
    //        manager.MaxFailedAccessAttemptsBeforeLockout = 5;

    //        // Register two factor authentication providers. This application uses Phone and Emails as a step of receiving a code for verifying the user
    //        // You can write your own provider and plug it in here.
    //        manager.RegisterTwoFactorProvider("Phone Code", new PhoneNumberTokenProvider<ApplicationUserTutores>
    //        {
    //            MessageFormat = "Your security code is {0}"
    //        });
    //        manager.RegisterTwoFactorProvider("Email Code", new EmailTokenProvider<ApplicationUserTutores>
    //        {
    //            Subject = "Security Code",
    //            BodyFormat = "Your security code is {0}"
    //        });
    //        manager.EmailService = new EmailService();
    //        manager.SmsService = new SmsService();
    //        var dataProtectionProvider = options.DataProtectionProvider;
    //        if (dataProtectionProvider != null)
    //        {
    //            manager.UserTokenProvider =
    //                new DataProtectorTokenProvider<ApplicationUserTutores>(dataProtectionProvider.Create("ASP.NET Identity"));
    //        }
    //        return manager;
    //    }
    //}

    //// Configure the application sign-in manager which is used in this application.
    //public class ApplicationTutoresSignInManager : SignInManager<ApplicationUserTutores, string>
    //{
    //    public ApplicationTutoresSignInManager(ApplicationUserTutoresManager userManager, IAuthenticationManager authenticationManager)
    //        : base(userManager, authenticationManager)
    //    {
    //    }

    //    public override Task<ClaimsIdentity> CreateUserIdentityAsync(ApplicationUserTutores user)
    //    {
    //        return user.GenerateUserIdentityAsync((ApplicationUserTutoresManager)UserManager);
    //    }

    //    public static ApplicationTutoresSignInManager Create(IdentityFactoryOptions<ApplicationTutoresSignInManager> options, IOwinContext context)
    //    {
    //        return new ApplicationTutoresSignInManager(context.GetUserManager<ApplicationUserTutoresManager>(), context.Authentication);
    //    }
    //}

    // Configure el administrador de usuarios de aplicación que se usa en esta aplicación. UserManager se define en ASP.NET Identity y se usa en la aplicación.
    public class ApplicationUserManagerAlumnos : UserManager<ApplicationUserAlumnos>
    {
        public ApplicationUserManagerAlumnos(IUserStore<ApplicationUserAlumnos> store)
            : base(store)
        {
        }

        public static ApplicationUserManagerAlumnos Create(IdentityFactoryOptions<ApplicationUserManagerAlumnos> options, IOwinContext context)
        {
            var manager = new ApplicationUserManagerAlumnos(new UserStore<ApplicationUserAlumnos>(context.Get<ApplicationDbContextAlumnos>()));
            // Configure la lógica de validación de nombres de usuario
            manager.UserValidator = new UserValidator<ApplicationUserAlumnos>(manager)
            {
                AllowOnlyAlphanumericUserNames = false,
                RequireUniqueEmail = true
            };

            // Configure la lógica de validación de contraseñas
            manager.PasswordValidator = new PasswordValidator
            {
                RequiredLength = 6,
                RequireNonLetterOrDigit = true,
                RequireDigit = true,
                RequireLowercase = true,
                RequireUppercase = true,
            };

            // Configurar valores predeterminados para bloqueo de usuario
            manager.UserLockoutEnabledByDefault = true;
            manager.DefaultAccountLockoutTimeSpan = TimeSpan.FromMinutes(5);
            manager.MaxFailedAccessAttemptsBeforeLockout = 5;

            // Registre proveedores de autenticación en dos fases. Esta aplicación usa los pasos Teléfono y Correo electrónico para recibir un código para comprobar el usuario
            // Puede escribir su propio proveedor y conectarlo aquí.
            manager.RegisterTwoFactorProvider("Código telefónico", new PhoneNumberTokenProvider<ApplicationUserAlumnos>
            {
                MessageFormat = "Su código de seguridad es {0}"
            });
            manager.RegisterTwoFactorProvider("Código de correo electrónico", new EmailTokenProvider<ApplicationUserAlumnos>
            {
                Subject = "Código de seguridad",
                BodyFormat = "Su código de seguridad es {0}"
            });
            manager.EmailService = new EmailService();
            manager.SmsService = new SmsService();
            var dataProtectionProvider = options.DataProtectionProvider;
            if (dataProtectionProvider != null)
            {
                manager.UserTokenProvider =
                    new DataProtectorTokenProvider<ApplicationUserAlumnos>(dataProtectionProvider.Create("ASP.NET Identity"));
            }
            return manager;
        }
    }

 // Configure el administrador de inicios de sesión que se usa en esta aplicación.
    public class ApplicationSignInManagerAlumnos : SignInManager<ApplicationUserAlumnos, string>
    {
        public ApplicationSignInManagerAlumnos(ApplicationUserManagerAlumnos userManager, IAuthenticationManager authenticationManager)
            : base(userManager, authenticationManager)
        {
        }

        public override Task<ClaimsIdentity> CreateUserIdentityAsync(ApplicationUserAlumnos user)
        {
            return user.GenerateUserIdentityAsync((ApplicationUserManagerAlumnos)UserManager);
        }

        public static ApplicationSignInManagerAlumnos Create(IdentityFactoryOptions<ApplicationSignInManagerAlumnos> options, IOwinContext context)
        {
            return new ApplicationSignInManagerAlumnos(context.GetUserManager<ApplicationUserManagerAlumnos>(), context.Authentication);
        }
    }


   
    public class ApplicationUserManagerTutores : UserManager<ApplicationUserTutores>
    {
        public ApplicationUserManagerTutores(IUserStore<ApplicationUserTutores> store)
            : base(store)
        {
        }

        public static ApplicationUserManagerTutores Create(IdentityFactoryOptions<ApplicationUserManagerTutores> options, IOwinContext context)
        {
            var manager = new ApplicationUserManagerTutores(new UserStore<ApplicationUserTutores>(context.Get<ApplicationDbContextTutores>()));
            // Configure la lógica de validación de nombres de usuario
            manager.UserValidator = new UserValidator<ApplicationUserTutores>(manager)
            {
                AllowOnlyAlphanumericUserNames = false,
                RequireUniqueEmail = true
            };

            // Configure la lógica de validación de contraseñas
            manager.PasswordValidator = new PasswordValidator
            {
                RequiredLength = 6,
                RequireNonLetterOrDigit = true,
                RequireDigit = true,
                RequireLowercase = true,
                RequireUppercase = true,
            };

            // Configurar valores predeterminados para bloqueo de usuario
            manager.UserLockoutEnabledByDefault = true;
            manager.DefaultAccountLockoutTimeSpan = TimeSpan.FromMinutes(5);
            manager.MaxFailedAccessAttemptsBeforeLockout = 5;

            // Registre proveedores de autenticación en dos fases. Esta aplicación usa los pasos Teléfono y Correo electrónico para recibir un código para comprobar el usuario
            // Puede escribir su propio proveedor y conectarlo aquí.
            manager.RegisterTwoFactorProvider("Código telefónico", new PhoneNumberTokenProvider<ApplicationUserTutores>
            {
                MessageFormat = "Su código de seguridad es {0}"
            });
            manager.RegisterTwoFactorProvider("Código de correo electrónico", new EmailTokenProvider<ApplicationUserTutores>
            {
                Subject = "Código de seguridad",
                BodyFormat = "Su código de seguridad es {0}"
            });
            manager.EmailService = new EmailService();
            manager.SmsService = new SmsService();
            var dataProtectionProvider = options.DataProtectionProvider;
            if (dataProtectionProvider != null)
            {
                manager.UserTokenProvider =
                    new DataProtectorTokenProvider<ApplicationUserTutores>(dataProtectionProvider.Create("ASP.NET Identity"));
            }
            return manager;
        }
    }

  //  Configure el administrador de inicios de sesión que se usa en esta aplicación.
    public class ApplicationSignInManagerTutores : SignInManager<ApplicationUserTutores, string>
    {
        public ApplicationSignInManagerTutores(ApplicationUserManagerTutores userManager, IAuthenticationManager authenticationManager)
            : base(userManager, authenticationManager)
        {
        }

        public override Task<ClaimsIdentity> CreateUserIdentityAsync(ApplicationUserTutores user)
        {
            return user.GenerateUserIdentityAsync((ApplicationUserManagerTutores)UserManager);
        }

        public static ApplicationSignInManagerTutores Create(IdentityFactoryOptions<ApplicationSignInManagerTutores> options, IOwinContext context)
        {
            return new ApplicationSignInManagerTutores(context.GetUserManager<ApplicationUserManagerTutores>(), context.Authentication);
        }
    }


}
