﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Claims;
using System.Web;
using System.Web.Mvc;

    public class HasPermissionAttribute : ActionFilterAttribute
    {
        private string _permission;

        public HasPermissionAttribute(string permission)
        {
            this._permission = permission;
        }

        public override void OnActionExecuting(ActionExecutingContext filterContext)
        {
            if (_permission != "")
            {
                var user = System.Web.HttpContext.Current.User as ClaimsPrincipal;
                if (user == null)
                { 
                        var url = new UrlHelper(filterContext.RequestContext);
                        var loginUrl = url.Content("/" + this._permission + "/Login");
                        filterContext.HttpContext.Response.Redirect(loginUrl, true);}
                else
                if (user.HasClaim(c => c.Type == ClaimTypes.Role))

                    if (user.FindFirst(c => c.Type == ClaimTypes.Role).Value != _permission)
                    //if (!CHECK_IF_USER_OR_ROLE_HAS_PERMISSION(_permission))
                    {
                        // If this user does not have the required permission then redirect to login page
                        //var url = new UrlHelper(filterContext.RequestContext);
                        //var loginUrl = url.Content("/Account/Login");
                        //filterContext.HttpContext.Response.Redirect(loginUrl, true);
                        throw new ApplicationException("No estas autorizado para realizar esta acción");
                    }
            }
        }
    }
