﻿

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Dapper;
using System.Globalization;

namespace SeguridadAlumnos
{

    public partial class catalogoAlumnos
    {
        public string Matricula { get; set; }
        public string Nombre { get; set; }
        public string ApPaterno { get; set; }
        public string ApMaterno { get; set; }
        public string Curp { get; set; }
        public string Sexo { get; set; }
        public Nullable<System.DateTime> FechaNacimiento { get; set; }
        public short IdLocalidadNac { get; set; }
        public short IdMpioNac { get; set; }
        public short IdEstadoNac { get; set; }
        public string Calle { get; set; }
        public string Numero { get; set; }
        public string Colonia { get; set; }
        public Nullable<int> CodigoPostal { get; set; }
        public short IdLocalidadViv { get; set; }
        public short IdMpioViv { get; set; }
        public short IdEstadoViv { get; set; }
        public string ClaveLada { get; set; }
        public string Telefono { get; set; }
        public string CorreoElectronico { get; set; }
        public Nullable<short> IdTipoSanguineo { get; set; }
        public Nullable<short> IdGrupoEtnico { get; set; }
        public string BecaOportunidades { get; set; }
        public Nullable<short> IdEstadoCivil { get; set; }
        public string NombrePadre { get; set; }
        public string ApPaternoPadre { get; set; }
        public string ApMaternoPadre { get; set; }
        public Nullable<short> IdOcupacionPadre { get; set; }
        public string TelefonoPadre { get; set; }
        public string NombreMadre { get; set; }
        public string ApPaternoMadre { get; set; }
        public string ApMaternoMadre { get; set; }
        public Nullable<short> IdOcupacionMadre { get; set; }
        public string TelefonoMadre { get; set; }
        public string NombreTutor { get; set; }
        public string ApPaternoTutor { get; set; }
        public string ApMaternoTutor { get; set; }
        public Nullable<short> IdOcupacionTutor { get; set; }
        public string TelefonoTutor { get; set; }
        public Nullable<short> IdTiempoTranslado { get; set; }
        public Nullable<short> IdTransporte { get; set; }
        public string cveSecundaria { get; set; }
        public Nullable<decimal> PromedioSecundaria { get; set; }
        public int IdPlanEstudio { get; set; }
        public short IdValorCicloIngreso { get; set; }
        public short IdCicloEscolar { get; set; }
        public string NoImss { get; set; }
        public short IdStatusAlumno { get; set; }
        public short IdCampus { get; set; }
        public short IdValorCiclo { get; set; }
        public Nullable<System.DateTime> FechaModificacion { get; set; }
        public Nullable<int> IdUsuario { get; set; }
        public Nullable<short> IdStatusProceso { get; set; }
        public Nullable<short> IdPlanEstudioA { get; set; }
        public Nullable<short> IdPlanEstudioB { get; set; }
        public bool CurpPorSistema { get; set; }
        public bool EsRegular { get; set; }
        public Nullable<short> IdGrupoCampus { get; set; }
        public Nullable<short> IdGrupoNombre { get; set; }
        public short IdCicloEscolarIngreso { get; set; }
        public Nullable<System.DateTime> FechaSolicitud { get; set; }
        public Nullable<decimal> PromedioSecundariaAdmision { get; set; }
        public Nullable<bool> AsistenciaExamen { get; set; }
        public Nullable<decimal> CalificacionExamenIngreso { get; set; }
        public Nullable<bool> Condicionado { get; set; }
        public Nullable<short> NumeroBajasTemporales { get; set; }
        public Nullable<System.DateTime> FechaUltimaBajaTemporal { get; set; }
        public Nullable<decimal> IngresoFamiliar { get; set; }
        public Nullable<short> KmCasaaCampus { get; set; }
        public bool NoRequiereTitulo { get; set; }
        public long IdAlumno { get; set; }
        public Nullable<System.DateTime> FechaNacimientoTutor { get; set; }
        public Nullable<short> IdGradoEstudiosTutor { get; set; }
        public Nullable<System.DateTime> FechaNacimientoPadre { get; set; }
        public Nullable<short> IdGradoEstudiosPadre { get; set; }
        public Nullable<bool> EsFinadoPadre { get; set; }
        public Nullable<System.DateTime> FechaNacimientoMadre { get; set; }
        public Nullable<short> IdGradoEstudiosMadre { get; set; }
        public Nullable<bool> EsFinadaMadre { get; set; }
        public Nullable<short> IdSituacionFamiliar { get; set; }
        public Nullable<short> IdLocalidadVivTutor { get; set; }
        public Nullable<short> IdMpioVivTutor { get; set; }
        public Nullable<short> IdEstadoVivTutor { get; set; }
        public string CalleTutor { get; set; }
        public string NumeroTutor { get; set; }
        public string ColoniaTutor { get; set; }
        public string CodigoPostalTutor { get; set; }
        public string ClaveLadaTutor { get; set; }
        public string CorreoElectronicoTutor { get; set; }
        public string PlanEstudio { get; set; }
        public string Campus { get; set; }
        public string CicloEscolar { get; set; }
        public short IdCarrera { get; set; }
        public string Carrera { get; set; }
        public short IdModalidadEstudio { get; set; }


    }

    public sealed class Alumnos
    {

        private static volatile Alumnos instance;
        private static object syncRoot = new Object();
        private static bdAriesAlumnos db = new bdAriesAlumnos();




        public List<SeguridadAlumnos.catalogoAlumnos> ctAlumnos;

        private void setAlumnos()
        {
            DapperQuery dp = new DapperQuery("bdAriesAlumnos");
            string query;

            //           query = @"SELECT c.IdKardex,a.IdConvenioLaboralTrabajadorCategoria ,a.FechaTermino FROM Convenios_stConvenioLaboralTrabajadorCategoria a
            //            inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
            //            inner join Kardex_ctTrabajador c on b.IdTrabajador=c.IdTrabajador
            //            inner join Catalogos_ctEstructuraOrganica d on  a.IdEstructuraOrganica = d.IdEstructuraOrganica
            //            order by a.FechaInicio desc";
            //           ConveniosUsuarios = (List<ConvenioLaboralTrabajadorCategoriaValido>)dp.connection.Query<ConvenioLaboralTrabajadorCategoriaValido>(query);
            query = @"SELECT Matricula
      ,a.Nombre
      ,ApPaterno
      ,ApMaterno
      ,Curp
      ,Sexo
      ,FechaNacimiento
      ,IdLocalidadNac
      ,IdMpioNac
      ,IdEstadoNac
      ,Calle
      ,a.Numero
      ,Colonia
      ,CodigoPostal
      ,IdLocalidadViv
      ,IdMpioViv
      ,IdEstadoViv
      ,ClaveLada
      ,Telefono
      ,CorreoElectronico
      ,IdTipoSanguineo
      ,IdGrupoEtnico
      ,BecaOportunidades
      ,IdEstadoCivil
      ,NombrePadre
      ,ApPaternoPadre
      ,ApMaternoPadre
      ,IdOcupacionPadre
      ,TelefonoPadre
      ,NombreMadre
      ,ApPaternoMadre
      ,ApMaternoMadre
      ,IdOcupacionMadre
      ,TelefonoMadre
      ,NombreTutor
      ,ApPaternoTutor
      ,ApMaternoTutor
      ,IdOcupacionTutor
      ,TelefonoTutor
      ,IdTiempoTranslado
      ,IdTransporte
      ,cveSecundaria
      ,PromedioSecundaria
      ,a.IdPlanEstudio
      ,IdValorCicloIngreso
      ,a.IdCicloEscolar
      ,NoImss
      ,IdStatusAlumno
      ,a.IdCampus
      ,IdValorCiclo
      ,FechaModificacion
      ,IdUsuario
      ,IdStatusProceso
      ,IdPlanEstudioA
      ,IdPlanEstudioB
      ,CurpPorSistema
      ,EsRegular
      ,IdGrupoCampus
      ,IdGrupoNombre
      ,IdCicloEscolarIngreso
      ,FechaSolicitud
      ,PromedioSecundariaAdmision
      ,AsistenciaExamen
      ,CalificacionExamenIngreso
      ,Condicionado
      ,NumeroBajasTemporales
      ,FechaUltimaBajaTemporal
      ,IngresoFamiliar
      ,KmCasaaCampus
      ,NoRequiereTitulo
      ,IdAlumno
      ,FechaNacimientoTutor
      ,IdGradoEstudiosTutor
      ,FechaNacimientoPadre
      ,IdGradoEstudiosPadre
      ,EsFinadoPadre
      ,FechaNacimientoMadre
      ,IdGradoEstudiosMadre
      ,EsFinadaMadre
      ,IdSituacionFamiliar
      ,IdLocalidadVivTutor
      ,IdMpioVivTutor
      ,IdEstadoVivTutor
      ,CalleTutor
      ,NumeroTutor
      ,ColoniaTutor
      ,CodigoPostalTutor
      ,ClaveLadaTutor
    ,CorreoElectronicoTutor
      ,b.Nombre as  PlanEstudio 
        ,NombreLargo as Campus
        ,d.Nombre as  CicloEscolar 
        ,b.IdCarrera
        ,c.Nombre as Carrera 
        ,b.IdModalidadEstudio
  FROM ctAlumnos a inner join ctPlanEstudio b on a.IdPlanEstudio=b.IdPlanEstudio
  inner join ctCarrera c on c.IdCarrera=b.IdCarrera
  inner join ctCicloescolar d on a.IdCicloEscolar=d.IdCicloEscolar
  inner join ctCampus e on a.IdCampus=e.IdCampus";
            this.ctAlumnos = (List<catalogoAlumnos>)dp.connection.Query<catalogoAlumnos>(query);

            dp.Close();


        }

        public void Reset()
        {
            setAlumnos();
        }
        private Alumnos()
        {

            setAlumnos();

        }

        public static Alumnos Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new Alumnos();
                    }
                }

                return instance;
            }
        }

        public SeguridadAlumnos.catalogoAlumnos Logeado(string email)
        {
            if (email.Trim() == "")
                return new SeguridadAlumnos.catalogoAlumnos();
            else
                return ctAlumnos.Where(s => s.CorreoElectronico == email).FirstOrDefault();
        }


        public class LoginStatus
        {
            public bool Success { get; set; }
            public string Message { get; set; }
            public string TargetURL { get; set; }
            public string Curp { get; set; }

        }

        public LoginStatus ValidateUser(string email)
        {
            LoginStatus status = new LoginStatus();


            status.Success = true;


            var usuario = Instance.ctAlumnos.Where(b => b.CorreoElectronico == email.ToLower()).FirstOrDefault();




            if (usuario == null)
            {
                status.Message = "Estimado usuario, no existe el correo electronico en nuestra base de datos, te sugerimos verificar con tu oficina de control escolar tu cuenta y/o actualizar tu información";
                status.Success = false;
            }
            else
            {
                status.Curp = usuario.Curp;


            }


            return status;

        }

        public void ActualizarLog(string email)
        {

            var usuario = Instance.ctAlumnos.Where(b => b.CorreoElectronico == email.ToLower()).FirstOrDefault();

            DapperQuery dp = new DapperQuery("bdSeguridadAlumnos");
            DateTime hoy = DateTime.Now.Date;

            CultureInfo ci = new CultureInfo("Es-Mx");

            string query;


            query = @" INSERT INTO UsersLog
           (email
           ,Ingreso
           ,Año
           ,Mes
           ,Dia
           ,NombreDia
           ,Hora,Minuto,Campus,Grado)
     VALUES
           ('" + email + @"'
           ,GETDATE()
           ,year(GETDATE())
           ,month(GETDATE())
           ,day(GETDATE())
           ,'" + ci.DateTimeFormat.GetDayName(DateTime.Now.DayOfWeek).ToUpper() + @"'
           ,DATEPART(HOUR,GETDATE())
           ,DATEPART(MINUTE,GETDATE()),'" + usuario.Campus + "'," + usuario.IdValorCiclo + ")";


            dp.connection.Execute(query);


            dp.Close();

        }

    }
}
