﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data.SqlClient;
using System.Linq;
using System.Threading.Tasks;

namespace Nova.Models.Trabajador
{
    public class ComprobantePago
    {
        public long IdNominaTrabajador { get; set; }
        public string QuincenaMes { get; set; }
        public string MesNomina { get; set; }
        public string Periodo { get; set; }
        public string GrupoPagoNomina { get; set; }
        public string TipoNomina { get; set; }
        public string EtiquetaReporte { get; set; }
        public string UUID { get; set; }
        public bool EsCancelado { get; set; }
        public string NombreCompleto { get; set; }
        public string Nomina { get; set; }
        public int Año { get; set; }
        public byte[] PDFFile { get; set; }
    }

    public static class Comprobante
    {
       

        public static DapperQuery dp = new DapperQuery("bdNovaEntities");

        internal static async Task<IEnumerable<int>> ObtenerAñosPagoTrabajadorAsync(int idTrabajador)

        {
            
            string selectQuery = @"select Año from Nomina_stNominaTrabajadorHistorial 
                                        where Año>=2025 and IdTrabajador=@IdTrabajador 
                                        group by Año order by Año desc";
            try
            {
              
                    
                    var parameters = new { IdTrabajador = idTrabajador };
                    var resultado = await dp.connection.QueryAsync<int>(selectQuery, parameters);

                    if (resultado == null)
                    {
                        throw new Exception("No se encontraron registros para el trabajador");
                    }
                    dp.Close();

                    return resultado;
                
            }
            catch (SqlException ex)
            {
                throw new Exception($"Error de base de datos: {ex.Message}", ex);
            }
            catch (Exception ex)
            {
                throw new Exception("Error al tratar de obtener el campo años. ", ex);
            }
        }

        internal static async Task<IEnumerable<ComprobantePago>> ObtenerDatosComprobantePagoTrabajadorAsync(int idTrabajador, int año)
        {
            var bd = ObtenerNombreBaseDatos("bdNovaTimbrado");
            

            string selectQuery = $@"
                        select a.IdNominaTrabajador,QuincenaMes,MesNomina,Periodo='QUINCENA'+space(1)+QuincenaMes+space(1)+MesNomina
                                ,GrupoPagoNomina,TipoNomina,EtiquetaReporte
                                    ,c.UUID,c.EsCancelado,max(NombreCompleto) as NombreCompleto
                                            ,EtiquetaReporte +SPACE(1)+TipoNomina as Nomina
                                            from Nomina_stNominaTrabajadorHistorial a
                                            left join Nomina_DispersionTrabajador b on a.IdNominaTrabajador=b.IdNominaTrabajador
                                                left join {bd}.dbo.Nomina_stNominaXMLPDF c on c.IdNominaTrabajador=b.IdNominaTrabajador
                                                    where Año=@Año and EstatusNomina in ('NORMAL','RECALCULO')
                                                        and b.EsTimbrado=1  and (c.ErrorSistema=0 and c.EsCancelado=0)
                                                            and IdTrabajador=@IdTrabajador
                          group by QuincenaMes,MesNomina,GrupoPagoNomina,TipoNomina,EtiquetaReporte,a.IdNominaTrabajador
                          ,c.UUID,c.ErrorSistema,c.EsCancelado
                            order by QuincenaMes,EtiquetaReporte,TipoNomina";
            try
            {
                
                    var parameters = new { IdTrabajador = idTrabajador, Año = año };
                    var resultado = await dp.connection.QueryAsync<ComprobantePago>(selectQuery, parameters);

                    if (resultado == null || resultado.Count() == 0)
                    {
                        throw new Exception("No se encontraron registros para el trabajador");
                    }
                    return resultado;
                
            }
            catch (SqlException ex)
            {
                throw new Exception($"Error de base de datos: {ex.Message}", ex);
            }
            catch (Exception ex)
            {
                throw new Exception("Error al tratar de obtener los datos.", ex);
            }
        }

        internal static async Task<byte[]> ObtenerComprobantePDF(int idNominaTrabajador, string uuid)
        {
            var bd = ObtenerNombreBaseDatos("bdNovaTimbrado");

            string selectQuery = string.Format(@"SELECT PDF FROM {0}.dbo.Nomina_stNominaXMLPDF 
                           WHERE IdNominaTrabajador = @IdNominaTrabajador AND UUID = @UUID", bd);

            try
            {
               
                  
                    var parameters = new { IdNominaTrabajador = idNominaTrabajador, UUID = uuid };
                    var resultado = await dp.connection.ExecuteScalarAsync<byte[]>(selectQuery, parameters);

                    if (resultado == null)
                        throw new Exception("No se encontró el comprobante digital para el trabajador");

                    return resultado;
                 
            }
            catch (SqlException ex)
            {
                throw new Exception($"Error de base de datos: {ex.Message}", ex);
            }
            catch (Exception ex)
            {
                throw new Exception("Error al obtener el comprobante PDF", ex);
            }
        }

        private static string ObtenerNombreBaseDatos(string cnstring)
        {
            try
            {
                var connectionString = ConfigurationManager.ConnectionStrings[cnstring].ConnectionString;
                var providerConnectionString = connectionString.Split(new[] { "provider connection string=\"" }, StringSplitOptions.None)[1].Split('"')[0];
                var sqlBuilder = new SqlConnectionStringBuilder(providerConnectionString);
                return sqlBuilder.InitialCatalog;
            }
            catch (Exception e)
            {
                throw new Exception(ExceptionExtensions.GetOriginalException(e).Message);
            }



        }
    }
}