﻿using Dapper;
using DevExpress.Data.Filtering.Helpers;
using Nova.Libraries;
using Nova.Models.AsignarPlaza;
using Nova.Models.Kardex;

using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Globalization;
using System.Linq;
using System.Web;
using Nova.Models.Calculos;
namespace Nova.Models.Sindicato
{
    public class Contratos
    {
        private bdNovaEntities dbNova = new bdNovaEntities();

        public Contratos(long idKardexSolicitudEvaluacion)
        {
            var datosSolicitud = this.dbNova.Kardex_SolicitudEvaluaciones.Find(idKardexSolicitudEvaluacion);
            IdKardexSolicitudEvaluacion = idKardexSolicitudEvaluacion;
            this.Aspirante = ObtenDatosGenerales(datosSolicitud.IdKardexCandidato);
            this.Laborales = ObtenDatosLaborales(idKardexSolicitudEvaluacion);
            this.Laborales.DatosJefeInmediato = ObtenDatosGenerales(this.Laborales.IdKardexResponsableArea);
            this.Laborales.DatosPersonalBase = ObtenDatosGenerales(this.Laborales.IdKardexPersonalBase);
            var horasCentroAutorizadas = dbNova.Kardex_EstructuraOrganicaHorasAutorizadas.Where(y => y.IdEstructuraOrganica == datosSolicitud.IdEstructuraOrganicaLaboraFisicamente);
            List<CargaHoraria> cargaHorariaAutorizada = new List<CargaHoraria>();

            cargaHorariaAutorizada = ObtenCargaHoraria(datosSolicitud.IdKardexSolicitudEvaluacion);
            this.CargaHorariaAutorizada = cargaHorariaAutorizada;


            //if (this.Laborales.IdConvenioLaboralTrabajadorCategoria == 0)
            //{
            //    throw new ArgumentException("EL ASPIRANTE NO CUENTA CON UNA PLAZA ASIGNADA [" + this.Laborales.IdKardexCandidato + "] " + this.Aspirante.NombreCompleto);
            //}

            if (this.Laborales.RelacionLaboral == "DOCENTE" && this.CargaHorariaAutorizada.Count == 0)
            {
                throw new ArgumentException("EL DOCENTE NO CUENTA CON CARGA HORARIA AUTORIZADA [" + this.Laborales.IdKardexCandidato + "] " + this.Aspirante.NombreCompleto);
            }

            if (this.CargaHorariaAutorizada.Max(y => y.maximaAreaConocimiento) == null)
            {
                foreach (var item in CargaHorariaAutorizada)
                {
                    item.maximaAreaConocimiento = this.CargaHorariaAutorizada.Where(x => !x.Descripcion.Contains("ACTIVIDAD COMPLEMENTARIA")).Max(m => m.Descripcion);
                }
            }


            if (this.Laborales.EstatusContrato == "CONTRATADO")
            {

                CalculadoraSueldo calculadora = new CalculadoraSueldo();
                NominaParaContrato datos = new NominaParaContrato();

                if (this.Laborales.IdConvenioLaboralTrabajadorCategoria > 0)
                {



                    if (this.Laborales.RelacionLaboral == "DOCENTE")
                    {
                        int horasTotales = this.CargaHorariaAutorizada.Sum(y => y.TotalHoras);
                        int horasExtraOrdinarias = this.CargaHorariaAutorizada.Sum(y => y.HorasExtraOrdinarias);
                        horasTotales = (horasTotales < 0 ? horasTotales * -1 : horasTotales);
                        if (horasTotales > 0)
                        {

                            datos = calculadora.getSueldoVigente(this.Laborales.IdConvenioLaboralTrabajadorCategoria, horasTotales, datosSolicitud.FechaInicio);
                            this.Laborales.HorasSemanaMes = horasTotales;
                            this.Laborales.HorasExtraOrdinarias = horasExtraOrdinarias;
                        }
                        else { throw new ArgumentException("EL DOCENTE NO CUENTA CON CARGA HORARIA AUTORIZADA [" + this.Laborales.IdKardexCandidato + "] " + this.Aspirante.NombreCompleto); }
                    }
                    else
                    {
                        datos = calculadora.getSueldoVigente(this.Laborales.IdConvenioLaboralTrabajadorCategoria, this.Laborales.HorasSemanaMes, datosSolicitud.FechaInicio);
                    }
                }
                else
                {
                    throw new Exception("EL TRABAJADOR AÚN NO CUENTA CON UNA PLAZA AUTORIZADA POR EL ÁREA DE RECURSOS HUMANOS!");
                }
                this.Laborales.ImporteSalarioQuincenal = datos.Sueldo;
                this.Laborales.LetraImporteSalarioQuincenal = TextoMoneda.ConvertirCantidadALetras(datos.Sueldo);
                this.Laborales.ImporteAyudaDespensa = datos.AyudaParaDespensa;
                this.Laborales.LetraImporteAyudaDespensa = TextoMoneda.ConvertirCantidadALetras(datos.AyudaParaDespensa);
                this.Laborales.ImporteEficiencia = datos.Eficiencia;
                this.Laborales.LetraImporteEficiencia = TextoMoneda.ConvertirCantidadALetras(datos.Eficiencia);
                this.Laborales.ImporteApoyoMaterialDidactico = datos.MaterialDidactico;
                this.Laborales.LetraImporteApoyoMaterialDidactico = TextoMoneda.ConvertirCantidadALetras(datos.MaterialDidactico);
            }

            //else
            //{
            //    throw new Exception("EL TRABAJADOR AÚN NO CUENTA CON EL ESTATUS 'CONTRATADO' NECESARIO PARA ESTA ACCIÓN. ESTATUS ACTUAL :" + this.Laborales.EstatusContrato);
            //}
            if (horasCentroAutorizadas.Count() > 0)
            {
                short horasCentro = horasCentroAutorizadas.FirstOrDefault().HorasAutorizadas;
                this.Laborales.HorasAutorizadas = horasCentro;

            }
            List<Nomina_SuplenciasSolicitudes> suplenciasSolicitudesControl = new List<Nomina_SuplenciasSolicitudes>();
            suplenciasSolicitudesControl = datosSolicitud.Nomina_SuplenciasSolicitudes.Where(x => x.IdKardexSolicitudEvaluacion == this.IdKardexSolicitudEvaluacion).ToList();

            if (suplenciasSolicitudesControl.Count > 0)
            {
                if (suplenciasSolicitudesControl.FirstOrDefault().IdKardexSuplido.HasValue)
                {
                    int idkardex = suplenciasSolicitudesControl.FirstOrDefault().IdKardexSuplido.Value;
                    this.PersonalACubrir = ObtenDatosGenerales(idkardex);
                }

            }

        }


        //-----------------------------------------------------------
        public string ImagenOficio { get; set; }
        public DatosGenerales Aspirante { get; set; }
        public DatosGenerales PersonalACubrir { get; set; }
        //public DatosGenerales PersonalEncargadoArea { get; set; }
        public DatosLaborales Laborales { get; set; }
        public List<CargaHoraria> CargaHorariaAutorizada { get; set; }
        public long IdKardexSolicitudEvaluacion { get; }


        internal static Contratos getContrato(int idKardexSolicitudEvaluacion)
        {
            return new Contratos(idKardexSolicitudEvaluacion);
        }


        public DatosGenerales ObtenDatosGenerales(int idKadex)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = $@"
                        DECLARE @idKardex INT
                        SET @idKardex = {idKadex}

                        ;WITH KardexGrado AS (
                            SELECT TOP 1
                                b.IdKardex,
                                c.KardexNivelEstudio AS GradoAcademico,
                                b.AbreviaturaProfesion AS AbreviaturaGradoAcademico,
                                b.NivelEstudioDescripcion,
                                b.NumeroCedulaProfesional
                            FROM Kardex_ctDatosPersonales a
                            LEFT JOIN Kardex_GradoAcademico b ON a.IdKardex = b.IdKardex
                            LEFT JOIN Kardex_NivelEstudio c ON c.IdKardexNivelEstudio = b.IdKardexNivelEstudio
                            WHERE a.IdKardex = @idKardex
                            ORDER BY Orden DESC, AñoTermino DESC
                        ),

                        DatosGenerales AS (
                            SELECT
                                a.IdKardex,
                                a.Nombre,
                                a.ApellidoPaterno,
                                a.ApellidoMaterno,
                                a.ApellidoPaterno+SPACE(1)+a.ApellidoMaterno+SPACE(1)+a.Nombre as NombreCompleto, 
                                a.Telefono as TelefonoParticular,
                                a.TelefonoCelular,
                                a.RFC,
                                a.CURP,
                                a.CorreoElectronico,
                                EstadoCivil=CASE WHEN a.Sexo='M' then LEFT(c.EstadoCivil, LEN(c.EstadoCivil) - 1) + 'A' else c.EstadoCivil end,
                                Nacionalidad = CASE WHEN a.IdPais = 154 THEN 'Mexicana' ELSE 'Extranjera' END,
                                EsMujer = CASE WHEN a.Sexo = 'M' THEN 1 ELSE 0 END,
                                PrefijoGenero = CASE WHEN a.Sexo = 'M' THEN 'la' ELSE 'el' END,
                                Direccion = a.Calle + ' ' +
                                    CASE WHEN CAST(ISNULL(a.NumeroExterior, 0) AS INT) > 0 THEN 'No.' + CAST(a.NumeroExterior AS VARCHAR(10)) ELSE 'S/N' END + ' ' +
                                    CASE WHEN CAST(ISNULL(a.NumeroInterior, 0) AS INT) > 0 THEN 'Int.' + CAST(a.NumeroInterior AS VARCHAR(10)) ELSE '' END + ' ' +
                                    'COL. ' + a.Colonia + ' C.P. ' + CAST(a.CodigoPostal AS NVARCHAR(10)) + ', ' + d.Municipio + ', ' + bb.Estado
                            ,d.Municipio as Municipio
                            ,bb.Estado
                            ,Edad=cast((datediff (DAY,a.FechaNacimiento,getdate()) / 365.25) as int)
                            FROM Kardex_ctDatosPersonales a
                            INNER JOIN Kardex_EstadoCivil c ON a.IdEstadoCivil = c.IdEstadoCivil 
                            INNER JOIN ctMunicipios d ON d.IdMpio = a.IdMunicipioVive AND d.IdEstado = a.IdEstadoVive
                            inner join ctEstados bb on a.IdEstadoVive=bb.IdEstado
                                WHERE a.IdKardex = @idKardex
                        ),
                            DatosDocumentacion as
                            (
                               select E.IdKardex,E.FolioElector,E.ClaveElector,D.FolioAntecedentes,D.FechaDocumentoAntecedentes,F.FolioNoInhabilitado
                               ,F.FechaDocumentoNoInhabilitado
                               from (
                               select top 1 a.IdKardex,Folio as FolioElector,Clave as ClaveElector,FechaDocumento as FechaDocumentoElector
                               from Kardex_DocumentosExpediente a
                               inner join Kardex_TipoDocumento b on a.IdKardexTipoDocumento=b.IdKardexTipoDocumento
                                where a.IdKardex = @idKardex and DocumentoExpediente like '%ELEC%'
                                order by FechaActualizacion desc ) as E
	                            left join 
	                            (select top 1 a.IdKardex,Folio as FolioAntecedentes,FechaDocumento as FechaDocumentoAntecedentes
                               from Kardex_DocumentosExpediente a
                               inner join Kardex_TipoDocumento b on a.IdKardexTipoDocumento=b.IdKardexTipoDocumento
                                where a.IdKardex = @idKardex and DocumentoExpediente like '%ANTECEDENTES%PENAL%'
                                order by FechaActualizacion desc ) as D on E.IdKardex=D.IdKardex
	
	                            left join 
	                            (select top 1 a.IdKardex,Folio as FolioNoInhabilitado,FechaDocumento as FechaDocumentoNoInhabilitado
                               from Kardex_DocumentosExpediente a
                               inner join Kardex_TipoDocumento b on a.IdKardexTipoDocumento=b.IdKardexTipoDocumento
                                where a.IdKardex = @idKardex and DocumentoExpediente like '%NO%INHABILITACION%'
                                order by FechaActualizacion desc ) as F on E.IdKardex=F.IdKardex
                            )

                                    SELECT a.*
                                    ,AbreviaturaGradoAcademico=isnull(b.AbreviaturaGradoAcademico,'C.') 
                                    ,GradoAcademico=isnull(b.NivelEstudioDescripcion,'') 
                                    ,CedulaProfesional=isnull(b.NumeroCedulaProfesional,'0')
                                    ,FolioElector=ISNULL(c.FolioElector,'0')
			                        ,ClaveElector=ISNULL(c.ClaveElector,'0')
			                        ,FolioAntecedentes=isnull(c.FolioAntecedentes,'0')
			                        ,c.FechaDocumentoAntecedentes
			                        ,FolioNoInhabilitado=isnull(c.FolioNoInhabilitado,'0')
			                        ,c.FechaDocumentoNoInhabilitado
                                    FROM DatosGenerales a
                                    LEFT JOIN KardexGrado b ON a.IdKardex = b.IdKardex
                                    LEFT JOIN DatosDocumentacion c ON a.IdKardex = c.IdKardex;
                            ";

            var model = (DatosGenerales)dp.connection.QuerySingleOrDefault<DatosGenerales>(query);
            dp.Close();
            return model;
        }
        public DatosLaborales ObtenDatosLaborales(long idKardexSolicitudEvaluacion)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = $@"
                        DECLARE @idKardexSolicitudEvaluacion INT
                        SET @idKardexSolicitudEvaluacion = {idKardexSolicitudEvaluacion}
                            
                            select DatosLaborales.*,
                            DatosResponsableArea.IdKardexResponsableArea,CategoriaResponsableArea
                            from (
                                    select
                                a.IdKardexSolicitudEvaluacion
		                    ,a.IdKardexCandidato
		                    ,c.IdConvenioLaboralTrabajadorCategoria
		                    ,a.IdConvenioLaboralTrabajadorCategoriaaCubrir
		                    ,isnull(h.IdKardex,0) as IdKardexPersonalBase
		                    ,dd.Categoria
							,cc.EstructuraOrganica as Adscripcion
		                    ,bb.EstructuraOrganica as UbicacionFisica 
		                    ,bb.IdModalidadEstudio as IdModalidadEstudioUbicacionFisica
                            ,a.IdEstructuraOrganicaLaboraFisicamente as IdEstructuraOrganicaFisica
                            ,ee.RelacionLaboral
		                    ,TipoIncidencia=e.TextoImpresionTipoSuplencia
		                    ,a.CicloEscolar
		                    ,a.FechaInicio
		                    ,a.FechaTermino
		                    ,NumeroOficio as NumeroOficioSindicato
                            ,FolioOficio as NumeroOficio
		                    ,HorasSemanaMes=isnull(d.HorasMaximo,0)*5
                            ,isnull(a.Observaciones,'') Observaciones
                            ,ff.EstatusContratos as EstatusContrato
                            ,bb.Direccion as DireccionUbicacionFisica
	                        ,cc.Direccion as DireccionAdscripcion
                            ,d.ConvenioLaboral
                            ,e.TipoSuplencia
		                    from Kardex_SolicitudEvaluaciones a
		                    left join Nomina_SuplenciasSolicitudes b on b.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
		                    left join Convenios_SuplenciasControl c on b.IdSuplenciaSolicitud=c.IdSuplenciaSolicitud
		                    left join vwDatosAspirantesTrabajadores d on d.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria
		                    left join Nomina_SuplenciaTipo e on e.IdTipoSuplencia=a.IdTipoSuplencia
		                    left join vwDatosAspirantesTrabajadores h on h.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoriaaCubrir
	                        inner join Catalogos_ctEstructuraOrganica bb on a.IdEstructuraOrganicaLaboraFisicamente=bb.IdEstructuraOrganica
							inner join Catalogos_ctEstructuraOrganica cc on a.IdEstructuraOrganicaAdscripcion=cc.IdEstructuraOrganica
							inner join Plazas_ctCategoria dd on dd.IdCategoria=a.IdCategoriaAspirante
							inner join Catalogos_ctRelacionLaboral ee on ee.IdRelacionLaboral=a.IdRelacionLaboral
                            inner join Catalogos_ctEstatusContratos ff on ff.IdEstatusContratos=a.IdEstatusContratacion
	                        where  a.IdKardexSolicitudEvaluacion=@idKardexSolicitudEvaluacion
                            ) as DatosLaborales
                            left join (
                                        select IdKardex as IdKardexResponsableArea
							           ,Categoria as CategoriaResponsableArea,IdModalidadEstudio,IdEstructuraOrganicaFisica
							           from vwDatosAspirantesTrabajadores
								        where  EstatusTrabajador='ALTA' and RestringirMenu is null and EsComisionado=0
								        and RelacionConvenioLaboral in ('ADMINISTRATIVO-CONFIANZA') and (Categoria like 'DIRECT%'
								        or Categoria like 'RESPONS%')
                                        union all
                                         select IdKardex as IdKardexResponsableArea
							           ,Categoria as CategoriaResponsableArea,IdModalidadEstudio,IdEstructuraOrganicaFisica
										from vwDatosAspirantesTrabajadores
								        where  EstatusTrabajador='ALTA' and RestringirMenu is null 
								        and RelacionConvenioLaboral in ('MANDO MEDIO-SUPERIOR')
                                        ) as DatosResponsableArea
                                  on DatosLaborales.IdModalidadEstudioUbicacionFisica=DatosResponsableArea.IdModalidadEstudio
                                    and DatosResponsableArea.IdEstructuraOrganicaFisica=DatosLaborales.IdEstructuraOrganicaFisica
                            ";

            var model = (DatosLaborales)dp.connection.QuerySingleOrDefault<DatosLaborales>(query);
            model.FechaFirmaContrato = ObtenFechaFirmaContrato(model.FechaInicio);
            dp.Close();
            return model;
        }

        private DateTime ObtenFechaFirmaContrato(DateTime fechaInicio)
        {
            var fecha = fechaInicio;
            do
            {
                fecha = fecha.AddDays(-1);
            } while (fecha.DayOfWeek == DayOfWeek.Saturday || fecha.DayOfWeek == DayOfWeek.Sunday);

            return fecha;
        }

        public List<CargaHoraria> ObtenCargaHoraria(long idKardexSolicitudEvaluacion)
        {
            var datosSolicitudEvaluacion = dbNova.Kardex_SolicitudEvaluaciones.Find(idKardexSolicitudEvaluacion);
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            //var cicloPrueba = "2023-1";
            //var idPrueba = 3672;


            List<CargaHoraria> model = dp.connection.Query<CargaHoraria>("spObtenCargaHorariaCicloKardex", new { CicloEscolar = datosSolicitudEvaluacion.CicloEscolar, IdKardex = datosSolicitudEvaluacion.IdKardexCandidato }, commandType: CommandType.StoredProcedure).ToList();

            //List<CargaHoraria> model = dp.connection.Query<CargaHoraria>("spObtenCargaHorariaCicloKardex", new { CicloEscolar = cicloPrueba, IdKardex = idPrueba }, commandType: CommandType.StoredProcedure).ToList();
            dp.Close();
            return model;
        }
    }
    public class DatosGenerales
    {
        public int IdKardex { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; }
        public string ApellidoMaterno { get; set; }
        public string NombreCompleto { get; set; }
        public string Direccion { get; set; }
        public string Municipio { get; set; }
        public string Estado { get; set; }
        public string GradoAcademico { get; set; }
        public string AbreviaturaGradoAcademico { get; set; }
        public string PrefijoGenero { get; set; }
        public bool EsMujer { get; set; }
        public string TelefonoParticular { get; set; }
        public string TelefonoCelular { get; set; }
        public string Rfc { get; set; }
        public string Curp { get; set; }
        public string EstadoCivil { get; set; }
        public string Nacionalidad { get; set; }
        public int Edad { get; set; }
        public string CorreoElectronico { get; set; }
        public string CedulaProfesional { get; set; }
        public string ClaveElector { get; set; }
        public string FolioElector { get; set; }
        public string FolioAntecedentes { get; set; }
        public DateTime FechaDocumentoAntecedentes { get; set; }
        public string FolioNoInhabilitado { get; set; }
        public DateTime FechaDocumentoNoInhabilitado { get; set; }

    }
    public class DatosLaborales
    {
        public int IdKardexSolicitudEvaluacion { get; set; }
        public int IdKardexCandidato { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int IdConvenioLaboralTrabajadorCategoriaaCubrir { get; set; }
        public int IdKardexPersonalBase { get; set; }
        public int IdModalidadEstudioUbicacionFisica { get; set; }
        public string Categoria { get; set; }
        public string Adscripcion { get; set; }
        public string UbicacionFisica { get; set; }
        public string TipoIncidencia { get; set; }
        public string CicloEscolar { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }

        public DateTime FechaFirmaContrato { get; set; }
        public string NumeroOficioSindicato { get; set; }
        public string NumeroOficio { get; set; }
        public string RelacionLaboral { get; set; }
        public int HorasSemanaMes { get; set; }
        public int HorasExtraOrdinarias { get; set; }
        public decimal ImporteSalarioQuincenal { get; set; }
        public string LetraImporteSalarioQuincenal { get; set; }
        public decimal ImporteAyudaDespensa { get; set; }
        public string LetraImporteAyudaDespensa { get; set; }
        public decimal ImporteMonederoElectronico { get; set; }
        public string LetraImporteMonederoElectronico { get; set; }
        public decimal ImporteApoyoMaterialDidactico { get; set; }
        public string LetraImporteApoyoMaterialDidactico { get; set; }
        public decimal ImporteAyudaTransporte { get; set; }
        public string LetraImporteAyudaTransporte { get; set; }
        public decimal ImporteEficiencia { get; set; }
        public string LetraImporteEficiencia { get; set; }
        public DatosGenerales DatosPersonalBase { get; set; }
        public DatosGenerales DatosJefeInmediato { get; set; }
        public int IdKardexResponsableArea { get; set; }
        public string CategoriaResponsableArea { get; set; }
        public string Observaciones { get; set; }
        public string EstatusContrato { get; set; }
        public short HorasAutorizadas { get; set; }
        public string DireccionUbicacionFisica { get; set; }
        public string DireccionAdscripcion { get; set; }
        public string ConvenioLaboral { get; set; }
        public string TipoSuplencia { get; set; }

    }

    public class CargaHoraria
    {
        public int IdKardex { get; set; }
        public string PlanEstudio { get; set; }
        public string Descripcion { get; set; }
        public string AreaConocimiento { get; set; }
        public short HorasGrupales { get; set; }
        public short HorasAsesoriaIndividual { get; set; }
        public short HorasNoGrupales { get; set; }
        public short HorasClub { get; set; }
        public short TotalHoras { get; set; }
        public bool EsComponenteProfesional { get; set; }
        public string maximaAreaConocimiento { get; set; }
        public short HorasExtraOrdinarias { get; set; }
    }

    public static class TextoMoneda
    {
        static string[] unidades = { "cero", "un", "dos", "tres", "cuatro", "cinco", "seis", "siete", "ocho", "nueve", "diez", "once", "doce", "trece", "catorce", "quince", "dieciséis", "diecisiete", "dieciocho", "diecinueve", "trés", "dós" };
        static string[] decenas = { "", "", "veinte", "treinta", "cuarenta", "cincuenta", "sesenta", "setenta", "ochenta", "noventa", "veinti" };
        static string[] centenas = { "", "ciento", "doscientos", "trescientos", "cuatrocientos", "quinientos", "seiscientos", "setecientos", "ochocientos", "novecientos" };
        static string[] miles = { "", "mil", "millón", "millones", "billón", "billones" };

        public static string ConvertirCantidadALetras(decimal cantidad)
        {
            // Separar la cantidad en partes enteras y decimales
            long parteEntera = (long)cantidad;
            int parteDecimal = (int)((cantidad - parteEntera) * 100);

            // Convertir parte entera a letras
            string cantidadEnLetras = ConvertirParteEntera(parteEntera);

            // Agregar la parte decimal si es mayor a cero
            if (parteDecimal > 0)
            {
                cantidadEnLetras += " pesos con " + parteDecimal.ToString("00") + "/100 M.N.";
                return cantidad.ToString("C", CultureInfo.CurrentCulture) + " (" + cantidadEnLetras.Trim() + ")";
            }

            return cantidad.ToString("C", CultureInfo.CurrentCulture) + " (" + cantidadEnLetras.Trim() + " pesos 00/100 M.N.)";
        }
        static string ConvertirParteEntera(long numero)
        {
            if (numero < 20)
            {
                //if (numero == 1)
                //    return "uno";
                //else
                return unidades[numero];
            }
            else if (numero < 100)
            {
                int unidad = (int)(numero % 10);
                int decena = (int)(numero / 10);

                if (unidad > 0)
                {
                    if (decena == 2)
                    {
                        decena = 10;
                        unidad = (int)(numero % 10);

                        //si la unidad es 3 se acentúa en los 20's
                        unidad = unidad == 3 ? unidad = 20 : unidad;
                        //si la unidad es 2 se acentúa en los 20's
                        unidad = unidad == 2 ? unidad = 21 : unidad;

                        return decenas[decena] + unidades[unidad];
                    }
                    else
                        return decenas[decena] + " y " + unidades[unidad];
                }
                else
                {
                    return decenas[decena];
                }
            }
            else if (numero < 1000)
            {

                int unidad = (int)(numero % 10);
                int decena = (int)((numero % 100) / 10);
                int centena = (int)(numero / 100);

                if (numero == 100)
                    return "cien";


                if (unidad == 0 && decena == 0)
                {

                    return centenas[centena];
                }
                else
                {
                    return centenas[centena] + " " + ConvertirParteEntera(numero % 100);
                }
            }
            else
            {
                int millar = 0, aux = 0;
                string cantidadEnLetras = "";

                while (numero > 0)
                {
                    aux++;
                    if (numero % 1000 != 0)
                    {
                        long grupo = numero % 1000;

                        if (grupo == 1 && millar == 0)
                        {
                            cantidadEnLetras = miles[millar] + " " + cantidadEnLetras;
                        }
                        else if (grupo > 0)
                        {
                            string grupoEnLetras = ConvertirParteEntera(grupo);

                            if (millar == 0)
                            {
                                cantidadEnLetras = grupoEnLetras + " " + miles[millar] + " " + cantidadEnLetras;
                            }
                            else
                            {

                                if (aux >= 3) millar += 1;
                                cantidadEnLetras = grupoEnLetras + " " + miles[millar] + " " + cantidadEnLetras;
                            }
                        }
                    }

                    millar++;
                    numero /= 1000;
                }

                return cantidadEnLetras.Trim();
            }
        }



    }
}