﻿using Dapper;
using DevExpress.CodeParser;
using DevExpress.XtraEditors;
using log4net;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data.Entity;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Transactions;

namespace Nova.Models
{




    public class CatalogoEstructuraOrganica
    {
        public int IdEstructuraOrganica { get; set; }
        public string EstructuraOrganica { get; set; }
        public int IdModalidadEstudio { get; set; }

    }

    public class HorarioTipoHoras
    {
        public int TotalHoras { get; set; }
        public int TotalHorasClub { get; set; }
    }
        public class RetardosOTiempoFuera
    {
        public long IdTrabajador { get; set; }
        public long IdConvenioLaboralTrabajadorCategoria { get; set; }
        public DateTime Fecha { get; set; }
        public TimeSpan TiempoFuera { get; set; }

        public short Horas { get; set; }
        public string RelacionLaboral { get; set; }
        public long IdIncidenciaTrabajador { get; set; }

    }
    public class CryptorEngine
    {
        /// <summary>
        /// Encrypt a string using dual encryption method. Return a encrypted cipher Text
        /// </summary>
        /// <param name="toEncrypt">string to be encrypted</param>
        /// <param name="useHashing">use hashing? send to for extra secirity</param>
        /// <returns></returns>
        public static string Encrypt(string toEncrypt, bool useHashing)
        {
            byte[] keyArray;
            byte[] toEncryptArray = UTF8Encoding.UTF8.GetBytes(toEncrypt);

            System.Configuration.AppSettingsReader settingsReader = new AppSettingsReader();
            // Get the key from config file
            //string key = (string)settingsReader.GetValue("SecurityKey", typeof(String));
            string key = "NoEstasDeprimdoEstasDistraido2019";
            //System.Windows.Forms.MessageBox.Show(key);
            if (useHashing)
            {
                MD5CryptoServiceProvider hashmd5 = new MD5CryptoServiceProvider();
                keyArray = hashmd5.ComputeHash(UTF8Encoding.UTF8.GetBytes(key));
                hashmd5.Clear();
            }
            else
                keyArray = UTF8Encoding.UTF8.GetBytes(key);

            TripleDESCryptoServiceProvider tdes = new TripleDESCryptoServiceProvider();
            tdes.Key = keyArray;
            tdes.Mode = CipherMode.ECB;
            tdes.Padding = PaddingMode.PKCS7;

            ICryptoTransform cTransform = tdes.CreateEncryptor();
            byte[] resultArray = cTransform.TransformFinalBlock(toEncryptArray, 0, toEncryptArray.Length);
            tdes.Clear();
            return Convert.ToBase64String(resultArray, 0, resultArray.Length);
        }
        /// <summary>
        /// DeCrypt a string using dual encryption method. Return a DeCrypted clear string
        /// </summary>
        /// <param name="cipherString">encrypted string</param>
        /// <param name="useHashing">Did you use hashing to encrypt this data? pass true is yes</param>
        /// <returns></returns>
        public static string Decrypt(string cipherString, bool useHashing)
        {
            byte[] keyArray;
            byte[] toEncryptArray = Convert.FromBase64String(cipherString);

            System.Configuration.AppSettingsReader settingsReader = new AppSettingsReader();
            //Get your key from config file to open the lock!
            string key = "NoEstasDeprimdoEstasDistraido2019";

            if (useHashing)
            {
                MD5CryptoServiceProvider hashmd5 = new MD5CryptoServiceProvider();
                keyArray = hashmd5.ComputeHash(UTF8Encoding.UTF8.GetBytes(key));
                hashmd5.Clear();
            }
            else
                keyArray = UTF8Encoding.UTF8.GetBytes(key);

            TripleDESCryptoServiceProvider tdes = new TripleDESCryptoServiceProvider();
            tdes.Key = keyArray;
            tdes.Mode = CipherMode.ECB;
            tdes.Padding = PaddingMode.PKCS7;

            ICryptoTransform cTransform = tdes.CreateDecryptor();
            byte[] resultArray = cTransform.TransformFinalBlock(toEncryptArray, 0, toEncryptArray.Length);

            tdes.Clear();
            return UTF8Encoding.UTF8.GetString(resultArray);
        }
    }

    public class TrabajadoresConRetardos
      {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public DateTime Fecha { get; set; }
        }
    public class RelojChecador
    {
        bdNovaEntities bd = new bdNovaEntities();

        private bool _usaHorariosDocentes { get; set; } = true;
        public List<CatalogoEstructuraOrganica> CatalogoEstructuraOrganica = new List<CatalogoEstructuraOrganica>();
        public List<TrabajadoresConRetardos> TrabajadoresConRetardos = new List<TrabajadoresConRetardos>();

        private static readonly ILog log = LogManager.GetLogger(typeof(MvcApplication));

        public short idRetardo { get; set; }
        public short idFaltaHoraClub { get; set; }
        public short idRetardoPorHora { get; set; }
        public short idFalta { get; set; }
        public short idFaltaRetardo { get; set; }
        public short idFaltaPorHora { get; set; }
        public short idOmisionSalida { get; set; }
        public short idVacaciones { get; set; }
        public short idIncapacidad { get; set; }
        public short idSuspension { get; set; }
        public short idPrimaDominical { get; set; }
        public short idDiasDescanso { get; set; }

        public short idFaltaPorExcederPases { get; set; }

        public int IdJefeRecursosHumanos { get; set; }


        public List<vwDatosAspirantesTrabajadores> vwDatosAspirantesTrabajadores = new List<vwDatosAspirantesTrabajadores>();

        public List<vwDatosAspirantesTrabajadores> trabajadoressegunAreasdelReloj = new List<vwDatosAspirantesTrabajadores>();

        

        public List<Nomina_RelojChecadorLibre> Nomina_RelojChecadorLibre = new List<Nomina_RelojChecadorLibre>();

        public List<Nomina_HorariosEspeciales> Nomina_HorariosEspeciales = new List<Nomina_HorariosEspeciales>();



        public List<Convenios_stRelacionConvenioLaboral> Convenios_stRelacionConvenioLaboral = new List<Convenios_stRelacionConvenioLaboral>();

        public List<Nomina_HorariosConvenioConfiguracion> Nomina_HorariosConvenioConfiguracion = new List<Nomina_HorariosConvenioConfiguracion>();

        public List<Nomina_RelojChecadorAreas> Nomina_RelojChecadorAreas = new List<Nomina_RelojChecadorAreas>();




        public List<Nomina_CalendarioEventos> Nomina_CalendarioEventos { get; set; } = new List<Nomina_CalendarioEventos>();

        public List<Nomina_RelojChecadorAsistencia> Nomina_RelojChecadorAsistencia { get; set; } = new List<Nomina_RelojChecadorAsistencia>();

        public List<Nomina_RelojChecadorAreasEstructuraOrganicaTolerancia> Nomina_RelojChecadorAreasEstructuraOrganicaTolerancia { get; set; } = new List<Nomina_RelojChecadorAreasEstructuraOrganicaTolerancia>();

     

        public List<Nomina_RelojChecadorAreasEstructuraOrganica> Nomina_RelojChecadorAreasEstructuraOrganica = new List<Nomina_RelojChecadorAreasEstructuraOrganica>();


        Nomina_stNominaTrabajador NominaTrabajador = new Nomina_stNominaTrabajador();

        public enum TiposdeIncidencia
        {
            Retardo, Falta, FaltaPorRetardo, OmisionSalida, FaltaPorHora, RetardoPorHora, PrimaDominical, DiasDescanso, FaltaPorExcederPases,FaltaHoraClub
        }
        public enum TiposdeJustificacion
        {
            Suspension, Vacaciones
        }

        public RelojChecador(bool light)
        {
            Nomina_CalendarioEventos = bd.Nomina_CalendarioEventos.ToList();
            var tipoIndicencias = bd.Catalogos_ctTipoIncidencia.ToList();

            var tiposjustificaciones = bd.Incidencia_ctJustificacion.ToList();
            idFalta = tipoIndicencias.Where(x => x.Incidencia == "FALTA POR DÍA").FirstOrDefault().IdTipoIncidencia;

            idFaltaPorExcederPases = tipoIndicencias.Where(x => x.Incidencia == "FALTA POR DÍA POR EXCEDER HORAS DE PASES DE SALIDA").FirstOrDefault().IdTipoIncidencia;


            idRetardo = tipoIndicencias.Where(x => x.Incidencia == "RETARDO POR DÍA").FirstOrDefault().IdTipoIncidencia;

            idFaltaHoraClub = tipoIndicencias.Where(x => x.Incidencia == "FALTA HORAS CLUB").FirstOrDefault().IdTipoIncidencia;

            idRetardoPorHora = tipoIndicencias.Where(x => x.Incidencia == "RETARDO POR HORA").FirstOrDefault().IdTipoIncidencia;

            idFaltaRetardo = tipoIndicencias.Where(x => x.Incidencia == "FALTA POR RETARDOS").FirstOrDefault().IdTipoIncidencia;

            idFaltaPorHora = tipoIndicencias.Where(x => x.Incidencia == "FALTA POR HORAS").FirstOrDefault().IdTipoIncidencia;

            idOmisionSalida = tipoIndicencias.Where(x => x.Incidencia == "OMISIÓN DE SALIDA").FirstOrDefault().IdTipoIncidencia;

            idPrimaDominical = tipoIndicencias.Where(x => x.Incidencia == "PRIMA DOMINICAL").FirstOrDefault().IdTipoIncidencia;
            idDiasDescanso = tipoIndicencias.Where(x => x.Incidencia == "DIAS DE DESCANSO OBLIGATORIO").FirstOrDefault().IdTipoIncidencia;

            idSuspension = (short)tiposjustificaciones.Where(x => x.IncidenciaJustificacion == "SUSPENSIÓN DE LABORES").FirstOrDefault().IdIncidenciaJustificacion;

            idVacaciones = (short)tiposjustificaciones.Where(x => x.IncidenciaJustificacion == "VACACIONES").FirstOrDefault().IdIncidenciaJustificacion;
            idIncapacidad = (short)tiposjustificaciones.Where(x => x.IncidenciaJustificacion == "INCAPACIDAD").FirstOrDefault().IdIncidenciaJustificacion;

            IdJefeRecursosHumanos = Nova.Models.Kardex_ctDatosPersonales.getIdJefeRecursosHumanos();



        }
        public RelojChecador()
        {
            Nomina_CalendarioEventos = bd.Nomina_CalendarioEventos.ToList();
            var tipoIndicencias = bd.Catalogos_ctTipoIncidencia.ToList();

            var tiposjustificaciones = bd.Incidencia_ctJustificacion.ToList();
            idFalta = tipoIndicencias.Where(x => x.Incidencia == "FALTA POR DÍA").FirstOrDefault().IdTipoIncidencia;

            idFaltaPorExcederPases = tipoIndicencias.Where(x => x.Incidencia == "FALTA POR DÍA POR EXCEDER HORAS DE PASES DE SALIDA").FirstOrDefault().IdTipoIncidencia;

            idFaltaHoraClub = tipoIndicencias.Where(x => x.Incidencia == "FALTA HORAS CLUB").FirstOrDefault().IdTipoIncidencia;
            idRetardo = tipoIndicencias.Where(x => x.Incidencia == "RETARDO POR DÍA").FirstOrDefault().IdTipoIncidencia;
            idRetardoPorHora = tipoIndicencias.Where(x => x.Incidencia == "RETARDO POR HORA").FirstOrDefault().IdTipoIncidencia;

            idFaltaRetardo = tipoIndicencias.Where(x => x.Incidencia == "FALTA POR RETARDOS").FirstOrDefault().IdTipoIncidencia;

            idFaltaPorHora = tipoIndicencias.Where(x => x.Incidencia == "FALTA POR HORAS").FirstOrDefault().IdTipoIncidencia;

            idOmisionSalida = tipoIndicencias.Where(x => x.Incidencia == "OMISIÓN DE SALIDA").FirstOrDefault().IdTipoIncidencia;

            idPrimaDominical = tipoIndicencias.Where(x => x.Incidencia == "PRIMA DOMINICAL").FirstOrDefault().IdTipoIncidencia;
            idDiasDescanso = tipoIndicencias.Where(x => x.Incidencia == "DIAS DE DESCANSO OBLIGATORIO").FirstOrDefault().IdTipoIncidencia;

            idSuspension = (short)tiposjustificaciones.Where(x => x.IncidenciaJustificacion == "SUSPENSIÓN DE LABORES").FirstOrDefault().IdIncidenciaJustificacion;

            idVacaciones = (short)tiposjustificaciones.Where(x => x.IncidenciaJustificacion == "VACACIONES").FirstOrDefault().IdIncidenciaJustificacion;
            idIncapacidad = (short)tiposjustificaciones.Where(x => x.IncidenciaJustificacion == "INCAPACIDAD").FirstOrDefault().IdIncidenciaJustificacion;

            IdJefeRecursosHumanos = Nova.Models.Kardex_ctDatosPersonales.getIdJefeRecursosHumanos();


            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 0, EstructuraOrganica = "SELECCIONE UN LUGAR", IdModalidadEstudio = 0 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 3, EstructuraOrganica = "DIRECCIÓN GENERAL", IdModalidadEstudio = 0 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 4, EstructuraOrganica = "ALMACEN", IdModalidadEstudio = 0 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 5, EstructuraOrganica = "DIRECCION DE EMSAD", IdModalidadEstudio = 0 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 8, EstructuraOrganica = "DIRECCIÓN ACADÉMICA", IdModalidadEstudio = 0 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 27, EstructuraOrganica = "PLANTEL NÚM. 01 OAXACA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 28, EstructuraOrganica = "PLANTEL NÚM. 02 CUICATLÁN", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 29, EstructuraOrganica = "PLANTEL NÚM. 03 IXTLÁN", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 30, EstructuraOrganica = "PLANTEL NÚM. 04 TUTUTEPEC", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 31, EstructuraOrganica = "PLANTEL NÚM. 05 ETLA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 32, EstructuraOrganica = "PLANTEL NÚM. 06 EL BARRIO", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 33, EstructuraOrganica = "PLANTEL NÚM. 07 TELIXTLAHUACA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 34, EstructuraOrganica = "PLANTEL NÚM. 08 YOLOMECATL", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 35, EstructuraOrganica = "PLANTEL NÚM. 09 VALLE NACIONAL", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 36, EstructuraOrganica = "PLANTEL NÚM. 10 SANTA MARÍA ZACATEPEC", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 37, EstructuraOrganica = "PLANTEL NÚM. 11 MARÍA LOMBARDO", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 38, EstructuraOrganica = "PLANTEL NÚM. 12 JAMILTEPEC", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 39, EstructuraOrganica = "PLANTEL NÚM. 13 ASTATA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 40, EstructuraOrganica = "PLANTEL NÚM. 14 EL CAMARÓN", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 41, EstructuraOrganica = "PLANTEL NÚM. 15 JICAYÁN", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 42, EstructuraOrganica = "PLANTEL NÚM. 16 MITLA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 43, EstructuraOrganica = "PLANTEL NÚM. 17 AYUTLA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 44, EstructuraOrganica = "PLANTEL NÚM. 18 TEHUANTEPEC", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 45, EstructuraOrganica = "PLANTEL NÚM. 19 CANDELARIA LOXICHA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 46, EstructuraOrganica = "PLANTEL NÚM. 20 ASUNCIÓN IXTALTEPEC", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 47, EstructuraOrganica = "PLANTEL NÚM. 21 SAN PEDRO POCHUTLA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 48, EstructuraOrganica = "PLANTEL NÚM. 22 IXTEPEC", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 49, EstructuraOrganica = "PLANTEL NÚM. 23 JUCHITÁN", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 50, EstructuraOrganica = "PLANTEL NÚM. 24 SAN ESTEBAN ATATLAHUCA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 51, EstructuraOrganica = "PLANTEL NÚM. 25 SAN PABLO HUIXTEPEC", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 52, EstructuraOrganica = "PLANTEL NÚM. 26 SAN DIONISIO DEL MAR", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 53, EstructuraOrganica = "PLANTEL NÚM. 27 LA MIXTEQUITA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 54, EstructuraOrganica = "PLANTEL NÚM. 28 AYOTZINTEPEC", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 55, EstructuraOrganica = "PLANTEL NÚM. 29 XOXOCOTLÁN", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 56, EstructuraOrganica = "PLANTEL NÚM. 30 SAN PEDRO SINIYUVI", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 57, EstructuraOrganica = "PLANTEL NÚM. 31 SANTA ELENA EL TULE", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 58, EstructuraOrganica = "PLANTEL NÚM. 32 CERRO QUEMADO", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 59, EstructuraOrganica = "PLANTEL NÚM. 33 CHAHUITES", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 60, EstructuraOrganica = "PLANTEL NÚM. 34 GUEVEA DE HUMBOLDT", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 61, EstructuraOrganica = "PLANTEL NÚM. 35 SAN JOSÉ AYUQUILA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 62, EstructuraOrganica = "PLANTEL NÚM. 36 BENEMÉRITO JUÁREZ", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 63, EstructuraOrganica = "PLANTEL NÚM. 37 SAN GABRIEL MIXTEPEC", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 64, EstructuraOrganica = "PLANTEL NÚM. 38 SANTA MARÍA HUATULCO", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 65, EstructuraOrganica = "PLANTEL NÚM. 39 SAN JOSÉ LACHIGUIRÍ", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 66, EstructuraOrganica = "EMSAD NÚM. 01 COIXTLAHUACA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 67, EstructuraOrganica = "EMSAD NÚM. 05 TEPETLAPA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 69, EstructuraOrganica = "EMSAD NÚM. 07 PEÑOLES", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 70, EstructuraOrganica = "EMSAD NÚM. 08 SAN PABLO COATLAN", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 71, EstructuraOrganica = "EMSAD NÚM. 09 SAN PEDRO CAJONOS", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 74, EstructuraOrganica = "EMSAD NÚM. 12 JUQUILA MIXES", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 75, EstructuraOrganica = "EMSAD NÚM. 13 SAN BALTAZAR LOXICHA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 76, EstructuraOrganica = "EMSAD NÚM. 14 ZAPOTITLÁN LAGUNAS", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 77, EstructuraOrganica = "EMSAD NÚM. 15 SANTA MARÍA OZOLOTEPEC", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 78, EstructuraOrganica = "EMSAD NÚM. 16 SANTIAGO COMALTEPEC", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 79, EstructuraOrganica = "EMSAD NÚM. 17 SAN JOSÉ DEL PACIFICO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 80, EstructuraOrganica = "EMSAD NÚM. 18 SINDIHUI", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 81, EstructuraOrganica = "EMSAD NÚM. 19 SANTA INÉS DE ZARAGOZA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 82, EstructuraOrganica = "EMSAD NÚM. 20 SAN MIGUEL PERAS", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 83, EstructuraOrganica = "EMSAD NÚM. 21 SAN MIGUEL DEL PUERTO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 85, EstructuraOrganica = "EMSAD NÚM. 23 CABECERA NUEVA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 86, EstructuraOrganica = "EMSAD NÚM. 24 SANTO DOMINGO IXCATLAN", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 88, EstructuraOrganica = "EMSAD NÚM. 26 SAN BALTAZAR CHICHICAPAM", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 90, EstructuraOrganica = "EMSAD NÚM. 28 COLLANTES", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 91, EstructuraOrganica = "EMSAD NÚM. 29 GUERRERO ITUNDUJIA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 92, EstructuraOrganica = "EMSAD NÚM. 30 ZARAGOZA ITUNDUJIA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 93, EstructuraOrganica = "EMSAD NÚM. 31 SANTO DOMINGO YOSOÑAMA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 94, EstructuraOrganica = "EMSAD NÚM. 32 SANTA MARÍA ECATEPEC", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 95, EstructuraOrganica = "EMSAD NÚM. 33 GENERAL FELIPE ANGELES", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 96, EstructuraOrganica = "EMSAD NÚM. 34 SAN CRISTOBAL CHAYUCO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 97, EstructuraOrganica = "EMSAD NÚM. 35 SAN ANTONINO EL ALTO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 98, EstructuraOrganica = "EMSAD NÚM. 36 LA MERCED DEL POTRERO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 99, EstructuraOrganica = "EMSAD NÚM. 37 GUADALUPE DE RAMÍREZ", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 100, EstructuraOrganica = "EMSAD NÚM. 38 TEZOATLÁN", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 101, EstructuraOrganica = "EMSAD NÚM. 39 SANTA CATARINA YOSONOTU", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 102, EstructuraOrganica = "EMSAD NÚM. 40 CHIVELA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 103, EstructuraOrganica = "EMSAD NÚM. 41 SAN FRANCISCO TLAPANCINGO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 104, EstructuraOrganica = "EMSAD NÚM. 42 SAN MIGUEL TLACOTEPEC", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 106, EstructuraOrganica = "EMSAD NÚM. 44 SAN VICENTE LACHIXIO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 107, EstructuraOrganica = "EMSAD NÚM. 45 SAN PABLO TIJALTEPEC", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 108, EstructuraOrganica = "EMSAD NÚM. 46 COLONIA CUAUHTÉMOC", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 109, EstructuraOrganica = "EMSAD NÚM. 47 SAN MIGUEL CHICAHUA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 110, EstructuraOrganica = "EMSAD NÚM. 48 ZEGACHE", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 113, EstructuraOrganica = "EMSAD NÚM. 51 MAGDALENA PEÑASCO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 114, EstructuraOrganica = "EMSAD NÚM. 52 BUENAVISTA LOXICHA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 115, EstructuraOrganica = "EMSAD NÚM. 53 LA VENTA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 116, EstructuraOrganica = "EMSAD NÚM. 54 SAN LORENZO TEXMELUCAN", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 118, EstructuraOrganica = "EMSAD NÚM. 56 SANTA MARÍA SOLA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 119, EstructuraOrganica = "EMSAD NÚM. 57 SAN JUAN CABEZA DEL RÍO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 120, EstructuraOrganica = "EMSAD NÚM. 58 EL CIRUELO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 121, EstructuraOrganica = "EMSAD NÚM. 59 VILLA TALEA DE CASTRO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 122, EstructuraOrganica = "EMSAD NÚM. 60 VILLA DE CHILAPA DE DÍAZ", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 123, EstructuraOrganica = "EMSAD NÚM. 61 ABEJONES", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 125, EstructuraOrganica = "EMSAD NÚM. 63 SAN SEBASTIAN NOPALERA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 126, EstructuraOrganica = "EMSAD NÚM. 64 SANTA MARÍA CUQUÍLA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 128, EstructuraOrganica = "EMSAD NÚM. 66 MAGDALENA YODOCONO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 129, EstructuraOrganica = "EMSAD NÚM. 67 QUIEGOLANI", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 130, EstructuraOrganica = "EMSAD NÚM. 68 SAN MATEO PEÑASCO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 131, EstructuraOrganica = "EMSAD NÚM. 69 SAN MARTÍN ITUNYOSO", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 132, EstructuraOrganica = "EMSAD NÚM. 70 SANTA MARÍA PUXMETACAN", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 133, EstructuraOrganica = "EMSAD NÚM. 71 SANTA LUCÍA MONTEVERDE", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 135, EstructuraOrganica = "EMSAD NÚM. 73 SAN MIGUEL MIXTEPEC", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 136, EstructuraOrganica = "EMSAD NÚM. 74 MAGDALENA JALTEPEC", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 137, EstructuraOrganica = "EMSAD NÚM. 75 CAMELIA ROJA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 138, EstructuraOrganica = "EMSAD NÚM. 76 ARRAZOLA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 139, EstructuraOrganica = "EMSAD NÚM. 77 FLOR BATAVIA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 140, EstructuraOrganica = "EMSAD NÚM. 78 SAN JOSÉ MONTEVERDE", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 141, EstructuraOrganica = "EMSAD NÚM. 79 SAN SIMÓN ZAHUATLAN", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 142, EstructuraOrganica = "EMSAD NÚM. 80 SANTA LUCÍA MIAHUATLAN", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 143, EstructuraOrganica = "EMSAD NÚM. 81 LA SABANA", IdModalidadEstudio = 2 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 147, EstructuraOrganica = "PLANTEL NÚM. 40 SANTA MARÍA ATZOMPA", IdModalidadEstudio = 1 });
            CatalogoEstructuraOrganica.Add(new CatalogoEstructuraOrganica { IdEstructuraOrganica = 169, EstructuraOrganica = "PLANTEL NÚM. 41 SANTO DOMINGO TONALÁ", IdModalidadEstudio = 1 });

            vwDatosAspirantesTrabajadores = bd.vwDatosAspirantesTrabajadores.Where(b=> b.RestringirMenu==null || b.Incidencia.Contains("INCAPACIDAD")).ToList();
            Convenios_stRelacionConvenioLaboral = bd.Convenios_stRelacionConvenioLaboral.ToList();

            Nomina_RelojChecadorLibre = bd.Nomina_RelojChecadorLibre.Where(d => (d.FechaInicio <= DateTime.Now && d.FechaTermino >= DateTime.Now)
            || (d.FechaInicio <= DateTime.Now && d.FechaTermino == null)
            ).ToList();
            Nomina_HorariosConvenioConfiguracion = bd.Nomina_HorariosConvenioConfiguracion.ToList();

            Nomina_RelojChecadorAreas = bd.Nomina_RelojChecadorAreas.ToList();

            Nomina_HorariosEspeciales = bd.Nomina_HorariosEspeciales.ToList();

            Nomina_RelojChecadorAreasEstructuraOrganica = bd.Nomina_RelojChecadorAreasEstructuraOrganica.ToList();


        }
        public void ActualizaPlazasQueTerminanHoy()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string q = $@"update  Plazas_stDistribucionPlazaCategoria 
set EsVacante=1 
where IdDistribucionPlazaCategoria in(
SELECT 
      [IdDistribucionPlazaCategoria]
        FROM [vwDatosAspirantesTrabajadores]
  where FechaTermino='{DateTime.Now.ToString("yyyyMMdd")}'
)";
            dp.connection.Execute(q, null);
        



        dp.Close();


        }
    public TimeSpan CalcularHorasSinClases(List<NominaHorariosDocentesDetalle> horarios)
        {
            TimeSpan horasSinClases = TimeSpan.Zero;
            if (horarios==null)
                return horasSinClases;

            if (horarios.Count == 0)
            {
                return horasSinClases;
            }

            TimeSpan horarioInicio = TimeSpan.Parse(horarios[0].HoraInicio);
            TimeSpan horarioFin = TimeSpan.Parse(horarios[horarios.Count - 1].HoraFinal);

            TimeSpan horarioAnteriorFin = horarioInicio;

            foreach (var horario in horarios)
            {
                TimeSpan actualInicio = TimeSpan.Parse(horario.HoraInicio);
                TimeSpan actualFin = TimeSpan.Parse(horario.HoraFinal);

                // Calcular intervalo sin clases entre horarios
                if (actualInicio > horarioAnteriorFin)
                {
                    horasSinClases += actualInicio - horarioAnteriorFin;
                }

                horarioAnteriorFin = actualFin;
            }

            // Calcular intervalo sin clases después del último horario
            if (horarioAnteriorFin < horarioFin)
            {
                horasSinClases += horarioFin - horarioAnteriorFin;
            }

            return horasSinClases;
        }

        public bool ProcesarIncidenciasTestingId(int id, string fecha, short idEstructuraOrganicaReloj, ref bool yaprocesofaltasunavez, bool UsarHorariosDocentes= true)
        {
            this._usaHorariosDocentes = UsarHorariosDocentes;
            var hayerror = false;

            var FechaReg = DateTime.Parse(fecha);

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {

                bdNovaEntities basedb = new bdNovaEntities();
                Nomina_RelojChecadorAsistencia = basedb.Nomina_RelojChecadorAsistencia.Where(c => c.IdTrabajador == id 
                //&& 
                //c.EsProcesada == false
             && c.FechaAsistencia.Year == FechaReg.Year && c.FechaAsistencia.Month == FechaReg.Month && c.FechaAsistencia.Day == FechaReg.Day).ToList();

                var fechaproceso = FechaReg;

                TransactionOptions transactionoptions2 = new TransactionOptions();
                transactionoptions2.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;

                if (UsarHorariosDocentes && yaprocesofaltasunavez==false)
                {
                    using (TransactionScope scope2 = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
                    {
                        NominaTrabajador.setHorariosDocentes(fechaproceso.ToString("yyyyMMdd"),false,false,true);
                    }
                }

                var asistenciastrabajadores = Nomina_RelojChecadorAsistencia.GroupBy(d => d.IdTrabajador).Select(r => new { IdTrabajador = r.Key }).ToList();
                if (asistenciastrabajadores.Count == 0)
                {
                    if (yaprocesofaltasunavez == false)
                    {

                        if ((fechaproceso.DayOfWeek != DayOfWeek.Saturday) && (fechaproceso.DayOfWeek != DayOfWeek.Sunday))
                        {
                            // paa esta accion qeu se usa para correr masivamente el proceso se omite la cmparacion de sabado y domingos
                            //para que sea mas rapido el proceso
                            GenerarFaltasPersonalSinAsistencias(fechaproceso, idEstructuraOrganicaReloj, true);
                            yaprocesofaltasunavez = true;
                        }
                    }

                }
                else
                {
                    foreach (var item in asistenciastrabajadores)
                    {
                        hayerror = CrearIncidencia((int)item.IdTrabajador, fechaproceso, idEstructuraOrganicaReloj, UsarHorariosDocentes);

                        CreaFaltasPorRetardosYPases(fechaproceso,(int)item.IdTrabajador);

                    }

                   

                    basedb.Configuration.AutoDetectChangesEnabled = false;
                    basedb.Configuration.ValidateOnSaveEnabled = false;

                    var asistenciasdeltrabajador = basedb.Nomina_RelojChecadorAsistencia.Where(c => c.IdTrabajador == id
                     && c.FechaAsistencia.Year == FechaReg.Year && c.FechaAsistencia.Month == FechaReg.Month && c.FechaAsistencia.Day == FechaReg.Day).ToList();
                    foreach (var ele in asistenciasdeltrabajador)
                    {
                        ele.EsProcesada = true;
                        basedb.Nomina_RelojChecadorAsistencia.Add(ele);
                        basedb.Entry(ele).State = EntityState.Modified;

                    }

                    basedb.SaveChanges();

                    var controlasistenciasdeltrabajador = basedb.Nomina_RelojChecadorAsistencia.Where(c => c.IdEstructuraOrganica == idEstructuraOrganicaReloj
                    && c.EsProcesada == false && c.FechaAsistencia.Year == FechaReg.Year && c.FechaAsistencia.Month == FechaReg.Month && c.FechaAsistencia.Day == FechaReg.Day).ToList();



                    if (controlasistenciasdeltrabajador.Count == 0)
                    {
                        var control = basedb.Nomina_RelojChecadorControl.Where(v => v.IdEstructuraOrganica == idEstructuraOrganicaReloj && DbFunctions.TruncateTime(v.FechaRegistro) == fechaproceso.Date).FirstOrDefault();
                        if (control != null)
                        {
                            control.ProcesoIncidenciasCompletado = true;



                            basedb.Nomina_RelojChecadorControl.Attach(control);
                            basedb.Entry(control).State = EntityState.Modified;
                        }
                        }
                    try
                    {
                        basedb.SaveChanges();
                    }
                    catch (Exception er)
                    {

                        var d = er.Message;
                    }
                }
                scope.Complete();


            }



            return hayerror;






        }

        public bool ProcesarIncidenciasTesting(short idEstructuraOrganicaReloj, string fi, string ff)
        {
            DateTime diaI = DateTime.Parse(fi);
            DateTime diaF = DateTime.Parse(ff);

            var hayerror = false;
            var ultimodiaprocesadoBD = bd.Nomina_RelojChecadorControl.Where(r => r.IdEstructuraOrganica == idEstructuraOrganicaReloj

   && DbFunctions.TruncateTime(r.FechaRegistro) == DbFunctions.TruncateTime(diaI)

   ).OrderByDescending(w => w.FechaRegistro).FirstOrDefault();

            var diasaprocesar = bd.Nomina_RelojChecadorControl.Where(r => r.IdEstructuraOrganica == idEstructuraOrganicaReloj
            //&& r.ProcesoIncidenciasCompletado == false
            && DbFunctions.TruncateTime(r.FechaRegistro) == DbFunctions.TruncateTime(diaF)
            ).OrderBy(w => w.FechaRegistro).Select(w => new { FechaRegistro = w.FechaRegistro }).ToList();

            DateTime ultimodiaAprocesar = new DateTime();
            DateTime IniciodiaAprocesar = new DateTime();
            if (diasaprocesar.Count > 0)
            {
                ultimodiaAprocesar = diasaprocesar.LastOrDefault().FechaRegistro;
                IniciodiaAprocesar = ultimodiaprocesadoBD.FechaRegistro;
            }
            else
            {
                ultimodiaAprocesar = diaF;
                IniciodiaAprocesar = diaI;
            }

            List<DateTime> diastotales = new List<DateTime>();
            for (var date = IniciodiaAprocesar; date <= ultimodiaAprocesar; date = date.AddDays(1))
            {
                diastotales.Add(date);
            }



            Nomina_RelojChecadorAreasEstructuraOrganicaTolerancia = bd.Nomina_RelojChecadorAreasEstructuraOrganicaTolerancia.ToList();


            foreach (var dt in diastotales)
            {
                if (diasaprocesar.Where(s => s.FechaRegistro.Date == dt.Date).FirstOrDefault() == null)
                    diasaprocesar.Add(new { FechaRegistro = dt });
            }

            diasaprocesar = diasaprocesar.OrderBy(s => s.FechaRegistro).ToList();
            foreach (var ele in diasaprocesar)
            {

                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    bdNovaEntities basedb = new bdNovaEntities();
                    Nomina_RelojChecadorAsistencia = basedb.Nomina_RelojChecadorAsistencia.Where(c => c.IdEstructuraOrganica == idEstructuraOrganicaReloj
                    //&& c.EsProcesada == false
                 && c.FechaAsistencia.Year == ele.FechaRegistro.Year && c.FechaAsistencia.Month == ele.FechaRegistro.Month && c.FechaAsistencia.Day == ele.FechaRegistro.Day).ToList();

                    var fechaproceso = ele.FechaRegistro;

                    var asistenciastrabajadores = Nomina_RelojChecadorAsistencia.GroupBy(d => d.IdTrabajador).Select(r => new { IdTrabajador = r.Key }).ToList();

                    TransactionOptions transactionoptions2 = new TransactionOptions();
                    transactionoptions2.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                    using (TransactionScope scope2 = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
                    {
                        NominaTrabajador.setHorariosDocentes(fechaproceso.ToString("yyyyMMdd"),false,false,true);
                    }

                    if (asistenciastrabajadores.Count == 0)
                    {
                        GenerarFaltasPersonalSinAsistencias(fechaproceso, idEstructuraOrganicaReloj, true);

                    }
                    else
                    {
                        foreach (var item in asistenciastrabajadores.Where(s => s.IdTrabajador != null))
                        {
                            hayerror = CrearIncidencia((int)item.IdTrabajador, fechaproceso, idEstructuraOrganicaReloj);

                            CreaFaltasPorRetardosYPases(fechaproceso, (int)item.IdTrabajador);

                            basedb.Configuration.AutoDetectChangesEnabled = false;
                            basedb.Configuration.ValidateOnSaveEnabled = false;


                            var asistenciasdeltrabajador = Nomina_RelojChecadorAsistencia.Where(c => c.IdTrabajador == item.IdTrabajador
                    && c.FechaAsistencia.Year == ele.FechaRegistro.Year && c.FechaAsistencia.Month == ele.FechaRegistro.Month && c.FechaAsistencia.Day == ele.FechaRegistro.Day).ToList();

                            foreach (var dat in asistenciasdeltrabajador)
                            {
                                dat.EsProcesada = true;
                                basedb.Nomina_RelojChecadorAsistencia.Add(dat);
                                basedb.Entry(dat).State = EntityState.Modified;

                            }

                            basedb.SaveChanges();
                        }

                       

                        var controlasistenciasdeltrabajador = basedb.Nomina_RelojChecadorAsistencia.Where(c => c.IdEstructuraOrganica == idEstructuraOrganicaReloj
                        && c.EsProcesada == false
               && c.FechaAsistencia.Year == ele.FechaRegistro.Year && c.FechaAsistencia.Month == ele.FechaRegistro.Month && c.FechaAsistencia.Day == ele.FechaRegistro.Day).ToList();

                        if (controlasistenciasdeltrabajador.Count == 0)
                        {
                            var control = basedb.Nomina_RelojChecadorControl.Where(v => v.IdEstructuraOrganica == idEstructuraOrganicaReloj && DbFunctions.TruncateTime(v.FechaRegistro) == fechaproceso.Date).FirstOrDefault();
                            if (control != null)
                            {
                                control.ProcesoIncidenciasCompletado = true;



                                basedb.Nomina_RelojChecadorControl.Attach(control);
                                basedb.Entry(control).State = EntityState.Modified;
                            }
                        }

                        //var control = basedb.Nomina_RelojChecadorControl.Where(v => v.IdEstructuraOrganica == idEstructuraOrganicaReloj && DbFunctions.TruncateTime(v.FechaRegistro) == fechaproceso.Date).FirstOrDefault();

                        //if (control != null)
                        //{
                        //    control.ProcesoIncidenciasCompletado = true;

                        //    basedb.Configuration.AutoDetectChangesEnabled = false;
                        //    basedb.Configuration.ValidateOnSaveEnabled = false;


                        //    basedb.Nomina_RelojChecadorControl.Attach(control);
                        //    basedb.Entry(control).State = EntityState.Modified;
                        //}

                        try
                        {
                            basedb.SaveChanges();
                        }
                        catch (Exception er)
                        {

                            var d = er.Message;
                        }
                    }

                    scope.Complete();
                }

            }



            return hayerror;







        }

        public void CreaFaltasPorRetardosYPases(DateTime fecha,int idtrabajador)
        {
            DateTime fechaqna = fecha;
            DateTime fechaInicioMes = fecha;
            DateTime fecha1aqna = fecha;

            string IdEmpleados = "";
            var diasmes = DateTime.DaysInMonth(fechaqna.Year, fechaqna.Month);

            DateTime fechaqnaFinal = new DateTime(fechaqna.Year, fechaqna.Month, 15);

            DateTime FinalMes = new DateTime(fechaqna.Year, fechaqna.Month, diasmes);

            bool Es2aQna = false;
            if (fechaqna.Day > 15)
            {

                Es2aQna = true;
                fechaqna = new DateTime(fechaqna.Year, fechaqna.Month, 16);
                fechaqnaFinal = new DateTime(fechaqna.Year, fechaqna.Month, diasmes);


            }
            else
            {
                fechaqna = new DateTime(fechaqna.Year, fechaqna.Month, 1);

            }


            fechaInicioMes = new DateTime(fechaqna.Year, fechaqna.Month, 1);
            fecha1aqna = new DateTime(fechaqna.Year, fechaqna.Month, 15);


            bdNovaEntities basedb = new bdNovaEntities();

            //var areas = basedb.Nomina_RelojChecadorAreasEstructuraOrganica.Where(s => s.Nomina_RelojChecadorAreas.IdEstructuraOrganica == idEstructuraOrganicaReloj).Select(s => s.IdEstructuraOrganica).ToArray();

            // var listaemple = this.TrabajadoresConRetardos.Select(a => a.IdConvenioLaboralTrabajadorCategoria).ToList();

            // var listaemple = this.TrabajadoresConRetardos.Select(a => a.IdConvenioLaboralTrabajadorCategoria).ToList();

            List<int> listaemple = basedb.vwDatosAspirantesTrabajadoresHistorial.Where(s =>
              s.IdTrabajador == idtrabajador).Select(z => (int)z.IdConvenioLaboralTrabajadorCategoria).ToList();

            List<int> empleados = listaemple;
            //List<int> empleados = basedb.vwDatosAspirantesTrabajadoresHistorial.Where(s =>
            //  s.IdTrabajador==idtrabajador).Select(z=> (int)z.IdConvenioLaboralTrabajadorCategoria).ToList();
           
            //var listaemple = trab.Select(d => d.IdConvenioLaboralTrabajadorCategoria).ToArray();

            var empleadosConRetardosQnaactual = basedb.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking()
                .Where(c => empleados.Contains((int)c.IdConvenioLaboralTrabajadorCategoria) &&
            c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
            DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaqna) &&
            DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fechaqnaFinal)
            ).Select(w => w.IdConvenioLaboralTrabajadorCategoria).ToList();

            //  List<IncidenciaPermiso_stIncidenciaTrabajador> empleadosConRetardos1aqna = new List<IncidenciaPermiso_stIncidenciaTrabajador>();   
            if (Es2aQna == true)
            {
                var empleadosConRetardos1aqna = basedb.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
               c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
               DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaInicioMes) &&
               DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fecha1aqna)
                ).Select(w => w.IdConvenioLaboralTrabajadorCategoria).ToList();

                empleadosConRetardosQnaactual.AddRange(empleadosConRetardos1aqna);
            }

            var empleadosConRetardos = empleadosConRetardosQnaactual.ToArray();

            //var universo = empleados.Where(s => empleadosConRetardos.Contains((int)s.IdConvenioLaboralTrabajadorCategoria)).ToList();
            var universo = basedb.vwDatosAspirantesTrabajadoresHistorial.Where(s=> empleadosConRetardos.Contains((int)s.IdConvenioLaboralTrabajadorCategoria)).ToList();

            var incidencias = basedb.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
             //c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && 
             DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaqna) &&
             DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fechaqnaFinal)
             ).OrderBy(v => new { v.IdConvenioLaboralTrabajadorCategoria, v.FechaInicio }).ToList();

            List<IncidenciaPermiso_stIncidenciaTrabajador> retardos1aqna = new List<IncidenciaPermiso_stIncidenciaTrabajador>();
            if (Es2aQna)
            {



                retardos1aqna = basedb.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
                c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") &&
                DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaInicioMes) &&
                DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fecha1aqna)
                ).OrderBy(v => new { v.IdConvenioLaboralTrabajadorCategoria, v.FechaInicio }).ToList();
            }

            var retardosCONFALTAS = incidencias.Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
    c.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
   c.FechaInicio.Date >= fechaqna.Date &&
    c.FechaInicio.Date <= fechaqnaFinal.Date
   ).OrderBy(v => v.FechaInicio).ToList();

            foreach (var ele in universo)
            {
                bool evaluar = true;
                int MaximoNumeroRetardos = 2;

                var retardos = incidencias.Where(c => c.IdConvenioLaboralTrabajadorCategoria == ele.IdConvenioLaboralTrabajadorCategoria &&
        c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
       c.FechaInicio.Date >= fechaqna.Date &&
        c.FechaInicio.Date <= fechaqnaFinal.Date
       ).OrderBy(v => v.FechaInicio).ToList();

                List<IncidenciaPermiso_stIncidenciaTrabajador> retardosanteriores = new List<IncidenciaPermiso_stIncidenciaTrabajador>();


                int totalretardos = 0;

                evaluar = true;
                MaximoNumeroRetardos = 2;

                if (ele.ConvenioLaboral == "BASE" && ele.RelacionLaboral == "ADMINISTRATIVO")
                {
                    //if (Es2aQna == false)
                    //{
                    //    evaluar = false;
                    //}
                    //else
                    //{
                    MaximoNumeroRetardos = 5;
                    retardosanteriores = retardos1aqna.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ele.IdConvenioLaboralTrabajadorCategoria).ToList();

                    retardos.AddRange(retardosanteriores);
                    //}

                }




                List<RetardosOTiempoFuera> listaretardos = new List<RetardosOTiempoFuera>();

                if (retardos.Count > MaximoNumeroRetardos && evaluar)
                {
                    foreach (var item in retardos.OrderBy(w => w.FechaInicio))
                    {
                        IncidenciaPermiso_stIncidenciaTrabajador tienefalta = null;
                        if (ele.RelacionLaboral != "DOCENTE")
                        {
                            tienefalta = retardosCONFALTAS.Where(a => a.FechaInicio == item.FechaInicio
                          && item.IdConvenioLaboralTrabajadorCategoria == a.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                        }

                        if (item.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && tienefalta == null)
                        {
                            var nohayomisionoFalta = retardos.Where(q => q.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                            && (q.IdIncidenciaJustificacion > 0 && q.Autorizo) && q.FechaInicio == item.FechaInicio && (q.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") || q.Catalogos_ctTipoIncidencia.Incidencia.Contains("OMISI"))).ToList();

                            var yaestaenlabase = incidencias.Where(q => q.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                             && (q.IdIncidenciaJustificacion == 0 && q.EsCerrada == true) && q.FechaInicio == item.FechaInicio && q.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA POR RETARDOS")).ToList();

                            if (nohayomisionoFalta.Count == 0 && yaestaenlabase.Count == 0)
                            {
                                totalretardos = totalretardos + 1;


                            }
                            if (totalretardos > MaximoNumeroRetardos)
                            {
                                RetardosOTiempoFuera rt = new RetardosOTiempoFuera();
                                rt.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                rt.Fecha = item.FechaInicio;
                                listaretardos.Add(rt);
                            }
                        }
                    }


                }

                int totalretardosfor = listaretardos.Count();
                int totalretardosforaplicados = 0;
                if (Es2aQna && listaretardos.Count() > MaximoNumeroRetardos)
                {
                    totalretardosfor = listaretardos.Count() - MaximoNumeroRetardos;
                }
                foreach (var l in listaretardos)
                {
                    if (totalretardosforaplicados < totalretardosfor)
                    {
                        if (ele.RelacionLaboral.Contains("DOCENTE"))
                            GuardaIncidencia((int)l.IdConvenioLaboralTrabajadorCategoria, l.Fecha, TiposdeIncidencia.FaltaPorRetardo, "PORRETARDODOCENTE", 1, null, null, true);
                        else
                            GuardaIncidencia((int)l.IdConvenioLaboralTrabajadorCategoria, l.Fecha, TiposdeIncidencia.FaltaPorRetardo, "PORRETARDO", 8, null, null, true);
                    }
                    totalretardosforaplicados++;
                }
            }

            //descuentos por exceder pases de salida
            var emple = this.vwDatosAspirantesTrabajadores.Where(s => s.IdTrabajador == idtrabajador && s.EsPlazaBase==true).ToList();
            if (emple.Count()>0)
            if (emple.FirstOrDefault().ConvenioLaboral == "BASE")
            {
                foreach (var ele in emple)
                {
                    IdEmpleados = IdEmpleados + ele.IdTrabajador + ",";
                }

                IdEmpleados = IdEmpleados.Substring(0, IdEmpleados.Length - 1);

                int HORASMAXIMO = 9;

                string query = @"
            SELECT c.IdTrabajador,
            a.IdConvenioLaboralTrabajadorCategoria,a.FechaInicio
            ,a.TiempoFuera,horas
            ,RelacionLaboral,IdIncidenciaTrabajador
            FROM   IncidenciaPermiso_stIncidenciaTrabajador a
            inner join  Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
            inner join vwDatosAspirantesTrabajadoreshistorial c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
            inner join Incidencia_ctJustificacion d on d.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
            where Categoria<>'VIGILANTE' AND  b.Incidencia in ('HORAS POR PASE DE SALIDA')
            and year(a.fechaInicio)=" + fechaqna.Year + @"
            and month(a.fechaInicio)='" + fechaqna.Month + @"'   
            and c.idtrabajador in (" + IdEmpleados + @") 
        union all
SELECT c.IdTrabajador,
            a.IdConvenioLaboralTrabajadorCategoria,a.FechaInicio
            ,a.TiempoFuera,horas
            ,RelacionLaboral,IdIncidenciaTrabajador
            FROM   IncidenciaPermiso_stIncidenciaTrabajador a
            inner join  Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
            inner join vwDatosAspirantesTrabajadoreshistorial c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
            inner join Incidencia_ctJustificacion d on d.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
            where Categoria<>'VIGILANTE' and EsFaltaDirecta=0 and 
 b.Incidencia like ('%FALTA%')
 AND 
 d.IncidenciaJustificacion in ('PASE DE SALIDA')
            and year(a.fechaInicio)=" + fechaqna.Year + @"
            and month(a.fechaInicio)='" + fechaqna.Month + @"'   
            and c.idtrabajador in (" + IdEmpleados + @") order by 3 ";


                DapperQuery dp = new DapperQuery("bdNovaEntities");



                List<RetardosOTiempoFuera> excesos = (List<RetardosOTiempoFuera>)dp.connection.Query<RetardosOTiempoFuera>(query);
                List<RetardosOTiempoFuera> trabajadorestiempo = new List<RetardosOTiempoFuera>();
                trabajadorestiempo.Add(excesos.LastOrDefault());

                dp.Close();


                double sumaTotalMinutos = excesos
                .Where(item => item.TiempoFuera.TotalMinutes <= 180) // 3 horas y 1 minuto son 181 minutos
             .Sum(item => item.TiempoFuera.TotalMinutes);

                    var excede3horasenpases = excesos
                  .Where(item => item.TiempoFuera.TotalMinutes > 181) // 3 horas y 1 minuto son 181 minutos
                  .ToList();


                    TimeSpan sumaTotal = TimeSpan.FromMinutes(sumaTotalMinutos);

                var idsTrabajadores = emple.Select(a => a.IdTrabajador).ToList();

                var fechaqnaDate = fechaqna.Date;
                var fechaqnaFinalDate = fechaqnaFinal.Date;

                    bool nuevehorasmasunminuto = false;
                    if (sumaTotal.Hours == 9 && sumaTotal.Minutes > 0)
                        nuevehorasmasunminuto = true;

                        if (sumaTotal.Hours > 9  || excede3horasenpases.Count()>0 || nuevehorasmasunminuto)
                    {


                    var faltasporpaseenbd = basedb.IncidenciaPermiso_stIncidenciaTrabajador
            .AsNoTracking()
            .Where(c => idsTrabajadores.Contains(c.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador)
                && c.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA POR EXCEDER HORAS DE PASES DE SALIDA")
                && DbFunctions.TruncateTime(c.FechaInicio) >= fechaqna.Date
                && DbFunctions.TruncateTime(c.FechaInicio) <= fechaqnaFinal.Date)
            .Include(a => a.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
            .OrderBy(v => v.FechaInicio)
            .ToList();


                    foreach (var j in trabajadorestiempo)
                    {
 

                            int horasADescontar = CalcularDiasADescontar(sumaTotal, HORASMAXIMO);
                         
                            horasADescontar = horasADescontar + excede3horasenpases.Count();
                            

                        var existenfaltas = faltasporpaseenbd.Where(q => j.IdTrabajador == q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();
                        horasADescontar = horasADescontar - existenfaltas.Count();

                        DateTime fechainicioincidecia = fechaqna;
                        if (existenfaltas.Count() > 0)
                        {
                            fechainicioincidecia = existenfaltas.LastOrDefault().FechaInicio.AddDays(1);
                        }

                        if (j.RelacionLaboral.Contains("DOCENTE"))
                        {
                            while (horasADescontar > 0)
                            {
                                // Calcular las horas a descontar en el día actual
                                int horasEnEsteDia = Math.Min(horasADescontar, HORASMAXIMO);

                                // Crear incidencia para el día actual

                                GuardaIncidencia((int)j.IdConvenioLaboralTrabajadorCategoria, fechainicioincidecia, TiposdeIncidencia.FaltaPorExcederPases, "FaltaPorPasesSalidaDocente",horasEnEsteDia, $"0{horasEnEsteDia}:00:00", null, true);


                                // Restar las horas descontadas
                                horasADescontar -= horasEnEsteDia;
                            }

                        }

                        else
                        {
                            for (int i = 0; i < horasADescontar; i++)
                            {
                                GuardaIncidencia((int)j.IdConvenioLaboralTrabajadorCategoria, fechainicioincidecia, TiposdeIncidencia.FaltaPorExcederPases,"FaltaPorPasesSalida", 8, $"0{8}:00:00", null, true);

                                fechainicioincidecia = ObtenerFechaSiguienteNoFinDeSemana(fechainicioincidecia);


                            }
                        }

                    }

                    //  int totalIncidencias = j.Horas - HORASMAXIMO;


                }


            }


        }

        public int CalcularDiasADescontar(TimeSpan tiempoTotal,int  HORAS_MAXIMO)
        {
            // Si el tiempo es menor o igual al máximo, no hay días a descontar
            if (tiempoTotal.TotalHours <= HORAS_MAXIMO)
                return 0;

            // Calculamos el exceso de tiempo
            TimeSpan tiempoExcedido = tiempoTotal - TimeSpan.FromHours(HORAS_MAXIMO);

            // Si hay exceso, calculamos los días
            // Cualquier exceso de más de 0 minutos cuenta como un día adicional
            int diasADescontar = (int)Math.Ceiling(tiempoExcedido.TotalHours);

            return diasADescontar;
        }

        [Obsolete]
        private void CreaFaltasPorRetardosYPases(int idtrabajador, DateTime fecha)
        {
            DateTime fechaqna = fecha;
            DateTime fechaInicioMes = fecha;
            DateTime fecha1aqna = fecha;

            string IdEmpleados = "";
            var diasmes = DateTime.DaysInMonth(fechaqna.Year, fechaqna.Month);

            DateTime fechaqnaFinal = new DateTime(fechaqna.Year, fechaqna.Month, 15);

            DateTime FinalMes = new DateTime(fechaqna.Year, fechaqna.Month, diasmes);

            bool Es2aQna = false;
            if (fechaqna.Day > 15)
            {

                Es2aQna = true;
                fechaqna = new DateTime(fechaqna.Year, fechaqna.Month, 16);
                fechaqnaFinal = new DateTime(fechaqna.Year, fechaqna.Month, diasmes);


            }
            else
            {
                fechaqna = new DateTime(fechaqna.Year, fechaqna.Month, 1);

            }


            fechaInicioMes = new DateTime(fechaqna.Year, fechaqna.Month, 1);
            fecha1aqna = new DateTime(fechaqna.Year, fechaqna.Month, 15);


            bdNovaEntities basedb = new bdNovaEntities();

            //var areas = basedb.Nomina_RelojChecadorAreasEstructuraOrganica.Where(s => s.Nomina_RelojChecadorAreas.IdEstructuraOrganica == idEstructuraOrganicaReloj).Select(s => s.IdEstructuraOrganica).ToArray();

            List<vwDatosAspirantesTrabajadores> empleados = basedb.vwDatosAspirantesTrabajadores.Where(s => s.RestringirMenu == null && s.IdTrabajador== idtrabajador).ToList();
            var listaemple = empleados.Select(d => d.IdConvenioLaboralTrabajadorCategoria).ToArray();

            var empleadosConRetardosQnaactual = basedb.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking()
                .Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
            c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
            DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaqna) &&
            DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fechaqnaFinal)
            ).Select(w => w.IdConvenioLaboralTrabajadorCategoria).ToList();

            //  List<IncidenciaPermiso_stIncidenciaTrabajador> empleadosConRetardos1aqna = new List<IncidenciaPermiso_stIncidenciaTrabajador>();   
            if (Es2aQna == true)
            {
                var empleadosConRetardos1aqna = basedb.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
               c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
               DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaInicioMes) &&
               DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fecha1aqna)
                ).Select(w => w.IdConvenioLaboralTrabajadorCategoria).ToList();

                empleadosConRetardosQnaactual.AddRange(empleadosConRetardos1aqna);
            }

            var empleadosConRetardos = empleadosConRetardosQnaactual.ToArray();

            var universo = empleados.Where(s => empleadosConRetardos.Contains((int)s.IdConvenioLaboralTrabajadorCategoria)).ToList();

            var incidencias = basedb.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
             //c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && 
             DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaqna) &&
             DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fechaqnaFinal)
             ).OrderBy(v => new { v.IdConvenioLaboralTrabajadorCategoria, v.FechaInicio }).ToList();

            List<IncidenciaPermiso_stIncidenciaTrabajador> retardos1aqna = new List<IncidenciaPermiso_stIncidenciaTrabajador>();
            if (Es2aQna)
            {



                retardos1aqna = basedb.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
                c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") &&
                DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaInicioMes) &&
                DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fecha1aqna)
                ).OrderBy(v => new { v.IdConvenioLaboralTrabajadorCategoria, v.FechaInicio }).ToList();
            }

            var retardosCONFALTAS = incidencias.Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
    c.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
   c.FechaInicio.Date >= fechaqna.Date &&
    c.FechaInicio.Date <= fechaqnaFinal.Date
   ).OrderBy(v => v.FechaInicio).ToList();

            foreach (var ele in universo)
            {
                bool evaluar = true;
                int MaximoNumeroRetardos = 2;

                var retardos = incidencias.Where(c => c.IdConvenioLaboralTrabajadorCategoria == ele.IdConvenioLaboralTrabajadorCategoria &&
        c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
       c.FechaInicio.Date >= fechaqna.Date &&
        c.FechaInicio.Date <= fechaqnaFinal.Date
       ).OrderBy(v => v.FechaInicio).ToList();

                List<IncidenciaPermiso_stIncidenciaTrabajador> retardosanteriores = new List<IncidenciaPermiso_stIncidenciaTrabajador>();


                int totalretardos = 0;

                evaluar = true;
                MaximoNumeroRetardos = 2;

                if (ele.ConvenioLaboral == "BASE" && ele.RelacionLaboral == "ADMINISTRATIVO")
                {
                    //if (Es2aQna == false)
                    //{
                    //    evaluar = false;
                    //}
                    //else
                    //{
                    MaximoNumeroRetardos = 5;
                    retardosanteriores = retardos1aqna.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ele.IdConvenioLaboralTrabajadorCategoria).ToList();

                    retardos.AddRange(retardosanteriores);
                    //}

                }




                List<RetardosOTiempoFuera> listaretardos = new List<RetardosOTiempoFuera>();

                if (retardos.Count > MaximoNumeroRetardos && evaluar)
                {
                    foreach (var item in retardos.OrderBy(w => w.FechaInicio))
                    {
                        var tienefalta = retardosCONFALTAS.Where(a => a.FechaInicio == item.FechaInicio
                        && item.IdConvenioLaboralTrabajadorCategoria == a.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                        if (item.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && tienefalta == null)
                        {
                            var nohayomisionoFalta = retardos.Where(q => q.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                            && (q.IdIncidenciaJustificacion > 0 && q.Autorizo) && q.FechaInicio == item.FechaInicio && (q.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") || q.Catalogos_ctTipoIncidencia.Incidencia.Contains("OMISI"))).ToList();

                            var yaestaenlabase = incidencias.Where(q => q.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                             && (q.IdIncidenciaJustificacion == 0 && q.EsCerrada == true) && q.FechaInicio == item.FechaInicio && q.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA POR RETARDOS")).ToList();

                            if (nohayomisionoFalta.Count == 0 && yaestaenlabase.Count == 0)
                            {
                                totalretardos = totalretardos + 1;


                            }
                            if (totalretardos > MaximoNumeroRetardos)
                            {
                                RetardosOTiempoFuera rt = new RetardosOTiempoFuera();
                                rt.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                rt.Fecha = item.FechaInicio;
                                listaretardos.Add(rt);
                            }
                        }
                    }


                }

                int totalretardosfor = listaretardos.Count();
                int totalretardosforaplicados = 0;
                if (Es2aQna && listaretardos.Count() > MaximoNumeroRetardos)
                {
                    totalretardosfor = listaretardos.Count() - MaximoNumeroRetardos;
                }
                foreach (var l in listaretardos)
                {
                    if (totalretardosforaplicados < totalretardosfor)
                    {
                        if (ele.RelacionLaboral.Contains("DOCENTE"))
                            GuardaIncidencia((int)l.IdConvenioLaboralTrabajadorCategoria, l.Fecha, TiposdeIncidencia.FaltaPorRetardo,"PorRetardosDocente", 1, null, "1", true);
                        else
                            GuardaIncidencia((int)l.IdConvenioLaboralTrabajadorCategoria, l.Fecha, TiposdeIncidencia.FaltaPorRetardo,"PorReatardo", 8, null, "1", true);
                    }
                    totalretardosforaplicados++;
                }
            }

            //descuentos por exceder pases de salida
//            if (empleados.FirstOrDefault().ConvenioLaboral == "BASE")
//            {
//                foreach (var ele in empleados)
//                {
//                    IdEmpleados = IdEmpleados + ele.IdTrabajador + ",";
//                }

//                IdEmpleados = IdEmpleados.Substring(0, IdEmpleados.Length - 1);

//                int HORASMAXIMO = 9;

//                string query = @"
//SELECT c.IdTrabajador,
//a.IdConvenioLaboralTrabajadorCategoria,a.FechaInicio
//,a.TiempoFuera,horas
//,RelacionLaboral
//FROM   IncidenciaPermiso_stIncidenciaTrabajador a
//inner join  Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
//inner join vwDatosAspirantesTrabajadoreshistorial c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
//inner join Incidencia_ctJustificacion d on d.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
//where (b.Incidencia in ('HORAS POR PASE DE SALIDA') or d.IncidenciaJustificacion in ('PASE DE SALIDA'))
//and year(a.fechaInicio)=" + fechaqna.Year + @"
//and month(a.fechaInicio)='" + fechaqna.Month + @"'   
//and c.idtrabajador in (" + IdEmpleados + @") order by a.fechaInicio ";


//                DapperQuery dp = new DapperQuery("bdNovaEntities");



//                List<RetardosOTiempoFuera> excesos = (List<RetardosOTiempoFuera>)dp.connection.Query<RetardosOTiempoFuera>(query);
//                List<RetardosOTiempoFuera> trabajadorestiempo = new List<RetardosOTiempoFuera>();
//                trabajadorestiempo.Add(excesos.LastOrDefault());

//                dp.Close();


//                double sumaTotalMinutos = excesos
//             .Sum(item => item.TiempoFuera.TotalMinutes);

//                TimeSpan sumaTotal = TimeSpan.FromMinutes(sumaTotalMinutos);

//                var idsTrabajadores = empleados.Select(a => a.IdTrabajador).ToList();

//                var fechaqnaDate = fechaqna.Date;
//                var fechaqnaFinalDate = fechaqnaFinal.Date;

//                if (sumaTotal.Hours > 9)
//                {


//                    var faltasporpaseenbd = basedb.IncidenciaPermiso_stIncidenciaTrabajador
//            .AsNoTracking()
//            .Where(c => idsTrabajadores.Contains(c.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador)
//                && c.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA POR EXCEDER HORAS DE PASES DE SALIDA")
//                && DbFunctions.TruncateTime(c.FechaInicio) >= fechaqna.Date
//                && DbFunctions.TruncateTime(c.FechaInicio) <= fechaqnaFinal.Date)
//            .Include(a => a.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
//            .OrderBy(v => v.FechaInicio)
//            .ToList();


//                    foreach (var j in trabajadorestiempo)
//                    {
//                        int horasADescontar = sumaTotal.Hours - HORASMAXIMO;
//                        var existenfaltas = faltasporpaseenbd.Where(q => j.IdTrabajador == q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();
//                        horasADescontar = horasADescontar - existenfaltas.Count();

//                        DateTime fechainicioincidecia = fechaqna;
//                        if (existenfaltas.Count() > 0)
//                        {
//                            fechainicioincidecia = existenfaltas.LastOrDefault().FechaInicio.AddDays(1);
//                        }

//                        if (j.RelacionLaboral.Contains("DOCENTE"))
//                        {
//                            while (horasADescontar > 0)
//                            {
//                                // Calcular las horas a descontar en el día actual
//                                int horasEnEsteDia = Math.Min(horasADescontar, HORASMAXIMO);

//                                // Crear incidencia para el día actual

//                                GuardaIncidencia((int)j.IdConvenioLaboralTrabajadorCategoria, fechainicioincidecia, TiposdeIncidencia.FaltaPorExcederPases, horasEnEsteDia, $"0{horasEnEsteDia}:00:00", "1", true);


//                                // Restar las horas descontadas
//                                horasADescontar -= horasEnEsteDia;
//                            }

//                        }

//                        else
//                        {
//                            for (int i = 0; i < horasADescontar; i++)
//                            {
//                                GuardaIncidencia((int)j.IdConvenioLaboralTrabajadorCategoria, fechainicioincidecia, TiposdeIncidencia.FaltaPorExcederPases, 8, $"0{8}:00:00", "1", true);

//                                fechainicioincidecia = ObtenerFechaSiguienteNoFinDeSemana(fechainicioincidecia);


//                            }
//                        }

//                    }

//                    //  int totalIncidencias = j.Horas - HORASMAXIMO;


//                }


//            }         
                
           
        }

        private DateTime ObtenerFechaSiguienteNoFinDeSemana(DateTime fecha)
        {
            do
            {
                fecha = fecha.AddDays(1);
            } while (EsFinDeSemana(fecha));

            return fecha;
        }

        private bool EsFinDeSemana(DateTime fecha)
        {
            return fecha.DayOfWeek == DayOfWeek.Saturday || fecha.DayOfWeek == DayOfWeek.Sunday;
        }

        public void CierreMesSinAfectarRetardos(short idEstructuraOrganica, string fecha, string qna, string año)
        {
            DateTime fechaqna = DateTime.Parse(fecha);
            DateTime fechaInicioMes = DateTime.Parse(fecha);
            DateTime fecha1aqna = DateTime.Parse(fecha);

            string IdEmpleados = "";
            var diasmes = DateTime.DaysInMonth(fechaqna.Year, fechaqna.Month);

            DateTime fechaqnaFinal = new DateTime(fechaqna.Year, fechaqna.Month, 15);

            DateTime FinalMes = new DateTime(fechaqna.Year, fechaqna.Month, diasmes);

            bool Es2aQna = false;
            if (fechaqna.Day > 15)
            {

                Es2aQna = true;
                fechaqna = new DateTime(fechaqna.Year, fechaqna.Month, 16);
                fechaqnaFinal = new DateTime(fechaqna.Year, fechaqna.Month, diasmes);


            }
            else
            {
                fechaqna = new DateTime(fechaqna.Year, fechaqna.Month, 1);

            }


            fechaInicioMes = new DateTime(fechaqna.Year, fechaqna.Month, 1);
            fecha1aqna = new DateTime(fechaqna.Year, fechaqna.Month, 15);

            bdNovaEntities basedb = new bdNovaEntities();

            List<vwDatosAspirantesTrabajadores> empleados = basedb.vwDatosAspirantesTrabajadores.Where(s => s.RestringirMenu == null && s.IdEstructuraOrganicaFisica== idEstructuraOrganica).ToList();


            // if (fechaqna.Day > 15)
            //{

            foreach (var ele in empleados)
            {
                IdEmpleados = IdEmpleados + ele.IdConvenioLaboralTrabajadorCategoria + ",";
            }

            IdEmpleados = IdEmpleados.Substring(0, IdEmpleados.Length - 1);

            //excedieron de horas por pases de salida
            //                string query = @"SELECT 
            //a.IdConvenioLaboralTrabajadorCategoria,max(a.FechaInicio) as Fecha
            //,CONVERT(TIME, DATEADD(s, SUM(( DATEPART(hh, TiempoFuera) * 3600 ) + ( DATEPART(mi, TiempoFuera) * 60 ) + DATEPART(ss, TiempoFuera)), 0)) AS TiempoFuera
            //,RelacionLaboral
            //FROM   IncidenciaPermiso_stIncidenciaTrabajador a
            //inner join  Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
            //inner join vwDatosAspirantesTrabajadores c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
            //inner join Incidencia_ctJustificacion d on d.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
            //where b.Incidencia in ('OMISIÓN DE SALIDA', 'PASE DE SALIDA') and a.fechaInicio>='" + fechaqna.Date.ToString("yyyyMMdd") + @"' 
            //and a.fechaInicio<='" + FinalMes.Date.ToString("yyyyMMdd") + @"'  and a.IdConvenioLaboralTrabajadorCategoria in (" + IdEmpleados + @")
            //and (a.Autorizo = 1 and a.IdIncidenciaJustificacion>0)
            //and IncidenciaJustificacion not in ('SUSPENSIÓN DE LABORES','DÍA DE LA MADRE' )
            //group by a.IdConvenioLaboralTrabajadorCategoria,RelacionLaboral";


            string query = @"SELECT 
a.IdConvenioLaboralTrabajadorCategoria,a.FechaInicio as Fecha
,a.Horas
,RelacionLaboral
FROM   IncidenciaPermiso_stIncidenciaTrabajador a
inner join  Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
inner join vwDatosAspirantesTrabajadores c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Incidencia_ctJustificacion d on d.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
where (b.Incidencia in ('HORAS POR PASE DE SALIDA') or d.IncidenciaJustificacion in ('PASE DE SALIDA'))
and cast(a.fechaInicio as date)>='" + fechaqna.Date.ToString("yyyyMMdd") + @"' 
and cast(a.fechaInicio as date)<='" + fechaqnaFinal.Date.ToString("yyyyMMdd") + @"'  and a.IdConvenioLaboralTrabajadorCategoria in (" + IdEmpleados + @")
and (a.Autorizo = 1 )
   and a.Horas>3";


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            List<RetardosOTiempoFuera> excesos = (List<RetardosOTiempoFuera>)dp.connection.Query<RetardosOTiempoFuera>(query);

            dp.Close();

            foreach (var j in excesos)
            {


                if (j.Horas > 3)
                {
                    int totalIncidencias = j.Horas - 3;
                    //if (!j.RelacionLaboral.Contains("DOCENTE"))
                    GuardaIncidencia((int)j.IdConvenioLaboralTrabajadorCategoria, j.Fecha, TiposdeIncidencia.FaltaPorExcederPases,"CierreMesSinAfectarRetardos", totalIncidencias, $"0{totalIncidencias}:00:00", "1", true, qna, año);



                    //for (int i = 1; i < totalIncidencias; i++)
                    //{
                    //    GuardaIncidencia((int)j.IdConvenioLaboralTrabajadorCategoria, j.Fecha, TiposdeIncidencia.FaltaPorExcederPases, 1, "01:00:00", "1",true, qna, año);
                    //}
                }
            }
            //}
        }
        public void CierreMes(short idEstructuraOrganica, string fecha,string qna,string año)
        {
            DateTime fechaqna = DateTime.Parse(fecha);
            DateTime fechaInicioMes = DateTime.Parse(fecha);
            DateTime fecha1aqna = DateTime.Parse(fecha);

            string IdEmpleados = "";
            var diasmes = DateTime.DaysInMonth(fechaqna.Year, fechaqna.Month);

            DateTime fechaqnaFinal = new DateTime(fechaqna.Year, fechaqna.Month, 15);

            DateTime FinalMes = new DateTime(fechaqna.Year, fechaqna.Month, diasmes);

            bool Es2aQna=false;
            if (fechaqna.Day > 15)
            {
                
                Es2aQna = true;
                fechaqna = new DateTime(fechaqna.Year, fechaqna.Month, 16);
                fechaqnaFinal = new DateTime(fechaqna.Year, fechaqna.Month, diasmes);


            }
            else
            {
                fechaqna = new DateTime(fechaqna.Year, fechaqna.Month, 1);

            }


            fechaInicioMes = new DateTime(fechaqna.Year, fechaqna.Month, 1);
            fecha1aqna = new DateTime(fechaqna.Year, fechaqna.Month, 15);
           

            bdNovaEntities basedb = new bdNovaEntities();

            //var areas = basedb.Nomina_RelojChecadorAreasEstructuraOrganica.Where(s => s.Nomina_RelojChecadorAreas.IdEstructuraOrganica == idEstructuraOrganicaReloj).Select(s => s.IdEstructuraOrganica).ToArray();

            List<vwDatosAspirantesTrabajadores> empleados = basedb.vwDatosAspirantesTrabajadores.Where(s => s.RestringirMenu==null && s.IdEstructuraOrganicaFisica == idEstructuraOrganica).ToList();
            var listaemple = empleados.Select(d => d.IdConvenioLaboralTrabajadorCategoria).ToArray();

            var empleadosConRetardosQnaactual = basedb.IncidenciaPermiso_stIncidenciaTrabajador.Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
            c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && c.IdIncidenciaJustificacion==0 && c.Autorizo==false &&
            DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaqna) &&
            DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fechaqnaFinal)
            ).Select(w => w.IdConvenioLaboralTrabajadorCategoria).ToList();

          //  List<IncidenciaPermiso_stIncidenciaTrabajador> empleadosConRetardos1aqna = new List<IncidenciaPermiso_stIncidenciaTrabajador>();   
            if (Es2aQna == true)
            {
                var  empleadosConRetardos1aqna = basedb.IncidenciaPermiso_stIncidenciaTrabajador.Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
                c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
                DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaInicioMes) &&
                DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fecha1aqna)
                ).Select(w => w.IdConvenioLaboralTrabajadorCategoria).ToList();

                empleadosConRetardosQnaactual.AddRange(empleadosConRetardos1aqna);
            }

            var empleadosConRetardos = empleadosConRetardosQnaactual.ToArray();

            var universo = empleados.Where(s => empleadosConRetardos.Contains((int)s.IdConvenioLaboralTrabajadorCategoria)).ToList();

            var incidencias = basedb.IncidenciaPermiso_stIncidenciaTrabajador.Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
             //c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && 
             DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaqna) &&
             DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fechaqnaFinal)
             ).OrderBy(v => new { v.IdConvenioLaboralTrabajadorCategoria, v.FechaInicio }).ToList();

            List<IncidenciaPermiso_stIncidenciaTrabajador> retardos1aqna = new List<IncidenciaPermiso_stIncidenciaTrabajador>();
            if (Es2aQna)
            {



             retardos1aqna = basedb.IncidenciaPermiso_stIncidenciaTrabajador.Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
             c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") &&
             DbFunctions.TruncateTime(c.FechaInicio) >= DbFunctions.TruncateTime(fechaInicioMes) &&
             DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fecha1aqna)
             ).OrderBy(v => new { v.IdConvenioLaboralTrabajadorCategoria, v.FechaInicio }).ToList();
            }

            var retardosCONFALTAS = incidencias.Where(c => listaemple.Contains(c.IdConvenioLaboralTrabajadorCategoria) &&
    c.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && c.IdIncidenciaJustificacion == 0 && c.Autorizo == false &&
   c.FechaInicio.Date >= fechaqna.Date &&
    c.FechaInicio.Date <= fechaqnaFinal.Date
   ).OrderBy(v => v.FechaInicio).ToList();

            foreach (var ele in universo)
            {
                bool evaluar = true;
                int MaximoNumeroRetardos = 2;

                var retardos = incidencias.Where(c => c.IdConvenioLaboralTrabajadorCategoria == ele.IdConvenioLaboralTrabajadorCategoria &&
        c.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && c.IdIncidenciaJustificacion==0 && c.Autorizo==false &&
       c.FechaInicio.Date >= fechaqna.Date &&
        c.FechaInicio.Date <= fechaqnaFinal.Date
       ).OrderBy(v => v.FechaInicio).ToList();

                List<IncidenciaPermiso_stIncidenciaTrabajador> retardosanteriores = new List<IncidenciaPermiso_stIncidenciaTrabajador>();


                int totalretardos = 0;

                evaluar = true;
                MaximoNumeroRetardos = 2;

                if (ele.ConvenioLaboral == "BASE" && ele.RelacionLaboral == "ADMINISTRATIVO")
                {
                    //if (Es2aQna == false)
                    //{
                    //    evaluar = false;
                    //}
                    //else
                    //{
                        MaximoNumeroRetardos = 5;
                        retardosanteriores = retardos1aqna.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ele.IdConvenioLaboralTrabajadorCategoria).ToList();

                        retardos.AddRange(retardosanteriores);
                    //}

                }
               



                List<RetardosOTiempoFuera> listaretardos = new List<RetardosOTiempoFuera>();

                if (retardos.Count > MaximoNumeroRetardos && evaluar)
                {
                    foreach (var item in retardos.OrderBy(w=> w.FechaInicio))
                    {
                        var tienefalta = retardosCONFALTAS.Where(a => a.FechaInicio == item.FechaInicio
                        && item.IdConvenioLaboralTrabajadorCategoria == a.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                        if (item.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO POR") && tienefalta==null)
                        {
                            var nohayomisionoFalta = retardos.Where(q => q.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                            && (q.IdIncidenciaJustificacion > 0 && q.Autorizo) && q.FechaInicio == item.FechaInicio && (q.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") || q.Catalogos_ctTipoIncidencia.Incidencia.Contains("OMISI"))).ToList();

                            var yaestaenlabase = incidencias.Where(q => q.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                             && (q.IdIncidenciaJustificacion == 0 && q.EsCerrada == true) && q.FechaInicio == item.FechaInicio && q.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA POR RETARDOS")).ToList();

                            if (nohayomisionoFalta.Count == 0 && yaestaenlabase.Count == 0)
                            {
                                totalretardos = totalretardos + 1;


                            }
                            if (totalretardos > MaximoNumeroRetardos)
                            {
                                RetardosOTiempoFuera rt = new RetardosOTiempoFuera();
                                rt.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                rt.Fecha = item.FechaInicio;
                                listaretardos.Add(rt);
                            }
                        }
                    }


                }

                int totalretardosfor = listaretardos.Count();
                int totalretardosforaplicados = 0;
                if (Es2aQna && listaretardos.Count() > MaximoNumeroRetardos)
                {
                    totalretardosfor = listaretardos.Count() - MaximoNumeroRetardos;
                }
                foreach (var l in listaretardos)
                {
                    if (totalretardosforaplicados < totalretardosfor)
                    {
                        if (ele.RelacionLaboral.Contains("DOCENTE"))
                            GuardaIncidencia((int)l.IdConvenioLaboralTrabajadorCategoria, l.Fecha, TiposdeIncidencia.FaltaPorRetardo,"FaltaCM_PorRetardoDocente", 1, null, "1", true, qna, año);
                        else
                            GuardaIncidencia((int)l.IdConvenioLaboralTrabajadorCategoria, l.Fecha, TiposdeIncidencia.FaltaPorRetardo, "FaltaCM_PorRetardoAdmivo", 8, null, "1", true, qna, año);
                    }
                    totalretardosforaplicados++;
                }
            }




           // if (fechaqna.Day > 15)
            //{

                foreach (var ele in empleados)
                {
                    IdEmpleados = IdEmpleados + ele.IdConvenioLaboralTrabajadorCategoria + ",";
                }

                IdEmpleados = IdEmpleados.Substring(0, IdEmpleados.Length - 1);

                //excedieron de horas por pases de salida
//                string query = @"SELECT 
//a.IdConvenioLaboralTrabajadorCategoria,max(a.FechaInicio) as Fecha
//,CONVERT(TIME, DATEADD(s, SUM(( DATEPART(hh, TiempoFuera) * 3600 ) + ( DATEPART(mi, TiempoFuera) * 60 ) + DATEPART(ss, TiempoFuera)), 0)) AS TiempoFuera
//,RelacionLaboral
//FROM   IncidenciaPermiso_stIncidenciaTrabajador a
//inner join  Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
//inner join vwDatosAspirantesTrabajadores c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
//inner join Incidencia_ctJustificacion d on d.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
//where b.Incidencia in ('OMISIÓN DE SALIDA', 'PASE DE SALIDA') and a.fechaInicio>='" + fechaqna.Date.ToString("yyyyMMdd") + @"' 
//and a.fechaInicio<='" + FinalMes.Date.ToString("yyyyMMdd") + @"'  and a.IdConvenioLaboralTrabajadorCategoria in (" + IdEmpleados + @")
//and (a.Autorizo = 1 and a.IdIncidenciaJustificacion>0)
//and IncidenciaJustificacion not in ('SUSPENSIÓN DE LABORES','DÍA DE LA MADRE' )
//group by a.IdConvenioLaboralTrabajadorCategoria,RelacionLaboral";


                string query = @"SELECT 
a.IdConvenioLaboralTrabajadorCategoria,a.FechaInicio as Fecha
,a.Horas
,RelacionLaboral
FROM   IncidenciaPermiso_stIncidenciaTrabajador a
inner join  Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
inner join vwDatosAspirantesTrabajadores c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Incidencia_ctJustificacion d on d.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
where (b.Incidencia in ('HORAS POR PASE DE SALIDA') or d.IncidenciaJustificacion in ('PASE DE SALIDA'))
and cast(a.fechaInicio as date)>='" + fechaqna.Date.ToString("yyyyMMdd") + @"' 
and cast(a.fechaInicio as date)<='" + fechaqnaFinal.Date.ToString("yyyyMMdd") + @"'  and a.IdConvenioLaboralTrabajadorCategoria in (" + IdEmpleados + @")
and (a.Autorizo = 1 )
   and a.Horas>3";


                DapperQuery dp = new DapperQuery("bdNovaEntities");



                List<RetardosOTiempoFuera> excesos = (List<RetardosOTiempoFuera>)dp.connection.Query<RetardosOTiempoFuera>(query);

                dp.Close();

                foreach (var j in excesos)
                {


                    if (j.Horas > 3 )
                    {
                    int totalIncidencias = j.Horas - 3;
                    //if (!j.RelacionLaboral.Contains("DOCENTE"))
                            GuardaIncidencia((int)j.IdConvenioLaboralTrabajadorCategoria, j.Fecha, TiposdeIncidencia.FaltaPorExcederPases,"CM_ExcedioPases", totalIncidencias, $"0{totalIncidencias}:00:00", "1", true,qna,año);

                      

                        //for (int i = 1; i < totalIncidencias; i++)
                        //{
                        //    GuardaIncidencia((int)j.IdConvenioLaboralTrabajadorCategoria, j.Fecha, TiposdeIncidencia.FaltaPorExcederPases, 1, "01:00:00", "1",true, qna, año);
                        //}
                    }
                }
            //}
        }

        private void settrabajadoresSegunreloj(short idEstructuraOrganicaReloj)
        {
            var areadelreloj = Nomina_RelojChecadorAreasEstructuraOrganica.Where(q => q.Nomina_RelojChecadorAreas.IdEstructuraOrganica == idEstructuraOrganicaReloj).Select(q => q.IdEstructuraOrganica).ToArray();

            trabajadoressegunAreasdelReloj = vwDatosAspirantesTrabajadores.Where(a =>  a.IdEstructuraOrganicaFisica!=null && areadelreloj.Contains((short)a.IdEstructuraOrganicaFisica)).ToList();

        }
        public bool ProcesarIncidencias(short idEstructuraOrganicaReloj)
        {
            settrabajadoresSegunreloj(idEstructuraOrganicaReloj);

            var hayerror = false;

            
                    var relojVinculadoaOtro = Nomina_RelojChecadorAreas.Where(s => s.IdEstructuraOrganica == idEstructuraOrganicaReloj).FirstOrDefault();
            List<Nomina_RelojChecadorAreas> relojesInvolucrados = new List<Nomina_RelojChecadorAreas>();
            if (relojVinculadoaOtro.IdRelojAreasGrupo != null)
            {
                relojesInvolucrados = Nomina_RelojChecadorAreas.Where(a => a.IdRelojAreasGrupo == relojVinculadoaOtro.IdRelojAreasGrupo ).ToList();
            }

            var ultimodiaprocesadoBD = bd.Nomina_RelojChecadorControl.Where(r => r.IdEstructuraOrganica == idEstructuraOrganicaReloj
   //&& r.ProcesoIncidenciasCompletado == true
   && r.ProcesoDeFaltasCompletado == true

   ).OrderByDescending(w => w.FechaRegistro).FirstOrDefault();

            DateTime ultimoproceso = DateTime.Parse("2024-02-01");
            if (ultimodiaprocesadoBD != null)
            {
                ultimoproceso = ultimodiaprocesadoBD.FechaRegistro;
            }

            var diasaprocesar = bd.Nomina_RelojChecadorControl.Where(r => r.IdEstructuraOrganica == idEstructuraOrganicaReloj
            && r.ProcesoIncidenciasCompletado == false && r.FechaRegistro > DbFunctions.TruncateTime(ultimoproceso)
            && DbFunctions.TruncateTime(r.FechaRegistro) < DbFunctions.TruncateTime(DateTime.Now)
            ).OrderBy(w => w.FechaRegistro).Select(w => new { FechaRegistro = w.FechaRegistro }).ToList();



            DateTime ultimodiaAprocesar = new DateTime();
            DateTime IniciodiaAprocesar = new DateTime();
            if (diasaprocesar.Count > 0)
            {
                ultimodiaAprocesar = diasaprocesar.LastOrDefault().FechaRegistro;

                if (ultimodiaprocesadoBD != null)
                    IniciodiaAprocesar = ultimodiaprocesadoBD.FechaRegistro.AddDays(1);
                else
                {
                    IniciodiaAprocesar = diasaprocesar.FirstOrDefault().FechaRegistro; ;
                }

                var diastotales = new List<DateTime>();

                for (var dt = IniciodiaAprocesar; dt <= ultimodiaAprocesar; dt = dt.AddDays(1))
                {
                    diastotales.Add(dt);
                }


              //  var diastotales = Enumerable.Range(0, 1 + ultimodiaAprocesar.Subtract(IniciodiaAprocesar).Days)
              //.Select(offset => IniciodiaAprocesar.AddDays(offset))
              //.ToArray();


                foreach (var dt in diastotales)
                {
                    if (diasaprocesar.Where(s => s.FechaRegistro.Date == dt.Date).FirstOrDefault() == null)
                        diasaprocesar.Add(new { FechaRegistro = dt });
                }
            }

            Nomina_RelojChecadorAreasEstructuraOrganicaTolerancia = bd.Nomina_RelojChecadorAreasEstructuraOrganicaTolerancia.ToList();

            diasaprocesar = diasaprocesar.OrderBy(s => s.FechaRegistro).ToList();
            int diast = diasaprocesar.Count();
            int ndia = 0;
            foreach (var ele in diasaprocesar)
            {
                ndia++;
                log.Info($"Dias a procesar {ele.FechaRegistro.ToString("yyyy-MM-dd")} {ndia} de {diast}");
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    bdNovaEntities basedb = new bdNovaEntities();

                    if (relojVinculadoaOtro.IdRelojAreasGrupo != null)
                    {
                        var datosrelojes = relojesInvolucrados.Select(s => s.IdEstructuraOrganica).ToArray();
                        Nomina_RelojChecadorAsistencia = basedb.Nomina_RelojChecadorAsistencia.Where(c => datosrelojes.Contains(c.IdEstructuraOrganica )
                    && c.EsProcesada == false
                 && c.FechaAsistencia.Year == ele.FechaRegistro.Year && c.FechaAsistencia.Month == ele.FechaRegistro.Month && c.FechaAsistencia.Day == ele.FechaRegistro.Day).ToList();

                    }
                    else
                    {
                        var trabajdoresvig = trabajadoressegunAreasdelReloj.Select(e => e.IdTrabajador).ToArray();

                        Nomina_RelojChecadorAsistencia = basedb.Nomina_RelojChecadorAsistencia.Where(c => c.IdEstructuraOrganica == idEstructuraOrganicaReloj
                     && c.EsProcesada == false
                  && c.FechaAsistencia.Year == ele.FechaRegistro.Year && c.FechaAsistencia.Month == ele.FechaRegistro.Month && c.FechaAsistencia.Day == ele.FechaRegistro.Day &&
                  trabajdoresvig.Contains(c.IdTrabajador)
                   ).ToList();
                    }
                    var fechaproceso = ele.FechaRegistro;

                    var asistenciastrabajadores = Nomina_RelojChecadorAsistencia.GroupBy(d => d.IdTrabajador).Select(r => new { IdTrabajador = r.Key }).ToList();

                    //verifica que existan asistencias de todos los demas reljoes vinculados al grupo pñara este dia si no no lo procesa

                    bool PuedeProcesar = true;
                    int existentodos = 0;
                    if (relojVinculadoaOtro.IdRelojAreasGrupo != null)
                    {
                        
                        foreach (var item in relojesInvolucrados)
                        {
                            var ValidaNomina_RelojChecadorAsistencia = basedb.Nomina_RelojChecadorAsistencia.Where(c => c.IdEstructuraOrganica == item.IdEstructuraOrganica
                    && c.EsProcesada == false
                 && c.FechaAsistencia.Year == ele.FechaRegistro.Year && c.FechaAsistencia.Month == ele.FechaRegistro.Month && c.FechaAsistencia.Day == ele.FechaRegistro.Day).ToList();

                            

                            var Validaasistenciastrabajadores = ValidaNomina_RelojChecadorAsistencia.GroupBy(d => d.IdTrabajador).Select(r => new { IdTrabajador = r.Key }).ToList();
                            if (ValidaNomina_RelojChecadorAsistencia.Count > 0)
                                existentodos++;
                            else
                                log.Info($"Reloj {relojVinculadoaOtro.EstructuraOrganica} vinculado a otros relojes:  {item.EstructuraOrganica} no hay datos para {ele.FechaRegistro}");

                        }

                        if (existentodos != relojesInvolucrados.Count())
                            PuedeProcesar = false;

                    }

                    if (PuedeProcesar)
                    {

                        TransactionOptions transactionoptions2 = new TransactionOptions();
                        transactionoptions2.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                        using (TransactionScope scope2 = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
                        {
                            NominaTrabajador.setHorariosDocentes(fechaproceso.ToString("yyyyMMdd"),false,false,true);
                        }

                        if (asistenciastrabajadores.Count == 0)
                        {
                            GenerarFaltasPersonalSinAsistencias(fechaproceso, idEstructuraOrganicaReloj, true);

                        }
                        else
                        {
                            var listtrabproce = asistenciastrabajadores.Where(s => s.IdTrabajador != null).ToList();
                            int nasist = listtrabproce.Count();
                            int nemple = 0;
                            foreach (var item in listtrabproce)
                            {
                                nemple++;
                                log.Info($"creando incidencias para el trabajador {item.IdTrabajador} para el reloj {idEstructuraOrganicaReloj} ({nemple} de {nasist})");
                                hayerror = CrearIncidencia((int)item.IdTrabajador, fechaproceso, idEstructuraOrganicaReloj);

                                CreaFaltasPorRetardosYPases(fechaproceso, (int)item.IdTrabajador);

                                basedb.Configuration.AutoDetectChangesEnabled = false;
                                basedb.Configuration.ValidateOnSaveEnabled = false;


                                var asistenciasdeltrabajador = Nomina_RelojChecadorAsistencia.Where(c => c.IdTrabajador == item.IdTrabajador
                        && c.FechaAsistencia.Year == ele.FechaRegistro.Year && c.FechaAsistencia.Month == ele.FechaRegistro.Month && c.FechaAsistencia.Day == ele.FechaRegistro.Day).ToList();

                                foreach (var dat in asistenciasdeltrabajador)
                                {
                                   
                                    dat.EsProcesada = true;
                                    basedb.Nomina_RelojChecadorAsistencia.Add(dat);
                                    basedb.Entry(dat).State = EntityState.Modified;

                                }

                                basedb.SaveChanges();
                            }

                            

                            var controlasistenciasdeltrabajador = basedb.Nomina_RelojChecadorAsistencia.Where(c => c.IdEstructuraOrganica == idEstructuraOrganicaReloj
                            && c.EsProcesada == false
                   && c.FechaAsistencia.Year == ele.FechaRegistro.Year && c.FechaAsistencia.Month == ele.FechaRegistro.Month && c.FechaAsistencia.Day == ele.FechaRegistro.Day).ToList();

                            if (controlasistenciasdeltrabajador.Count == 0)
                            {
                                var control = basedb.Nomina_RelojChecadorControl.Where(v => v.IdEstructuraOrganica == idEstructuraOrganicaReloj && DbFunctions.TruncateTime(v.FechaRegistro) == fechaproceso.Date).FirstOrDefault();
                                if (control != null)
                                {
                                    control.ProcesoIncidenciasCompletado = true;



                                    basedb.Nomina_RelojChecadorControl.Attach(control);
                                    basedb.Entry(control).State = EntityState.Modified;
                                    log.Info($"SE ACTUALIZO LA TABLA DE CONTROL para EL RELOJ {idEstructuraOrganicaReloj} CON FECHA :{ele.FechaRegistro.ToString("yyyy-MM-dd")}");


                                }
                            }

                            //var control = basedb.Nomina_RelojChecadorControl.Where(v => v.IdEstructuraOrganica == idEstructuraOrganicaReloj && DbFunctions.TruncateTime(v.FechaRegistro) == fechaproceso.Date).FirstOrDefault();

                            //if (control != null)
                            //{
                            //    control.ProcesoIncidenciasCompletado = true;

                            //    basedb.Configuration.AutoDetectChangesEnabled = false;
                            //    basedb.Configuration.ValidateOnSaveEnabled = false;


                            //    basedb.Nomina_RelojChecadorControl.Attach(control);
                            //    basedb.Entry(control).State = EntityState.Modified;
                            //}

                            try
                            {
                                basedb.SaveChanges();
                            }
                            catch (Exception er)
                            {

                                var d = er.Message;
                            }
                        }

                        scope.Complete();

                    }
                    else
                        log.Info($"NO SE PROCESO Reloj grupal  {relojVinculadoaOtro.EstructuraOrganica} no hay datos para {ele.FechaRegistro}");

                }

            }



            return hayerror;






        }

        private HorarioTipoHoras HorasDocentes(vwDatosAspirantesTrabajadoresHistorial trabajador, DateTime fecha)
        {
            int totaleshoras = 0;
            int totaleshorasClub= 0;
            HorarioTipoHoras regresa = new HorarioTipoHoras();




            //List<NominaHorariosDocentesDetalle> CargaDocente = NominaTrabajador.NominaHorariosDocentesDetalle.Where(x => x.IdKardex == trabajador.IdKardex && x.Vigente == 1).ToList();

            List<NominaHorariosDocentesDetalle> CargaDocente = new List<NominaHorariosDocentesDetalle>();
            var resul= NominaTrabajador.getHorarioActualDocente(trabajador.IdKardex,0, fecha.ToString("yyyy-MM-dd"));

           // bool existeenHorario = true;

            //if (CargaDocente.Count == 0)
            //{
            //    NominaTrabajador.getHorarioDocenteAnterior(trabajador.IdKardex);
            //    if (NominaTrabajador.NominaHorariosDocentesDetalleAnterior.Count == 0)
            //    {
            //        existeenHorario = false;

            //    }
            //    else
            //        CargaDocente = NominaTrabajador.NominaHorariosDocentesDetalleAnterior;
            //}

            if (resul.TieneHorario == false)
            {
                Nomina_DocentesHorasPago horario = NominaTrabajador.ListaNomina_DocentesHorasPago.Where(c => c.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                if (horario != null)
                {
                    totaleshoras = (short)horario.TotalHorasPago;
                    totaleshoras = totaleshoras / 5;
                }
            }
            else
            {
                foreach (var item in resul.NominaHorariosDocentesDetalle)
                {
                    totaleshoras = totaleshoras + (int)item.Horas;
                    if (item.TipoHoras == "HORAS CLUB")
                        totaleshorasClub = totaleshorasClub + (int)item.Horas;

                }

                //if (trabajador.EsHomologado == false)
                //    //Lunes
                //    if ((int)fecha.DayOfWeek == 1)


                //        switch ((int)fecha.DayOfWeek)
                //        {
                //            case 1:
                //                totaleshoras = (int)CargaDocente.LunesGrupales + (int)CargaDocente.LunesNoGrupales;
                //                break;
                //            case 2:
                //                totaleshoras = (int)CargaDocente.MartesGrupales + (int)CargaDocente.MartesNoGrupales;
                //                break;
                //            case 3:
                //                totaleshoras = (int)CargaDocente.MiercolesGrupales + (int)CargaDocente.MiercolesNoGrupales;
                //                break;
                //            case 4:
                //                totaleshoras = (int)CargaDocente.JuevesGrupales + (int)CargaDocente.JuevesNoGrupales;
                //                break;
                //            case 5:
                //                totaleshoras = (int)CargaDocente.ViernesGrupales + (int)CargaDocente.ViernesNoGrupales;
                //                break;
                //        }
                //    //totaleshoras = (int)(CargaDocente.LunesGrupales + CargaDocente.MartesGrupales + CargaDocente.MiercolesGrupales + CargaDocente.JuevesGrupales + CargaDocente.ViernesGrupales + CargaDocente.SabadoGrupales + CargaDocente.DomingoGrupales + CargaDocente.LunesNoGrupales + CargaDocente.MartesNoGrupales + CargaDocente.MiercolesNoGrupales + CargaDocente.JuevesNoGrupales + CargaDocente.ViernesNoGrupales + CargaDocente.SabadoNoGrupales + CargaDocente.DomingoNoGrupales);
                //    else
                //    {
                //        int thi = 0;
                //        int thng = 0;

                //        switch ((int)fecha.DayOfWeek)
                //        {
                //            case 1:
                //                totaleshoras = (int)CargaDocente.LunesGrupales;
                //                thi = (int)CargaDocente.LunesHorasInterinas;
                //                thng = (int)CargaDocente.LunesNoGrupales;
                //                thi = thi + thng;
                //                totaleshoras = totaleshoras - thi;
                //                break;
                //            case 2:
                //                totaleshoras = (int)CargaDocente.MartesGrupales;
                //                thi = (int)CargaDocente.MartesHorasInterinas;
                //                thng = (int)CargaDocente.MartesNoGrupales;
                //                thi = thi + thng;
                //                totaleshoras = totaleshoras - thi;
                //                break;
                //            case 3:

                //                totaleshoras = (int)CargaDocente.MiercolesGrupales;
                //                thi = (int)CargaDocente.MiercolesHorasInterinas;
                //                thng = (int)CargaDocente.MiercolesNoGrupales;
                //                thi = thi + thng;
                //                totaleshoras = totaleshoras - thi;
                //                break;
                //            case 4:
                //                totaleshoras = (int)CargaDocente.JuevesGrupales;
                //                thi = (int)CargaDocente.JuevesHorasInterinas;
                //                thng = (int)CargaDocente.JuevesNoGrupales;
                //                thi = thi + thng;
                //                totaleshoras = totaleshoras - thi;
                //                break;
                //            case 5:
                //                totaleshoras = (int)CargaDocente.ViernesGrupales;
                //                thi = (int)CargaDocente.ViernesHorasInterinas;
                //                thng = (int)CargaDocente.ViernesNoGrupales;
                //                thi = thi + thng;
                //                totaleshoras = totaleshoras - thi;
                //                break;
                //        }



                //    }




            }
            regresa.TotalHoras = totaleshoras;
            regresa.TotalHorasClub = totaleshorasClub;
            return regresa;
        }

        //private bool CrearIncidenciaTesting (int idt, DateTime Fecha, short IdEstructuraOrganicaReloj)
        //{
        //    Boolean tieneFaltaTrabajador = false;
        //    Boolean tieneRetardoTrabajador = false;


        //    var trabajador = vwDatosAspirantesTrabajadores.Where(x => x.IdTrabajador == idt).FirstOrDefault();

             



        //        var horariosPorconvenio = Convenios_stRelacionConvenioLaboral.Where(z => z.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral).FirstOrDefault();

        //        var RelojChecadorLibre = Nomina_RelojChecadorLibre.Where(c => c.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

        //        //permisos
        //        var permisos = bd.IncidenciaPermiso_stIncidenciaTrabajador.Where(c => (c.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "PERMISO"
        //        || c.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "PERMISO CON GOCE DE SUELDO")
        //        && c.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt
        //        && DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(Fecha) && DbFunctions.TruncateTime(c.FechaTermino) >= DbFunctions.TruncateTime(Fecha)).ToList();

        //        //si hay permisos entonces no crea ninguna falta


        //        //para los apoyos de becas con goce de sueldo tampoco crea incidencias

        //        var ListaNominaApoyoEstudios = bd.Nomina_ApoyoEstudios.Where(p =>

        //        (p.IdTrabajador == idt && DbFunctions.TruncateTime(p.FechaInicio) <= DbFunctions.TruncateTime(Fecha) && p.FechaTermino == null) || (p.IdTrabajador == idt && DbFunctions.TruncateTime(p.FechaInicio) <= DbFunctions.TruncateTime(Fecha) && DbFunctions.TruncateTime(p.FechaTermino) >= DbFunctions.TruncateTime(Fecha))).ToList();


        //        Int32 totaleshoras = 0;

        //        var EsExima = false;

        //        if (RelojChecadorLibre != null)
        //        {
        //            if (RelojChecadorLibre.EsExima)
        //                EsExima = true;
        //        }

        //        var categoriapermiso = trabajador.Categoria == "RESPONSABLE DEL CENTRO \"A\"" || trabajador.Categoria == "COORDINADOR ACADÉMICO" ||
        //            trabajador.Categoria == "RESPONSABLE DEL CENTRO \"B\"" || trabajador.Categoria == "RESPONSABLE DEL CENTRO \"C\"" ||
        //            trabajador.Categoria == "DIRECTOR DE PLANTEL \"A\"" || trabajador.Categoria == "DIRECTOR DE PLANTEL \"B\"" ||
        //            trabajador.Categoria == "DIRECTOR DE PLANTEL \"C\"" || trabajador.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"C\""
        //            || trabajador.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"B\"" || trabajador.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"A\""
        //            || trabajador.Categoria == "SUBDIRECTOR DE PLANTEL \"B\"" || trabajador.Categoria == "SUBDIRECTOR DE PLANTEL \"C\"" || trabajador.Categoria == "SUBDIRECTOR DE PLANTEL \"A\"";

        //        var validar = true;
        //        if (categoriapermiso && trabajador.IdModalidadEstudio > 0)
        //        {
        //            validar = false;
        //        }


        //        if (permisos.Count == 0 && validar && EsExima == false && ListaNominaApoyoEstudios.Count == 0)
        //        {


        //            var dia = (int)Fecha.DayOfWeek;
        //            var horariosPorconvenioDias = Nomina_HorariosConvenioConfiguracion.Where(z =>
        //            z.Dia == dia &&
        //            z.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral).ToList();

        //            Nomina_HorariosConvenioConfiguracion retardoMinimo = new Nomina_HorariosConvenioConfiguracion();

        //            //busca el minimo de retardo y tolernacia para aplciarlo en caso de que tengan un horario en sabado o domingo
        //            if (dia == 0 || dia == 6)
        //            {
        //                retardoMinimo = Nomina_HorariosConvenioConfiguracion.Where(z =>
        //              z.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral).OrderBy(s => s.ToleranciaEntrada).FirstOrDefault();


        //            }

        //            var horarioespecial = this.Nomina_HorariosEspeciales.Where(c =>

        //                    c.Dia == dia && c.IdTrabajador == idt && c.FechaInicio.Value.Date <= Fecha.Date && (Fecha != null || Fecha.Date >= DateTime.Now.Date))
        //                    .OrderBy(v => v.Entrada)
        //                    .ToList();




        //            var fechasolaTempo = Fecha.Date;
        //            bdNovaEntities basedatos = new bdNovaEntities();
        //            //dias Suspension
        //            var diassuspension = Nomina_CalendarioEventos.Where(x => x.Nomina_CalendarioTipoEvento.CalendarioTipoEvento == "SUSPENSIÓN DE ACTIVIDADES"
        //            && x.FechaInicio == fechasolaTempo && x.FechaTermino == fechasolaTempo
        //            && x.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
        //            ).ToList();


        //            Boolean PrimaDominicalDiasDescanso = false;
        //            Boolean PrimaDominical = false;
        //            Boolean DiasDescanso = false;

        //            var horariodesabadosdomingos = horarioespecial.Where(s => s.Dia == dia).FirstOrDefault();

        //            if (horariosPorconvenio.Catalogos_ctConvenioLaboral.ConvenioLaboral.Contains("BASE"))
        //            {

        //                if (diassuspension.Count > 0)
        //                {
        //                    PrimaDominicalDiasDescanso = true;
        //                    DiasDescanso = true;
        //                }
        //                else
        //                if (dia == 0 || dia == 6 && horariodesabadosdomingos == null)
        //                {
        //                    bool tienehorariodocente = false;
        //                    if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE"))
        //                    {
        //                        var horariodocente = NominaTrabajador.getHorarioActualDocente(trabajador.IdKardex, dia, Fecha.ToString("yyyy-MM-dd"));
        //                        tienehorariodocente = horariodocente.TieneHorario;

        //                    }

        //                    if (tienehorariodocente == false)
        //                    {
        //                        PrimaDominicalDiasDescanso = true;
        //                        PrimaDominical = true;
        //                    }
        //                }

        //            }


        //            var tienefaltaenbd = bd.IncidenciaPermiso_stIncidenciaTrabajador.Where(y =>
        //    (y.IdTipoIncidencia == idFalta || y.IdTipoIncidencia == idFaltaRetardo
        //    || y.IdTipoIncidencia == idOmisionSalida) &&
        //        y.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt &&
        //        DbFunctions.TruncateTime(y.FechaInicio) == DbFunctions.TruncateTime(Fecha)).FirstOrDefault();


        //            if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE") && PrimaDominical == false)
        //            {
                    
        //                  totaleshoras = HorasDocentes(trabajador, Fecha);

        //                var model = Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == idt).OrderBy(x => x.FechaAsistencia).ToList();
        //                if (model != null)
        //                {
        //                    //var horariodocentepordia = NominaTrabajador.ListastHorariosDetalleNomina.Where(d => d.IdDia == dia && d.IdNova == trabajador.IdKardex).OrderBy(x => x.HoraInicio).ToList();
        //                    // var horariodocentepordia = NominaTrabajador.NominaHorariosDocentesDetalle.Where(d => d.IdDia == dia && d.IdKardex == trabajador.IdKardex).OrderBy(x => x.HoraInicio).ToList();
        //                    var resul = NominaTrabajador.getHorarioActualDocente(trabajador.IdKardex, dia, Fecha.ToString("yyyy-MM-dd"));


        //                    if (resul.NominaHorariosDocentesDetalle.Count > 0)
        //                    {
        //                        if (horariosPorconvenioDias.Count == 0)
        //                        {

        //                            Nomina_HorariosConvenioConfiguracion horariotemporal = new Nomina_HorariosConvenioConfiguracion();

        //                            horariotemporal.ToleranciaEntrada = retardoMinimo.ToleranciaEntrada;
        //                            horariotemporal.ToleranciaRetardo = retardoMinimo.ToleranciaRetardo;


        //                            horariosPorconvenioDias.Clear();
        //                            horariosPorconvenioDias.Add(horariotemporal);
        //                        }

        //                        var entrada = resul.NominaHorariosDocentesDetalle.FirstOrDefault();
        //                        TimeSpan timeentrada = TimeSpan.Parse(entrada.HoraInicio);
        //                        horariosPorconvenioDias[0].Entrada = timeentrada;
        //                        var salida = resul.NominaHorariosDocentesDetalle.LastOrDefault();
        //                        TimeSpan timesalida = TimeSpan.Parse(salida.HoraFinal);
        //                        horariosPorconvenioDias[0].Salida = timesalida;



        //                    }

        //                }

        //            }

        //            if (horariosPorconvenio.AplicaChecarAsistencia && (horariosPorconvenioDias.Count > 0 || DiasDescanso)
        //                && tienefaltaenbd == null || horariodesabadosdomingos != null
        //                )
        //            {
        //                if (tienefaltaenbd != null)
        //                    tieneFaltaTrabajador = true;

        //                GenerarFaltasPersonalSinAsistencias(Fecha, IdEstructuraOrganicaReloj, true);


        //                var model = Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == idt).OrderBy(x => x.FechaAsistencia).ToList();
        //                if (model.Count > 0)
        //                {
        //                    // los que estan libr de checar, si tiene una omision de entrada o de salida
        //                    // esos si se les considera una incidencia
        //                    if (model.Count == 1 && RelojChecadorLibre != null)
        //                    {
        //                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, model[0].FechaAsistencia, TiposdeIncidencia.Falta);
        //                        tieneFaltaTrabajador = true;

        //                    }
        //                    else
        //                    if (RelojChecadorLibre == null)
        //                    {
        //                        var toleranciaEspecial = Nomina_RelojChecadorAreasEstructuraOrganicaTolerancia.Where(c => c.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
        //                         && c.Nomina_RelojChecadorAreas.IdEstructuraOrganica == trabajador.IdEstructuraOrganicaFisica).FirstOrDefault();
        //                        // var IdRetardo = tipoIndicencias.Where(x => x.Incidencia == "RETARDO POR DÍA").FirstOrDefault().IdTipoIncidencia; ;

        //                        if (toleranciaEspecial != null)
        //                        {
        //                            foreach (var item in horariosPorconvenioDias)
        //                            {
        //                                item.ToleranciaEntrada = toleranciaEspecial.Tolerancia;
        //                                item.ToleranciaRetardo = toleranciaEspecial.ToleranciaRetardo;
        //                            }

        //                        }

        //                        var entrada = model.FirstOrDefault();
        //                        try
        //                        {




        //                            //entradas
        //                            if (horarioespecial.Count > 0)
        //                            {
        //                                if (entrada.FechaAsistencia.TimeOfDay > horarioespecial[0].Entrada)
        //                                {
        //                                    //posible falta


        //                                    DateTime entradaConTolerancia = DateTime.Parse(horarioespecial[0].Entrada.ToString()).AddMinutes((double)horarioespecial[0].ToleranciaEntrada + 1);
        //                                    DateTime entradaConRetardo = DateTime.Parse(horarioespecial[0].Entrada.ToString()).AddMinutes((double)horarioespecial[0].ToleranciaEntrada + (double)horarioespecial[0].ToleranciaRetardo + 1);
        //                                    if (entrada.FechaAsistencia.TimeOfDay >= entradaConTolerancia.TimeOfDay)
        //                                    {
        //                                        if (entrada.FechaAsistencia.TimeOfDay >= entradaConRetardo.TimeOfDay)
        //                                        {
        //                                            if (tieneFaltaTrabajador == false)
        //                                            //falta
        //                                            {
        //                                                GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta);
        //                                                tieneFaltaTrabajador = true;
        //                                            }
        //                                        }
        //                                        else
        //                                              //retardo
        //                                              if (tieneFaltaTrabajador == false)
        //                                        {
        //                                            GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Retardo);
        //                                            tieneRetardoTrabajador = true;
        //                                        }


        //                                    }


        //                                }

        //                                if (horarioespecial.Count > 1)
        //                                {
        //                                    var entrada2 = model.Where(b => b.FechaAsistencia.TimeOfDay >= horarioespecial[0].Entrada
        //                                    && b.FechaAsistencia.TimeOfDay >= horarioespecial[1].Entrada).OrderBy(v => v.FechaAsistencia).ToList();

        //                                    var HeEntrada2 = entrada2.FirstOrDefault();
        //                                    DateTime entrada2ConTolerancia = DateTime.Parse(horarioespecial[1].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada);
        //                                    DateTime entrada2ConRetardo = DateTime.Parse(horarioespecial[1].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo);
        //                                    if (HeEntrada2 == null)
        //                                    {
        //                                        if (tieneFaltaTrabajador == false)
        //                                        {
        //                                            GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta);
        //                                            tieneFaltaTrabajador = true;
        //                                        }
        //                                    }
        //                                    else
        //                                    if (HeEntrada2.FechaAsistencia.TimeOfDay >= entrada2ConTolerancia.TimeOfDay)
        //                                    {
        //                                        if (HeEntrada2.FechaAsistencia.TimeOfDay >= entrada2ConRetardo.TimeOfDay)
        //                                        { //falta
        //                                            if (tieneFaltaTrabajador == false)
        //                                            {
        //                                                GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, HeEntrada2.FechaAsistencia, TiposdeIncidencia.Falta);
        //                                                tieneFaltaTrabajador = true;
        //                                            }
        //                                        }
        //                                        else
        //                                            //retardo
        //                                            if (tieneFaltaTrabajador == false)
        //                                        {
        //                                            GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, HeEntrada2.FechaAsistencia, TiposdeIncidencia.Retardo);
        //                                            tieneRetardoTrabajador = true;
        //                                        }

        //                                    }


        //                                }
        //                            }
        //                            else
        //                            {
        //                                //horario Normal
        //                                if (horariosPorconvenio.AplicaCargaHoraria == false && horariosPorconvenioDias[0].Entrada != null)

        //                                {

        //                                    if (entrada.FechaAsistencia.TimeOfDay > horariosPorconvenioDias[0].Entrada)
        //                                    {
        //                                        DateTime entradaConTolerancia = DateTime.Parse(horariosPorconvenioDias[0].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada).AddMinutes(1);
        //                                        DateTime entradaConRetardo = DateTime.Parse(horariosPorconvenioDias[0].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo).AddMinutes(1);
        //                                        if (entrada.FechaAsistencia.TimeOfDay >= entradaConTolerancia.TimeOfDay)
        //                                        {
        //                                            if (entrada.FechaAsistencia.TimeOfDay >= entradaConRetardo.TimeOfDay)
        //                                            {
        //                                                if (tieneFaltaTrabajador == false)
        //                                                {
        //                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta);
        //                                                    tieneFaltaTrabajador = true;
        //                                                }
        //                                            }
        //                                            else
        //                                                if (tieneFaltaTrabajador == false)
        //                                            {
        //                                                GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Retardo);
        //                                                tieneRetardoTrabajador = true;
        //                                            }
        //                                        }
        //                                    }
        //                                }
        //                                else
        //                                if (horariosPorconvenio.AplicaCargaHoraria == true && horariosPorconvenioDias[0].Entrada != null)
        //                                {
        //                                    //docentes incidencias por horas
        //                                    if (entrada.FechaAsistencia.TimeOfDay > horariosPorconvenioDias[0].Entrada)
        //                                    {
        //                                        DateTime entradaConTolerancia = DateTime.Parse(horariosPorconvenioDias[0].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada + 1);
        //                                        DateTime entradaConRetardo = DateTime.Parse(horariosPorconvenioDias[0].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo + 1);
        //                                        if (entrada.FechaAsistencia.TimeOfDay >= entradaConTolerancia.TimeOfDay)
        //                                        {
        //                                            if (entrada.FechaAsistencia.TimeOfDay >= entradaConRetardo.TimeOfDay)
        //                                            {
        //                                                if (tieneFaltaTrabajador == false)
        //                                                {
        //                                                    string startTime = horariosPorconvenioDias[0].Entrada.ToString();
        //                                                    string endTime = entrada.FechaAsistencia.TimeOfDay.ToString();

        //                                                    TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));

        //                                                    int horas = 0;

        //                                                if (duration.Minutes > 0 )
        //                                                {
        //                                                    if (duration.Minutes > (double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo)
        //                                                        horas = 1;
        //                                                    else
        //                                                    if (duration.Minutes > (double)horariosPorconvenioDias[0].ToleranciaEntrada)
        //                                                    {
        //                                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.RetardoPorHora, 1);
        //                                                    }
                                                            
                                                         
        //                                                }
        //                                                    if (duration.Hours > 0)
        //                                                        horas = horas + duration.Hours;

        //                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.FaltaPorHora, horas);
        //                                                    // tieneFaltaTrabajador = true;
        //                                                }
        //                                            }
        //                                            else
        //                                            //    if (tieneFaltaTrabajador == false)
        //                                            {
        //                                                GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.RetardoPorHora, 1);

        //                                                tieneRetardoTrabajador = true;
        //                                            }
        //                                        }
        //                                        //else
        //                                        //{
        //                                        //    string startTime = horariosPorconvenioDias[0].Entrada.ToString();
        //                                        //    string endTime = entrada.FechaAsistencia.TimeOfDay.ToString();

        //                                        //    TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));

        //                                        //    int horas = 0;

        //                                        //    if (duration.Minutes > 0)
        //                                        //        horas = 1;
        //                                        //    if (duration.Hours > 0)
        //                                        //        horas = horas + duration.Hours;

        //                                        //    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.FaltaPorHora, horas);
        //                                        //}
        //                                    }
        //                                }

        //                            }


        //                            ////ahora se buscan retardos acumulados
        //                            //var fechasQuincena = ObtenFechasIncioTerminoQuincenas(Fecha);
        //                            //var fechainicialqna = fechasQuincena[0];
        //                            //var fechafinalqna = fechasQuincena[1];
        //                            //var retardos = bd.IncidenciaPermiso_stIncidenciaTrabajador.Where(s =>
        //                            //(s.IdTipoIncidencia == idRetardo || s.IdTipoIncidencia == idRetardoPorHora)
        //                            //&& s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == idt
        //                            //&& DbFunctions.TruncateTime(s.FechaInicio) >= DbFunctions.TruncateTime(fechainicialqna)
        //                            //&& DbFunctions.TruncateTime(s.FechaInicio) <= DbFunctions.TruncateTime(fechafinalqna)).OrderByDescending(d => d.FechaInicio).ToList();

        //                            //if ((retardos.Count == 3 || retardos.Count == 6 || retardos.Count == 9 || retardos.Count == 12 || retardos.Count == 15))
        //                            //{
        //                            //    var diashorario = Nomina_HorariosConvenioConfiguracion.Where(z =>
        //                            //          z.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral).ToList();

        //                            //    //  var diafaltaporretardo = SiguienteDiaHabil(model[0].FechaAsistencia, diashorario);
        //                            //    var diafaltaporretardo = retardos[0].FechaInicio;
        //                            //    if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE"))
        //                            //        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, diafaltaporretardo, TiposdeIncidencia.FaltaPorRetardo, 1);
        //                            //    else
        //                            //    {
        //                            //        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, diafaltaporretardo, TiposdeIncidencia.FaltaPorRetardo);

        //                            //    }




        //                            //}

        //                            bool tienesalida = true; ;
        //                            //var totalregistros = 2;
        //                            if (horarioespecial.Count > 1)
        //                            //if (horarioespecial != null && horarioespecial[1].Entrada != null)
        //                            {
        //                                var resultado = model.Where(x => x.FechaAsistencia.TimeOfDay >= horarioespecial[1].Salida).FirstOrDefault();
        //                                if (resultado == null)
        //                                    tienesalida = false;
        //                            }
        //                            else
        //                            if (horarioespecial.Count > 0)
        //                            {
        //                                if (trabajador.Categoria == "VIGILANTE")
        //                                {

        //                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta);
        //                                    tieneFaltaTrabajador = true;

        //                                }
        //                                else
        //                                {
        //                                    var resultado = model.Where(x => x.FechaAsistencia.TimeOfDay >= horarioespecial[0].Salida).FirstOrDefault();
        //                                    if (resultado == null)
        //                                    {
        //                                        if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE"))
        //                                        {
        //                                            var ultimoacceso = model.LastOrDefault();
        //                                            string startTime = ultimoacceso.FechaAsistencia.TimeOfDay.ToString();
        //                                            string endTime = horarioespecial[0].Salida.ToString();

        //                                            TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));

        //                                            int horas = 0;

                                                    

        //                                        if (duration.Minutes > 0)
        //                                        {
        //                                            if (duration.Minutes > (double)horariosPorconvenioDias[0].ToleranciaEntrada)
        //                                            {
        //                                                if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE"))
        //                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.RetardoPorHora, 1);
        //                                                else
        //                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Retardo, 1);
        //                                                tieneRetardoTrabajador = true;
        //                                            }
        //                                            else
        //                                            if (duration.Minutes > (double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo)
        //                                                horas = 1;
        //                                        }
        //                                        if (duration.Hours > 0)
        //                                            horas = horas + duration.Hours;

        //                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, ultimoacceso.FechaAsistencia, TiposdeIncidencia.FaltaPorHora, horas);
        //                                            tienesalida = true;
        //                                        }
        //                                        //else
        //                                        //    tienesalida = false;

        //                                    }
        //                                }
        //                            }
        //                            // totalregistros = 4;

        //                            //salidas
        //                            if (tienesalida)
        //                            {
        //                                var salida = model.LastOrDefault();



        //                                //if (tieneFaltaTrabajador == false && tieneRetardoTrabajador == false)
        //                                if (tieneFaltaTrabajador == false)
        //                                {
        //                                    if (horarioespecial.Count > 0)
        //                                    {
        //                                        if (salida.FechaAsistencia.TimeOfDay < horarioespecial[0].Salida)
        //                                        {
        //                                            var ultimoacceso = model.LastOrDefault();
        //                                            string startTime = ultimoacceso.FechaAsistencia.TimeOfDay.ToString();
        //                                            string endTime = horarioespecial[0].Salida.ToString();

        //                                            TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));

        //                                            int horas = 0;

        //                                        if (duration.Minutes > 0)
        //                                            horas = 1;
        //                                        if (duration.Hours > 0)
        //                                            horas = horas + duration.Hours;


        //                                        string totaltiempofuera = duration.ToString(@"hh\:mm\:ss");

        //                                        //GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.OmisionSalida, horas, totaltiempofuera);
        //                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta, horas, totaltiempofuera);
        //                                        tieneFaltaTrabajador = true;
        //                                        }
        //                                    }
        //                                    else
        //                                    if (salida.FechaAsistencia.TimeOfDay < horariosPorconvenioDias[0].Salida)
        //                                    {
        //                                        var ultimoacceso = model.LastOrDefault();
        //                                        string startTime = ultimoacceso.FechaAsistencia.TimeOfDay.ToString();
        //                                        string endTime = horariosPorconvenioDias[0].Salida.ToString();

        //                                        string entradaH = horariosPorconvenioDias[0].Entrada.ToString();

        //                                        TimeSpan duracionPorHoras = DateTime.Parse(endTime).Subtract(DateTime.Parse(entradaH));
                                            
        //                                    TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));

        //                                    bool entradespues = true;
        //                                    if (ultimoacceso.FechaAsistencia.TimeOfDay < horariosPorconvenioDias[0].Entrada)
        //                                    {
        //                                        duration = horariosPorconvenioDias[0].Salida.Subtract(horariosPorconvenioDias[0].Entrada);
        //                                        entradespues = false;
        //                                    }



        //                                    int horas = 0;

        //                                    if (duration.Minutes > 0 && entradespues)
        //                                        horas = 1;
        //                                    if (duration.Hours > 0)
        //                                        horas = horas + duration.Hours;




        //                                    string totaltiempofuera = duration.ToString(@"hh\:mm\:ss");

        //                                        //omision de salida
        //                                        if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE"))
        //                                        {
        //                                        var horariodocente = NominaTrabajador.getHorarioActualDocente(trabajador.IdKardex, dia, Fecha.ToString("yyyy-MM-dd"));
        //                                        int horasefectivas = (int)horariodocente.NominaHorariosDocentesDetalle.Sum(s => s.Horas);
        //                                        int horasreales = duracionPorHoras.Hours - horasefectivas;
        //                                        horas = horas - horasreales;
        //                                        //cambio 21 nov por solicitud de bitzania
        //                                        //if (tieneRetardoTrabajador)
        //                                        //   EditarGuardarIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.FaltaPorHora, tieneFaltaTrabajador, horas);
        //                                        //else
        //                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, ultimoacceso.FechaAsistencia, TiposdeIncidencia.FaltaPorHora, horas);

        //                                        }
        //                                        else
        //                                        {
        //                                            //GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.OmisionSalida, horas, totaltiempofuera);
        //                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta, horas, totaltiempofuera);
        //                                        tieneFaltaTrabajador = true;
        //                                        }

        //                                    }
        //                                }

        //                            }
        //                            else
        //                            {
        //                                EditarGuardarIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta, tieneFaltaTrabajador);
        //                                tieneFaltaTrabajador = true;
        //                            }


        //                        }
        //                        catch (Exception ax)
        //                        {

        //                            throw;
        //                        }

        //                    } // if (RelojChecadorLibre == null)

        //                }//model !=null

        //                //
        //                if (PrimaDominicalDiasDescanso && tieneFaltaTrabajador == false)
        //                {

        //                    if (DiasDescanso)
        //                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, Fecha, TiposdeIncidencia.DiasDescanso);
        //                }
        //                else
        //                if ((tieneFaltaTrabajador || tieneRetardoTrabajador) & DiasDescanso == false)
        //                {
        //                    JustificaFaltasAutomaticamenteTrabajador(Fecha, trabajador);
        //                }
        //            }
        //            else
        //            // -----
        //            {

        //                if (PrimaDominical)
        //                {
        //                    var modelo = Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == idt).OrderBy(x => x.FechaAsistencia).ToList();
        //                    if (modelo != null)
        //                    {
        //                        if (modelo.Count > 1)
        //                        {
        //                            var e1 = modelo.FirstOrDefault().FechaAsistencia;
        //                            var s1 = modelo.LastOrDefault().FechaAsistencia;
        //                            TimeSpan diff = s1 - e1;
        //                            double hjornada = diff.TotalHours;
        //                            if (hjornada > 7)
        //                                GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, Fecha, TiposdeIncidencia.PrimaDominical);

        //                        }



        //                    }
        //                }


        //                var control = bd.Nomina_RelojChecadorControl.Where(d => DbFunctions.TruncateTime(d.FechaRegistro) == DbFunctions.TruncateTime(Fecha)
        //                  && d.IdEstructuraOrganica == IdEstructuraOrganicaReloj).FirstOrDefault();

        //                if (control != null)
        //                {
        //                    var modelocontrol = bd.Nomina_RelojChecadorControl.Find(control.IdControlAsistencia);
        //                    modelocontrol.ProcesoDeFaltasCompletado = true;
        //                    bd.Nomina_RelojChecadorControl.Attach(modelocontrol);
        //                    bd.Entry(modelocontrol).State = EntityState.Modified;
        //                }

        //                try
        //                {
        //                    bd.SaveChanges();
        //                }
        //                catch (Exception ex)
        //                {

        //                    throw;
        //                }
        //            }


        //        } //if 
        //        else
        //        {
        //            // no entro por el if (permisos.Count == 0 && validar && EsExima == false)
        //            GenerarFaltasPersonalSinAsistencias(Fecha, IdEstructuraOrganicaReloj,true);
        //        }
            
        //    return true;

        //}

        private bool CrearIncidencia(int idt, DateTime Fecha, short IdEstructuraOrganicaReloj, bool UsarHorariosDocentes = true)
        {
            _usaHorariosDocentes = UsarHorariosDocentes;
            Boolean tieneFaltaTrabajador = false;
            Boolean tieneRetardoTrabajador = false;

            HorariosVigenteAnterior horariodocentepordia = new HorariosVigenteAnterior();
            //var trabajador = vwDatosAspirantesTrabajadores.Where(x => x.IdTrabajador == idt).FirstOrDefault();var trabajador = vwDatosAspirantesTrabajadores.Where(x => x.IdTrabajador == idt).FirstOrDefault();
            //cambio el 24 de abrile 20233

            //       var trabajador = vwDatosAspirantesTrabajadores
            //.Where(x => x.IdTrabajador == idt &&
            //            (x.RestringirMenu == null ||
            //              x.Incidencia.Contains("INCAPACIDAD")))
            //.FirstOrDefault();
            var diasmes = DateTime.DaysInMonth(Fecha.Year, Fecha.Month);

            var fechafinmes = DateTime.Parse(Fecha.Year.ToString() + "-" + Fecha.Month.ToString() + "-" + diasmes.ToString());

            //var trabajador = bd.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(s =>
            //s.IdTrabajador==idt && 
            //    DbFunctions.TruncateTime(s.FechaInicio) <= DbFunctions.TruncateTime(Fecha)
            //  && (s.FechaTermino == null
            //  || ((DbFunctions.TruncateTime(s.FechaTermino) <= DbFunctions.TruncateTime(fechafinmes) || DbFunctions.TruncateTime(s.FechaTermino) >= DbFunctions.TruncateTime(fechafinmes)) && s.FechaTermino.Value.Year >= Fecha.Year - 1)

            //  )
            //   ).OrderByDescending(a=> a.FechaInicio).FirstOrDefault();
            vwDatosAspirantesTrabajadoresHistorial trabajador = null;
            var trabajadorlista = bd.vwDatosAspirantesTrabajadoresHistorial
    .AsNoTracking()
    .Where(s => s.IdTrabajador == idt &&
                DbFunctions.TruncateTime(s.FechaInicio) <= DbFunctions.TruncateTime(Fecha) &&
                (DbFunctions.TruncateTime(s.FechaTermino) == null || DbFunctions.TruncateTime(s.FechaTermino) >= DbFunctions.TruncateTime(Fecha)))
    //.OrderByDescending(a => a.FechaInicio)
    .ToList();

            if (trabajadorlista.Count() > 1)
            {
                if (trabajadorlista.Where(a => a.FechaTermino != null).Count() > 1)
                {
                    trabajador = trabajadorlista.Where(a => a.FechaTermino != null && a.EsPlazaBase==false).FirstOrDefault();
                }
                else
                {
                    trabajador = trabajadorlista.Where(a => a.FechaTermino != null).FirstOrDefault();
                }
            }
            else
                trabajador = trabajadorlista.FirstOrDefault();

            // si es null ya no hay convenios para esa fecha para este trabajador
            if (trabajador != null)
            {
                var horariosPorconvenio = Convenios_stRelacionConvenioLaboral.Where(z => z.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral).FirstOrDefault();

                var RelojChecadorLibre = Nomina_RelojChecadorLibre.Where(c => c.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                //permisos
                var permisos = bd.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(c => (c.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "PERMISO"
                && c.EsCancelada==false
                || c.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "PERMISO CON GOCE DE SUELDO")
                && !c.Catalogos_ctTipoIncidencia.Incidencia.Contains("LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA")
                && c.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt
                && DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(Fecha) && DbFunctions.TruncateTime(c.FechaTermino) >= DbFunctions.TruncateTime(Fecha)).ToList();

                //si hay permisos entonces no crea ninguna falta

                //para los apoyos de becas con goce de sueldo tampoco crea incidencias

                var ListaNominaApoyoEstudios = bd.Nomina_ApoyoEstudios.AsNoTracking().Where(p =>

                (p.IdTrabajador == idt && DbFunctions.TruncateTime(p.FechaInicio) <= DbFunctions.TruncateTime(Fecha) && p.FechaTermino == null) || (p.IdTrabajador == idt && DbFunctions.TruncateTime(p.FechaInicio) <= DbFunctions.TruncateTime(Fecha) && DbFunctions.TruncateTime(p.FechaTermino) >= DbFunctions.TruncateTime(Fecha))).ToList();


                Int32 totaleshoras = 0;
                Int32 totaleshorasClub = 0;

                TimeSpan horasausentes;

                var EsExima = false;

                if (RelojChecadorLibre != null)
                {
                    if (RelojChecadorLibre.EsExima)
                        EsExima = true;
                }

                var categoriapermiso = trabajador.Categoria == "VIGILANTE";
                var categoriapermisoMM = trabajador.IdRelacionConvenioLaboral == 15;
                //var categoriapermiso = trabajador.Categoria == "RESPONSABLE DEL CENTRO \"A\"" || trabajador.Categoria == "COORDINADOR ACADÉMICO" ||
                //    trabajador.Categoria == "RESPONSABLE DEL CENTRO \"B\"" || trabajador.Categoria == "RESPONSABLE DEL CENTRO \"C\"" ||
                //    trabajador.Categoria == "DIRECTOR DE PLANTEL \"A\"" || trabajador.Categoria == "DIRECTOR DE PLANTEL \"B\"" ||
                //    trabajador.Categoria == "DIRECTOR DE PLANTEL \"C\"" || trabajador.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"C\""
                //    || trabajador.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"B\"" || trabajador.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"A\""
                //    || trabajador.Categoria == "SUBDIRECTOR DE PLANTEL \"B\"" || trabajador.Categoria == "SUBDIRECTOR DE PLANTEL \"C\"" || trabajador.Categoria == "SUBDIRECTOR DE PLANTEL \"A\"";

                // var categoriapermiso = trabajador.IdRelacionConvenioLaboral == 15;

                var validar = true;
                if (categoriapermisoMM)
                {
                    validar = false;
                }
                else
                if (categoriapermiso && trabajador.IdModalidadEstudio > 0)
                {
                    validar = false;
                }


                if (permisos.Count == 0 && validar && EsExima == false && ListaNominaApoyoEstudios.Count == 0)
                {


                    var dia = (int)Fecha.DayOfWeek;
                    var horariosPorconvenioDias = Nomina_HorariosConvenioConfiguracion.Where(z =>
                    z.Dia == dia &&
                    z.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral).ToList();

                    Nomina_HorariosConvenioConfiguracion retardoMinimo = new Nomina_HorariosConvenioConfiguracion();

                    //busca el minimo de retardo y tolernacia para aplciarlo en caso de que tengan un horario en sabado o domingo
                    if (dia == 0 || dia == 6)
                    {
                        retardoMinimo = Nomina_HorariosConvenioConfiguracion.Where(z =>
                     z.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral).OrderBy(s => s.ToleranciaEntrada).FirstOrDefault();


                    }

                    //var horarioespecial = this.Nomina_HorariosEspeciales.Where(c =>

                    //        c.Dia == dia && c.IdTrabajador == idt && /*((c.FechaInicio.Value.Date <= Fecha.Date && c.FechaTermino.Value.Date>= Fecha.Date )*/ || c.FechaTermino == null))
                    //        .OrderBy(v => v.Entrada)
                    //        .ToList();

                    // Obtener registros con FechaTermino nula
                    var registrosConFechaTerminoNula = this.Nomina_HorariosEspeciales
                        .Where(c => c.Dia == dia
                                    && c.IdTrabajador == idt
                                    && c.FechaInicio.HasValue
                                    && c.FechaInicio.Value.Date <= Fecha.Date
                                    && c.FechaTermino == null)
                        .ToList();

                    // Obtener registros con FechaTermino no nula y dentro del rango
                    var registrosConFechaTerminoNoNula = this.Nomina_HorariosEspeciales
                        .Where(c => c.Dia == dia
                                    && c.IdTrabajador == idt
                                    && c.FechaInicio.HasValue
                                    && c.FechaInicio.Value.Date <= Fecha.Date
                                    && c.FechaTermino.HasValue
                                    && c.FechaTermino.Value.Date >= Fecha.Date)
                        .ToList();

                    bool horarioespecialvalido = true;

                    // no se consideran horarios especiales solo para
                    // los docentes de oficinas centrales
                    if (trabajador.RelacionLaboral.Contains("DOCENTE") && trabajador.IdModalidadEstudio > 0)
                    {
                        horarioespecialvalido = false;
                            }
                    // Combinar ambos conjuntos de resultados
                    List<Nomina_HorariosEspeciales> horarioespecial = new List<Nomina_HorariosEspeciales>();

                    if (horarioespecialvalido)
                    {
                        horarioespecial = registrosConFechaTerminoNula
                      .Union(registrosConFechaTerminoNoNula)
                      .OrderBy(v => v.Entrada)
                      .ToList();
                    }

                    var fechasolaTempo = Fecha.Date;
                    bdNovaEntities basedatos = new bdNovaEntities();
                    //dias Suspension
                    var diassuspension = Nomina_CalendarioEventos.Where(x => x.Nomina_CalendarioTipoEvento.CalendarioTipoEvento == "SUSPENSIÓN DE ACTIVIDADES"
                    && x.FechaInicio == fechasolaTempo && x.FechaTermino == fechasolaTempo
                    && x.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
                    ).ToList();


                    Boolean PrimaDominicalDiasDescanso = false;
                    Boolean PrimaDominical = false;
                    Boolean DiasDescanso = false;

                    var horariodesabadosdomingos = horarioespecial.Where(s => s.Dia == dia).FirstOrDefault();

                    if (horariosPorconvenio.Catalogos_ctConvenioLaboral.ConvenioLaboral.Contains("BASE"))
                    {

                        if (diassuspension.Count > 0)
                        {
                            PrimaDominicalDiasDescanso = true;
                            DiasDescanso = true;
                        }
                        else
                        if (dia == 0 || dia == 6 && horariodesabadosdomingos == null)
                        {
                            bool tienehorariodocente = false;
                            if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE"))
                            {
                                var horariodocente = NominaTrabajador.getHorarioActualDocente(trabajador.IdKardex, dia, Fecha.ToString("yyyy-MM-dd"));
                                tienehorariodocente = horariodocente.TieneHorario;

                            }

                            if (tienehorariodocente == false)
                            {
                                PrimaDominicalDiasDescanso = true;
                                PrimaDominical = true;
                            }
                        }

                    }


                    var hasidoagregadaunafalta = false;
                    var tienefaltaenbd = bd.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(y => y.EsFaltaDirecta==false &&
            (y.IdTipoIncidencia == idFalta || y.IdTipoIncidencia == idFaltaRetardo
            || y.IdTipoIncidencia == idOmisionSalida) &&
                y.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt &&
                DbFunctions.TruncateTime(y.FechaInicio) == DbFunctions.TruncateTime(Fecha)).FirstOrDefault();


                    if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE") && PrimaDominical == false)
                    {
                        if (UsarHorariosDocentes)
                        {
                            var horasdocentetipos = HorasDocentes(trabajador, Fecha);
                            totaleshoras = horasdocentetipos.TotalHoras;
                            

                        }
                        var model = Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == idt).OrderBy(x => x.FechaAsistencia).ToList();
                        if (model != null)
                        {
                            //var horariodocentepordia = NominaTrabajador.ListastHorariosDetalleNomina.Where(d => d.IdDia == dia && d.IdNova == trabajador.IdKardex).OrderBy(x => x.HoraInicio).ToList();
                            // var horariodocentepordia = NominaTrabajador.NominaHorariosDocentesDetalle.Where(d => d.IdDia == dia && d.IdKardex == trabajador.IdKardex).OrderBy(x => x.HoraInicio).ToList();
                            if (UsarHorariosDocentes)
                            {
                                horariodocentepordia = NominaTrabajador.getHorarioActualDocente(trabajador.IdKardex, dia, Fecha.ToString("yyyy-MM-dd"));



                                if (horariodocentepordia.NominaHorariosDocentesDetalle.Count > 0)
                                {
                                    if (horariosPorconvenioDias.Count == 0)
                                    {

                                        Nomina_HorariosConvenioConfiguracion horariotemporal = new Nomina_HorariosConvenioConfiguracion();

                                        horariotemporal.ToleranciaEntrada = retardoMinimo.ToleranciaEntrada;
                                        horariotemporal.ToleranciaRetardo = retardoMinimo.ToleranciaRetardo;


                                        horariosPorconvenioDias.Clear();
                                        horariosPorconvenioDias.Add(horariotemporal);
                                    }

                                    var entrada = horariodocentepordia.NominaHorariosDocentesDetalle.FirstOrDefault();
                                    TimeSpan timeentrada = TimeSpan.Parse(entrada.HoraInicio);
                                    horariosPorconvenioDias[0].Entrada = timeentrada;
                                    var salida = horariodocentepordia.NominaHorariosDocentesDetalle.LastOrDefault();
                                    TimeSpan timesalida = TimeSpan.Parse(salida.HoraFinal);
                                    horariosPorconvenioDias[0].Salida = timesalida;

                                    //    horasausentes = CalcularHorasAusentes(timeentrada, timesalida, horariodocentepordia.NominaHorariosDocentesDetalle);


                                }
                            }
                        }

                    }

                    if (horariosPorconvenio.AplicaChecarAsistencia && (horariosPorconvenioDias.Count > 0 || DiasDescanso)
                        && tienefaltaenbd == null || horariodesabadosdomingos != null
                        )
                    {
                        if (tienefaltaenbd != null)
                            tieneFaltaTrabajador = true;

                        GenerarFaltasPersonalSinAsistencias(Fecha, IdEstructuraOrganicaReloj);


                        var model = Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == idt).OrderBy(x => x.FechaAsistencia).ToList();
                        if (model.Count > 0)
                        {
                            // los que estan libr de checar, si tiene una omision de entrada o de salida
                            // esos si se les considera una incidencia
                            if (model.Count == 1 && RelojChecadorLibre != null)
                            {
                                GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, model[0].FechaAsistencia, TiposdeIncidencia.Falta,"LIBREDEMONITOREO");
                                tieneFaltaTrabajador = true;

                            }
                            else
                            if (RelojChecadorLibre == null)
                            {
                                var toleranciaEspecial = Nomina_RelojChecadorAreasEstructuraOrganicaTolerancia.Where(c => c.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
                                 && c.Nomina_RelojChecadorAreas.IdEstructuraOrganica == trabajador.IdEstructuraOrganicaFisica).FirstOrDefault();
                                // var IdRetardo = tipoIndicencias.Where(x => x.Incidencia == "RETARDO POR DÍA").FirstOrDefault().IdTipoIncidencia; ;

                                if (toleranciaEspecial != null)
                                {
                                    foreach (var item in horariosPorconvenioDias)
                                    {
                                        item.ToleranciaEntrada = toleranciaEspecial.Tolerancia;
                                        item.ToleranciaRetardo = toleranciaEspecial.ToleranciaRetardo;
                                    }

                                }

                                var entrada = model.FirstOrDefault();
                                try
                                {




                                    //entradas
                                    if (horarioespecial.Count > 0)
                                    {
                                        if (entrada.FechaAsistencia.TimeOfDay > horarioespecial[0].Entrada)
                                        {
                                            //posible falta


                                            DateTime entradaConTolerancia = DateTime.Parse(horarioespecial[0].Entrada.ToString()).AddMinutes((double)horarioespecial[0].ToleranciaEntrada + 1);
                                            DateTime entradaConRetardo = DateTime.Parse(horarioespecial[0].Entrada.ToString()).AddMinutes((double)horarioespecial[0].ToleranciaEntrada + (double)horarioespecial[0].ToleranciaRetardo + 1);
                                            if (entrada.FechaAsistencia.TimeOfDay >= entradaConTolerancia.TimeOfDay)
                                            {
                                                if (entrada.FechaAsistencia.TimeOfDay >= entradaConRetardo.TimeOfDay)
                                                {
                                                    if (tieneFaltaTrabajador == false)
                                                    //falta
                                                    {
                                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta,"FaltaEntradaHE");
                                                        tieneFaltaTrabajador = true;
                                                    }
                                                }
                                                else
                                                      //retardo
                                                      if (tieneFaltaTrabajador == false)
                                                {
                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Retardo,"RetardoHE");
                                                    tieneRetardoTrabajador = true;
                                                }


                                            }


                                        }

                                        if (horarioespecial.Count > 1)
                                        {
                                            var entrada2 = model.Where(b => b.FechaAsistencia.TimeOfDay >= horarioespecial[0].Entrada
                                            && b.FechaAsistencia.TimeOfDay >= horarioespecial[1].Entrada).OrderBy(v => v.FechaAsistencia).ToList();

                                            var HeEntrada2 = entrada2.FirstOrDefault();
                                            DateTime entrada2ConTolerancia = DateTime.Parse(horarioespecial[1].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada);
                                            DateTime entrada2ConRetardo = DateTime.Parse(horarioespecial[1].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo);
                                            if (HeEntrada2 == null)
                                            {
                                                if (tieneFaltaTrabajador == false)
                                                {
                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta,"FaltaSinEntradaHorarioEspecial");
                                                    tieneFaltaTrabajador = true;
                                                }
                                            }
                                            else
                                            if (HeEntrada2.FechaAsistencia.TimeOfDay >= entrada2ConTolerancia.TimeOfDay)
                                            {
                                                if (HeEntrada2.FechaAsistencia.TimeOfDay >= entrada2ConRetardo.TimeOfDay)
                                                { //falta
                                                    if (tieneFaltaTrabajador == false)
                                                    {
                                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, HeEntrada2.FechaAsistencia, TiposdeIncidencia.Falta, "FaltaEntradaHorarioEspecial");
                                                        tieneFaltaTrabajador = true;
                                                    }
                                                }
                                                else
                                                    //retardo
                                                    if (tieneFaltaTrabajador == false)
                                                {
                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, HeEntrada2.FechaAsistencia, TiposdeIncidencia.Retardo,"RetardoHorarioEspecial");
                                                    tieneRetardoTrabajador = true;
                                                }

                                            }


                                        }
                                    }
                                    else
                                    {
                                        //horario Normal
                                        if (horariosPorconvenio.AplicaCargaHoraria == false && horariosPorconvenioDias[0].Entrada != null)

                                        {

                                            if (entrada.FechaAsistencia.TimeOfDay > horariosPorconvenioDias[0].Entrada)
                                            {
                                                DateTime entradaConTolerancia = DateTime.Parse(horariosPorconvenioDias[0].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada).AddMinutes(1);
                                                DateTime entradaConRetardo = DateTime.Parse(horariosPorconvenioDias[0].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo).AddMinutes(1);
                                                if (entrada.FechaAsistencia.TimeOfDay >= entradaConTolerancia.TimeOfDay)
                                                {
                                                    if (entrada.FechaAsistencia.TimeOfDay >= entradaConRetardo.TimeOfDay)
                                                    {
                                                        if (tieneFaltaTrabajador == false)
                                                        {
                                                            GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta,"FaltaEntradaNormal");
                                                            tieneFaltaTrabajador = true;
                                                        }
                                                    }
                                                    else
                                                        if (tieneFaltaTrabajador == false)
                                                    {
                                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Retardo,"RetardoNormal");
                                                        tieneRetardoTrabajador = true;
                                                    }
                                                }
                                            }
                                        }
                                        else
                                        if (horariosPorconvenio.AplicaCargaHoraria == true && horariosPorconvenioDias[0].Entrada != null)
                                        {
                                            //docentes incidencias por horas
                                            if (entrada.FechaAsistencia.TimeOfDay > horariosPorconvenioDias[0].Entrada)
                                            {
                                                DateTime entradaConTolerancia = DateTime.Parse(horariosPorconvenioDias[0].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada + 1);
                                                DateTime entradaConRetardo = DateTime.Parse(horariosPorconvenioDias[0].Entrada.ToString()).AddMinutes((double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo + 1);
                                                if (entrada.FechaAsistencia.TimeOfDay >= entradaConTolerancia.TimeOfDay)
                                                {
                                                    if (entrada.FechaAsistencia.TimeOfDay >= entradaConRetardo.TimeOfDay)
                                                    {
                                                        if (tieneFaltaTrabajador == false)
                                                        {





                                                            /////
                                                            string startTime = horariosPorconvenioDias[0].Entrada.ToString();
                                                            string endTime = entrada.FechaAsistencia.TimeOfDay.ToString();

                                                            // TimeSpan horasAusentes = CalcularHorasAusentes(startTime, endTime, horariosMaestro);

                                                            TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));
                                                            TimeSpan horassinclase = CalcularHorasSinClases(horariodocentepordia.NominaHorariosDocentesDetalle);
                                                            string totaltiempofuera = duration.ToString(@"hh\:mm\:ss");

                                                            int horas = 0;

                                                            //if (duration.Minutes > 0)
                                                            //    horas = 1;
                                                            //if (duration.Hours > 0)
                                                            //    horas = horas + duration.Hours;
                                                            if (duration.Minutes > 0)
                                                            {
                                                                if (duration.Minutes > (double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo)
                                                                    horas = 1;
                                                                else
                                                                if (duration.Minutes > (double)horariosPorconvenioDias[0].ToleranciaEntrada)
                                                                {
                                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.RetardoPorHora,"RetardoPorHoraNormal", 1);
                                                                }
                                                            }
                                                            if (duration.Hours > 0)
                                                            {
                                                                horas = horas + duration.Hours;
                                                                if (horas > horassinclase.TotalHours)
                                                                    horas = horas - (int)horassinclase.TotalHours;
                                                                else
                                                                    horas = (int)horassinclase.TotalHours - horas;


                                                            }
                                                            if (horas > 0)
                                                                GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.FaltaPorHora,"FaltaHorasDocenteNormal", horas, totaltiempofuera);
                                                            // tieneFaltaTrabajador = true;
                                                        }
                                                    }
                                                    else
                                                    //    if (tieneFaltaTrabajador == false)
                                                    {
                                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.RetardoPorHora,"ReatrdoHoraDoente", 1);

                                                        tieneRetardoTrabajador = true;
                                                    }
                                                }
                                                //else
                                                //{
                                                //    string startTime = horariosPorconvenioDias[0].Entrada.ToString();
                                                //    string endTime = entrada.FechaAsistencia.TimeOfDay.ToString();

                                                //    TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));

                                                //    int horas = 0;

                                                //    if (duration.Minutes > 0)
                                                //        horas = 1;
                                                //    if (duration.Hours > 0)
                                                //        horas = horas + duration.Hours;

                                                //    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.FaltaPorHora, horas);
                                                //}
                                            }
                                        }

                                    }


                                    ////ahora se buscan retardos acumulados
                                    //var fechasQuincena = ObtenFechasIncioTerminoQuincenas(Fecha);
                                    //var fechainicialqna = fechasQuincena[0];
                                    //var fechafinalqna = fechasQuincena[1];
                                    //var retardos = bd.IncidenciaPermiso_stIncidenciaTrabajador.Where(s =>
                                    //(s.IdTipoIncidencia == idRetardo || s.IdTipoIncidencia == idRetardoPorHora)
                                    //&& s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == idt
                                    //&& DbFunctions.TruncateTime(s.FechaInicio) >= DbFunctions.TruncateTime(fechainicialqna)
                                    //&& DbFunctions.TruncateTime(s.FechaInicio) <= DbFunctions.TruncateTime(fechafinalqna)).OrderByDescending(d => d.FechaInicio).ToList();

                                    //if ((retardos.Count == 3 || retardos.Count == 6 || retardos.Count == 9 || retardos.Count == 12 || retardos.Count == 15))
                                    //{
                                    //    var diashorario = Nomina_HorariosConvenioConfiguracion.Where(z =>
                                    //          z.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral).ToList();

                                    //    //  var diafaltaporretardo = SiguienteDiaHabil(model[0].FechaAsistencia, diashorario);
                                    //    var diafaltaporretardo = retardos[0].FechaInicio;
                                    //    if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE"))
                                    //        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, diafaltaporretardo, TiposdeIncidencia.FaltaPorRetardo, 1);
                                    //    else
                                    //    {
                                    //        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, diafaltaporretardo, TiposdeIncidencia.FaltaPorRetardo);

                                    //    }




                                    //}

                                    bool tienesalida = true; ;
                                    //var totalregistros = 2;
                                    if (horarioespecial.Count > 1)
                                    //if (horarioespecial != null && horarioespecial[1].Entrada != null)
                                    {
                                        var resultado = model.Where(x => x.FechaAsistencia.TimeOfDay >= horarioespecial[1].Salida).FirstOrDefault();
                                        if (resultado == null)
                                            tienesalida = false;
                                    }
                                    else
                                    if (horarioespecial.Count > 0)
                                    {
                                        if (trabajador.Categoria == "VIGILANTE")
                                        {

                                            GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta,"FaltaVigilante");
                                            tieneFaltaTrabajador = true;

                                        }
                                        else
                                        {
                                            var resultado = model.Where(x => x.FechaAsistencia.TimeOfDay >= horarioespecial[0].Salida).FirstOrDefault();
                                            if (resultado == null)
                                            {
                                                if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE"))
                                                {
                                                    var ultimoacceso = model.LastOrDefault();
                                                    string startTime = ultimoacceso.FechaAsistencia.TimeOfDay.ToString();
                                                    string endTime = horarioespecial[0].Salida.ToString();

                                                    TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));

                                                    int horas = 0;

                                                    //if (duration.Minutes > 0)
                                                    //    horas = 1;
                                                    //if (duration.Hours > 0)
                                                    //    horas = horas + duration.Hours;
                                                    if (duration.Minutes > 0)
                                                    {
                                                        if (duration.Minutes > (double)horariosPorconvenioDias[0].ToleranciaEntrada)
                                                        {
                                                            if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE") && horarioespecial.Count == 0)
                                                            {
                                                                GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.RetardoPorHora,"RetardoHoraDocenteCL", 1);

                                                                tieneRetardoTrabajador = true;
                                                            }
                                                        }
                                                        else
                                                        if (duration.Minutes > (double)horariosPorconvenioDias[0].ToleranciaEntrada + (double)horariosPorconvenioDias[0].ToleranciaRetardo)
                                                            horas = 1;
                                                    }
                                                    if (duration.Hours > 0)
                                                        horas = horas + duration.Hours;
                                                    if (horarioespecial.Count == 0)
                                                    {
                                                        if (!tieneFaltaTrabajador)
                                                            GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, ultimoacceso.FechaAsistencia, TiposdeIncidencia.FaltaPorHora, "FaltaHoraDocenteSinHE", horas);
                                                    }
                                                    else
                                                    {
                                                        hasidoagregadaunafalta = true;
                                                        if (!tieneFaltaTrabajador)
                                                            GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, ultimoacceso.FechaAsistencia, TiposdeIncidencia.Falta, "FaltaHoraDocenteConHE", 8);
                                                    }
                                                    tienesalida = true;
                                                }
                                                //else
                                                //    tienesalida = false;

                                            }
                                        }
                                    }
                                    // totalregistros = 4;

                                    //salidas
                                    if (tienesalida)
                                    {
                                        var salida = model.LastOrDefault();



                                        //if (tieneFaltaTrabajador == false && tieneRetardoTrabajador == false)
                                        if (tieneFaltaTrabajador == false)
                                        {
                                            if (horarioespecial.Count > 0)
                                            {
                                                if (salida.FechaAsistencia.TimeOfDay < horarioespecial[0].Salida)
                                                {
                                                    var ultimoacceso = model.LastOrDefault();
                                                    string startTime = ultimoacceso.FechaAsistencia.TimeOfDay.ToString();
                                                    string endTime = horarioespecial[0].Salida.ToString();

                                                    TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));

                                                    int horas = 0;

                                                    if (duration.Minutes > 0)
                                                        horas = 1;
                                                    if (duration.Hours > 0)
                                                        horas = horas + duration.Hours;


                                                    string totaltiempofuera = duration.ToString(@"hh\:mm\:ss");

                                                    //if (horarioespecial.Count==0)
                                                    if (hasidoagregadaunafalta == false)
                                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta, "FaltaHoraTiempoFuera", horas, totaltiempofuera);


                                                    tieneFaltaTrabajador = true;
                                                }
                                            }
                                            else
                                            if (salida.FechaAsistencia.TimeOfDay < horariosPorconvenioDias[0].Salida)
                                            {
                                                var ultimoacceso = model.LastOrDefault();
                                                string startTime = ultimoacceso.FechaAsistencia.TimeOfDay.ToString();
                                                string endTime = horariosPorconvenioDias[0].Salida.ToString();

                                                string entradaH = horariosPorconvenioDias[0].Entrada.ToString();

                                                //TimeSpan duracionPorHoras = DateTime.Parse(endTime).Subtract(DateTime.Parse(entradaH));

                                                var duracionPorHoras = CalcularHorasSinClases(horariodocentepordia.NominaHorariosDocentesDetalle);
                                                TimeSpan duration = DateTime.Parse(endTime).Subtract(DateTime.Parse(startTime));

                                                bool entradespues = true;
                                                if (ultimoacceso.FechaAsistencia.TimeOfDay < horariosPorconvenioDias[0].Entrada)
                                                {
                                                    duration = horariosPorconvenioDias[0].Salida.Subtract(horariosPorconvenioDias[0].Entrada);
                                                    entradespues = false;
                                                }



                                                int horas = 0;

                                                if (duration.Minutes > 0 && entradespues)
                                                    horas = 1;
                                                if (duration.Hours > 0)
                                                    horas = horas + duration.Hours;

                                                string totaltiempofuera = "";
                                                if (duration.Minutes > 0 && duration.Hours == 0)
                                                {
                                                    TimeSpan unaHora = new TimeSpan(1, 0, 0);
                                                    totaltiempofuera = unaHora.ToString(@"hh\:mm\:ss");
                                                }
                                                else
                                                    totaltiempofuera = duration.ToString(@"hh\:mm\:ss");

                                                //omision de salida
                                                if (horariosPorconvenio.RelacionConvenioLaboral.Contains("DOCENTE"))
                                                {
                                                    var horariodocente = NominaTrabajador.getHorarioActualDocente(trabajador.IdKardex, dia, Fecha.ToString("yyyy-MM-dd"));
                                                    int horasefectivas = (int)horariodocente.NominaHorariosDocentesDetalle.Sum(s => s.Horas);
                                                    int horasreales = duracionPorHoras.Hours - horasefectivas;

                                                    var horaclub= horariodocente.NominaHorariosDocentesDetalle.Where(z=> z.TipoHoras=="HORAS CLUB").FirstOrDefault();

                                                    var totalhoraclub = horariodocente.NominaHorariosDocentesDetalle
                                                        .Where(z => z.TipoHoras == "HORAS CLUB" &&
                                                              TimeSpan.Parse(z.HoraFinal) > salida.FechaAsistencia.TimeOfDay)
                                                        .ToList();

                                                    if (totalhoraclub.Count>0)
                                                    {
                                                        horas = horas - totalhoraclub.Count;
                                                        string horasFormateadas = TimeSpan.FromHours(totalhoraclub.Count).ToString(@"hh\:mm\:ss");
                                                        GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, ultimoacceso.FechaAsistencia, TiposdeIncidencia.FaltaHoraClub, "FaltaDocenteHorasCLUBAUT", totalhoraclub.Count, horasFormateadas);

                                                        TimeSpan tiempofuerahc = TimeSpan.Parse(totaltiempofuera);
                                                        tiempofuerahc = tiempofuerahc.Subtract(TimeSpan.FromHours(totalhoraclub.Count));
                                                          totaltiempofuera = tiempofuerahc.ToString(@"hh\:mm\:ss");
                                                    }
                                                    //if (horas> horasreales)
                                                    //    horas = horas - horasreales;
                                                    //else
                                                    //    horas = horasreales-horas ;
                                                    // 21 de nov coambio solicitado por bitzania
                                                    //los retardos y faltas de docentes deben de mostrarse
                                                    //if (tieneRetardoTrabajador)
                                                    //  EditarGuardarIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.FaltaPorHora, tieneFaltaTrabajador, horas);
                                                    //else
                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, ultimoacceso.FechaAsistencia, TiposdeIncidencia.FaltaPorHora,"FaltaDocenteHorasRealesRC", horas, totaltiempofuera);

                                                }
                                                else
                                                {
                                                    //GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.OmisionSalida, horas, totaltiempofuera);
                                                    GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta, "FaltaDocenteHorasReales", horas, totaltiempofuera);
                                                    tieneFaltaTrabajador = true;
                                                }

                                            }
                                        }

                                    }
                                    else
                                    {
                                        EditarGuardarIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, entrada.FechaAsistencia, TiposdeIncidencia.Falta, tieneFaltaTrabajador);
                                        tieneFaltaTrabajador = true;
                                    }


                                }
                                catch (Exception ax)
                                {

                                    throw;
                                }

                            } // if (RelojChecadorLibre == null)

                        }//model !=null

                        //
                        if (PrimaDominicalDiasDescanso && tieneFaltaTrabajador == false)
                        {

                            if (DiasDescanso)
                                GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, Fecha, TiposdeIncidencia.DiasDescanso,"DiasDescanso");
                        }
                        else
                        if ((tieneFaltaTrabajador || tieneRetardoTrabajador) & DiasDescanso == false)
                        {
                            JustificaFaltasAutomaticamenteTrabajador(Fecha, trabajador);
                        }
                    }
                    else
                    // -----
                    {

                        if (PrimaDominical)
                        {
                            var modelo = Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == idt).OrderBy(x => x.FechaAsistencia).ToList();
                            if (modelo != null)
                            {
                                if (modelo.Count > 1)
                                {
                                    var e1 = modelo.FirstOrDefault().FechaAsistencia;
                                    var s1 = modelo.LastOrDefault().FechaAsistencia;
                                    TimeSpan diff = s1 - e1;
                                    double hjornada = diff.TotalHours;
                                    //deshabilitadas las primas automaticas
                                    //if (hjornada > 7)
                                       // GuardaIncidencia((int)trabajador.IdConvenioLaboralTrabajadorCategoria, Fecha, TiposdeIncidencia.PrimaDominical, "PrimaDominical");

                                }



                            }
                        }


                        var control = bd.Nomina_RelojChecadorControl.AsNoTracking().Where(d => DbFunctions.TruncateTime(d.FechaRegistro) == DbFunctions.TruncateTime(Fecha)
                          && d.IdEstructuraOrganica == IdEstructuraOrganicaReloj).FirstOrDefault();

                        if (control != null)
                        {
                            var modelocontrol = bd.Nomina_RelojChecadorControl.Find(control.IdControlAsistencia);
                            modelocontrol.ProcesoDeFaltasCompletado = true;
                            bd.Nomina_RelojChecadorControl.Attach(modelocontrol);
                            bd.Entry(modelocontrol).State = EntityState.Modified;
                        }

                        try
                        {
                            bd.SaveChanges();
                        }
                        catch (Exception ex)
                        {

                            throw;
                        }
                    }


                } //if 
                else
                {
                    // no entro por el if (permisos.Count == 0 && validar && EsExima == false)
                    GenerarFaltasPersonalSinAsistencias(Fecha, IdEstructuraOrganicaReloj, true);
                }

            }

            return true;

        }

        private DateTime SiguienteDiaHabil(DateTime fechaAsistencia, List<Nomina_HorariosConvenioConfiguracion> horario)
        {
            var fechaprobable = fechaAsistencia.AddDays(1);
            var dia = (int)fechaprobable.DayOfWeek;

            var existeenhorario = horario.Where(r => r.Dia == dia).FirstOrDefault();
            if (existeenhorario == null)
            {

                return SiguienteDiaHabil(fechaprobable, horario);


            }
            else
            {
                var esdiainhabil = bd.Nomina_CalendarioEventos.Where(s => DbFunctions.TruncateTime(s.FechaInicio) == DbFunctions.TruncateTime(fechaprobable)).FirstOrDefault();
                if (esdiainhabil == null)
                    return fechaprobable;
                else
                    return SiguienteDiaHabil(fechaprobable, horario);

            }


            return fechaprobable;


        }

        private void JustificaFaltasAutomaticamenteTrabajador(DateTime fecha, vwDatosAspirantesTrabajadoresHistorial listatrabajadores)
        {
            var fechasola = fecha.Date;
            bdNovaEntities basedatos = new bdNovaEntities();
            //dias Suspension
            //var diassuspension = Nomina_CalendarioEventos.Where(x => x.Nomina_CalendarioTipoEvento.CalendarioTipoEvento == "SUSPENSIÓN DE ACTIVIDADES"
            //&& x.FechaInicio == fechasola && x.FechaTermino == fechasola
            //&& x.IdRelacionConvenioLaboral == listatrabajadores.IdRelacionConvenioLaboral
            //).ToList();

            var diassuspension = Nomina_CalendarioEventos
    .Where(x => x.Nomina_CalendarioTipoEvento.CalendarioTipoEvento == "SUSPENSIÓN DE ACTIVIDADES"
                 && x.FechaInicio.Date <= fechasola && x.FechaTermino.Date >= fechasola
                 && x.IdRelacionConvenioLaboral == listatrabajadores.IdRelacionConvenioLaboral)
    .ToList();


            var vacaciones = Nomina_CalendarioEventos.Where(x => x.Nomina_CalendarioTipoEvento.CalendarioTipoEvento == "VACACIONES" 
             && x.IdRelacionConvenioLaboral == listatrabajadores.IdRelacionConvenioLaboral && fechasola >= x.FechaInicio && fechasola <= x.FechaTermino).ToList();

            var listajustificaciones = basedatos.Incidencia_ctJustificacion.ToList();


            if (diassuspension.Count > 0)
            {

                //foreach (var item in listatrabajadores)
                //{

                short[] arregloIncidencias = { idFalta, idFaltaPorHora, idFaltaRetardo, idRetardo, idRetardoPorHora };
                bdNovaEntities nova = new bdNovaEntities();
                var incidenciaLista = nova.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => DbFunctions.TruncateTime(z.FechaInicio) == fechasola
                 && DbFunctions.TruncateTime(z.FechaTermino) == fechasola && z.IdConvenioLaboralTrabajadorCategoria == listatrabajadores.IdConvenioLaboralTrabajadorCategoria
                 && (z.IdTipoIncidencia == idFalta || z.IdTipoIncidencia == idFaltaPorHora || z.IdTipoIncidencia == idFaltaRetardo
                     || z.IdTipoIncidencia == idRetardo || z.IdTipoIncidencia == idRetardoPorHora
                 )
                 && z.IdIncidenciaJustificacion == 0).ToList();

                foreach (var incidencia in incidenciaLista)


                {
                    incidencia.IdIncidenciaJustificacion = idSuspension;
                    incidencia.FechaJustificacion = fechasola;
                    incidencia.FechaAutorizacion = fechasola;
                    incidencia.IdConvenioLaboralTrabajadorCategoriaJustifico = IdJefeRecursosHumanos;
                    incidencia.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdJefeRecursosHumanos;
                    incidencia.Autorizo = true;

                    nova.Configuration.AutoDetectChangesEnabled = false;
                    nova.Configuration.ValidateOnSaveEnabled = false;


                    nova.IncidenciaPermiso_stIncidenciaTrabajador.Attach(incidencia);
                    nova.Entry(incidencia).State = EntityState.Modified;

                    try
                    {
                        nova.SaveChanges();
                    }
                    catch (Exception er)
                    {


                    }
                }


            }
            //}
            else
            if (vacaciones.Count > 0)
            {

                //foreach (var item in listatrabajadores)
                //{


                bdNovaEntities nova = new bdNovaEntities();
                var incidenciaLista = nova.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => DbFunctions.TruncateTime(z.FechaInicio) == fechasola
                 && DbFunctions.TruncateTime(z.FechaTermino) == fechasola && z.IdConvenioLaboralTrabajadorCategoria == listatrabajadores.IdConvenioLaboralTrabajadorCategoria
                  && (z.IdTipoIncidencia == idFalta || z.IdTipoIncidencia == idFaltaPorHora || z.IdTipoIncidencia == idFaltaRetardo
                     || z.IdTipoIncidencia == idRetardo || z.IdTipoIncidencia == idRetardoPorHora
                 )
                 && z.IdIncidenciaJustificacion == 0).ToList();


                foreach (var incidencia in incidenciaLista)

                {
                    incidencia.IdIncidenciaJustificacion = idVacaciones;
                    incidencia.FechaJustificacion = fechasola;
                    incidencia.FechaAutorizacion = fechasola;
                    incidencia.IdConvenioLaboralTrabajadorCategoriaJustifico = IdJefeRecursosHumanos;
                    incidencia.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdJefeRecursosHumanos;
                    incidencia.Autorizo = true;

                    nova.Configuration.AutoDetectChangesEnabled = false;
                    nova.Configuration.ValidateOnSaveEnabled = false;


                    nova.IncidenciaPermiso_stIncidenciaTrabajador.Attach(incidencia);
                    nova.Entry(incidencia).State = EntityState.Modified;

                    try
                    {
                        nova.SaveChanges();
                    }
                    catch (Exception er)
                    {


                    }
                    //}


                }
            }
            else {
                //incapacidades
                var incapAcidad = basedatos.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking()
    .Where(z => fechasola >= DbFunctions.TruncateTime(z.FechaInicio)
             && fechasola <= DbFunctions.TruncateTime(z.FechaTermino)
             && z.IdConvenioLaboralTrabajadorCategoria == listatrabajadores.IdConvenioLaboralTrabajadorCategoria
             && z.Catalogos_ctTipoIncidencia.Incidencia.Contains("INCAPACIDAD"))
    .ToList();

                if (incapAcidad.Count() > 0)
                {

                    bdNovaEntities nova = new bdNovaEntities();
                    var incidenciaLista = nova.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(z => DbFunctions.TruncateTime(z.FechaInicio) == fechasola
                     && DbFunctions.TruncateTime(z.FechaTermino) == fechasola && z.IdConvenioLaboralTrabajadorCategoria == listatrabajadores.IdConvenioLaboralTrabajadorCategoria
                      && (z.IdTipoIncidencia == idFalta || z.IdTipoIncidencia == idFaltaPorHora || z.IdTipoIncidencia == idFaltaRetardo
                         || z.IdTipoIncidencia == idRetardo || z.IdTipoIncidencia == idRetardoPorHora
                     )
                     && z.IdIncidenciaJustificacion == 0).ToList();


                    foreach (var incidencia in incidenciaLista)

                    {
                        incidencia.IdIncidenciaJustificacion = idIncapacidad;
                        incidencia.FechaJustificacion = fechasola;
                        incidencia.FechaAutorizacion = fechasola;
                        incidencia.IdConvenioLaboralTrabajadorCategoriaJustifico = IdJefeRecursosHumanos;
                        incidencia.IdConvenioLaboralTrabajadorCategoriaAutorizo = IdJefeRecursosHumanos;
                        incidencia.Autorizo = true;

                        nova.Configuration.AutoDetectChangesEnabled = false;
                        nova.Configuration.ValidateOnSaveEnabled = false;


                        nova.IncidenciaPermiso_stIncidenciaTrabajador.Attach(incidencia);
                        nova.Entry(incidencia).State = EntityState.Modified;

                        try
                        {
                            nova.SaveChanges();
                        }
                        catch (Exception er)
                        {


                        }
                    }
                }

            }
        }

        //private HorariosVigenteAnterior getHorarioVigenteAnterior(int IdKardex, int diasemana)
        //{
        //    HorariosVigenteAnterior regresa = new HorariosVigenteAnterior();
        //    //var horariodocentepordia = NominaTrabajador.ListastHorariosDetalleNomina.Where(d => d.IdDia == diasemana && d.IdNova == item.IdKardex).OrderBy(x => x.HoraInicio).ToList();
        //    List<NominaHorariosDocentesDetalle> horariodocentepordia = new List<NominaHorariosDocentesDetalle>();

        //    horariodocentepordia = NominaTrabajador.NominaHorariosDocentesDetalle.Where(d => d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();

        //    bool tieneHorario = true;
        //    if (horariodocentepordia.Count == 0)
        //    {
        //        NominaTrabajador.getHorarioDocenteAnterior(IdKardex);
        //        horariodocentepordia = NominaTrabajador.NominaHorariosDocentesDetalleAnterior.OrderBy(x => x.HoraInicio).ToList();

        //        if (horariodocentepordia.Count == 0)
        //            tieneHorario = false;
        //    }

        //    horariodocentepordia = NominaTrabajador.NominaHorariosDocentesDetalle.Where(d => d.IdDia == diasemana && d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();
        //    regresa.NominaHorariosDocentesDetalle = horariodocentepordia;
        //    regresa.TieneHorario = tieneHorario;
        //    return regresa;
        //}
        private void GenerarFaltasPersonalSinAsistencias(DateTime fecha, int IdEstructuraOrganicaReloj,bool sinregistrosenBD=false)
        {
            var relojVinculadoaOtro = Nomina_RelojChecadorAreas.Where(s => s.IdEstructuraOrganica == IdEstructuraOrganicaReloj).FirstOrDefault();
            List<short> areasInvoucradas = new List<short>();

            List<Nomina_RelojChecadorControl> control = new List<Nomina_RelojChecadorControl>();
            bool haygrupos = false;
            if (relojVinculadoaOtro != null)
            {
                if (relojVinculadoaOtro.IdRelojAreasGrupo != null)
                    haygrupos = true;
            }

            bool ProcesoDeFaltasCompletado = false;
            bool totalareasengrupocompletado = false;

                if (haygrupos)
            {
                var areasporgrupo = Nomina_RelojChecadorAreas.Where(s => s.IdRelojAreasGrupo == relojVinculadoaOtro.IdRelojAreasGrupo).Select(s => s.IdEstructuraOrganica).ToArray();
                   areasInvoucradas = bd.Nomina_RelojChecadorAreasEstructuraOrganica.Where(r => areasporgrupo.Contains(r.Nomina_RelojChecadorAreas.IdEstructuraOrganica)).Select(a=> a.IdEstructuraOrganica).ToList();
               
                   //     control = bd.Nomina_RelojChecadorControl.Where(d => DbFunctions.TruncateTime(d.FechaRegistro) == DbFunctions.TruncateTime(fecha)
                   //&& areasInvoucradas.Contains(d.IdEstructuraOrganica)).ToList();

                   control = bd.Nomina_RelojChecadorControl.AsNoTracking().Where(d => DbFunctions.TruncateTime(d.FechaRegistro) == DbFunctions.TruncateTime(fecha)
           && areasporgrupo.Contains(d.IdEstructuraOrganica)).ToList();

                if (control.Count() == 0)
                {

                    var resultados = bd.Nomina_RelojChecadorControl.AsNoTracking()
    .Where(d => DbFunctions.TruncateTime(d.FechaRegistro) >= DbFunctions.TruncateTime(fecha)
                && areasporgrupo.Contains(d.IdEstructuraOrganica))
    .GroupBy(d => d.IdEstructuraOrganica)  // Agrupar por IdEstructuraOrganica
    .Select(grupo => new
    {
        ProcesoDeFaltasCompletado=grupo.Any(q=> q.ProcesoDeFaltasCompletado),
        IdEstructuraOrganica = grupo.Key,
        TotalPorGrupo = grupo.Count(),  // Obtener el total por grupo
        FechaMaxima = grupo.Min(d => d.FechaRegistro)  // Obtener la fecha máxima por grupo
    })
    .ToList();
                    if (areasporgrupo.Count() == resultados.Count())
                    {
                        totalareasengrupocompletado = true;
                        
                        if (resultados.All(r => r.ProcesoDeFaltasCompletado))
                        {
                            // Todos los valores mínimos booleanos son true, puedes trabajar con los resultados
                            ProcesoDeFaltasCompletado = true;
                        }
                        else
                        {
                            
                            ProcesoDeFaltasCompletado = false;
                        }
                    }

                }
                else
                {
                    if (areasporgrupo.Count() == control.Count())
                    {
                        totalareasengrupocompletado = true;
                        
                        if (control.All(r => r.ProcesoDeFaltasCompletado))
                        {
                            // Todos los valores mínimos booleanos son true, puedes trabajar con los resultados
                            ProcesoDeFaltasCompletado = true;
                        }
                        else
                        {

                            ProcesoDeFaltasCompletado = false ;
                        }
                    }
                }

            }
            else
            {
                areasInvoucradas = bd.Nomina_RelojChecadorAreasEstructuraOrganica.AsNoTracking().Where(r =>r.Nomina_RelojChecadorAreas.IdEstructuraOrganica== IdEstructuraOrganicaReloj).Select(a => a.IdEstructuraOrganica).ToList();
                control = bd.Nomina_RelojChecadorControl.Where(d => DbFunctions.TruncateTime(d.FechaRegistro) == DbFunctions.TruncateTime(fecha)
           && d.IdEstructuraOrganica == IdEstructuraOrganicaReloj).ToList();
                
            }





            //if (totalareasengrupocompletado)
            //{
            //    ProcesoDeFaltasCompletado = control.FirstOrDefault().ProcesoDeFaltasCompletado;
            //}
            //else
            if (control.Count() > 0)
            {
                
                if (control.All(r => r.ProcesoDeFaltasCompletado))
                {
                    // Todos los valores mínimos booleanos son true, puedes trabajar con los resultados
                    ProcesoDeFaltasCompletado = true;
                }
                else
                {

                    ProcesoDeFaltasCompletado = false;
                }

            }

            List<int?> registrospersonal = new List<int?>();

            if (!ProcesoDeFaltasCompletado || sinregistrosenBD)
            {
                 
                int totaldiasMes= System.DateTime.DaysInMonth(fecha.Year, fecha.Month);
                var fechafinmes = DateTime.Parse(fecha.Year.ToString()+"-"+ fecha.Month.ToString()+"-"+totaldiasMes.ToString());
               
                 if (haygrupos)
            {
                var areasporgrupo = Nomina_RelojChecadorAreas.Where(s => s.IdRelojAreasGrupo == relojVinculadoaOtro.IdRelojAreasGrupo).Select(s => s.IdEstructuraOrganica).ToArray();

                registrospersonal = bd.Nomina_RelojChecadorAsistencia.AsNoTracking().Where(d => areasporgrupo.Contains(d.IdEstructuraOrganica) 
                    && DbFunctions.TruncateTime(d.FechaAsistencia) == DbFunctions.TruncateTime(fecha)).Select(v => v.IdTrabajador).ToList();
            }
            else
            {
                registrospersonal = bd.Nomina_RelojChecadorAsistencia.AsNoTracking().Where(d => d.IdEstructuraOrganica == IdEstructuraOrganicaReloj
                    && DbFunctions.TruncateTime(d.FechaAsistencia) == DbFunctions.TruncateTime(fecha)).Select(v => v.IdTrabajador).ToList();
            }
                  //registrospersonal = bd.Nomina_RelojChecadorAsistencia.Where(d => d.IdEstructuraOrganica == IdEstructuraOrganicaReloj
                  //&& DbFunctions.TruncateTime(d.FechaAsistencia) == DbFunctions.TruncateTime(fecha)).Select(v => v.IdTrabajador).ToArray();

                 //areasInvoucradas = bd.Nomina_RelojChecadorAreasEstructuraOrganica.Where(r => r.Nomina_RelojChecadorAreas.IdEstructuraOrganica == IdEstructuraOrganicaReloj).Select(Q => Q.IdEstructuraOrganica).ToList();


               // var personalSegunReloj = bd.vwDatosAspirantesTrabajadores.Where(s => s.RestringirMenu == null
               //&& DbFunctions.TruncateTime(s.FechaInicio) <= DbFunctions.TruncateTime(fecha)
               //&& (s.FechaTermino == null
               //|| ((DbFunctions.TruncateTime(s.FechaTermino) <= DbFunctions.TruncateTime(fechafinmes) || DbFunctions.TruncateTime(s.FechaTermino) >= DbFunctions.TruncateTime(fechafinmes)) && s.FechaTermino.Value.Year >= fecha.Year - 1)

               //)
               //  && areasInvoucradas.Contains((short)s.IdEstructuraOrganicaFisica)).ToList();

                //caso alicia se va de comision en 1o de cotubre y enla 2a de sep yano la toma en cuenta
                //por eso deben de agregar todos sin importat si n tienen o no comision

                //var personalSegunReloj = bd.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(s => 
                //  DbFunctions.TruncateTime(s.FechaInicio) <= DbFunctions.TruncateTime(fecha)
                //&& (s.FechaTermino==null 
                //|| ((DbFunctions.TruncateTime( s.FechaTermino)<= DbFunctions.TruncateTime(fechafinmes) || DbFunctions.TruncateTime(s.FechaTermino) >= DbFunctions.TruncateTime(fechafinmes)) && s.FechaTermino.Value.Year>= fecha.Year-1)
                
                //)
                //  && areasInvoucradas.Contains((short)s.IdEstructuraOrganicaFisica)).ToList();

                var personalSegunRelojtodos = bd.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(s =>
                  DbFunctions.TruncateTime(s.FechaInicio) <= DbFunctions.TruncateTime(fecha)
                && (s.FechaTermino == null
                || ((DbFunctions.TruncateTime(s.FechaTermino) >= DbFunctions.TruncateTime(fecha) 
                || DbFunctions.TruncateTime(s.FechaTermino) >= DbFunctions.TruncateTime(fechafinmes))
                //&& s.FechaTermino.Value.Year >= fecha.Year - 1
                )

                )
                  && areasInvoucradas.Contains((short)s.IdEstructuraOrganicaFisica)).ToList();

                var trabajadoresgrales=personalSegunRelojtodos.Select(a => a.IdTrabajador).ToList();

                var personalSegunRelojtodosComisionados = bd.vwDatosAspirantesTrabajadoresHistorial.AsNoTracking().Where(s =>
                  DbFunctions.TruncateTime(s.FechaInicio) <= DbFunctions.TruncateTime(fecha)
                && (s.FechaTermino == null
                || ((DbFunctions.TruncateTime(s.FechaTermino) >= DbFunctions.TruncateTime(fecha)
                || DbFunctions.TruncateTime(s.FechaTermino) >= DbFunctions.TruncateTime(fechafinmes))
                
                )

                )
                  && trabajadoresgrales.Contains(s.IdTrabajador) 
                  && !areasInvoucradas.Contains((short)s.IdEstructuraOrganicaFisica)).ToList();

                string cadenaConcatenada = string.Join(", ", personalSegunRelojtodos.Select(p => p.IdConvenioLaboralTrabajadorCategoria));


               // personalSegunRelojtodos= personalSegunRelojtodos.Where(z=>  !personalSegunRelojtodosComisionados.Select(a=> a.IdTrabajador ).Contains(z.IdTrabajador)).ToList();

                // Filtrar las personas que tienen exactamente un contrato
                var personasConUnContrato = personalSegunRelojtodos
                    .GroupBy(c => c.IdTrabajador)
                    .Where(g => g.Count() == 1)
                    .SelectMany(g => g)
                    .ToList();

                // Filtrar las personas que tienen exactamente dos contratos y al menos uno con fecha de término
                var personasConDosContratosConFechaTermino = personalSegunRelojtodos
                    .GroupBy(c => c.IdTrabajador)
                    .Where(g => g.Count() == 2 && g.Any(c => c.FechaTermino != null))
                    .SelectMany(g => g)
                    .ToList();

                // Combinar ambas listas en una sola lista final
                var personalSegunReloj = personasConUnContrato.Concat(personasConDosContratosConFechaTermino).ToList();

                // se quitan a los de base de dir gral.
                //var areasInvoucradasBaseOfCentrales = bd.Nomina_RelojChecadorAreasEstructuraOrganica.Where(r => r.IdRelojChecadorAreas==1 || r.IdRelojChecadorAreas == 2
                //).Select(Q => Q.IdEstructuraOrganica).ToList();

                //var personalBaseOfCentrales = bd.vwDatosAspirantesTrabajadores.Where(s => s.RestringirMenu == null && (s.FechaTermino == null
                //|| ((DbFunctions.TruncateTime(s.FechaTermino) <= DbFunctions.TruncateTime(fechafinmes) || DbFunctions.TruncateTime(s.FechaTermino) >= DbFunctions.TruncateTime(fechafinmes)) && s.FechaTermino.Value.Year >= fecha.Year - 1)

                //)
                //  && s.ConvenioLaboral== "BASE"  && areasInvoucradasBaseOfCentrales.Contains((short)s.IdEstructuraOrganicaFisica)).Select(q=> q.IdTrabajador).ToArray();


                var conveniosValidos = Convenios_stRelacionConvenioLaboral.Where(z => z.AplicaChecarAsistencia == true).ToList();


                // se comento esa linea para los de base deof centrales
                var faltas = personalSegunReloj.Where(v => conveniosValidos.Select(b => b.IdRelacionConvenioLaboral).Contains((short)v.IdRelacionConvenioLaboral)
                && !registrospersonal.Contains((int)v.IdTrabajador)).ToList();

                //var faltas = personalSegunReloj.Where(v => conveniosValidos.Select(b => b.IdRelacionConvenioLaboral).Contains((short)v.IdRelacionConvenioLaboral)
                //&& !registrospersonal.Contains((int)v.IdTrabajador)
                //  && !personalBaseOfCentrales.Contains((int)v.IdTrabajador)
                //).ToList();



                //quita a las persosnas que tengan algun permiso o licencia
          //      var permisos = bd.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(c=> (c.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "PERMISO"
          //  || c.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "PERMISO SIN GOCE DE SUELDO")
          //&& DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fecha) && DbFunctions.TruncateTime(c.FechaTermino) >= DbFunctions.TruncateTime(fecha)).Select(f => f.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();


                var permisos = bd.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(c => (c.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "PERMISO"
                && c.EsCancelada==false
&&  c.Catalogos_ctTipoIncidencia.Incidencia!= "LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA"
&& c.Catalogos_ctTipoIncidencia.Incidencia != "LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA")
&& DbFunctions.TruncateTime(c.FechaInicio) <= DbFunctions.TruncateTime(fecha) && DbFunctions.TruncateTime(c.FechaTermino) >= DbFunctions.TruncateTime(fecha)).Select(f => f.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();
                


                var faltaspersonalsinpermisos = faltas.Where(b => !permisos.Contains((int)b.IdTrabajador)).ToList();

                //para los apoyos de becas con goce de sueldo tampoco crea incidencias

                var ListaNominaApoyoEstudios = bd.Nomina_ApoyoEstudios.AsNoTracking().Where(p =>
               
                (DbFunctions.TruncateTime(p.FechaInicio) <= DbFunctions.TruncateTime(fecha) && p.FechaTermino == null) || (DbFunctions.TruncateTime(p.FechaInicio) <= DbFunctions.TruncateTime(fecha) && DbFunctions.TruncateTime(p.FechaTermino) >= DbFunctions.TruncateTime(fecha))).Select(b=> b.IdTrabajador).ToList();

                var faltaspersonalsinpermisosniapoyos = faltaspersonalsinpermisos.Where(b => !ListaNominaApoyoEstudios.Contains((int)b.IdTrabajador)).ToList();

                var buscarfaltaspersonalsinpermisosniapoyos = faltaspersonalsinpermisosniapoyos.Select(x => x.IdTrabajador).ToArray();

                var diasemana = (int)fecha.DayOfWeek;
                var fechaS = fecha.Date;

                var personalqueyatienefaltaenbdLista = bd.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(y =>
(y.IdTipoIncidencia == idFalta || y.IdTipoIncidencia == idFaltaRetardo
|| y.IdTipoIncidencia == idFaltaPorHora || y.IdTipoIncidencia == idFaltaPorExcederPases) &&
    buscarfaltaspersonalsinpermisosniapoyos.Contains(y.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador) &&

    DbFunctions.TruncateTime(y.FechaInicio) == DbFunctions.TruncateTime(fecha)).AsNoTracking().ToList();
    
   var personalqueyatienefaltaenbd= personalqueyatienefaltaenbdLista.Select(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToArray();

                var faltaspersonalsinpermisosniapoyosnifaltas = faltaspersonalsinpermisosniapoyos.Where(b => !personalqueyatienefaltaenbd.Contains((int)b.IdTrabajador)).ToList();


                foreach (var item in faltaspersonalsinpermisosniapoyosnifaltas)
                {

                    var existecomisionenotrocentro = personalSegunRelojtodosComisionados.Where(a => a.IdTrabajador == item.IdTrabajador).FirstOrDefault();

                    
                    bool procesarenestafecha = false;
                    if (item.EsPlazaBase == false)
                    {
                        procesarenestafecha = true;
                    }
                    else
                    if (existecomisionenotrocentro != null  )
                    {
                        if (fecha.Date >= existecomisionenotrocentro.FechaInicio.Value.Date)
                        {
                            if (existecomisionenotrocentro.FechaTermino != null)
                            {
                                if (fecha.Date <= existecomisionenotrocentro.FechaTermino.Value.Date)
                                {
                                    procesarenestafecha = false;  // Dentro del rango de comisión
                                }
                            }
                            else
                            {
                                procesarenestafecha = false;  // La comisión no tiene fecha de término
                            }
                        }
                        else
                        {
                            procesarenestafecha = true;  // Fecha anterior al inicio de la comisión
                        }
                    }
                    else
                    {
                        procesarenestafecha = true;  // No hay comisión, se puede procesar
                    }


                    if (procesarenestafecha)
                    {
                        var diassuspension = Nomina_CalendarioEventos
      .Where(x => x.Nomina_CalendarioTipoEvento.CalendarioTipoEvento == "SUSPENSIÓN DE ACTIVIDADES"
                   && x.FechaInicio.Date <= fechaS && x.FechaTermino.Date >= fechaS
                   && x.IdRelacionConvenioLaboral == item.IdRelacionConvenioLaboral)
      .ToList();



                        var horariosPorconvenioDias = Nomina_HorariosConvenioConfiguracion.Where(z =>
                    z.Dia == diasemana &&
                    z.IdRelacionConvenioLaboral == item.IdRelacionConvenioLaboral).ToList();


                        var horarioespecial = this.Nomina_HorariosEspeciales.Where(c =>

                                 c.IdTrabajador == item.IdTrabajador && c.FechaInicio.Value.Date <= fechaS && (fechaS != null || fechaS >= DateTime.Now.Date))

                                .ToList();

                        bool trabajaenesteDia = true;


                        if (item.FechaTermino != null)
                            if (fecha.Date > item.FechaTermino.Value.Date)
                                trabajaenesteDia = false;

                        HorariosVigenteAnterior horario = new HorariosVigenteAnterior();

                        if (diassuspension.Count > 0)
                        {
                            trabajaenesteDia = true;
                        }
                        else
                        if (item.RelacionLaboral.Contains("DOCENTE"))
                        {

                            //var horariodocentepordia = NominaTrabajador.ListastHorariosDetalleNomina.Where(d => d.IdDia == diasemana && d.IdNova == item.IdKardex).OrderBy(x => x.HoraInicio).ToList();
                            //List<NominaHorariosDocentesDetalle> horariodocentepordia = new List<NominaHorariosDocentesDetalle>();

                            //horariodocentepordia = NominaTrabajador.NominaHorariosDocentesDetalle.Where(d => d.IdKardex == item.IdKardex).OrderBy(x => x.HoraInicio).ToList();

                            //bool tieneHorario = true;
                            //if (horariodocentepordia.Count== 0)
                            //{
                            //    horariodocentepordia = NominaTrabajador.NominaHorariosDocentesDetalleAnterior.Where(d => d.IdKardex == item.IdKardex).OrderBy(x => x.HoraInicio).ToList();

                            //    if (horariodocentepordia.Count == 0)
                            //        tieneHorario = false;
                            //}

                            //horariodocentepordia = NominaTrabajador.NominaHorariosDocentesDetalle.Where(d => d.IdDia == diasemana && d.IdKardex == item.IdKardex).OrderBy(x => x.HoraInicio).ToList();
                            if (horarioespecial.Count > 0)
                            {
                                var x = horarioespecial.Where(s => s.Dia == diasemana).FirstOrDefault();
                                if (x == null)
                                    trabajaenesteDia = false;

                            }
                            else
                            {
                                horario = NominaTrabajador.getHorarioActualDocente(item.IdKardex, diasemana, fecha.ToString("yyyy-MM-dd"));

                                if (horario.NominaHorariosDocentesDetalle.Count == 0 && horario.TieneHorario)
                                    trabajaenesteDia = false;
                            }
                        }
                        else
                        if (horarioespecial.Count > 0)
                        {
                            var x = horarioespecial.Where(s => s.Dia == diasemana).FirstOrDefault();
                            if (x == null)
                                trabajaenesteDia = false;

                        }
                        else
                                 if (horariosPorconvenioDias.Count == 0)
                            trabajaenesteDia = false;


                        var RelojChecadorLibre = Nomina_RelojChecadorLibre.Where(c => c.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                        Boolean EsExima = false;

                        if (RelojChecadorLibre != null)
                        {
                            if (RelojChecadorLibre.EsExima)
                                EsExima = true;
                        }

                        var categoriapermiso = item.Categoria == "VIGILANTE";
                        //var categoriapermiso = item.Categoria == "RESPONSABLE DEL CENTRO \"A\"" || item.Categoria == "COORDINADOR ACADÉMICO" ||
                        //    item.Categoria == "RESPONSABLE DEL CENTRO \"B\"" || item.Categoria == "RESPONSABLE DEL CENTRO \"C\"" ||
                        //    item.Categoria == "DIRECTOR DE PLANTEL \"A\"" || item.Categoria == "DIRECTOR DE PLANTEL \"B\"" ||
                        //    item.Categoria == "DIRECTOR DE PLANTEL \"C\"" || item.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"C\""
                        //    || item.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"B\"" || item.Categoria == "AUXILIAR DEL RESPONSABLE DEL CENTRO \"A\""
                        //    || item.Categoria == "SUBDIRECTOR DE PLANTEL \"B\"" || item.Categoria == "SUBDIRECTOR DE PLANTEL \"C\"" || item.Categoria == "SUBDIRECTOR DE PLANTEL \"A\"";

                        var validar = true;

                        if (categoriapermiso && item.IdModalidadEstudio > 0)
                        {
                            validar = false;
                        }

                        var diaprocesado = bd.Nomina_RelojChecadorAsistencia.AsNoTracking().Where(y =>
       y.IdTrabajador == item.IdTrabajador && y.EsProcesada == true &&
           DbFunctions.TruncateTime(y.FechaAsistencia) == DbFunctions.TruncateTime(fecha)).AsNoTracking().FirstOrDefault();

                        //                 var tienefaltaenbd = bd.IncidenciaPermiso_stIncidenciaTrabajador.Where(y =>
                        //(y.IdTipoIncidencia == idFalta || y.IdTipoIncidencia == idFaltaRetardo 
                        //|| y.IdTipoIncidencia ==idFaltaPorHora || y.IdTipoIncidencia == idFaltaPorExcederPases) &&
                        //    y.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == item.IdTrabajador &&
                        //    DbFunctions.TruncateTime(y.FechaInicio) == DbFunctions.TruncateTime(fecha)).AsNoTracking().FirstOrDefault();

                        //if (diaprocesado ==null && tienefaltaenbd == null && trabajaenesteDia && validar && EsExima==false)
                        if (diaprocesado == null && trabajaenesteDia && validar && EsExima == false)
                        {
                            if (item.RelacionLaboral.Contains("DOCENTE")
                                && _usaHorariosDocentes)
                            {
                                //var horariodocentepordia = NominaTrabajador.ListastHorariosDetalleNomina.Where(d => d.IdDia == (short)fecha.DayOfWeek && d.IdNova == item.IdKardex).OrderBy(x => x.HoraInicio).ToList();


                                // var horariodocentepordia = NominaTrabajador.NominaHorariosDocentesDetalle.Where(d => d.IdDia == (short)fecha.DayOfWeek && d.IdKardex == item.IdKardex).OrderBy(x => x.HoraInicio).ToList();
                                //var horario = this.getHorarioVigenteAnterior(item.IdKardex, diasemana);

                                //if (horariodocentepordia.Count > 0)
                                var horariodoc = NominaTrabajador.getHorarioActualDocente(item.IdKardex, diasemana, fecha.ToString("yyyy-MM-dd"));

                                if (horariodoc.NominaHorariosDocentesDetalle.Count > 0)
                                {
                                    int horas = 0;

                                    horas = (int)horariodoc.NominaHorariosDocentesDetalle.Sum(d => d.Horas);

                                    //var entrada = horariodoc.NominaHorariosDocentesDetalle.FirstOrDefault();
                                    //TimeSpan timeentrada = TimeSpan.Parse(entrada.HoraInicio);

                                    //var salida = horariodoc.NominaHorariosDocentesDetalle.LastOrDefault();
                                    //TimeSpan timesalida = TimeSpan.Parse(salida.HoraFinal);


                                    //TimeSpan duration = timesalida.Subtract(timeentrada);



                                    //if (duration.Minutes > 0)
                                    //    horas = 1;
                                    //if (duration.Hours > 0)
                                    //    horas = horas + duration.Hours;

                                    GuardaIncidencia((int)item.IdConvenioLaboralTrabajadorCategoria, fecha, TiposdeIncidencia.FaltaPorHora, "FaltaSA_ConHorarioTotalHoras", horas);
                                    log.Info($"1 guarda falta sin checado para {item.IdConvenioLaboralTrabajadorCategoria} en la fecha : {fecha}");
                                }
                                else
                                {
                                    if (horarioespecial.Count > 0 && trabajaenesteDia)
                                    {
                                        GuardaIncidencia((int)item.IdConvenioLaboralTrabajadorCategoria, fecha, TiposdeIncidencia.Falta, "FaltaSA_HorarioEspecialTotalHoras");
                                        log.Info($"2 guarda falta sin checado para {item.IdConvenioLaboralTrabajadorCategoria} en la fecha : {fecha}");
                                    }
                                }
                            }
                            else
                            {
                                GuardaIncidencia((int)item.IdConvenioLaboralTrabajadorCategoria, fecha, TiposdeIncidencia.Falta, "FaltaSA_Administrativo");
                                log.Info($"3 guarda falta sin checado para {item.IdConvenioLaboralTrabajadorCategoria} en la fecha : {fecha}");
                            }

                            JustificaFaltasAutomaticamenteTrabajador(fecha, item);
                        }
                    }
                }

                if (sinregistrosenBD)
                {
                    //var modelocontrol = bd.Nomina_RelojChecadorControl.Where(s => DbFunctions.TruncateTime(s.FechaRegistro) == DbFunctions.TruncateTime(fecha)
                    //&& s.IdEstructuraOrganica==IdEstructuraOrganicaReloj
                    //).FirstOrDefault();

                    //if (modelocontrol == null)
                    //{
                    //    Nomina_RelojChecadorControl controlito = new Nomina_RelojChecadorControl();
                    //    controlito.FechaRegistro = fecha;
                    //    controlito.IdEstructuraOrganica = (short)IdEstructuraOrganicaReloj;
                    //    controlito.ProcesoDeFaltasCompletado = true;
                    //    controlito.ProcesoIncidenciasCompletado = true;
                    //    controlito.TotalRegistros = 0;
                    //    controlito.TotalTrabajadores = faltaspersonalsinpermisos.Count;
                    //    bd.Entry(controlito).State = EntityState.Added;
                    //}
                }
                else
                {
                    foreach (var item in control)
                    {
                        var modelocontrol = bd.Nomina_RelojChecadorControl.Find(item.IdControlAsistencia);
                        modelocontrol.ProcesoDeFaltasCompletado = true;
                        bd.Nomina_RelojChecadorControl.Attach(modelocontrol);
                        bd.Entry(modelocontrol).State = EntityState.Modified;
                    }
                    

                }

                try
                {
                    bd.SaveChanges();
                }
                catch (Exception ex)
                {

                    throw;
                }
 
            }
        }

        private DateTime[] ObtenFechasIncioTerminoQuincenas(DateTime fecha)
        {
            DateTime[] fechas = new DateTime[2];

            var mes = fecha.Month;

            var qnas = bd.Catalogos_ctQuincenaMes.Where(x => x.Catalogos_ctMes.IdMes == mes).OrderBy(c => c.QuincenaMes).ToList();
            var dia = fecha.Day;

            if (fecha.Day > 15)
            {
                fechas[0] = new DateTime(fecha.Year, fecha.Month, 16);
                fechas[1] = new DateTime(fecha.Year, fecha.Month, DateTime.DaysInMonth(fecha.Year, fecha.Month));
            }
            else
            {
                fechas[0] = new DateTime(fecha.Year, fecha.Month, 1);
                fechas[1] = new DateTime(fecha.Year, fecha.Month, 15);
            }


            return fechas;
        }

        private void EditarGuardarIncidencia(int IdConvenioLaboralTrabajadorCategoria, DateTime FechaAsistencia, TiposdeIncidencia TipoIncidencia,bool hayfalta=false,int horas=0)
        {
            bdNovaEntities basenova = new bdNovaEntities();

            var existeregistro = basenova.IncidenciaPermiso_stIncidenciaTrabajador.Where(d => d.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria
              && DbFunctions.TruncateTime(d.FechaInicio) == DbFunctions.TruncateTime(FechaAsistencia)
              && d.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO")).FirstOrDefault();

            if (existeregistro != null && hayfalta == false)
            {
                basenova.Configuration.AutoDetectChangesEnabled = false;
                basenova.Configuration.ValidateOnSaveEnabled = false;
                
                if (horas > 0)
                    existeregistro.Horas = (short)horas;

                switch (TipoIncidencia)
                {
                    case TiposdeIncidencia.Retardo:
                        existeregistro.IdTipoIncidencia = idRetardo;

                        break;

                    case TiposdeIncidencia.RetardoPorHora:
                        existeregistro.IdTipoIncidencia = idRetardoPorHora;

                        break;

                    case TiposdeIncidencia.Falta:
                        existeregistro.IdTipoIncidencia = idFalta;

                        break;

                    case TiposdeIncidencia.FaltaPorRetardo:
                        existeregistro.IdTipoIncidencia = idFaltaRetardo;

                        break;

                    case TiposdeIncidencia.OmisionSalida:
                        existeregistro.IdTipoIncidencia = idOmisionSalida;

                        break;


                    case TiposdeIncidencia.FaltaPorHora:
                        existeregistro.IdTipoIncidencia = idFaltaPorHora;

                        break;

                    case TiposdeIncidencia.PrimaDominical:
                        existeregistro.IdTipoIncidencia = idPrimaDominical;

                        break;

                    case TiposdeIncidencia.DiasDescanso:
                        existeregistro.IdTipoIncidencia = idDiasDescanso;

                        break;

                    case TiposdeIncidencia.FaltaPorExcederPases:
                        existeregistro.IdTipoIncidencia = idFaltaPorExcederPases;

                        break;

                }

                existeregistro.NivelIncidenciaSistema = "EditarFalta";
                basenova.Entry(existeregistro).State = EntityState.Modified;

                try
                {
                    basenova.SaveChanges();
                }
                catch (Exception ex)
                {

                    var t = ex.Message;
                }
            }

            else
            {
                if (hayfalta==false)
                    GuardaIncidencia(IdConvenioLaboralTrabajadorCategoria, FechaAsistencia, TiposdeIncidencia.Falta,"EditarFaltaNueva");

            }

        }
        private void GuardaIncidencia(int IdConvenioLaboralTrabajadorCategoria, DateTime FechaAsistencia, TiposdeIncidencia TipoIncidencia, string nivel, int horas = 0,string tf=null,string cerrar=null,bool autorizar=false,string qna=null,string año=null)
        {
            bdNovaEntities basenova = new bdNovaEntities();


            IncidenciaPermiso_stIncidenciaTrabajador incidencia = new IncidenciaPermiso_stIncidenciaTrabajador();
            incidencia.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
            incidencia.FechaCreacion = DateTime.Now;
            incidencia.FechaInicio = FechaAsistencia;
            incidencia.FechaTermino = FechaAsistencia;
            incidencia.IdConvenioLaboralTrabajadorCategoriaRegistro = IdJefeRecursosHumanos;
            incidencia.IdIncidenciaJustificacion = 0;
            incidencia.NivelIncidenciaSistema= nivel;
            //incidencia.EsCerrada= false;

            if (cerrar == "1")
            {
                incidencia.EsCerrada=true;
            }
            if (autorizar == true)
            {
                incidencia.Autorizo= true;
                incidencia.IdConvenioLaboralTrabajadorCategoriaAutorizo=IdJefeRecursosHumanos;
                incidencia.FechaAutorizacion = DateTime.Now;
            }

            if (qna != null)
                incidencia.QuincenaParaNomina = qna;

            if (año!= null)
                incidencia.AñoParaNomina= Libraries.ConvertToInt.ConvertToInt16(año);


            if (horas > 0)
                incidencia.Horas = (short)horas;

            if (tf != null)
            {
                TimeSpan tiempofuera = TimeSpan.Parse(tf);
                incidencia.TiempoFuera =tiempofuera;
            }


            switch (TipoIncidencia)
            {
                case TiposdeIncidencia.Retardo:
                    incidencia.IdTipoIncidencia = idRetardo;
                    
                    break;  
                case TiposdeIncidencia.FaltaHoraClub:
                    incidencia.IdTipoIncidencia = idFaltaHoraClub;
                    
                    break;

                case TiposdeIncidencia.RetardoPorHora:
                    incidencia.IdTipoIncidencia = idRetardoPorHora;
                    
                    break;

                case TiposdeIncidencia.Falta:
                    incidencia.IdTipoIncidencia = idFalta;

                    break;

                case TiposdeIncidencia.FaltaPorRetardo:
                    incidencia.IdTipoIncidencia = idFaltaRetardo;

                    break;

                case TiposdeIncidencia.OmisionSalida:
                    incidencia.IdTipoIncidencia = idOmisionSalida;

                    break;


                case TiposdeIncidencia.FaltaPorHora:
                    incidencia.IdTipoIncidencia = idFaltaPorHora;

                    break;

                case TiposdeIncidencia.PrimaDominical:
                    incidencia.IdTipoIncidencia = idPrimaDominical;

                    break;

                case TiposdeIncidencia.DiasDescanso:
                    incidencia.IdTipoIncidencia = idDiasDescanso;

                    break;

                case TiposdeIncidencia.FaltaPorExcederPases:
                    incidencia.IdTipoIncidencia = idFaltaPorExcederPases;

                    break;

            }

            basenova.Configuration.AutoDetectChangesEnabled = false;
            basenova.Configuration.ValidateOnSaveEnabled = false;
            basenova.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidencia);

            try
            {
                basenova.SaveChanges();
                if (TipoIncidencia == TiposdeIncidencia.Retardo || TipoIncidencia == TiposdeIncidencia.RetardoPorHora)
                {
                    TrabajadoresConRetardos.Add(new TrabajadoresConRetardos { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria, Fecha = FechaAsistencia });
                }
            }
            catch (Exception ex)
            {

                var t = ex.Message;
            }

        }


    }

}