﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public class DateEndValue : ValidationAttribute
    {

        protected override ValidationResult IsValid(object value, ValidationContext validationContext)
        {
            if (value != null)
            {
                DateTime date = Convert.ToDateTime(value);
                if (date < DateTime.Now)
                {
                    return new ValidationResult("La fecha debe ser posterior a la fecha actual");

                }
            }
            return ValidationResult.Success;
        }
    }
}