﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;


using System.Drawing;
using System.Drawing.Imaging;
using System.IO;


namespace Nova.Models
{
    public class ValidationImageUpload : ValidationAttribute
    {
        protected override ValidationResult IsValid(object value, ValidationContext validationContext)
        {
            if (value != null)
            {

                string srcRealArchivo = (String)value;
                string tipoArchivo = srcRealArchivo.Substring(srcRealArchivo.LastIndexOf('.') + 1).ToLower();

                if (ValidaExtension("." + tipoArchivo) == true)
                {

                }
                else
                {
                    //return new ValidationResult("El archivo no es de tipo imagen : " + tipoArchivo);
                }

                //HttpPostedFileBase
                //if (IsFileTypeValid(ImagenUrl) == false)
                //{
                //    return new ValidationResult("El archivo no es de tipo imagen : ");
                //} 




            }
            else
            {
                return new ValidationResult("Seleccione una imagen");
            }
            return ValidationResult.Success;
        }

        private Boolean ValidaExtension(string sExtension)
        {
            Boolean rel = false;
            switch (sExtension)
            {
                case ".jpg":
                case ".jpeg":
                case ".png":
                case ".gif":

                    rel = true;
                    break;
                default:
                    rel = false;
                    break;

            }
            return rel;
        }



        /*Inicio de funciones para comprobar extension de archivo*/
        private bool IsFileTypeValid(HttpPostedFileBase file)
        {
            bool isValid = false;

            try
            {
                using (var img = Image.FromStream(file.InputStream))
                {
                    if (IsOneOfValidFormats(img.RawFormat))
                    {
                        isValid = true;
                    }
                }
            }
            catch
            {
                //Image is invalid
            }
            return isValid;
        }

        private bool IsOneOfValidFormats(ImageFormat rawFormat)
        {
            List<ImageFormat> formats = getValidFormats();

            foreach (ImageFormat format in formats)
            {
                if (rawFormat.Equals(format))
                {
                    return true;
                }
            }
            return false;
        }

        private List<ImageFormat> getValidFormats()
        {
            List<ImageFormat> formats = new List<ImageFormat>();
            formats.Add(ImageFormat.Png);
            formats.Add(ImageFormat.Jpeg);
            formats.Add(ImageFormat.Gif);
            //add types here
            return formats;
        }
        /*fin de las funciones para comprobar extension de archivo*/

    }

}