﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Models
{
    [MetadataType(typeof(PortalCicloEscolarMetaData))]
    public partial class Portal_CicloEscolar
    {
    }
    public class PortalCicloEscolarMetaData
    {
        public object IdCicloEscolar { get; set; }
        //[Display(Name = "Ciclo Escolar")]
        //[Required(ErrorMessage = "Ciclo escolar es requerido")]
        //[MaxLength(150, ErrorMessage = "No puede superar los {1} caracteres")]
        //[MinLength(5, ErrorMessage = "Ingrese mínimo {1} caracteres")]
        //public object NombreCicloEscolar { get; set; }

        [Display(Name = "Inicio del Ciclo Escolar")]
        [Required(ErrorMessage = "Fecha de inicio requerido")]

        public object FechaInicioCiclo { get; set; }
        [Display(Name = "Termino del Ciclo Escolar")]
        [Required(ErrorMessage = "Fecha de termino requerido")]

        public object FechaTerminoCiclo { get; set; }
        public object EntregaFichaInicio { get; set; }
        public object EntregaFichaFin { get; set; }
        [Display(Name = "Inscripciones - Reinscripciones")]
        [Required(ErrorMessage = "Las fechas son requeridas")]

        public object InicioInscipcionReinscripcion { get; set; }
        [Display(Name = "Inscripciones - Reinscripciones")]
        [Required(ErrorMessage = "Las fechas son requeridas")]

        public object FinInscripcionReinscripcion { get; set; }
        [Display(Name = "Requisitos de Nuevo Ingreso")]
        [Required(ErrorMessage = "Los requisitos son requeridos")]
        [AllowHtml]
        [MinLength(5, ErrorMessage = "Ingrese mínimo {1} caracteres")]
        public object RequisitosNuevoIngreso { get; set; }
        [Display(Name = "Calendario Escolar")]
        [Required(ErrorMessage = "El calendario es requerido")]
        public object CalendarioUrl { get; set; }
    }
}