﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using Nova.Models;
using System.Web.Mvc;


namespace Nova.Models
{
    [MetadataType(typeof(PortalArticulosMetaData))]
    public partial class Portal_Articulos
    {
    }
    public class PortalArticulosMetaData
    {
        [Display(Name="Articulo")]
        [Required(ErrorMessage = "Asigne un nombre de Artículo")]
        [MaxLength(250, ErrorMessage = "No puede superar los {1} caracteres")]
        [MinLength(5, ErrorMessage = "Ingrese mínimo {1} caracteres")]
        public object NombreArticulo { get; set; }

        public object FechaCreacion { get; set; }

        [Display(Name="Fecha termino")]
        //[DateEndValue(ErrorMessage = "Fecha incorrecta")]
        //[DisplayFormat(ApplyFormatInEditMode = true, DataFormatString = "{0:dd/MM/yyyy}")]
        //public object FechaTermino { get; set; }

        [Required(ErrorMessage="Ingrese una breve descripción")]
        [MaxLength(5000, ErrorMessage = "No puede superar los {1} caracteres")]
        [MinLength(10, ErrorMessage = "Ingrese mínimo {1} caracteres")]
        public object Descripcion { get; set; }

        [Required(ErrorMessage = "Imgrese contenido al artículo")]
        [AllowHtml] 
        public object Contenido { get; set; }

        [Display(Name="Imagen intro")]
        [Required(ErrorMessage="Eliga una imagen")]
        [MaxLength(150, ErrorMessage = "No puede superar los {1} caracteres")]
        [MinLength(3, ErrorMessage = "Ingrese mínimo {1} caracteres")]
        public object ImagenUrl { get; set; }

        [Required]
        public object IdTipoArticulo { get; set; }


        [Display(Name="Url externo")]
        [Url(ErrorMessage = "Dirección URL no válida")]
        [MaxLength(1000, ErrorMessage = "No puede superar los {1} caracteres")]
        [MinLength(5, ErrorMessage = "Ingrese mínimo {1} caracteres")]
        public object UrlExterno { get; set; }
    }
}