﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using Nova.Models;

namespace Nova.Models
{
    [MetadataType(typeof(PortalAnexosMetaData))]
    public partial class Portal_ArticulosAnexos
    {
    }
    public class PortalAnexosMetaData
    {
        [Display(Name="Anexo")]
        [Required(ErrorMessage="Asigne un nombre")]
        [MaxLength(150, ErrorMessage = "No puede superar los {1} caracteres")]
        [MinLength(5, ErrorMessage = "Ingrese mínimo {1} caracteres")]
        public object NombreAnexo { get; set; }


        [Display(Name="Archivo")]
        [Required(ErrorMessage="Seleccione un archivo")]
        [MaxLength(150, ErrorMessage = "No puede superar los {1} caracteres")]
        [MinLength(2, ErrorMessage = "Ingrese mínimo {1} caracteres")]
        public object ArchivoUrl { get; set; }

        [Display(Name="Articulo")]
        [Required]
        public object IdArticulo { get; set; }

    }
}