﻿using Nova.Models;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Libraries;
using Dapper;
using System.Text;
namespace Nova.Models
{


    public sealed class NoticiasSingleton
    {

        private static volatile NoticiasSingleton instance;
        private static object syncRoot = new Object();


        public List<Portal_Articulos> Ultimas10Noticias;
        public List<Portal_Articulos> NoticiasVigentes;
        public List<Portal_Articulos> NoticiasVigentesComunicacionSocial;
        public List<Portal_Articulos> AvisosVigentes;
        public List<Portal_Articulos> ConvocatoriasVigentes;

        public List<Portal_Categoria> Categorias;

        

        public bool regenerar = false;


        public void getUltimas10Noticias()
        {
            bdNovaEntities bd = new bdNovaEntities();
            Ultimas10Noticias = bd.Portal_Articulos.Where(n =>
                                                        (n.Portal_TipoArticulo.TipoArticulo == "NOTICIAS" &&
                                                        n.Publicar == true) &&
                                                        (n.FechaTermino == null || n.FechaTermino >= DateTime.Now)
                                                        ).OrderByDescending(o => o.IdArticulo).Take(7).ToList();


        }

        public void getNoticiasVigentesComunicacionSocial()
        {
            bdNovaEntities bd = new bdNovaEntities();

            DateTime fechax= Convert.ToDateTime("01/01/2017");
            Categorias = bd.Portal_Categoria.ToList();

            NoticiasVigentesComunicacionSocial = bd.Portal_Articulos.Where(a =>
                                                (
                                                a.Publicar == true &&
                                                a.Portal_TipoArticulo.TipoArticulo == "NOTICIAS") &&
                                                (a.FechaCreacion >= fechax)
                                                ).ToList();

        }


        public void getNoticiasVigentes()
        {
            bdNovaEntities bd = new bdNovaEntities();

            
            Categorias= bd.Portal_Categoria.ToList();

            NoticiasVigentes= bd.Portal_Articulos.Where(a =>
                                                ( 
                                                a.Publicar == true &&
                                                a.Portal_TipoArticulo.TipoArticulo == "NOTICIAS") &&
                                                (a.FechaTermino == null || a.FechaTermino >= DateTime.Now)
                                                ).ToList();


        }
        public void getAvisosVigentes()
        {
            bdNovaEntities bd = new bdNovaEntities();


            Categorias = bd.Portal_Categoria.ToList();

            AvisosVigentes = bd.Portal_Articulos.Where(a =>
                                                (
                                                a.Publicar == true &&
                                                a.Portal_TipoArticulo.TipoArticulo == "AVISOS") &&
                                                (a.FechaTermino == null || a.FechaTermino >= DateTime.Now)
                                                ).ToList();


        }
        public void getConvocatoriasVigentes()
        {
            bdNovaEntities bd = new bdNovaEntities();


            Categorias = bd.Portal_Categoria.ToList();

            ConvocatoriasVigentes = bd.Portal_Articulos.Where(a =>
                                                (
                                                a.Publicar == true &&
                                                a.Portal_TipoArticulo.TipoArticulo == "CONVOCATORIAS") &&
                                                (a.FechaTermino == null || a.FechaTermino >= DateTime.Now)
                                                ).ToList();


        }


        private NoticiasSingleton()
        {


            getUltimas10Noticias();
            getNoticiasVigentes();
            getNoticiasVigentesComunicacionSocial();
            getConvocatoriasVigentes();
            getAvisosVigentes();


        }

        public  void Reset()
        {
            instance.getUltimas10Noticias();
            instance.getNoticiasVigentes();
            instance.getNoticiasVigentesComunicacionSocial();
            instance.getConvocatoriasVigentes();
            instance.getAvisosVigentes();
        }
         
        public static NoticiasSingleton Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new NoticiasSingleton();
                    }
                }
                else
                {
                    if (DateTime.Now.Day == 1)
                    {
                        if (instance.regenerar == false)
                        {
                            // instance = new NoticiasSingleton();
                            
                            instance.getUltimas10Noticias();
                            instance.getNoticiasVigentes();
                            instance.getNoticiasVigentesComunicacionSocial();
                            instance.getConvocatoriasVigentes();
                            instance.getAvisosVigentes();
                            instance.regenerar = true;
                        }
                    }
                    else
                    {
                        instance.regenerar = false;
                    }
                }

                return instance;
            }
        }




    }
}