﻿using Nova.Models;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Libraries;
using Dapper;
using System.Text;
namespace Nova.Models
{
   

    public sealed class CuadroHonor
    {

        private static volatile CuadroHonor instance;
        private static object syncRoot = new Object();


        public List<stAlumnosFotos> alumnosDestacados;

        public bool regenerar=false;
        

        public void getAlumnos()
        {

            // var curps = alumnos.Select(r => r.Curp).ToArray();
            String curps = "";
            List<Nova.Models.Portal_AlumnosDestacados> alumnos = Nova.Models.PortalNovaAries.getHonoresAlumnos();
            foreach (var item in alumnos)
            {
                curps = curps + "'" + item.Curp + "',";
            }
            curps = curps.Substring(0, curps.Length - 1);

            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string query;
            byte[] w = null;
            query = @"SELECT curp,foto,TipoImagen,Qrcodigo FROM stAlumnosFotos 
where  Curp in (" + curps + ") ";


            List<stAlumnosFotos> alumnosconfoto = (List<stAlumnosFotos>)dp.connection.Query<stAlumnosFotos>(query);

            alumnosDestacados = alumnosconfoto;





        }

        private CuadroHonor()
        {
            

            getAlumnos();


        }

        public static CuadroHonor Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new CuadroHonor();
                    }
                }
                else
                {
                    if (DateTime.Now.Day == 1)
                    {
                        if (instance.regenerar == false)
                        {
                            // instance = new CuadroHonor();
                            instance.getAlumnos();
                            instance.regenerar = true;
                        }
                    }
                    else
                    {
                        instance.regenerar = false;
                    }
                   }
                
                return instance;
            }
        }

      


    }
}