﻿using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Dapper;
using System.Web.UI;
using System.Net.Mail;
using System.Net;
using System.Text;
using System.Net.Mime;

namespace Nova.Models
{

    public class PoaMirHistorialEstatus
    {
        public short IdMirHistorialEstatus { get; set; }
        public System.DateTime FechaEstatus { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int IdMir { get; set; }
        public short IdMirEstatus { get; set; }
        public string ObservacionEstatus { get; set; }
        public string EstatusMir { get; set; }

    }
    public class PoaMirEstructura
    {
        public List<PoaMirElementos> PoaMirElementos { get; set; }

        public List<PoaMirDetalle> PoaMirDetalle { get; set; }

        public List<PoaMirHistorialEstatus> PoaMirHistorialEstatus { get; set; }



        public int NumberPages { get; set; }
        public int RecordsPerPage { get; set; }
        public int PageNumber { get; set; }
        public string Proyecto { get; set; }
        public string Area { get; set; }
        public string Usuario { get; set; }
        public string RolUsuario { get; set; }
        public string TipoElementoObjetivos { get; set; }
        public decimal PrespuestoTotal { get; set; }
        public decimal PrespuestoEjercido { get; set; }
        public decimal PrespuestoDisponible { get; set; }
        public int AñoVigente { get; set; }

    }
    public class PoaMirElementos
    {
        //public int RowNumber { get; set; }


        public int IdMir { get; set; }
        public int IdProyectos { get; set; }

        public string ResumenNarrativo { get; set; }
        public int Numero { get; set; }
        public string Proyecto { get; set; }
        public string AreaCreadora { get; set; }
        public string TipoElementoObjetivos { get; set; }

        public string NombreUsuarioArea { get; set; }
        public string ApellidoPaternoUsuarioArea { get; set; }
        public string ApellidoMaternoUsuarioArea { get; set; }

        public int IdConvenioLaboralTrabajadorCategoriaArea { get; set; }



        public string NombreUsuarioResponsable { get; set; }
        public string ApellidoPaternoUsuarioResponsable { get; set; }
        public string ApellidoMaternoUsuarioResponsable { get; set; }
        public string AreaResponsable { get; set; }

        public int IdConvenioLaboralTrabajadorCategoriaResponsable { get; set; }
        public int IdProyectoArbol { get; set; }
        public int IdPadreElementoObjetivos { get; set; }
        public int OrdenMir { get; set; }
        public int IdTipoElementoObjetivos { get; set; }
        public string EstatusMir { get; set; }



        public string Fin { get; set; }
        public string Proposito { get; set; }
        public string Componente { get; set; }
        public string Actividad { get; set; }
        public int MirCompleta { get; set; }
        public int TotalIndicadoresMir { get; set; }



        public bool Editable { get; set; }

    }

    public class PoaMirDetalle
    {
        //public int RowNumber { get; set; }



        public int IdMir { get; set; }
        public int IdProyectos { get; set; }

        public string ResumenNarrativo { get; set; }
        public int Numero { get; set; }
        public string Proyecto { get; set; }
        public string AreaCreadora { get; set; }
        public string TipoElementoObjetivos { get; set; }

        public string NombreUsuarioArea { get; set; }
        public string ApellidoPaternoUsuarioArea { get; set; }
        public string ApellidoMaternoUsuarioArea { get; set; }

        public int IdConvenioLaboralTrabajadorCategoriaArea { get; set; }



        public string NombreUsuarioResponsable { get; set; }
        public string ApellidoPaternoUsuarioResponsable { get; set; }
        public string ApellidoMaternoUsuarioResponsable { get; set; }
        public string AreaResponsable { get; set; }

        public int IdConvenioLaboralTrabajadorCategoriaResponsable { get; set; }



        public string Fin { get; set; }
        public string Proposito { get; set; }
        public string Componente { get; set; }
        public string Actividad { get; set; }
        public string EstatusMir { get; set; }
        public short IdMirEstatus { get; set; }
        public int IdIndicadores { get; set; }
        public int MetaAnualNumerador { get; set; }

    }


    public class PoaMir
    {
        private string BodyMail(string Titulo, string Mensaje, string _Usuario, string _Componente, string _Fecha)
        {




            string cadena = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional //Es' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'><html xmlns='http://www.w3.org/1999/xhtml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:o='urn:schemas-microsoft-com:office:office'><head>
  <!--[if gte mso 9]><xml>
   <o:OfficeDocumentSettings>
    <o:AllowPNG/>
    <o:PixelsPerInch>96</o:PixelsPerInch>
   </o:OfficeDocumentSettings>
  </xml><![endif]-->
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
  <meta name='viewport' content='width=device-width'>
  <meta http-equiv='X-UA-Compatible' content='IE=9; IE=8; IE=7; IE=EDGE'>
  <title>Cecyteo</title>
  
  
  <style id='media-query'>
    /* Client-specific Styles & Reset */
    #outlook a {
        padding: 0;
    }

    /* .ExternalClass applies to Outlook.com (the artist formerly known as Hotmail) */
    .ExternalClass {
        width: 100%;
    }

    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
        line-height: 100%;
    }

    #backgroundTable {
        margin: 0;
        padding: 0;
        width: 100% !important;
        line-height: 100% !important;
    }

    /* Buttons */
    .button a {
        display: inline-block;
        text-decoration: none;
        -webkit-text-size-adjust: none;
        text-align: center;
    }

    .button a div {
        text-align: center !important;
    }

    /* Outlook First */
    body.outlook p {
        display: inline !important;
    }

    a[x-apple-data-detectors] {
  color: inherit !important;
  text-decoration: none !important;
  font-size: inherit !important;
  font-family: inherit !important;
  font-weight: inherit !important;
  line-height: inherit !important; }

.btn {
	background-color:#12b317;
	-moz-border-radius:28px;
	-webkit-border-radius:28px;
	border-radius:28px;
	border:1px solid #18ab29;
	display:inline-block;
	cursor:pointer;
	color:#ffffff;
	font-family:Arial;
	font-size:17px;
	padding:16px 31px;
	text-decoration:none;
	text-shadow:0px 1px 0px #2f6627;
}
.btn:hover {
	background-color:#5cbf2a;
}
.btn:active {
	position:relative;
	top:1px;
}

/*  Media Queries */
@media only screen and (max-width: 500px) {
  table[class='body'] img {
    height: auto !important;
    width: 100% !important; }
  table[class='body'] img.fullwidth {
    max-width: 100% !important; }
  table[class='body'] center {
    min-width: 0 !important; }
  table[class='body'] .container {
    width: 95% !important; }
  table[class='body'] .row {
    width: 100% !important;
    display: block !important; }
  table[class='body'] .wrapper {
    display: block !important;
    padding-right: 0 !important; }
  table[class='body'] .columns, table[class='body'] .column {
    table-layout: fixed !important;
    float: none !important;
    width: 100% !important;
    padding-right: 0px !important;
    padding-left: 0px !important;
    display: block !important; }
  table[class='body'] .wrapper.first .columns, table[class='body'] .wrapper.first .column {
    display: table !important; }
  table[class='body'] table.columns td, table[class='body'] table.column td, .col {
    width: 100% !important; }
  table[class='body'] table.columns td.expander {
    width: 1px !important; }
  table[class='body'] .right-text-pad, table[class='body'] .text-pad-right {
    padding-left: 10px !important; }
  table[class='body'] .left-text-pad, table[class='body'] .text-pad-left {
    padding-right: 10px !important; }
  table[class='body'] .hide-for-small, table[class='body'] .show-for-desktop {
    display: none !important; }
  table[class='body'] .show-for-small, table[class='body'] .hide-for-desktop {
    display: inherit !important; }
  .mixed-two-up .col {
    width: 100% !important; } }
 @media screen and (max-width: 500px) {
      div[class='col'] {
          width: 100% !important;
      }
    }

    @media screen and (min-width: 501px) {
      table[class='container'] {
          width: 500px !important;
      }
    }
  </style>
</head>
<body style='width: 100% !important;min-width: 100%;-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100% !important;margin: 0;padding: 0;background-color: #FFFFFF'>
  <table cellpadding='0' cellspacing='0' width='100%' class='body' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;height: 100%;width: 100%;table-layout: fixed'>
      <tbody><tr style='vertical-align: top'>
          <td class='center' align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;background-color: #FFFFFF'>

              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #EDEDED'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid two-up' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 5px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
    <tbody><tr style='vertical-align: top'>
        <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;width: 100%;padding-top: 0px;padding-right: 0px;padding-bottom: 0px;padding-left: 0px'>
            <div align='center' style='font-size:12px'>
                <a href='https://www.cecyteo.edu.mx' target='_blank'>
                    <img class='center' align='center' border='0' src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/icons/logo.png' alt='Image' title='Image' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;margin: 0 auto;float: none;width: 100% !important;max-width: 174px' width='174'>
                </a>

            </div>
        </td>
    </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='250' style='width:250px;'><![endif]--><div class='col num6' style='display: inline-block;vertical-align: top;text-align: center;width: 250px'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 20px;padding-right: 0px;padding-bottom: 20px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 20px;padding-right: 10px;padding-bottom: 20px;padding-left: 10px'>
      <div style='color:#6E6F7A;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#6E6F7A;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><div style='text-align: right; line-height:18px; font-size:12px;'><strong><span style='font-size: 16px; line-height: 24px;'>Colegio de Estudios Científicos y Tecnológicos del Estado de Oaxaca</span></strong></div></div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #BBBBBB'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 25px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#ffffff;line-height:120%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:14px;font-size:12px;color:#ffffff;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'><p style='margin: 0;font-size: 18px;line-height: 22px;text-align: center'><span style='font-size: 24px; line-height: 28px;'><strong>" + Titulo + @"</strong></span></p></div>
        <div style='line-height:14px;font-size:12px;color:#ffffff;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'>
            <p style='margin: 0;font-size: 11px;text-align: center'><span style='font-size: 11px; line-height: 12px;'><strong>" + Mensaje + @"</strong></span></p>
            <p style='margin: 0;font-size: 11px;text-align: center'> Usuario: " + _Usuario + @"</p>
            <p style='margin: 0;font-size: 11px;text-align: center'> Componenete: " + _Componente + @"</p>
            <p style='margin: 0;font-size: 11px;text-align: center'> Fecha: " + _Fecha + @"</p>
        </div>
      </div>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 0px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#000;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	
      </div>
    </td>
  </tr>
</tbody></table>
 
<table align='center' width='100%' border='0' cellpadding='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='height: 0px;'>
        <table align='center' border='0' cellspacing='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;border-top: 0px solid transparent;width: 100%'><tbody><tr style='vertical-align: top'><td align='center' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'></td></tr></tbody></table>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
              <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
                <tbody><tr style='vertical-align: top'>
                  <td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: #ffffff'>
                    <!--[if gte mso 9]>
                    <table id='outlookholder' border='0' cellspacing='0' cellpadding='0' align='center'><tr><td>
                    <![endif]-->
                    <!--[if (IE)]>
                    <table width='500' align='center' cellpadding='0' cellspacing='0' border='0'>
                        <tr>
                            <td>
                    <![endif]-->
                    <table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' class='container' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit'><tbody><tr style='vertical-align: top'><td width='100%' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'><table cellpadding='0' cellspacing='0' width='100%' bgcolor='transparent' class='block-grid ' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;width: 100%;max-width: 500px;color: #333;background-color: transparent'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;text-align: center;font-size: 0'><!--[if (gte mso 9)|(IE)]><table width='100%' align='center' bgcolor='transparent' cellpadding='0' cellspacing='0' border='0'><tr><![endif]--><!--[if (gte mso 9)|(IE)]><td valign='top' width='500' style='width:500px;'><![endif]--><div class='col num12' style='display: inline-block;vertical-align: top;width: 100%'><table cellpadding='0' cellspacing='0' align='center' width='100%' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'><tbody><tr style='vertical-align: top'><td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;background-color: transparent;padding-top: 30px;padding-right: 0px;padding-bottom: 30px;padding-left: 0px;border-top: 0px solid transparent;border-right: 0px solid transparent;border-bottom: 0px solid transparent;border-left: 0px solid transparent'><table width='100%' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
      <table border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
        <tbody><tr style='vertical-align: top'>
          <td align='center' valign='top' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: center;padding-top: 10px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px;max-width: 114px'>

            <!--[if (gte mso 9)|(IE)]>
            <table width='94' align='left' border='0' cellspacing='0' cellpadding='0'>
              <tr>
                <td align='left'>
            <![endif]-->
            <table width='100%' align='left' cellpadding='0' cellspacing='0' border='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
              <tbody><tr style='vertical-align: top'>
                <td align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>


                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='https://www.facebook.com/CECyTEOaxaca' title='Facebook' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/facebook.png' alt='Facebook' title='Facebook' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>
                  <table align='left' border='0' cellspacing='0' cellpadding='0' style='border-spacing: 0;border-collapse: collapse;vertical-align: top;padding: 0 5px 5px 0' height='37'>
                    <tbody><tr style='vertical-align: top'>
                      <td width='37' align='left' valign='middle' style='word-break: break-word;border-collapse: collapse !important;vertical-align: top'>
                        <a href='http://twitter.com/cecyteoaxaca' title='Twitter' target='_blank'>
                          <img src='https://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/twitter.png' alt='Twitter' title='Twitter' width='32' style='outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block;border: none;height: auto;line-height: 100%;max-width: 32px !important'>
                        </a>
                      </td>
                    </tr>
                  </tbody></table>

                </td>
              </tr>
            </tbody></table>
            <!--[if (gte mso 9)|(IE)]>
                </td>
              </tr>
            </table>
            <![endif]-->
          </td>
        </tr>
      </tbody></table>
    </td>
  </tr>
</tbody></table>
<table cellpadding='0' cellspacing='0' width='100%' style='border-spacing: 0;border-collapse: collapse;vertical-align: top'>
  <tbody><tr style='vertical-align: top'>
    <td style='word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-top: 15px;padding-right: 10px;padding-bottom: 10px;padding-left: 10px'>
      <div style='color:#959595;line-height:150%;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;'>
      	<div style='line-height:18px;font-size:12px;color:#959595;font-family:Arial, 'Helvetica Neue', Helvetica, sans-serif;text-align:left;'>
          <p style='margin: 0;font-size: 12px;line-height: 21px;text-align: center'>Este correo ha sido generado de forma automática.</p>
              <p style='margin: 0;font-size: 14px;line-height: 21px;text-align: center'>Gobierno del Estado de Oaxaca.</p>
          </div>
      </div>
    </td>
  </tr>
</tbody></table>
</td></tr></tbody></table></div><!--[if (gte mso 9)|(IE)]></td><![endif]--><!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]--></td></tr></tbody></table></td></tr></tbody></table>
                    <!--[if mso]>
                    </td></tr></table>
                    <![endif]-->
                    <!--[if (IE)]>
                    </td></tr></table>
                    <![endif]-->
                  </td>
                </tr>
              </tbody></table>
          </td>
      </tr>
  </tbody></table>


</body></html>";
            AlternateView plainView =
     AlternateView.CreateAlternateViewFromString(cadena,
                             Encoding.UTF8,
                             MediaTypeNames.Text.Html);
            //byte[] bytes = Encoding.Default.GetBytes(cadena);
            //cadena = Encoding.UTF8.GetString(bytes);
            return cadena;
        }


        public List<Convenios_stConvenioLaboralTrabajadorCategoria> AdministradoresPoa()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"select  a.IdConvenioLaboralTrabajadorCategoria
      ,a.IdConvenioLaboralTrabajador
      ,xd.IdDistribucionPlazaCategoria
      ,xd.IdEstructuraOrganica
      ,xd.EsComisionado
      ,a.FechaInicio
      ,a.FechaTermino
      ,EsCancelado
      ,UserId
      ,FechaCreacion
      ,Observacion
      ,a.EsCuotaSindical
      ,a.FechaCuotaSindical 

 from Convenios_stConvenioLaboralTrabajadorCategoria a
inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador c on c.IdTrabajador=b.IdTrabajador
inner join vwDatosAspirantesTrabajadores xd on xd.IdKardex = c.IdKardex
where c.IdKardex in (
SELECT  IdKardex
  FROM [bdNova].[dbo].[GrupoRolAplicacion] a
  inner join AccesoRolAplicacion b on a.IdAccesoRolAplicacion=b.IdAccesoRolAplicacion
  inner join RolAplicacion c on c.IdRolAplicacion=b.IdRolAplicacion
  inner join Rol d on d.IdRol=c.IdRol
 inner join GrupoRolAplicacionUsuarioKardex e on e.IdGrupo=a.IdGrupo
 inner join UsuarioKardex f on f.IdUsuarioKardex=e.IdUsuarioKardex

  where d.Rol='PoaAdministrador'
  group by IdKardex
  ) and xd.EstatusTrabajador = 'ALTA' and xd.RestringirMenu is null";
            List<Convenios_stConvenioLaboralTrabajadorCategoria> admninistradores = (List<Convenios_stConvenioLaboralTrabajadorCategoria>)dp.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria>(query);

            dp.Close();
            bdNovaEntities bd = new bdNovaEntities();
            var array = admninistradores.Select(y => y.IdConvenioLaboralTrabajadorCategoria).ToArray();
            List<Convenios_stConvenioLaboralTrabajadorCategoria> resultado = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => array.Contains(f.IdConvenioLaboralTrabajadorCategoria)).ToList();

            return resultado;
        }


        public void NuevaActividadMail(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();
            var mir = bd.Poa_Mir.Find(id);

            string titulo = "";
            List<Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria> listadestinatarios = new List<Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria>();


            listadestinatarios = this.AdministradoresPoa();

            titulo = "Nueva actividad en la MIR";
            string remite = "<p><strong>Envía: " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "</strong></p>";
            string descripcion = " <p>Proyecto: " + mir.Poa_ProyectoArbol.Poa_Proyectos.Proyecto + " </p> <p>Area :" + mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica + " </p><p>Responsable " + mir.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + mir.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + mir.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "</p><p>" + mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos + ": " + mir.ResumenNarrativo + "</p><p>Estatus: " + mir.Poa_MirEstatus.EstatusMir + "</p><p>" + DateTime.Now.ToString() + "</p>";
            remite = remite + descripcion;


            string _Usuario = mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            int idProyectoArbol = mir.Poa_ProyectoArbol.IdPadreElementoObjetivos;
            string _Componente = bd.Poa_Mir.Where(t => t.IdProyectoArbol == idProyectoArbol).Select(s => s.ResumenNarrativo).FirstOrDefault();
            

            var bander = this.EnviarNotificacionMail(titulo, remite, listadestinatarios, _Usuario, _Componente, DateTime.Now.ToShortDateString());

        }


        public void CambioStatuslMail(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();
            //PoaMir poamir = new PoaMir();

            var mir = bd.Poa_Mir.Find(id);

            string titulo = "";
            List<Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria> listadestinatarios = new List<Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria>();
            // var t1 = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => f.IdConvenioLaboralTrabajadorCategoria == 1764).FirstOrDefault();

            if (mir.Poa_MirEstatus.EsAdministrador == false)
            {
                listadestinatarios = this.AdministradoresPoa();

                titulo = "Respuesta de solicitud de cambio de estatus";
                //listadestinatarios.Add(t1);
                //listadestinatarios.Add(bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => f.IdConvenioLaboralTrabajadorCategoria == 1889).FirstOrDefault());
            }
            else
            {
                listadestinatarios.Add(mir.Convenios_stConvenioLaboralTrabajadorCategoria);
                listadestinatarios.Add(mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria);
                titulo = "Cambio de Estatus MIR";

                //listadestinatarios.Add(bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => f.IdConvenioLaboralTrabajadorCategoria == 1889).FirstOrDefault());
            }
            //string
            string remite = "<p><strong>Envía: " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "</strong></p>";
            string descripcion = remite + " <p>Proyecto: " + mir.Poa_ProyectoArbol.Poa_Proyectos.Proyecto + " </p> ";
            //+ mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica + " </p><p>Responsable " + mir.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + mir.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + mir.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "</p><p>" + mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos + ": " + mir.ResumenNarrativo + "</p><p>Estatus: " + mir.Poa_MirEstatus.EstatusMir + "</p><p>" + DateTime.Now.ToString()+"</p>";


            //Convenios_stConvenioLaboralTrabajadorCategoria cltc = new Models.Convenios_stConvenioLaboralTrabajadorCategoria();
            string _Usuario = mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            int idProyectoArbol = mir.Poa_ProyectoArbol.IdPadreElementoObjetivos;
            string _Componente = bd.Poa_Mir.Where(t => t.IdProyectoArbol == idProyectoArbol).Select(s => s.ResumenNarrativo).FirstOrDefault();




            var bander = this.EnviarNotificacionMail(titulo, descripcion, listadestinatarios, _Usuario, _Componente, DateTime.Now.ToShortDateString());

        }

        public bool EnviarNotificacionMail(string Titulo, string Mensaje, List<Convenios_stConvenioLaboralTrabajadorCategoria> Destinatarios,string _Usuario, string _Componente, string _Fecha)
        {

            Nova.Models.Credenciales model = new Nova.Models.Credenciales();
            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");

            foreach (var item in Destinatarios)
            {
                msg.To.Add(item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico);
            }

            //msg.Bcc.Add("juan.carlos.manuel@cecyteo.edu.mx");
            //msg.Bcc.Add("roberv89@hotmail.com");

            msg.Subject = Titulo;
            msg.IsBodyHtml = true;


            msg.Body = this.BodyMail(Titulo, Mensaje, _Usuario,_Componente,_Fecha);


            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false;
            bool seenvio = true;
            try
            {
                client.Send(msg);


            }
            catch (Exception)
            {
                seenvio = false;
                // regresa = false;
                //throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }

            return seenvio;
        }

        public string setRol()
        {
            string rol = "";
            if (EsAdministrador())
                rol = "Administrador";
            else

                if (EsMandoMedio())
                rol = "Responsable";
            else
                if (AccesoAlCalendario() > 0)
                rol = "Usuario";


            return rol;
        }

        public bool EsMandoMedio()
        {
            var rol = Seguridad.Identidad.Roles().Where(f => f.RoleName == "PoaResponsable").FirstOrDefault();
            if (rol != null)
            {

                return true;
            }
            else
                return false;

        }


        public bool EsAdministrador()
        {
            var rol = Seguridad.Identidad.Roles().Where(f => f.RoleName == "PoaAdministrador").FirstOrDefault();
            if (rol != null)
            {
                return true;
            }
            else
                return false;

        }

        public bool TieneIndicadoresAsignados(int año)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            // int idusuario = 42;

            query = @"select count(j.IdIndicadores) as Total
  FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol = b.IdProyectoArbol
  inner join Poa_Proyectos c on c.IdProyectos = a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos = a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador = g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex = h.IdKardex
  inner join Poa_Indicadores j on j.IdMir = b.IdMir
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador = j.IdFrecuenciaMedicionIndicador
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador = d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador = g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex = h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica = d2.IdEstructuraOrganica
   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador = j.IdSentidoIndicador
  where año =" + año + "  and j.IdConvenioLaboralTrabajadorCategoria = " + idusuario;

            int existe = dp.connection.ExecuteScalar<int>(query);


            dp.Close();

            if (existe == 0)
            {
                return false;
            }
            return true;
        }


        private int AccesoAlCalendario()
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @" SELECT Año from  Poa_SistemaAñoVigente";

            int añoviogente = dp.connection.ExecuteScalar<int>(query);

            if (añoviogente == 0)
            {
                dp.Close();
                throw new ApplicationException("El Administrador del sistema no ha configurado el año vigente para el sistema.");
            }


            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            // int idusuario = 42;

            query = @"select count(j.IdIndicadores) as Total
  FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol = b.IdProyectoArbol
  inner join Poa_Proyectos c on c.IdProyectos = a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos = a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador = g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex = h.IdKardex
  inner join Poa_Indicadores j on j.IdMir = b.IdMir
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador = j.IdFrecuenciaMedicionIndicador
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria = j.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador = d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador = g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex = h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica = d2.IdEstructuraOrganica
   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador = j.IdSentidoIndicador
  where b.AñoMir=" + añoviogente + "  and j.IdConvenioLaboralTrabajadorCategoria = " + idusuario;





            int existe = dp.connection.ExecuteScalar<int>(query);


            dp.Close();

            if (existe == 0)
            {
                throw new ApplicationException("No existen indicadores asignados a Usted, favor de validarlo con el responsable de su Área.");
            }
            return idusuario;
        }
        public string AltaRolUsuario(int idconveniolaboraltrabajadorcateroria, bdNovaEntities basedatos)
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @" select a.IdUsuarioKardex from UsuarioKardex a
            inner join Kardex_ctTrabajador b on a.IdKardex = b.IdKardex
            inner join Convenios_stConvenioLaboralTrabajador c on b.IdTrabajador = c.IdTrabajador
            inner join Convenios_stConvenioLaboralTrabajadorCategoria d on c.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
            where IdConvenioLaboralTrabajadorCategoria = " + idconveniolaboraltrabajadorcateroria;

            int UsuarioKardex = dp.connection.ExecuteScalar<int>(query);
            dp.Close();
            if (UsuarioKardex == 0)
            {
                return "OK";
            }



            query = @"select b.* from GrupoRolAplicacionUsuarioKardex a
                    inner join UsuarioKardex b on a.IdUsuarioKardex = b.IdUsuarioKardex
                    inner join GrupoRolAplicacion c on a.IdGrupo = c.IdGrupo
                    inner join Grupo d on c.IdGrupo = d.IdGrupo
                    where a.IdUsuarioKardex=" + UsuarioKardex + " and (d.Grupo='GUsuarioPoa' or d.Grupo='GResponsablePoa')";





            var existeusuariopoa = dp.connection.Query<UsuarioKardex>(query);


            dp.Close();

            if (existeusuariopoa == null)
            {


                try
                {
                    GrupoRolAplicacionUsuarioKardex uk = new GrupoRolAplicacionUsuarioKardex();
                    uk.IdGrupo = basedatos.Grupo.Where(g => g.Grupo1 == "GUsuarioPoa").FirstOrDefault().IdGrupo;
                    uk.IdUsuarioKardex = UsuarioKardex;
                    basedatos.GrupoRolAplicacionUsuarioKardex.Add(uk);

                }
                catch (Exception e)
                {
                    var mensaje = ExceptionExtensions.GetOriginalException(e).Message;
                    return mensaje;
                }
                basedatos.SaveChanges();
            }
            return "OK";
        }


        public static Poa_Calendario Save(int Id, short Mes, decimal Valor, bdNovaEntities basedatos)
        {
            var existe = basedatos.Poa_Calendario.Where(r => r.Poa_CalendarioElemento.CalendarioElemento.ToLower() == "viaticos y pasajes" && r.IdIndicadores == Id && r.IdMes == Mes).FirstOrDefault();

            if (existe == null)
            {
                Poa_Calendario calendario = new Poa_Calendario();
                calendario.IdIndicadores = Id;
                calendario.IdMes = Mes;
                calendario.IdCalendarioElemento = basedatos.Poa_CalendarioElemento.Where(r => r.CalendarioElemento.ToLower() == "viaticos y pasajes").FirstOrDefault().IdCalendarioElemento;
                calendario.Valor = Valor;

                basedatos.Poa_Calendario.Add(calendario);
                basedatos.SaveChanges();

                return calendario;
            }
            else
                return existe;
        }
        public PoaMirEstructura getMir(int pagenum, int RecordsPerPage, string filter = null, string rol = "", int anioSeleccionado = 0)
        {
            string filtros = "";
            PoaMirEstructura resultado = new PoaMirEstructura();


            if (filter != null)
            {
                var campos = filter.Split(new string[] { "°" }, StringSplitOptions.None).Where(f => f.Trim().Length > 0).ToArray();
                string[] ArrayClaves = new string[campos.Count()];

                for (int i = 0; i < campos.Count(); i++)
                {
                    var datosinternos = campos[i].Split(new string[] { "|" }, StringSplitOptions.None).Where(f => f.Trim().Length > 0).ToArray();


                    switch (datosinternos[1])
                    {
                        case "Usuario":
                            filtros = filtros + " ( i2.Nombre like '%" + datosinternos[0] + "%' or  i2.ApellidoPaterno  like '%" + datosinternos[0] + "%'  or  i2.ApellidoMaterno  like ' % " + datosinternos[0] + " %') and ";
                            resultado.Usuario = datosinternos[0];
                            break;
                        case "Area":
                            filtros = filtros + " e.EstructuraOrganica like '%" + datosinternos[0] + "%' and ";
                            resultado.Area = datosinternos[0];
                            break;
                        case "Numero":
                            filtros = filtros + datosinternos[1] + " =" + datosinternos[0] + " and ";
                            resultado.Proyecto = datosinternos[0];
                            break;
                        case "TipoElementoObjetivos":
                            filtros = filtros + datosinternos[1] + " like '%" + datosinternos[0] + "%' and ";
                            resultado.TipoElementoObjetivos = datosinternos[0];
                            break;
                        default:

                            break;
                    }


                }
            }

            int idusuarioamandomedio = 0;
            int idusuariomnormal = 0;
            //para el caso de usuarios que NO sonadministradores
            if (rol != "Administrador")
            {


                if (rol == "Responsable")
                {
                    //idusuarioamandomedio = Seguridad.Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;
                    idusuarioamandomedio = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                    //idusuarioamandomedio = 42;
                    // filtros = filtros + " d.IdEstructuraOrganica=" + idarea + " and ";
                }
                else
                {
                    var id = AccesoAlCalendario();
                    if (id > 0)
                    {
                        idusuariomnormal = id;
                    }
                }
            }

            //BEGIN Region modificado 6 Sep 2018
            //validar que año se estara consultado|alternativa de año vigente
            int añoviogente = 0;
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"";

            if (anioSeleccionado != 0)
            {
                añoviogente = anioSeleccionado;
            }
            else
            {
                query = @" SELECT Año from  Poa_SistemaAñoVigente";
                añoviogente = dp.connection.ExecuteScalar<int>(query);
            }

            //END Region modificado 

            if (añoviogente == 0)
            {
                dp.Close();
                throw new ApplicationException("El Administrador del sistema no ha configurado el año vigente para el sistema.");
            }



            resultado.AñoVigente = añoviogente;
            // añoviogente = 2000;

            query = @" SELECT count(j.IdIndicadores) as total
          FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol
  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
  inner join Poa_Indicadores j on j.IdMir=b.IdMir
  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador=j.IdFrecuenciaMedicionIndicador
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=j.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador=j.IdSentidoIndicador
  where " + filtros + " + b.AñoMir =" + añoviogente;

            int totalrecords = dp.connection.ExecuteScalar<int>(query);


            int from = (pagenum * RecordsPerPage);
            int top = from;

            from = from - RecordsPerPage;




            string filtroEsAdministrador = "";


            //        switch (rol)
            //{
            //    case "Responsable":
            //                 filtroEsAdministrador =" and (j.IdConvenioLaboralTrabajadorCategoria = " + Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria + " or a.IdConvenioLaboralTrabajadorCategoria=" + Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria + ")";
            //                 break;

            //                        case "Usuario":
            //                 filtroEsAdministrador =" and (j.IdConvenioLaboralTrabajadorCategoria = " + Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria + ")";
            //             break;
            //}

            //   filtroEsAdministrador = " and (j.IdConvenioLaboralTrabajadorCategoria = " + 3985 + " or a.IdConvenioLaboralTrabajadorCategoria=" + 3985 + ")";

            //            query = @"  select q.*,rs.MirCompleta,rs.TotalIndicadoresMir from ( SELECT    * from (  select top " + top + @"   
            //    b.IdMir,a.IdProyectos
            //      ,b.ResumenNarrativo
            //      ,c.Numero
            //      ,c.Proyecto
            //	,e.EstructuraOrganica as AreaCreadora  
            //	 	,f.TipoElementoObjetivos 
            //	,i.Nombre as NombreUsuarioArea ,i.ApellidoPaterno as ApellidoPaternoUsuarioArea,i.ApellidoMaterno as ApellidoMaternoUsuarioArea
            //	,b.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaArea
            // 
            //	,i2.Nombre as NombreUsuarioResponsable ,i2.ApellidoPaterno as ApellidoPaternoUsuarioResponsable,i2.ApellidoMaterno as ApellidoMaternoUsuarioResponsable 
            //	,e2.EstructuraOrganica as AreaResponsable 
            //	,b.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaResponsable
            // 	,a.IdProyectoArbol
            // ,a.IdPadreElementoObjetivos
            // ,f.OrdenMir
            // ,a.IdTipoElementoObjetivos
            // ,ll.EstatusMir
            //  FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol
            //inner join Poa_MirEstatus ll on ll.IdMirEstatus=b.IdMirEstatus
            //  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
            //  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
            //  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
            //  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
            //  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
            //  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
            // inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
            //  left join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
            //  left join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
            //  left join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
            //  left join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
            //   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
            // left join Poa_Indicadores j on j.IdMir = b.IdMir
            //    where " + filtros + " a.Año =" + añoviogente + filtroEsAdministrador + @" 
            //    order by b.IdMir
            //) a
            //pivot (max(ResumenNarrativo) for TipoElementoObjetivos  in ([Fin],[Propósito],[Componente],[Actividad])) as MaxResumen
            // ) as q
            // left join 
            //(select x1.idmir,COUNT(IdIndicadores) TotalIndicadoresMir,sum(case when IdFrecuenciaMedicionIndicador > 0 then 1 else 0 end) as MirCompleta from 
            //Poa_Indicadores x1 inner join Poa_Mir x2
            //on x1.IdMir=x2.IdMir
            //inner join Poa_ProyectoArbol x3 on x3.IdProyectoArbol=x2.IdProyectoArbol
            //where x3.Año="+ añoviogente + @"
            //group by x1.idmir) rs on q.IdMir=rs.IdMir
            //order by Numero,OrdenMir  ";
            query = @"  select q.*,rs.MirCompleta,rs.TotalIndicadoresMir from ( select  top 100000 
      b.IdMir,max(a.IdProyectos) as IdProyectos
      ,max(b.ResumenNarrativo) as ResumenNarrativo
      ,max(c.Numero) as Numero
      ,max(c.Proyecto) as Proyecto
	,max(e.EstructuraOrganica) as AreaCreadora  
	 	,max(f.TipoElementoObjetivos)TipoElementoObjetivos
	,max(i.Nombre) as NombreUsuarioArea
	,max(i.ApellidoPaterno) as ApellidoPaternoUsuarioArea
	,max(i.ApellidoMaterno) as ApellidoMaternoUsuarioArea
	,max(b.IdConvenioLaboralTrabajadorCategoria) as IdConvenioLaboralTrabajadorCategoriaArea
 
	,max(i2.Nombre) as NombreUsuarioResponsable
	,max(i2.ApellidoPaterno) as ApellidoPaternoUsuarioResponsable
	,max(i2.ApellidoMaterno) as ApellidoMaternoUsuarioResponsable 
	,max(e2.EstructuraOrganica) as AreaResponsable 
	,max(b.IdConvenioLaboralTrabajadorCategoria) as IdConvenioLaboralTrabajadorCategoriaResponsable
 	,max(a.IdProyectoArbol) as IdProyectoArbol
 ,max(a.IdPadreElementoObjetivos) as IdPadreElementoObjetivos
 ,max(f.OrdenMir) as OrdenMir
 ,max(a.IdTipoElementoObjetivos) IdTipoElementoObjetivos
 ,max(ll.EstatusMir) as EstatusMir
 ,case when f.TipoElementoObjetivos='Fin' then f.TipoElementoObjetivos else null end as Fin
 ,case when f.TipoElementoObjetivos='Propósito' then f.TipoElementoObjetivos else null end as Proposito
 ,case when f.TipoElementoObjetivos='Componente' then f.TipoElementoObjetivos else null end as Componente
 ,case when f.TipoElementoObjetivos='Actividad' then f.TipoElementoObjetivos else null end as Actividad 
FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol
inner join Poa_MirEstatus ll on ll.IdMirEstatus=b.IdMirEstatus
  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
  left join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  left join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
  left join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
  left join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
 left join Poa_Indicadores j on j.IdMir = b.IdMir
    where " + filtros + " b.AñoMir =" + añoviogente + filtroEsAdministrador + @" 
group by 
    b.IdMir  
 ,f.TipoElementoObjetivos
    order by b.IdMir
 ) as q
 left join 
(select x1.idmir,COUNT(IdIndicadores) TotalIndicadoresMir,sum(case when IdFrecuenciaMedicionIndicador > 0 then 1 else 0 end) as MirCompleta from 
Poa_Indicadores x1 inner join Poa_Mir x2
on x1.IdMir=x2.IdMir
inner join Poa_ProyectoArbol x3 on x3.IdProyectoArbol=x2.IdProyectoArbol
where x2.AñoMir=" + añoviogente + @"
group by x1.idmir) rs on q.IdMir=rs.IdMir
order by Numero,OrdenMir  ";


            //            //      WHERE RowNumber > " + from + " order by Proyecto,OrdenElementoObjetivo,AreaCreadora, NombreUsuarioResponsable ,ApellidoPaternoUsuarioResponsable";

            List<PoaMirElementos> elementostemporal = new List<PoaMirElementos>();
            List<PoaMirElementos> elementos = new List<PoaMirElementos>();

            elementostemporal = (List<PoaMirElementos>)dp.connection.Query<PoaMirElementos>(query);

            var gruposproyectos = elementostemporal.GroupBy(f => f.IdProyectos).Select(g => g.Key).ToList();

            foreach (var grupo in gruposproyectos)
            {


                foreach (var item in elementostemporal.Where(p => p.IdProyectos == grupo && p.IdTipoElementoObjetivos == 5))
                {


                    PoaMirElementos elemento = new PoaMirElementos();
                    elemento = item;
                    elemento.Editable = false;
                    if (rol == "Administrador" || idusuarioamandomedio == item.IdConvenioLaboralTrabajadorCategoriaArea || idusuariomnormal == item.IdConvenioLaboralTrabajadorCategoriaResponsable)
                    {
                        elemento.Editable = true;
                    }
                    elementos.Add(elemento);
                    foreach (var proposito in elementostemporal.Where(p => p.IdProyectos == grupo && p.IdTipoElementoObjetivos == 1))
                    {
                        PoaMirElementos elementoproposito = new PoaMirElementos();
                        elementoproposito = proposito;
                        elementoproposito.Editable = false;
                        if (rol == "Administrador" || idusuarioamandomedio == proposito.IdConvenioLaboralTrabajadorCategoriaArea || idusuariomnormal == proposito.IdConvenioLaboralTrabajadorCategoriaResponsable)
                        {
                            elementoproposito.Editable = true;
                        }
                        elementos.Add(elementoproposito);
                        foreach (var componente in elementostemporal.Where(p => p.IdProyectos == grupo && p.IdPadreElementoObjetivos == proposito.IdProyectoArbol && p.IdTipoElementoObjetivos == 2))
                        {
                            PoaMirElementos elementocomponente = new PoaMirElementos();
                            elementocomponente = componente;
                            elementocomponente.Editable = false;
                            if (rol == "Administrador" || idusuarioamandomedio == componente.IdConvenioLaboralTrabajadorCategoriaArea || idusuariomnormal == componente.IdConvenioLaboralTrabajadorCategoriaResponsable)
                            {
                                elementocomponente.Editable = true;
                            }
                            elementos.Add(elementocomponente);

                            foreach (var actividades in elementostemporal.Where(p => p.IdProyectos == grupo && p.IdPadreElementoObjetivos == componente.IdProyectoArbol && p.IdTipoElementoObjetivos == 3))
                            {
                                PoaMirElementos elementoactividad = new PoaMirElementos();
                                elementoactividad = actividades;

                                elementoactividad.Editable = false;
                                if (rol == "Administrador" || idusuarioamandomedio == actividades.IdConvenioLaboralTrabajadorCategoriaArea || idusuariomnormal == actividades.IdConvenioLaboralTrabajadorCategoriaResponsable)
                                {
                                    elementoactividad.Editable = true;
                                }
                                elementos.Add(elementoactividad);

                            }
                        }
                    }


                }



            }



            String ids = String.Join(",", elementos.Select(r => r.IdMir));
            if (ids == "")
            { ids = "0"; }

            query = @"  SELECT    * from (  select top 10000   
            b.IdMir
   ,a.IdProyectos
      ,ti.Indicador as ResumenNarrativo
      ,c.Numero
      ,c.Proyecto
	,e.EstructuraOrganica as AreaCreadora
	 	,f.TipoElementoObjetivos
	,i.Nombre as NombreUsuarioArea ,i.ApellidoPaterno as ApellidoPaternoUsuarioArea,i.ApellidoMaterno as ApellidoMaternoUsuarioArea
	,b.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaCreador
 
	,i2.Nombre as NombreUsuarioResponsable ,i2.ApellidoPaterno as ApellidoPaternoUsuarioResponsable,i2.ApellidoMaterno as ApellidoMaternoUsuarioResponsable
	,e2.EstructuraOrganica as AreaResponsable
	,ti.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaResponsable
	,tt.EstatusMir,tt.IdMirEstatus,ti.IdIndicadores
     ,ti.MetaAnualNumerador 

  FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol = b.IdProyectoArbol
inner join poa_indicadores ti on ti.idMir=b.IdMir
  inner join Poa_MirEstatus tt on tt.IdMirEstatus = b.IdMirEstatus
  inner join Poa_Proyectos c on c.IdProyectos = a.IdProyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos = a.IdTipoElementoObjetivos
  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador h on h.IdTrabajador = g.IdTrabajador
 inner join vwKardex_ctDatosPersonales i on i.IdKardex = h.IdKardex
  left join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria = ti.IdConvenioLaboralTrabajadorCategoria
  left join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador = d2.IdConvenioLaboralTrabajador
  left join Kardex_ctTrabajador h2 on h2.IdTrabajador = g2.IdTrabajador
  left join vwKardex_ctDatosPersonales i2 on i2.IdKardex = h2.IdKardex
   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica = d2.IdEstructuraOrganica
   where " + filtros + " b.AñoMir =" + añoviogente + " and  b.IdMir in (" + ids + @")
            order by b.IdMir
) a
 ";



            resultado.PoaMirDetalle = (List<PoaMirDetalle>)dp.connection.Query<PoaMirDetalle>(query);


            query = @"SELECT    IdMirHistorialEstatus
      ,FechaEstatus
      ,IdConvenioLaboralTrabajadorCategoria
      ,IdMir
      ,a.IdMirEstatus
      ,ObservacionEstatus
      ,b.EstatusMir
   FROM Poa_MirHistorialEstatus a 
  inner join Poa_MirEstatus b on a.IdMirEstatus=b.IdMirEstatus where  a.IdMir in (" + ids + @") ";

            resultado.PoaMirHistorialEstatus = (List<PoaMirHistorialEstatus>)dp.connection.Query<PoaMirHistorialEstatus>(query);


            //            query = @"select 
            //SUM(a.Valor) as Total
            //  from Poa_Calendario a inner join 
            //  Poa_Indicadores b on a.IdIndicadores=b.IdIndicadores
            // inner join Poa_CalendarioElemento e on e.IdCalendarioElemento=a.IdCalendarioElemento
            //    where e.CalendarioElemento in ('Viaticos y pasajes','Presupuesto') and
            //b.IdIndicadores in (
            // SELECT j.IdIndicadores as total
            //          FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol
            //  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
            //  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
            //  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
            //  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
            //  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
            //  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
            // inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
            //  inner join Poa_Indicadores j on j.IdMir=b.IdMir
            //  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador=j.IdFrecuenciaMedicionIndicador
            //  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=j.IdConvenioLaboralTrabajadorCategoria
            //  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
            //  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
            //  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
            //   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
            //   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador=j.IdSentidoIndicador
            //  where " + filtros + " + a.Año =" + añoviogente + ")";

            //            int PresupuestoEjercido = dp.connection.ExecuteScalar<int>(query);


            //            query = @"select sum(Presupuesto) Total
            // FROM Poa_ProyectosAñoAreaPresupuesto z inner join 
            //  Poa_ProyectosAño a on z.IdProyectosAño=a.IdProyectosAño
            //  inner join Poa_Proyectos d on d.IdProyectos=a.IdProyectos
            //  inner join Catalogos_ctEstructuraOrganica e on z.IdEstructuraOrganica=e.IdEstructuraOrganica
            //    where e.IdEstructuraOrganica in (
            //SELECT e.IdEstructuraOrganica as total
            //          FROM Poa_ProyectoArbol a inner join Poa_Mir b on a.IdProyectoArbol=b.IdProyectoArbol
            //  inner join Poa_Proyectos c on c.IdProyectos=a.IdProyectos
            //  inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
            //  inner join Catalogos_ctEstructuraOrganica e on e.IdEstructuraOrganica=d.IdEstructuraOrganica
            //  inner join Poa_TipoElementoObjetivos f on f.IdTipoElementoObjetivos=a.IdTipoElementoObjetivos
            //  inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
            //  inner join Kardex_ctTrabajador h on h.IdTrabajador=g.IdTrabajador
            // inner join vwKardex_ctDatosPersonales i on i.IdKardex=h.IdKardex
            //  inner join Poa_Indicadores j on j.IdMir=b.IdMir
            //  inner join Poa_FrecuenciaMedicionIndicador k on k.IdFrecuenciaMedicionIndicador=j.IdFrecuenciaMedicionIndicador
            //  inner join Convenios_stConvenioLaboralTrabajadorCategoria d2 on d2.IdConvenioLaboralTrabajadorCategoria=j.IdConvenioLaboralTrabajadorCategoria
            //  inner join Convenios_stConvenioLaboralTrabajador g2 on g2.IdConvenioLaboralTrabajador=d2.IdConvenioLaboralTrabajador
            //  inner join Kardex_ctTrabajador h2 on h2.IdTrabajador=g2.IdTrabajador
            //  inner join vwKardex_ctDatosPersonales i2 on i2.IdKardex=h2.IdKardex
            //   inner join Catalogos_ctEstructuraOrganica e2 on e2.IdEstructuraOrganica=d2.IdEstructuraOrganica
            //   inner join Poa_SentidoIndicador l on l.IdSentidoIndicador=j.IdSentidoIndicador
            //where " + filtros + " + a.Año =" + añoviogente + ")";


            //            int Totalpresupuesto = dp.connection.ExecuteScalar<int>(query);


            //            List<Poa_PresupuestoMeses> Poa_PresupuestoelementosMeses = (List<Poa_PresupuestoMeses>)dp.connection.Query<Poa_PresupuestoMeses>(query);

            //            query = @"SELECT IdViaticosPasajes
            //              , a.IdCalendario
            //                ,IdOrigenDestino
            //                ,NumeroVisitas
            //                ,Dias
            //                ,ImporteViaticos
            //                ,NumeroPersonas
            //                ,TotalViaticos
            //                ,IdTipoPasaje
            //                ,ImporteBoleto
            //                ,TotalPasaje
            //                ,ViajeRedondoPersona
            //                ,b.IdMes
            //                ,b.IdIndicadores
            //                ,b.Valor
            //            FROM  Poa_ViaticosPasajes a inner join Poa_Calendario b on
            //            a.IdCalendario = b.IdCalendario where b.IdIndicadores in (" + ids + ")";

            //            List<Poa_ViaticosPasajesMeses> Poa_ViaticosPasajesMeses = (List<Poa_ViaticosPasajesMeses>)dp.connection.Query<Poa_ViaticosPasajesMeses>(query);



            //            //determinar que estatus tiene cada jerarquia, para saber si esta habilitado o deshabilitado
            //            //y se pueda interactuar con el registro en la interfaz


            //            resultado.Poa_ViaticosPasajesMeses = Poa_ViaticosPasajesMeses;

            //            foreach (var item in elementos)
            //            {

            //                var calendarioprogramado = elementosMeses.Where(e => e.IdIndicadores == item.IdIndicadores && e.CalendarioElemento == "Programado").ToList();
            //                var calendariopresupuestado = Poa_PresupuestoelementosMeses.Where(e => e.IdIndicadores == item.IdIndicadores).ToList();
            //                var calendarioavanzado = elementosMeses.Where(e => e.IdIndicadores == item.IdIndicadores && e.CalendarioElemento == "Avance").ToList();
            //                var calendariorealizado = elementosMeses.Where(e => e.IdIndicadores == item.IdIndicadores && e.CalendarioElemento == "Realizado").ToList();

            //                bool puedeprogramar = false;
            //                bool puedeavazar = false;
            //                bool puederealizar = false;
            //                bool puedepresupuestar = false;
            //                if (item.FrecuenciaMedicion == "Mensual")
            //                {
            //                    if (calendarioprogramado.Count < 12)
            //                    {
            //                        puedeprogramar = true;
            //                        puedeavazar = false;
            //                        puederealizar = false;
            //                        puedepresupuestar = false;
            //                    }
            //                    else
            //                    {
            //                        if (item.TipoElementoObjetivos == "Actividad")
            //                        {
            //                            if (calendariopresupuestado.Count < 12)
            //                            {
            //                                puedeprogramar = false;
            //                                puedepresupuestar = true;
            //                                puedeavazar = false;
            //                                puederealizar = false;

            //                            }
            //                            else
            //                            {
            //                                if (calendarioavanzado.Count < 12)
            //                                {
            //                                    puedeprogramar = false;
            //                                    puedeavazar = true;
            //                                    puederealizar = false;
            //                                    puedepresupuestar = false;
            //                                }
            //                            }
            //                        }
            //                        else
            //                        {
            //                            if (calendariorealizado.Count < 12)
            //                            {
            //                                puedeprogramar = false;
            //                                puedeavazar = false;
            //                                puederealizar = true;
            //                                puedepresupuestar = false;
            //                            }


            //                            else
            //                            {
            //                                if (calendarioavanzado.Count < 12)
            //                                {
            //                                    puedeprogramar = false;
            //                                    puedeavazar = true;
            //                                    puederealizar = false;
            //                                    puedepresupuestar = false;
            //                                }
            //                            }
            //                        }
            //                    }

            //                }


            //                if (item.FrecuenciaMedicion == "Anual")
            //                {
            //                    if (calendarioprogramado.Count < 1)
            //                    {
            //                        puedeprogramar = true;
            //                        puedeavazar = false;
            //                        puederealizar = false;
            //                        puedepresupuestar = false;
            //                    }
            //                    else
            //                    {
            //                        if (item.TipoElementoObjetivos == "Actividad")
            //                        {
            //                            if (calendariopresupuestado.Count < 1)
            //                            {
            //                                puedeprogramar = false;
            //                                puedepresupuestar = true;
            //                                puedeavazar = false;
            //                                puederealizar = false;

            //                            }
            //                            else
            //                            {
            //                                if (calendarioavanzado.Count < 1)
            //                                {
            //                                    puedeprogramar = false;
            //                                    puedeavazar = true;
            //                                    puederealizar = false;
            //                                    puedepresupuestar = false;
            //                                }
            //                            }
            //                        }
            //                        else
            //                        {
            //                            if (calendariorealizado.Count < 1)
            //                            {
            //                                puedeprogramar = false;
            //                                puedeavazar = false;
            //                                puederealizar = true;
            //                                puedepresupuestar = false;
            //                            }


            //                            else
            //                            {
            //                                if (calendarioavanzado.Count < 1)
            //                                {
            //                                    puedeprogramar = false;
            //                                    puedeavazar = true;
            //                                    puederealizar = false;
            //                                    puedepresupuestar = false;
            //                                }
            //                            }
            //                        }
            //                    }

            //                }

            //                if (item.FrecuenciaMedicion == "Trimestral")
            //                {
            //                    if (calendarioprogramado.Count < 3)
            //                    {
            //                        puedeprogramar = true;
            //                        puedeavazar = false;
            //                        puederealizar = false;
            //                        puedepresupuestar = false;
            //                    }
            //                    else
            //                    {
            //                        if (item.TipoElementoObjetivos == "Actividad")
            //                        {
            //                            if (calendariopresupuestado.Count < 3)
            //                            {
            //                                puedeprogramar = false;
            //                                puedepresupuestar = true;
            //                                puedeavazar = false;
            //                                puederealizar = false;

            //                            }
            //                            else
            //                            {
            //                                if (calendarioavanzado.Count < 3)
            //                                {
            //                                    puedeprogramar = false;
            //                                    puedeavazar = true;
            //                                    puederealizar = false;
            //                                    puedepresupuestar = false;
            //                                }
            //                            }
            //                        }
            //                        else
            //                        {
            //                            if (calendariorealizado.Count < 3)
            //                            {
            //                                puedeprogramar = false;
            //                                puedeavazar = false;
            //                                puederealizar = true;
            //                                puedepresupuestar = false;
            //                            }


            //                            else
            //                            {
            //                                if (calendarioavanzado.Count < 3)
            //                                {
            //                                    puedeprogramar = false;
            //                                    puedeavazar = true;
            //                                    puederealizar = false;
            //                                    puedepresupuestar = false;
            //                                }
            //                            }
            //                        }
            //                    }

            //                }








            //                item.HabilitadoProgramado = puedeprogramar;
            //                item.HabilitadoPresupuesto = puedepresupuestar;
            //                item.HabilitadoAvance = puedeavazar;
            //                item.HabilitadoRealizado = puederealizar;


            //            }


            //            query = @"select a.IdIndicadores,a.IdMes,Valor,CalendarioElemento from Poa_Calendario a left join
            // Poa_CalendarioElemento b on a.IdCalendarioElemento = b.IdCalendarioElemento
            //  where(IdIndicadores   in (" + ids + @") and b.CalendarioElemento = 'Programado')
            //  or (IdIndicadores   in (" + ids + ") and b.CalendarioElemento = 'Realizado')";



            //            List<AvancePorMes> AvancePorMes = (List<AvancePorMes>)dp.connection.Query<AvancePorMes>(query);

            //            List<AvancePorMes> TotalesAvancePorMes = new List<AvancePorMes>();


            //            string[] pieces = ids.Split(new string[] { "," },
            //                                              StringSplitOptions.None);

            //            int[] array2 = new int[pieces.Count()];

            //            for (int i = 0; i < pieces.Count(); i++)

            //            {
            //                int idseleccionado = Convert.ToInt32(pieces[i]);
            //                var metasprogramadas = AvancePorMes.Where(t => t.IdIndicadores == idseleccionado && t.CalendarioElemento == "Programado").Sum(g => g.Valor);


            //                foreach (var metas in AvancePorMes.Where(t => t.IdIndicadores == idseleccionado && t.CalendarioElemento == "Realizado").ToList())
            //                {
            //                    var avances = AvancePorMes.Where(t => t.IdIndicadores == idseleccionado && t.CalendarioElemento == "Realizado" && t.IdMes <= metas.IdMes).Sum(g => g.Valor);
            //                    decimal total = 0;
            //                    if (metasprogramadas > 0)
            //                    {
            //                        total = Math.Round((avances * 100) / metasprogramadas, 2);
            //                    }
            //                    AvancePorMes TotalesAvance = new AvancePorMes();
            //                    TotalesAvance.Valor = total;
            //                    TotalesAvance.IdIndicadores = idseleccionado;
            //                    TotalesAvance.IdMes = metas.IdMes;
            //                    TotalesAvance.CalendarioElemento = "Realizado";
            //                    TotalesAvancePorMes.Add(TotalesAvance);
            //                }

            //            }

            //            resultado.AvancePorMeses = TotalesAvancePorMes;

            resultado.PoaMirElementos = elementos;
            //resultado.CalendarioElementosMeses = elementosMeses;
            //resultado.Poa_PresupuestoMeses = Poa_PresupuestoelementosMeses;
            //resultado.PrespuestoTotal = Totalpresupuesto;
            //resultado.PrespuestoEjercido = PresupuestoEjercido;
            //resultado.PrespuestoDisponible = Totalpresupuesto - PresupuestoEjercido;
            //resultado.AñoVigente = añoviogente;

            //resultado.NumberPages = (int)Math.Round((double)(totalrecords / RecordsPerPage), 0);
            //resultado.PageNumber = pagenum;
            //resultado.RecordsPerPage = RecordsPerPage;
            resultado.RolUsuario = setRol();
            return resultado;
        }
    }
}