﻿using Dapper;
using DevExpress.Export;
using DevExpress.Utils;
using DevExpress.Web;
using DevExpress.Web.Mvc;
using DevExpress.XtraPivotGrid;
using DevExpress.XtraPrinting;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.UI.WebControls;

namespace Nova.Models
{
    //public enum PivotGridExportFormats { ExcelDataAware, Pdf, Excel, Mht, Rtf, Text, Html }

    //public class PivotGridExportOptions
    //{
    //    public PivotGridExportOptions()
    //    {
    //        WYSIWYG = new PivotGridExportWYSIWYGOptions();
    //        DataAware = new PivotGridDataAwareExportOptions();
    //    }

    //    public PivotGridExportFormats ExportType { get; set; }
    //    public PivotGridExportWYSIWYGOptions WYSIWYG { get; set; }
    //    public PivotGridDataAwareExportOptions DataAware { get; set; }
    //}

    //public class PivotGridExportWYSIWYGOptions
    //{
    //    public PivotGridExportWYSIWYGOptions()
    //    {
    //        PrintFilterHeaders = true;
    //        PrintColumnHeaders = true;
    //        PrintRowHeaders = true;
    //        PrintDataHeaders = true;
    //    }

    //    public bool PrintHeadersOnEveryPage { get; set; }
    //    public bool PrintFilterHeaders { get; set; }
    //    public bool PrintColumnHeaders { get; set; }
    //    public bool PrintRowHeaders { get; set; }
    //    public bool PrintDataHeaders { get; set; }
    //}

    //public class PivotGridDataAwareExportOptions
    //{
    //    public PivotGridDataAwareExportOptions()
    //    {
    //        AllowGrouping = true;
    //        AllowFixedColumnAndRowArea = true;
    //    }

    //    public bool AllowGrouping { get; set; }
    //    public bool AllowFixedColumnAndRowArea { get; set; }
    //    public bool ExportDisplayText { get; set; }
    //    public bool ExportRawData { get; set; }
    //}
    public class PlazasPivot
    {
        static PivotGridSettings exportPivotGridSettings;
        static PivotGridSettings dataAwarePivotGridSettings;

        public static PivotGridSettings ExportPivotGridSettings
        {
            get
            {
                if (exportPivotGridSettings == null)
                    exportPivotGridSettings = CreatePivotGridSettings();
                return exportPivotGridSettings;
            }
        }
        public static DevExpress.Web.Mvc.PivotGridSettings DataAwarePivotGridSettings
        {
            get
            {
                if (dataAwarePivotGridSettings == null)
                    dataAwarePivotGridSettings = CreateDataAwarePivotGridSettings();
                return dataAwarePivotGridSettings;
            }
        }

        public static PivotGridSettings GetPivotGridExportSettings(PivotGridExportWYSIWYGOptions options)
        {
            PivotGridSettings exportSettings = ExportPivotGridSettings;
            exportSettings.SettingsExport.OptionsPrint.PrintHeadersOnEveryPage = options.PrintHeadersOnEveryPage;
            exportSettings.SettingsExport.OptionsPrint.PrintFilterHeaders = ConvertToDefaultBoolean(options.PrintFilterHeaders);
            exportSettings.SettingsExport.OptionsPrint.PrintColumnHeaders = ConvertToDefaultBoolean(options.PrintColumnHeaders);
            exportSettings.SettingsExport.OptionsPrint.PrintRowHeaders = ConvertToDefaultBoolean(options.PrintRowHeaders);
            exportSettings.SettingsExport.OptionsPrint.PrintDataHeaders = ConvertToDefaultBoolean(options.PrintDataHeaders);
            return exportSettings;
        }
        static PivotGridSettings CreatePivotGridSettingsBase()
        {
            PivotGridSettings settings = new PivotGridSettings();
            settings.Name = "pivotGrid";
            settings.CallbackRouteValues = new { Controller = "PlazasPivot", Action = "PlazasVacantesPartialPivot" };
            settings.Width = Unit.Percentage(100);
            settings.OptionsPager.RowsPerPage = 50;
            settings.OptionsView.HorizontalScrollBarMode = ScrollBarMode.Auto;
            settings.OptionsData.DataProcessingEngine = PivotDataProcessingEngine.LegacyOptimized;
            return settings;
        }
        static PivotGridSettings CreatePivotGridSettings()
        {
            PivotGridSettings settings = CreatePivotGridSettingsBase();

            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 0;
                field.Caption = "Adscripción";
                field.FieldName = "Adscripcion";
            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 1;
                field.Caption = "Plaza";
                field.FieldName = "Plaza";
            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.ColumnArea;
                field.AreaIndex = 0;
                field.Caption = "EsVacante";
                field.FieldName = "EsVacante";

                //   field.FilterValues.Add((Boolean)false);

            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 1;
                field.Caption = "Nombre";
                field.FieldName = "Nombre";
            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 2;
                field.Caption = "EsAutorizada";
                field.FieldName = "EsAutorizada";
            });

            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 3;
                field.Caption = "EsVigente";
                field.FieldName = "EsVigente";
            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.DataArea;
                field.AreaIndex = 0;
                field.Caption = "#";
                field.FieldName = "No";
            });

            return settings;
        }


        static PivotGridSettings CreateDataAwarePivotGridSettings()
        {
            PivotGridSettings settings = CreatePivotGridSettingsBase();


            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 0;
                field.Caption = "Adscripción";
                field.FieldName = "Adscripcion";
            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 1;
                field.Caption = "Plaza";
                field.FieldName = "Plaza";
            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.ColumnArea;
                field.AreaIndex = 0;
                field.Caption = "EsVacante";
                field.FieldName = "EsVacante";
            
                //   field.FilterValues.Add((Boolean)false);

            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 1;
                field.Caption = "Nombre";
                field.FieldName = "Nombre";
            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 2;
                field.Caption = "EsAutorizada";
                field.FieldName = "EsAutorizada";
            });

            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 3;
                field.Caption = "EsVigente";
                field.FieldName = "EsVigente";
            });
            settings.Fields.Add(field =>
            {
                field.Area = PivotArea.DataArea;
                field.AreaIndex = 0;
                field.Caption = "#";
                field.FieldName = "No";
            });



            return settings;
        }
        static DefaultBoolean ConvertToDefaultBoolean(bool value)
        {
            return value ? DefaultBoolean.True : DefaultBoolean.False;
        }

        static Dictionary<PivotGridExportFormats, PivotGridExportType> exportTypes;
        static Dictionary<PivotGridExportFormats, PivotGridExportType> CreateExportTypes()
        {
            Dictionary<PivotGridExportFormats, PivotGridExportType> types = new Dictionary<PivotGridExportFormats, PivotGridExportType>();
            types.Add(PivotGridExportFormats.Pdf, new PivotGridExportType { Title = "Export to PDF", Method = PivotGridExtension.ExportToPdf });
            types.Add(PivotGridExportFormats.Excel, new PivotGridExportType { Title = "Export to XLSX", ExcelMethod = PivotGridExtension.ExportToXlsx });
            types.Add(PivotGridExportFormats.ExcelDataAware, new PivotGridExportType { Title = "Export to XLSX", ExcelMethod = PivotGridExtension.ExportToXlsx });
            types.Add(PivotGridExportFormats.Mht, new PivotGridExportType { Title = "Export to MHT", Method = PivotGridExtension.ExportToMht });
            types.Add(PivotGridExportFormats.Rtf, new PivotGridExportType { Title = "Export to RTF", Method = PivotGridExtension.ExportToRtf });
            types.Add(PivotGridExportFormats.Text, new PivotGridExportType { Title = "Export to TEXT", Method = PivotGridExtension.ExportToText });
            types.Add(PivotGridExportFormats.Html, new PivotGridExportType { Title = "Export to HTML", Method = PivotGridExtension.ExportToHtml });
            return types;
        }
        public static ActionResult GetExportActionResult(PivotGridExportOptions options, object data)
        {
            if (exportTypes == null)
                exportTypes = CreateExportTypes();

            PivotGridExportFormats format = options.ExportType;
            PivotGridSettings settings = GetPivotGridExportSettings(options.WYSIWYG);
            switch (format)
            {
                case PivotGridExportFormats.Excel:
                    return exportTypes[format].ExcelMethod(settings, data, new XlsxExportOptionsEx() { ExportType = ExportType.WYSIWYG });
                case PivotGridExportFormats.ExcelDataAware:
                    XlsxExportOptionsEx exportOptions = new XlsxExportOptionsEx() { ExportType = ExportType.DataAware };
                    exportOptions.AllowFixedColumnHeaderPanel = exportOptions.AllowFixedColumns = options.DataAware.AllowFixedColumnAndRowArea ? DefaultBoolean.True : DefaultBoolean.False;
                    exportOptions.AllowGrouping = options.DataAware.AllowGrouping ? DefaultBoolean.True : DefaultBoolean.False;
                    exportOptions.RawDataMode = options.DataAware.ExportRawData;
                    exportOptions.TextExportMode = options.DataAware.ExportDisplayText ? TextExportMode.Text : TextExportMode.Value;
                    return exportTypes[format].ExcelMethod(DataAwarePivotGridSettings, data, exportOptions);
                default:
                    return exportTypes[format].Method(settings, data);
            }
        }
        public delegate ActionResult PivotGridExportMethod(PivotGridSettings settings, object dataObject);
        public delegate ActionResult PivotGridDataAwareExportMethod(PivotGridSettings settings, object dataObject, XlsxExportOptions exportOptions);
        public class PivotGridExportType
        {
            public string Title { get; set; }
            public PivotGridExportMethod Method { get; set; }
            public PivotGridDataAwareExportMethod ExcelMethod { get; set; }
        }

    }

    public class PlazasVacantes
    {
        public int No { get; set; }//
        public string Plaza { get; set; }//
        //public string Categoria { get; set; }//
        public string Adscripcion { get; set; }//
        public string EsVigente { get; set; }
        public string EsVacante { get; set; }
        public string EsAutorizada { get; set; }
        public string Nombre { get; set; }


    }

}