﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Mail;
using System.Text;
using System.Web;
using System.Web.Mvc;

namespace Nova.Models
{
    public class Organigrama
    {

        public short IdEstructuraOrganica { get; set; }
        public string EstructuraOrganica { get; set; }

    }
    public class PersonalProcesos
    {
        bdNovaEntities bd = new bdNovaEntities();

        public void EnviarRecordatorio(int id, string correo)
        {
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria usuario = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => q.Convenios_stConvenioLaboralTrabajador.IdTrabajador == id).OrderByDescending(e => e.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            Nova.Models.Credenciales model = new Nova.Models.Credenciales();
            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            msg.To.Add(correo);
            model.getEmailAdministradores(ref msg);

            msg.Subject = "Recordatorio de actualización de información ";
            msg.IsBodyHtml = true;


            PersonalProcesos email = new PersonalProcesos();


            msg.Body = email.EmailReportarProceso(usuario);


            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false;

            try
            {
                client.Send(msg);


            }
            catch (Exception)
            {
                // regresa = false;
                throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }

            ///
        }
        
        public static List<Catalogos_ctEstructuraOrganica> getHijosEstructuraOrganica(short id)
        {
            bdNovaEntities bd = new bdNovaEntities();
            return bd.Catalogos_ctEstructuraOrganica.Where(w => w.IdEstructuraOrganicaPadre == id).ToList();
        }

        public string EmailTerminoProceso(Convenios_stConvenioLaboralTrabajadorCategoria usuario)
        {
            int total = 0;

            CredencialesEmailReporte regresa = new CredencialesEmailReporte();




            string depto = usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica;
            string reporta = usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            int totaltrabajadores = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.IdEstructuraOrganica == usuario.IdEstructuraOrganica).ToList().Count; ;
            string msg = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
<html>
<head>
 
<meta name='viewport' content='width=device-width'/>
<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>
<title>Nova </title>
<link rel='stylesheet' type='text/css' href='email.css'/>
</head>
<body bgcolor='#FFFFFF' topmargin='0' leftmargin='0' marginheight='0' marginwidth='0'>
<body bgcolor='#FFFFFF' topmargin='0' leftmargin='0' marginheight='0' marginwidth='0'>
    <img editable='true' />
<table class='head-wrap' bgcolor='#f5f5f5' style='width: 100%;'>
<tr>
	<td>
	</td>
	<td class='header container'>
		<div class='content'>
			<table bgcolor='#f5f5f5' class='' >
			<tr>
				<td >
					<img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png'/>
				</td>
				<td align='right' >
					<h6 class='collapse'>NOVA</h6>
				</td>
			</tr>
			</table>
		</div>
	</td>
	<td>
	</td>
</tr>
</table>
<table class='body-wrap'>
<tr>
	<td>
	</td>
	<td class='container' bgcolor='#FFFFFF'>
		<!-- content -->
		<div class='content'>
			<table bgcolor='' class='social' width='100%'>
			<tr>
				<td align='center'>
					<h1>Proceso de actualización de fotografias e información personal</h1>
				</td>
			</tr>
			</table>
		</div>
		<!-- COLUMN WRAP -->
		<div class='column-wrap'>
			<div class='column'>
			 
			</div>
			<div class='column'>
			 
			</div>
			<div class='content'>
				<!-- Line -->
				<table width='100%' height='81'>
				<td>
					 
				</td>
				<!-- DIVIDER TITLE -->
				<td align='center' valign='middle'>
					<tr>
						<td height='0' border='5px' cellspacing='0' cellpadding='0'>
							<h7>" + depto + @"</h7>
						</td>
					</tr>
				</td>
				<td align='center' valign='middle'>
					<tr>
						<td height='0' border='5px' cellspacing='0' cellpadding='0'>
							<h7>Reporta: " + reporta + @"</h7>
						</td>
					</tr>
				</td>
				<td>
					<table border='0' cellspacing='0' cellpadding='0'>
					<tr>
						<td width='1150' style='border-bottom: 1px solid #e5e5e5;'>
						</td>
					</tr>
					<tr>
						<td>
						</td>
					</tr>
					</table>
				</td>
				</table>
			</div>
			 
			<div class='content'>
				<table bgcolor='' class='social' width='100%'>
				<tr>
					<td>
						<h4 style='padding-top:30px;'>
							TOTAL DE TRABAJADORES A CARGO " + totaltrabajadores + @"
						</h4>
					</td>
				</tr>
				<tr>
					<td>
						<table align='left' width='100%'>
						
								<p>
									<h5 style='padding-top:20px;'>Se da por completado el proceso en la fecha: <strong style='color:#000;'>" + DateTime.Now + @"</strong></h5>
								</p>
								<p>
									 
								</p>
						
						</table>
					</td>
				</tr>
				</table>
			</div>
		<div class='content'>
			<table>
			<tr>
				<td align='center'>
					<p>
					 
					</p>
					<!-- /hero -->
					<!-- Callout Panel -->
					<p class='left'>
					 
						
					</p>
					<!-- /Callout Panel -->
				</td>
			</tr>
			</table>
		</div>
		<div class='clear'>
		</div>
	</div>
</td>
<td>
</td>
</tr>
</table>
<table class='footer-wrap'>
<tr>
<td>
</td>
<td class='container'>
	<!-- content -->
	<div class='content'>
		<table>
		<tr>
			<td align='center'>
				<p>
					<a href='www.cecyteo.edu.mx'>COLEGIO DE ESTUDIOS CIENTÍFICOS Y TECNOLÓGICOS DEL ESTADO DE OAXACA</a> 
				</p>
			</td>
		</tr>
		</table>
	</div>
	<!-- /content -->
</td>
<td>
</td>
</tr>
</table>
</body>
</html>";






            //regresa.Email = msg;
            //regresa.TotalReporte = (short)total;
            return msg;
        }

        public string EmailReportarProceso(Convenios_stConvenioLaboralTrabajadorCategoria usuario)
        {
            int total = 0;

            CredencialesEmailReporte regresa = new CredencialesEmailReporte();




            string depto = usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica;
            string reporta = usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            int totaltrabajadores = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.IdEstructuraOrganica == usuario.IdEstructuraOrganica && q.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ProcesoCompletado == false).ToList().Count; ;
            string msg = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
<html>
<head>
 
<meta name='viewport' content='width=device-width'/>
<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>
<title>Nova </title>
<link rel='stylesheet' type='text/css' href='email.css'/>
</head>
<body bgcolor='#FFFFFF' topmargin='0' leftmargin='0' marginheight='0' marginwidth='0'>
<body bgcolor='#FFFFFF' topmargin='0' leftmargin='0' marginheight='0' marginwidth='0'>
    <img editable='true' />
<table class='head-wrap' bgcolor='#f5f5f5' style='width: 100%;'>
<tr>
	<td>
	</td>
	<td class='header container'>
		<div class='content'>
			<table bgcolor='#f5f5f5' class='' >
			<tr>
				<td >
					<img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png'/>
				</td>
				<td align='right' >
					<h6 class='collapse'>NOVA</h6>
				</td>
			</tr>
			</table>
		</div>
	</td>
	<td>
	</td>
</tr>
</table>
<table class='body-wrap'>
<tr>
	<td>
	</td>
	<td class='container' bgcolor='#FFFFFF'>
		<!-- content -->
		<div class='content'>
			<table bgcolor='' class='social' width='100%'>
			<tr>
				<td align='center'>
					<h3>Proceso de actualización de fotografias e información personal</h3>
				</td>
			</tr>
			</table>
		</div>
		<!-- COLUMN WRAP -->
		<div class='column-wrap'>
			<div class='column'>
			 
			</div>
			<div class='column'>
			 
			</div>
			<div class='content'>
				<!-- Line -->
				<table width='100%' height='81'>
				<td>
					 
				</td>
				<!-- DIVIDER TITLE -->
				<td align='center' valign='middle'>
					<tr>
						<td height='0' border='5px' cellspacing='0' cellpadding='0'>
								<h7>ESTIMADO(A): " + reporta + @"</h7>
						</td>
					</tr>
				</td>
				<td align='center' valign='middle'>
					<tr>
						<td height='0' border='5px' cellspacing='0' cellpadding='0'>
						<h7>" + depto + @"</h7>
						</td>
					</tr>
				</td>
				<td>
					<table border='0' cellspacing='0' cellpadding='0'>
					<tr>
						<td width='1150' style='border-bottom: 1px solid #e5e5e5;'>
						</td>
					</tr>
					<tr>
						<td>
						</td>
					</tr>
					</table>
				</td>
				</table>
			</div>
			 
			<div class='content'>
				<table bgcolor='' class='social' width='100%'>
				<tr>
					<td>
                        
						<h4 style='padding-top:30px;text-align: justify;text-justify: inter-word;'>
							De acuerdo con la información contenida en el sistema NOVA al día de hoy, se encontraron un total de " + totaltrabajadores + @" trabajadores a su cargo, sin haber realizado el proceso de actualización de fotografías e información personal
por lo que le pedimos su invaluable apoyo para poder llevar a cabo esta tarea a la brevedad posible, le pedimos por favor haga caso omiso de este correo si usted ha concluido ya con el proceso , sin más por el momento reciba un cordial saludo.
						</h4>
               
					</td>
				</tr>
				<tr>
					<td>
						<table align='left' width='100%'>
						
<p>
									 <h4>ATENTAMENTE</h4>
								</p>
								<p>
									 <h4>DIRECCIÓN GENERAL</h4>
								</p>
								<p>
									 <h4>" + DateTime.Now + @"</h4>
								</p>
						
						</table>
					</td>
				</tr>
				</table>
			</div>
		<div class='content'>
			<table>
			<tr>
				<td align='center'>
					<p>
					 
					</p>
					<!-- /hero -->
					<!-- Callout Panel -->
					<p class='left'>
					 
						
					</p>
					<!-- /Callout Panel -->
				</td>
			</tr>
			</table>
		</div>
		<div class='clear'>
		</div>
	</div>
</td>
<td>
</td>
</tr>
</table>
<table class='footer-wrap'>
<tr>
<td>
</td>
<td class='container'>
	<!-- content -->
	<div class='content'>
		<table>
		<tr>
			<td align='center'>
				<p>
					<a href='www.cecyteo.edu.mx'>COLEGIO DE ESTUDIOS CIENTÍFICOS Y TECNOLÓGICOS DEL ESTADO DE OAXACA</a> 
				</p>
			</td>
		</tr>
		</table>
	</div>
	<!-- /content -->
</td>
<td>
</td>
</tr>
</table>
</body>
</html>";






            //regresa.Email = msg;
            //regresa.TotalReporte = (short)total;
            return msg;
        }



        public static string ShowSubItems(List<Catalogos_ctEstructuraOrganica> _object)
        {
            bdNovaEntities bd = new bdNovaEntities();
            StringBuilder output = new StringBuilder();
            List<Nova.Models.PersonalProcesos_Credenciales> terminados = bd.PersonalProcesos_Credenciales.ToList();


            output.Append("<table style='margin-left:20px;' margin-bottom:20px; > ");
            foreach (var subItem in _object)
            {

                vwDatosAspirantesTrabajadores x = bd.vwDatosAspirantesTrabajadores.Where(q => q.IdEstructuraOrganicaFisica == subItem.IdEstructuraOrganica).OrderBy(r => r.OrdenEstructuraOrganica).Take(1).FirstOrDefault();
                if (x != null)
                {
                    output.Append("<tr>");
                    output.Append("<td style='vertical-align: top;'>");


                    Convenios_stConvenioLaboralTrabajador trabajador = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => q.IdConvenioLaboralTrabajador == x.IdConvenioLaboralTrabajador).Select(q => q.Convenios_stConvenioLaboralTrabajador).FirstOrDefault();
                    //.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales;
                    if (trabajador != null)
                        output.Append("<label data-placement='top' data-original-title='A cargo: " + trabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + trabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + trabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "' class='tooltips'  >" + subItem.EstructuraOrganica + "</label>");
                    else
                        output.Append(subItem.EstructuraOrganica);

                    int totalempleados = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.IdEstructuraOrganica == subItem.IdEstructuraOrganica).ToList().Count;
                    int totalactualizados = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.IdEstructuraOrganica == subItem.IdEstructuraOrganica && q.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ProcesoCompletado == true).ToList().Count;
                    output.Append(ShowSubItems(getHijosEstructuraOrganica(subItem.IdEstructuraOrganica)));



                    output.Append("</td>");
                    output.Append("<td style='vertical-align: top;'> <label data-placement='top' data-original-title='Total de Trabajadores' style='padding-left:10px;' class='btn blue btn-outline btn-sm tooltips' > " + totalempleados + "</label>");
                    output.Append("</td>");

                    output.Append("<td style='vertical-align: top;'>  <label  data-placement='top' data-original-title='Total de Actualizados' style='padding-left:10px;' class='btn yellow btn-outline btn-sm tooltips'> " + totalactualizados + "</label>");
                    output.Append("</td>");


                    if (totalempleados > 0)
                        output.Append("<td style='vertical-align: top;'>  <label data-placement='top' data-original-title='% de Avance' style='padding-left:10px;' class='btn green btn-outline btn-sm tooltips' > " + ((totalactualizados * 100) / totalempleados) + "</label>");
                    else
                        output.Append("<td style='vertical-align: top;'>  <label data-placement='top' data-original-title='% de Avance' style='padding-left:10px;' class='btn green btn-outline btn-sm tooltips' >  0 </label>");
                    output.Append("</td>");

                    if (trabajador != null && (totalempleados > totalactualizados))
                    //{
                        //PersonalProcesos email = new PersonalProcesos();
                        //if (subItem.CorreoElectronico != null)
                        //    email.EnviarRecordatorio(trabajador.IdTrabajador, subItem.CorreoElectronico);
                        output.Append("<td style='vertical-align: top;'><a href='EnviarRecordatorio?id=" + trabajador.IdTrabajador + "&correo=" + subItem.CorreoElectronico + "' data-placement='top' data-original-title='Enviar correo recordatorio: " + trabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + trabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + trabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + "' class=' btn red btn-outline btn-sm tooltips'  ><i class='fa fa-envelope-o'></i></a></td>");
                    //}
                    if (trabajador != null)
                        if (terminados.Where(r => r.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajador).ToList().Count > 0)
                            output.Append("<td style='vertical-align: top;'><a href='javascript:void(0);' data-placement='top' data-original-title='Proceso terminado  class=' btn green btn-sm tooltips'  ><i class='fa fa-check'></i>" + terminados.Where(r => r.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajador).FirstOrDefault().FechaTermino + "</a></td>");

                    output.Append("</<tr>");
                }
            }
            output.Append("</table>");

            return output.ToString();
        }

    }
}