﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.Entity;
using System.Collections;

namespace Nova.Models.Permuta
{
    public class PermutasTrabajador
    {
        public static bdNovaEntities db = new bdNovaEntities();

        public static List<vwIdConvenioLaboralTrabajadorCategoria> GetPermutas(DbSet<vwIdConvenioLaboralTrabajadorCategoria> PermutaTrabajador, int IdTrabajador)
        {
            return PermutaTrabajador.Where(s => (s.IdTrabajador == IdTrabajador && s.GrupoEstatusTrabajador == "ALTA" && s.EsCancelado.Equals(false)) || s.FechaTerminoConvenio >= DateTime.Now).ToList();
        }

        public static List<vwRelacionConvenioLaboralTrabajadoresVigentes> GetPermutaTrabajador(DbSet<vwRelacionConvenioLaboralTrabajadoresVigentes> PermutaTrabajador, int IdTrabajador)
        {
            return PermutaTrabajador.Where(s => s.IdTrabajador == IdTrabajador).OrderByDescending(c => c.FechaTermino).ToList();
        }

        public static List<vwIdConvenioLaboralTrabajadorCategoria> GetPermutas2(DbSet<vwIdConvenioLaboralTrabajadorCategoria> PermutaTrabajador, int IdTrabajador)
        {
            return PermutaTrabajador.Where(s => (s.IdTrabajador == IdTrabajador && s.GrupoEstatusTrabajador == "ALTA" && s.EsCancelado.Equals(false)) || s.FechaTerminoConvenio >= DateTime.Now).ToList();
        }

        public static List<vwIdConvenioLaboralTrabajadorCategoria> GetPermutas3(DbSet<vwIdConvenioLaboralTrabajadorCategoria> PermutaTrabajador, int IdTrabajador)
        {
            return PermutaTrabajador.Where(s => (s.IdTrabajador == IdTrabajador && s.GrupoEstatusTrabajador == "ALTA" && s.RelacionLaboral == "BASE" && s.EsCancelado.Equals(false)) || s.FechaTerminoConvenio >= DateTime.Now).ToList();
        }

        public static List<Convenios_stConvenioLaboralTrabajadorCategoria> GetPermutaConvenioLaboralTrabajadorCategoria(DbSet<Convenios_stConvenioLaboralTrabajadorCategoria> PermutarTrabajador, int IdConvenioLaboralTrabajadorCategoria)
        {
            return PermutarTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
        }

        public static List<Convenios_stConvenioLaboralTrabajador> GetRenuncia(DbSet<Convenios_stConvenioLaboralTrabajador> RenunciaTrabajador, int IdTrabajador)
        {
            return RenunciaTrabajador.Where(s => s.IdTrabajador == IdTrabajador && s.FechaTermino == null).ToList();
        }


        public static List<Convenios_stConvenioLaboralTrabajadorCategoria> GetRenuncia2(DbSet<Convenios_stConvenioLaboralTrabajadorCategoria> RenunciaTrabajador2, int IdConvenioLaboralTrabajador)
        {
            return RenunciaTrabajador2.Where(s => s.IdConvenioLaboralTrabajador == IdConvenioLaboralTrabajador && (s.FechaTermino >= System.DateTime.Now || s.FechaTermino == null)).ToList();
        }

        public static List<Plazas_stDistribucionPlazaCategoria> GetRenuncia3(DbSet<Plazas_stDistribucionPlazaCategoria> RenunciaTrabajador3, int IdDistribucionPlazaCategoria)
        {
            return RenunciaTrabajador3.Where(s => s.IdDistribucionPlazaCategoria == IdDistribucionPlazaCategoria && s.EsVigente.Equals(true)).ToList();
        }

        public static List<Kardex_stEstatusTrabajador> GetRenuncia4(DbSet<Kardex_stEstatusTrabajador> RenunciaTrabajador4, int IdConvenioLaboralTrabajadorCategoria)
        {
            return RenunciaTrabajador4.Where(s => s.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
        }

        public static int ObtenRelacionConvenioLaboral(int IdTrabajador)
        {

            var IdConvenioLaboralTrabajadorCategoria = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                                        where a.IdTrabajador == IdTrabajador
                                                        select new { IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria }).SingleOrDefault().IdConvenioLaboralTrabajadorCategoria;


            return IdConvenioLaboralTrabajadorCategoria;
        }



       // public static int ObtenNominaTrabajador1(int IdTrabajador)
       // {

       //     var IdNominaTrabajador = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
       //                               join b in db.Nomina_stNominaTrabajador on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria
       //                               where a.IdTrabajador == IdTrabajador
       //                               select new
       //                               {
       //                                   IdNominaTrabajador = b.IdNominaTrabajador,


       //                               }
       //).OrderByDescending(aa => aa.IdNominaTrabajador).FirstOrDefault().IdNominaTrabajador;

       //     return unchecked((int)IdNominaTrabajador);
       // }

        public static int ObtenNominaTrabajador1(int IdTrabajador)
        {

            try
            {
                var IdNominaTrabajador = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                          join b in db.Nomina_stNominaTrabajador on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria
                                          where a.IdTrabajador == IdTrabajador
                                          select new { IdNominaTrabajador = b.IdNominaTrabajador }).OrderByDescending(aa => aa.IdNominaTrabajador).FirstOrDefault().IdNominaTrabajador;
                return unchecked((int)IdNominaTrabajador);
            }
            catch (Exception e)
            {
                Exception d = ExceptionExtensions.GetOriginalException(e);
                throw new ArgumentOutOfRangeException(d.Message, "El trabajador no esta activo en la nomina actual");

            }



        }




        public static int ObtenConvenioLaboralTrabajador1(int IdTrabajador)
        {

            var IdConvenioLaboralTrabajador = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                               where a.IdTrabajador == IdTrabajador
                                               select new { IdConvenioLaboralTrabajador = a.IdConvenioLaboralTrabajador }).SingleOrDefault().IdConvenioLaboralTrabajador;


            return IdConvenioLaboralTrabajador;
        }

        public static int ObtenDsitribucionPlazaCategoria1(int IdTrabajador)
        {

            var IdDistribuciónPlazaCategoria = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                                where a.IdTrabajador == IdTrabajador
                                                select new { IdDistribuciónPlazaCategoria = a.IdDistribucionPlazaCategoria }).SingleOrDefault().IdDistribuciónPlazaCategoria;


            return IdDistribuciónPlazaCategoria;
        }
        public static int ObtenEstructuraOrganica1(int IdTrabajador)
        {

            var IdEstructuraOrganica = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                        where a.IdTrabajador == IdTrabajador
                                        select new { IdEstructuraOrganica = a.IdEstructuraOrganica }).SingleOrDefault().IdEstructuraOrganica;


            return IdEstructuraOrganica;
        }
        public static bool ObtenEsComisionado1(int IdTrabajador)
        {

            var EsComisionado = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                 where a.IdTrabajador == IdTrabajador
                                 select new { EsComisionado = a.EsComisionado }).SingleOrDefault().EsComisionado;


            return EsComisionado;
        }
        public static DateTime ObtenFechaInicioConvenio1(int IdTrabajador)
        {

            var FechaInicioConvenio = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                       where a.IdTrabajador == IdTrabajador
                                       select new { FechaInicioConvenio = a.FechaInicioConvenio }).SingleOrDefault().FechaInicioConvenio;


            return FechaInicioConvenio;
        }

        public static string ObtenFechaTerminoConvenio1(int IdTrabajador)
        {

            var FechaTerminoConvenio = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                        where a.IdTrabajador == IdTrabajador
                                        select new { FechaTerminoConvenio = a.FechaTerminoConvenio }).SingleOrDefault().FechaTerminoConvenio;


            return FechaTerminoConvenio.ToString();
        }

        public static bool ObtenEsCancelado1(int IdTrabajador)
        {

            var EsCancelado = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                               where a.IdTrabajador == IdTrabajador
                               select new { EsCancelado = a.EsCancelado }).SingleOrDefault().EsCancelado;


            return EsCancelado;
        }

        public static int ObtenUserId1(int IdTrabajador)
        {

            var UserId = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                          where a.IdTrabajador == IdTrabajador
                          select new { UserId = a.UserId }).SingleOrDefault().UserId;


            return UserId;
        }

        public static DateTime ObtenFechaCreacion1(int IdTrabajador)
        {

            var FechaCreacion = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                 where a.IdTrabajador == IdTrabajador
                                 select new { FechaCreacion = a.FechaCreacion }).SingleOrDefault().FechaCreacion;


            return FechaCreacion;
        }
        public static int ObtenCategoriaPermuta(int IdTrabajador)
        {

            var IdCategoriaPermuta = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                      where a.IdTrabajador == IdTrabajador
                                      select new { IdCategoriaPermuta = a.IdCategoria }).SingleOrDefault().IdCategoriaPermuta;


            return IdCategoriaPermuta;
        }

        public static int ObtenConvenioLaboral(int IdTrabajador)
        {

            var IdConvenioLaboral = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                     where a.IdTrabajador == IdTrabajador
                                     select new { IdConvenioLaboral = a.IdConvenioLaboral }).SingleOrDefault().IdConvenioLaboral;


            return IdConvenioLaboral;
        }

        public static string ObtenNombre1(int IdTrabajador)
        {

            var Nombre1 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                           where a.IdTrabajador == IdTrabajador
                           select new { Nombre1 = a.Nombre }).SingleOrDefault().Nombre1;


            return Nombre1;
        }
        public static string ObtenPaterno1(int IdTrabajador)
        {

            var ObtenPaterno1 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                 where a.IdTrabajador == IdTrabajador
                                 select new { ObtenPaterno1 = a.ApellidoPaterno }).SingleOrDefault().ObtenPaterno1;


            return ObtenPaterno1;
        }
        public static string ObtenMaterno1(int IdTrabajador)
        {

            var ObtenMaterno1 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                 where a.IdTrabajador == IdTrabajador
                                 select new { ObtenMaterno1 = a.ApellidoMaterno }).SingleOrDefault().ObtenMaterno1;


            return ObtenMaterno1;
        }
        public static string ObtenConvenio1(int IdTrabajador)
        {

            var ObtenConvenio1 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                  where a.IdTrabajador == IdTrabajador
                                  select new { ObtenConvenio1 = a.ConvenioLaboral }).SingleOrDefault().ObtenConvenio1;


            return ObtenConvenio1;
        }
        public static string ObtenRelacion1(int IdTrabajador)
        {

            var ObtenRelacion1 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                  where a.IdTrabajador == IdTrabajador
                                  select new { ObtenRelacion1 = a.RelacionLaboral }).SingleOrDefault().ObtenRelacion1;


            return ObtenRelacion1;
        }

        public static string ObtenCategoria1(int IdTrabajador)
        {

            var ObtenCategoria1 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                   where a.IdTrabajador == IdTrabajador
                                   select new { ObtenCategoria1 = a.Categoria }).SingleOrDefault().ObtenCategoria1;


            return ObtenCategoria1;
        }



        public static List<vwIdConvenioLaboralTrabajadorCategoria> GetPermutas22(DbSet<vwIdConvenioLaboralTrabajadorCategoria> PermutaTrabajador)
        {
            return PermutaTrabajador.Where(s => (s.GrupoEstatusTrabajador == "ALTAS" && s.EsCancelado.Equals(false)) || s.FechaTerminoConvenio >= DateTime.Now).ToList();
        }


        public static int ObtenConvenioLaboral2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var IdConvenioLaboral2 = (from a in db.vwConvenioLaboralTrabjadorCategoriaIncidenciasSuplencias
                                      where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                      select new { IdConvenioLaboral2 = a.IdConvenioLaboral }).SingleOrDefault().IdConvenioLaboral2;


            return IdConvenioLaboral2;
        }

        public static int ObtenCategoriaPermuta2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var IdCategoriaPermuta2 = (from a in db.vwConvenioLaboralTrabjadorCategoriaIncidenciasSuplencias
                                       where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                       select new { IdCategoriaPermuta2 = a.IdCategoria }).SingleOrDefault().IdCategoriaPermuta2;


            return IdCategoriaPermuta2;
        }
        public static string ObtenNombre2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var Nombre2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                           where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                           select new { Nombre2 = a.Nombre }).SingleOrDefault().Nombre2;


            return Nombre2;
        }
        public static string ObtenPaterno2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var ObtenPaterno2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                 where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                 select new { ObtenPaterno2 = a.ApellidoPaterno }).SingleOrDefault().ObtenPaterno2;


            return ObtenPaterno2;
        }
        public static string ObtenMaterno2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var ObtenMaterno2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                 where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                 select new { ObtenMaterno2 = a.ApellidoMaterno }).SingleOrDefault().ObtenMaterno2;


            return ObtenMaterno2;
        }
        public static string ObtenConvenio2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var ObtenConvenio2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                  where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                  select new { ObtenConvenio2 = a.ConvenioLaboral }).SingleOrDefault().ObtenConvenio2;


            return ObtenConvenio2;
        }
        public static string ObtenRelacion2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var ObtenRelacion2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                  where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                  select new { ObtenRelacion2 = a.RelacionLaboral }).SingleOrDefault().ObtenRelacion2;


            return ObtenRelacion2;
        }

        public static string ObtenCategoria2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var ObtenCategoria2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                   where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                   select new { ObtenCategoria2 = a.Categoria }).SingleOrDefault().ObtenCategoria2;


            return ObtenCategoria2;
        }

        public static int ObtenConvenioLaboralTrabajador2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var IdConvenioLaboralTrabajador2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                                where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                                select new { IdConvenioLaboralTrabajador2 = a.IdConvenioLaboralTrabajador }).SingleOrDefault().IdConvenioLaboralTrabajador2;


            return IdConvenioLaboralTrabajador2;
        }
        public static int ObtenDsitribucionPlazaCategoria2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var IdDistribuciónPlazaCategoria2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                                 where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                                 select new { IdDistribuciónPlazaCategoria2 = a.IdDistribucionPlazaCategoria }).SingleOrDefault().IdDistribuciónPlazaCategoria2;


            return IdDistribuciónPlazaCategoria2;
        }
        public static int ObtenEstructuraOrganica2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var IdEstructuraOrganica2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                         where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                         select new { IdEstructuraOrganica2 = a.IdEstructuraOrganica }).SingleOrDefault().IdEstructuraOrganica2;


            return IdEstructuraOrganica2;
        }
        public static bool ObtenEsComisionado2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var EsComisionado2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                  where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                  select new { EsComisionado2 = a.EsComisionado }).SingleOrDefault().EsComisionado2;


            return EsComisionado2;
        }
        public static DateTime ObtenFechaInicioConvenio2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var FechaInicioConvenio2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                        where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                        select new { FechaInicioConvenio2 = a.FechaInicioConvenio }).SingleOrDefault().FechaInicioConvenio2;


            return FechaInicioConvenio2;
        }

        public static string ObtenFechaTerminoConvenio2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var FechaTerminoConvenio2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                         where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                         select new { FechaTerminoConvenio2 = a.FechaTerminoConvenio }).SingleOrDefault().FechaTerminoConvenio2;


            return FechaTerminoConvenio2.ToString();
        }

        public static bool ObtenEsCancelado2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var EsCancelado2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                select new { EsCancelado2 = a.EsCancelado }).SingleOrDefault().EsCancelado2;


            return EsCancelado2;
        }

        public static int ObtenUserId2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var UserId2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                           where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                           select new { UserId2 = a.UserId }).SingleOrDefault().UserId2;


            return UserId2;
        }

        public static DateTime ObtenFechaCreacion2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var FechaCreacion2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                  where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                  select new { FechaCreacion2 = a.FechaCreacion }).SingleOrDefault().FechaCreacion2;


            return FechaCreacion2;
        }

        public static IEnumerable ObtenFechaInicioNomina(int IdConvenioLaboralTrabajadorCategoria)
        {


            return (from a in db.vwConvenioLaboralTrabjadorCategoriaIncidenciasSuplencias
                    join b in db.Nomina_stNominaTrabajador on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria
                    join c in db.Nomina_stNomina on b.IdNomina equals c.IdNomina

                    select new
                    {
                        FechaInicioNomina = c.FechaInicio,
                        IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria

                    }
        ).Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();

        }
        public static string ObtenFechaInicioNomina2(int IdConvenioLaboralTrabajadorCategoria2)
        {


            var FechaInicio2 = (from a in db.vwConvenioLaboralTrabjadorCategoriaIncidenciasSuplencias
                                join b in db.Nomina_stNominaTrabajador on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria
                                join c in db.Nomina_stNomina on b.IdNomina equals c.IdNomina
                                where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                select new
                                {
                                    FechaInicio2 = c.FechaInicio,


                                }
       ).SingleOrDefault().FechaInicio2;

            return FechaInicio2.ToString();




        }

        public static string ObtenFechaTerminoNomina2(int IdConvenioLaboralTrabajadorCategoria2)
        {


            var FechaTermino2 = (from a in db.vwConvenioLaboralTrabjadorCategoriaIncidenciasSuplencias
                                 join b in db.Nomina_stNominaTrabajador on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria
                                 join c in db.Nomina_stNomina on b.IdNomina equals c.IdNomina
                                 where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                 select new
                                 {
                                     FechaTermino2 = c.FechaTermino,


                                 }
       ).OrderByDescending(dd => dd.FechaTermino2).FirstOrDefault().FechaTermino2;

            return FechaTermino2.ToString();




        }
        public static bool ObtenEsCerrada2(int IdConvenioLaboralTrabajadorCategoria2)
        {


            var EsCerrada2 = (from a in db.vwConvenioLaboralTrabjadorCategoriaIncidenciasSuplencias
                              join b in db.Nomina_stNominaTrabajador on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria
                              join c in db.Nomina_stNomina on b.IdNomina equals c.IdNomina
                              where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                              select new
                              {
                                  EsCerrada2 = c.EsCerrada,


                              }
       ).SingleOrDefault().EsCerrada2;

            return EsCerrada2;




        }

        public static int ObtenNominaTrabajador2(int IdConvenioLaboralTrabajadorCategoria2)
        {

            var IdNominaTrabajador2 = (from a in db.vwRelacionConvenioLaboralTrabajadoresVigentes
                                       join b in db.Nomina_stNominaTrabajador on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria
                                       where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2
                                       select new
                                       {
                                           IdNominaTrabajador2 = b.IdNominaTrabajador,


                                       }
       ).OrderByDescending(bb => bb.IdNominaTrabajador2).FirstOrDefault().IdNominaTrabajador2;

            return unchecked((int)IdNominaTrabajador2);
        }








        public static DateTime ObtenFechaInicioIncidencia(int IdConvenioLaboralTrabajadorCategoria2)
        {


            var FechaInicioIncidencia = (from a in db.vwIdConvenioLaboralTrabajadorCategoria
                                         join b in db.IncidenciaPermiso_stIncidenciaTrabajador on a.IdConvenioLaboralTrabajadorCategoria equals b.IdConvenioLaboralTrabajadorCategoria

                                         where a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria2

                                         select new
                                         {

                                             FechaInicioIncidencia = b.FechaInicio,
                                             IdTipoIncidencia = b.IdTipoIncidencia

                                         }
        ).Where(m => m.IdTipoIncidencia == 6).SingleOrDefault().FechaInicioIncidencia;

            return FechaInicioIncidencia;




        }

        public static int ObtenIdEstatusTrabajador()
        {

            var IdEstatusTrabajador = (from a in db.Catalogos_ctEstatusTrabajador
                                       where a.EstatusTrabajador == "ALTA POR PERMUTA"
                                       select new { IdEstatusTrabajador = a.IdEstatusTrabajador }).SingleOrDefault().IdEstatusTrabajador;


            return IdEstatusTrabajador;
        }



    }
}