﻿using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;

namespace Nova.Models
{
    [MetadataType(typeof(Percepciones_stPercepcionesCalendarizadasMetadata))]
    public partial class Percepciones_stPercepcionesCalendarizadas
    {
    }
    public class Percepciones_stPercepcionesCalendarizadasMetadata
    {
        [Required(ErrorMessage = "El tipo de platilla de la nómina es un campo obligatorio")]
        public object IdPlantillaNomina { get; set; }
        [Required(ErrorMessage = "La percepcion es un campo obligatorio")]
        public object IdPercepcion { get; set; }
        [Required(ErrorMessage = "El día que aplica la percepción es un  campo obligatorio")]
        [RegularExpression("(^[0-9]*$)", ErrorMessage = "Digite solo números")]
        public object Dia { get; set; }
        [Required(ErrorMessage = "El mes donde aplica la percepción es un  campo obligatorio")]
        public object IdMes { get; set; }
        [Required(ErrorMessage = "El importe de la percepcion es un  campo obligatorio")]
        [RegularExpression("(^[0-9 . ,]*$)", ErrorMessage = "Digite solo números")]
        public object Importe { get; set; }
        [Required(ErrorMessage = "El porcentaje sueldo de la percepción es un  campo obligatorio")]
        [RegularExpression("(^[0-9 %]*$)", ErrorMessage = "Digite solo números")]
        public object PorcenjateSueldo { get; set; }        
        [Required(ErrorMessage = "La partida presupuestal de la percepción es un campo obligatorio")]
        public object IdPartidaPresupuestal { get; set; }
        
    }
}





 


