﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Collections;
using System.ComponentModel.DataAnnotations;
using System.Data;
using System.Web.UI;

namespace Nova.Models.PercepcionesCalendarizadas
{
    public  class NominaPercepcionesCalendarizadas
    {
        const string NorthwindDataContextKey = "DXNorthwindDataContext";
        
        public static IEnumerable GetPlantillas2()
        {
            bdNovaEntities DB = new bdNovaEntities();
            return (from IdPlantillaNomina in DB.Nomina_ctPlantillaNomina select IdPlantillaNomina).ToList();
        }

        public static IEnumerable GetPercepcionesCalendarizadas(int IdPlantillaNomina)
        {
            bdNovaEntities DB = new bdNovaEntities();
            return (from idplantilla in DB.Percepciones_stPercepcionesCalendarizadas where idplantilla.IdPlantillaNomina == IdPlantillaNomina select idplantilla).ToList();
        }
        public static IEnumerable GetMes()
        {
            bdNovaEntities DB = new bdNovaEntities();
            return (from Mes in DB.Catalogos_ctMes select Mes).ToList();
        }

        public static bool GetEsCalculoporSistema(object id)
        {
            string f = id.ToString();
            int r = TryToParse(f);

            bdNovaEntities DB = new bdNovaEntities();
            return DB.Percepciones_ctPercepcion.Where(d => d.IdPercepcion == r).Select(h => h.EsCalculoPorSistema).SingleOrDefault();
        }

        private static int  TryToParse(string value)
        {
            int number;
            bool result = Int32.TryParse(value, out number);
            if (!result)
            {
                number= 0;   
            }
            return number;
        }
    }
}