﻿using Nova.Models;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Libraries;
using Dapper;
using System.Text;

namespace Nova.Models
{

    public class AjusteHorasFechaAplicacion
    {
        
        public DateTime FechaAplicacion { get; set; } 

        public int Horas { get; set; } = 0;

        public int DiasAAjustar { get; set; } = 0;

        public int HorasExcedentes { get; set; } = 0;

        public int HorasJornada { get; set; } = 0;

        public int HorasExcedentesNominaActual { get; set; } = 0;

        public int HorasJornadaNominaActual { get; set; } = 0;

        public List<NominaHorariosDocentesDetalle> NominaHorariosDocentesDetalle { get; set; }

     


    }

    public class HorariosVigenteAnterior
    {
        public List<NominaHorariosDocentesDetalle> NominaHorariosDocentesDetalle { get; set; }
        public bool TieneHorario { get; set; } = false;

        public bool HorarioVigente { get; set; } = false;

        public bool EsHorarioHorasExtraordinarias { get; set; }
        public bool SinAplicar{ get; set; } = false;


        public List<NominaHorariosDocentesDetalle> NominaHorariosDocentesDetalleAnterior { get; set; }
    }

    public class HorasPorDocente
    {

        public int Horas { get; set; }
        public int IdModalidadEstudio { get; set; }
        public string TipoHoras { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public int IdTrabajador { get; set; }
        public string ConvenioLaboral { get; set; }

        public string Categoria { get; set; }

        public string UbicacionFisica { get; set; }
        public string CicloEscolar { get; set; }
      
    

    }

    public partial class NominaNominaHorariosDocentes
    {
        public long IdNominaTrabajador { get; set; }
        public long IdConvenioLaboralTrabajadorCategoria { get; set; }
        public long IdHorarioNominaDocente { get; set; }


    }
        public partial class NominaHorariosDocentesDetalle
    {
        public long IdHorarioNominaDocente { get; set; }

        public int IdKardex { get; set; }

        public Nullable<int> IdCicloEscolar  { get; set; }

        public int IdDia { get; set; }

        public int IdTipoHoras { get; set; }

        public  string HoraInicio { get; set; }

        public string HoraFinal { get; set; }

        public Nullable<int> Horas { get; set; }

        public Nullable<short> IdModalidadEstudio { get; set; }

        public Nullable<bool> NoAutorizadas { get; set; }

        public Nullable<int> Vigente { get; set; }

        public Nullable<System.DateTime> FechaMovimiento { get; set; }

        public Nullable<System.DateTime> FechaInicioPago { get; set; }

        public Nullable<System.DateTime> FechaFinalPago { get; set; }

        public Nullable<bool> Aplicado { get; set; }

        public Nullable<bool> MarcarEliminado { get; set; }

        public Nullable<bool> InmediatoAnterior { get; set; }
        public Nullable<int> IdHorarioTabla { get; set; }
        public Nullable<int> IdHorario { get; set; }


        public string Dia { get; set; }
        public string TipoHoras { get; set; }
        public Nullable<int> IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string RFC { get; set; }
       
        public string CURP { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Sexo { get; set; }
        public Nullable<int> IdTrabajador { get; set; }
        public Nullable<System.DateTime> FechaAsignacion { get; set; }
        public string ConvenioLaboral { get; set; }
        public string RelacionLaboral { get; set; }
        public string Categoria { get; set; }
        public string EstructuraOrganica { get; set; }
        public string EstructuraOrganicaPadrePlaza { get; set; }
        public string UbicacionFisica { get; set; }
        public string EstructuraOrganicaPadre { get; set; }
        public Nullable<bool> EsComisionado { get; set; }
        public Nullable<System.DateTime> FechaInicio { get; set; }
        public Nullable<System.DateTime> FechaTermino { get; set; }
        public Nullable<short> IdConvenioLaboralTrabajador { get; set; }
        public string EstatusTrabajador { get; set; }
        public byte[] Fotografia { get; set; }
        public string NSS { get; set; }
        public string CorreoElectronico { get; set; }
        public Nullable<short> IdCategoria { get; set; }
        public Nullable<short> IdEstructuraOrganica { get; set; }
        public Nullable<short> IdRelacionLaboral { get; set; }
        public Nullable<short> IdConvenioLaboral { get; set; }
        public Nullable<short> IdEstructuraOrganicaPadre { get; set; }
        public string CorreoInstitucional { get; set; }
        public string Telefono { get; set; }
        public Nullable<short> OrdenEstructuraOrganica { get; set; }
        public Nullable<short> IdEstructuraOrganicaFisica { get; set; }
        public string Antiguedad { get; set; }
        public string Años { get; set; }
        public string Meses { get; set; }
        public string Dias { get; set; }
        public string Direccion { get; set; }
        public string CorreoTrabajo { get; set; }
        public string TelefonoTrabajo { get; set; }
        public Nullable<bool> ProcesoCompletado { get; set; }
      
        public Nullable<int> IdDistribucionPlazaCategoria { get; set; }
        public Nullable<short> IdRelacionConvenioLaboral { get; set; }
        public Nullable<int> IdeEmpleadoAnt { get; set; }
        public Nullable<bool> EsHomologado { get; set; }
        public string CategoriaAnteriorNova { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string Incidencia { get; set; }
        public Nullable<int> RestringirMenu { get; set; }
         public Nullable<long> IdNominaTrabajador { get; set; }  

}


public class stHorariosDetalleNomina
    {
        public long IdHorario { get; set; }
        public string HoraInicio { get; set; }
        public string HoraFin { get; set; }
        public short IdDia { get; set; }
        public int IdEmpleado { get; set; }
        public int IdNova { get; set; }
        public int IdCicloEscolar { get; set; }
        public string CicloEscolar { get; set; }
        public string Tipo { get; set; }
        public string Dia { get; set; }

    }


    public class HorariosVigenteAnteriorDiferencias
    {

        public int Horas2 { get; set; }
        public int HorasReales { get; set; }

        public int IdCicloEscolar { get; set; }

        public int IdKardex { get; set; }

        public int Diferencia { get; set; }
    }
        public partial class Nomina_DocentesHorasPago
    {
        public class conveniolaboraltrabajadorcategoriaTrabajador
        {
            public int IdConvenioLaboralTrabajadorCategoria { get; set; }
            public String Trabajador { get; set; }
            public String Categoria { get; set; }

        }
        public static List<conveniolaboraltrabajadorcategoriaTrabajador> ObtenTrabajadores()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select x.IdConvenioLaboralTrabajadorCategoria, x.nombre +' '+x.apellidopaterno +' '+ x.apellidomaterno as Trabajador, x.Categoria  from (
select c.IdConvenioLaboralTrabajador, a.nombre,a.apellidopaterno, a.apellidomaterno,case  when GETDATE() >= d.fechatermino THEN 0 ELSE 1 END as Esactivo,
d.IdConvenioLaboralTrabajadorCategoria, f.Categoria, h.ConvenioLaboral,i.RelacionLaboral from Kardex_ctDatosPersonales a
inner join Kardex_ctTrabajador b on a.idkardex = b.idkardex
inner join Convenios_stConvenioLaboralTrabajador c on b.idtrabajador = c.idtrabajador
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on c.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria e on d.IdDistribucionPlazaCategoria = e.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria f on e.IdCategoria = f.IdCategoria
inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral = f.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral h on g.IdConvenioLaboral = h.IdConvenioLaboral
inner join Catalogos_ctRelacionLaboral i on g.IdRelacionLaboral = i.IdRelacionLaboral
) as x
where Esactivo = 1 and x.RelacionLaboral='DOCENTE'";
           // HorarioVigente = (List<stHorario>)dp.connection.Query<stHorario>(query);
            List<conveniolaboraltrabajadorcategoriaTrabajador> listat = (List<conveniolaboraltrabajadorcategoriaTrabajador>)dp.connection.Query<conveniolaboraltrabajadorcategoriaTrabajador>(query);
            dp.Close();
            return listat.ToList();
        }
    }

    public class ConvenioLaboralTrabajadorCategoriaPlazas
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public short IdConvenioLaboralTrabajador { get; set; }
        public int IdDistribucionPlazaCategoria { get; set; }
        public short IdEstructuraOrganica { get; set; }
        public bool EsComisionado { get; set; }
        public System.DateTime FechaInicioNomina { get; set; }
        public System.DateTime FechaTerminoNomina { get; set; }
        public System.DateTime FechaInicio { get; set; }
        public Nullable<System.DateTime> FechaTermino { get; set; }
        public bool EsCancelado { get; set; }
        public int UserId { get; set; }
        public System.DateTime FechaCreacion { get; set; }
        public string Observacion { get; set; }
        public bool EsCuotaSindical { get; set; }
        public Nullable<System.DateTime> FechaCuotaSindical { get; set; }
        public Nullable<System.DateTime> FechaInicioPago { get; set; }
        public bool EsPrimerCalculo { get; set; }
        public Nullable<long> IdIncidenciaTrabajador { get; set; }

        public int IdCategoria { get; set; }

        public bool RestringirMenu { get; set; }
        public int IdTrabajador{ get; set; }
    }
}