﻿
using Nova.Models;

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Libraries;
using Dapper;
using System.Text;
using System.Reflection;

namespace Nova.Models
{



    public sealed class SingletonNominaPivot
    {

      

        private static volatile SingletonNominaPivot instance;
        private static object syncRoot = new Object();


        public List<ValorDatosNominaModel> ValorDatosNominaModel;
      
        public Int32 Año = 0;


        public bool regenerar = false;


        public void getDatos()
        {
            ValorDatosNominaModel = Nova.Models.DatosNominaClass.getDatos(this.Año,0);

        }

        

        private SingletonNominaPivot()
        {


            getDatos();
           

        }

        public void Reset()
        {
            instance.getDatos();
           
        }

        public static SingletonNominaPivot Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new SingletonNominaPivot();
                    }
                }
                else
                {
                    if (DateTime.Now.Day == 1)
                    {
                        if (instance.regenerar == false)
                        {
                            // instance = new SingletonNominaPivot();

                            instance.getDatos();
                           
                            instance.regenerar = true;
                        }
                    }
                    else
                    {
                        instance.regenerar = false;
                    }
                }

                return instance;
            }
        }




    }


    // public static class Singlett<Param, T>
    //where T : class
    // {
    //     static volatile Lazy<Func<Param, T>> _instance;
    //     static object _lock = new object();
    //     //public List<ValorDatosNominaModel> ValorDatosNominaModel;
    //     static Singlett()
    //     {
    //         //ValorDatosNominaModel = Nova.Models.DatosNominaClass.getDatos(this.Año, this.IdNomina);

    //     }

    //     public static Func<Param, T> Instance
    //     {
    //         get
    //         {
    //             if (_instance == null)
    //             {
    //                 _instance = new Lazy<Func<Param, T>>(() =>
    //                 {
    //                     lock (Singlett<Param, T>._lock)
    //                     {
    //                         try
    //                         {
    //                             ConstructorInfo constructor = null;
    //                             Type[] methodArgs = { typeof(Param) };
    //                             constructor = typeof(T).GetConstructor(BindingFlags.Instance | BindingFlags.NonPublic, null, methodArgs, null);// Binding flags excludes public constructors.
    //                             if (constructor == null)
    //                             {
    //                                 constructor = typeof(T).GetConstructor(BindingFlags.Public, null, methodArgs, null);
    //                                 if (constructor == null)
    //                                     return delegate (Param o) { return (T)Activator.CreateInstance(typeof(T), new object[] { o }); };
    //                             }
    //                             return delegate (Param o) { return (T)constructor.Invoke(new object[] { o }); };
    //                         }
    //                         catch (Exception exception)
    //                         {
    //                             throw exception;
    //                         }
    //                     }
    //                 });
    //             }
    //             return _instance.Value;
    //         }
    //     }
    // }
}