﻿using DevExpress.Web.ASPxHtmlEditor.Internal;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Nova.Models.Nomina
{
    public class PercepcionesNominaTrabajador
    {

        public short IdPlantillaNominaPercepcion { get; set; }
        public decimal Importe { get; set; }
        public bool EsImprimibleRecibo { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int IdNomina { get; set; }
        public string Tipo { get; set; }
        public bool EsGrabable { get; set; }
        public bool EsVariable { get; set; }
        public bool EsPrevisionSocial { get; set; }
        public bool EsAjusteHorasExcedentes { get; set; }
        public bool EsAjusteHorasInterinas { get; set; }
        public short IdPercepcion { get; set; }
        public string Percepcion { get; set; }
        public bool EsDevolucionFaltas { get; set; }

        public string Concepto { get; set; } = "";
        public bool TratamientoEspecialIncapacidadesSueldoIsr { get; set; } = false;
        public int IdTrabajador { get; set; } = 0;
    }



    public class CreditosTrabajador
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int IdCreditoTrabajador { get; set; }
        public decimal Importe { get; set; }
        public decimal Saldo { get; set; }
        public bool EsAjuste { get; set; }

        public DateTime FechaTermino { get; set; }
        public bool Terminar { get; set; }

        public string Motivo { get; set; }

        public short ParcialidadesPagadas { get; set; }

        public bool EsAjustetSaldoInsuficiente { get; set; }
        

    }
    //public class PercepcionPersonalizadaTrabajador
    //{
    //    public int IdConvenioLaboralTrabajadorCategoria { get; set; }
    //    public int IdPercepcionesPersonalizadas { get; set; }
    //    public decimal Importe { get; set; }
    //}

    public class PensionesTrabajador
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int IdPensionTrabajador { get; set; }
        public decimal Importe { get; set; }
        public string Concepto { get; set; } = "";
    }

    

        public class BaseGravableTrabajadorMes
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int IdTrabajador { get; set; }
       
        public decimal BaseGravable { get; set; }

        public string Plantilla { get; set; }

        public string QuincenaMes { get; set; }

    }


    public class PercepcionesTrabajadorMes
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int IdTrabajador { get; set; }
        public short IdPercepcion { get; set; }
        public short IdPlantillaNominaPercepcion  { get; set; }
        
        public decimal Importe { get; set; }
        public decimal BaseGravable { get; set; }

        public string Plantilla { get; set; }

        public string QuincenaMes { get; set; }

        public bool? BasePrimaria { get; set; }

    }

    public class DeduccionesTrabajadorMes
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int IdTrabajador { get; set; }
        public short IdPlantillaNominaDeduccion { get; set; }
        public short IdDeducion { get; set; }
        public string Deduccion { get; set; }
        public decimal Importe { get; set; }
        public string Plantilla { get; set; }
        public bool EsCerrada { get; set; }
        
    }
    public class FaltasTrabajador
    {
        public int IdTrabajador { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public long IdIncidenciaTrabajador { get; set; }
        public int IdDeduccion { get; set; }
        public string Deduccion { get; set; }
        public decimal Importe { get; set; }
    }

    public class VariablesNominaTrabajador
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public decimal Importe { get; set; }
        public string Concepto { get; set; }
        public string ConceptoExtra { get; set; }
        public long IdIncidenciaTrabajador { get; set; }

        public int IdTrabajador { get; set; } = 0;
    }

}
