﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Models
{
    public class SuplenciasSolicitudesDependencias
    {
        public int IdSuplenciaSolicitud { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }

        public string NombreCubierto { get; set; }
        public string ApellidoPaternoCubierto { get; set; }
        public string ApellidoMaternoCubierto { get; set; }

        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string TipoSuplencia { get; set; }
        public string Categoria { get; set; }
        public string CategoriaAnterior { get; set; }
        public string CategoriaCubierto { get; set; }

        public int IdConvenioLaboralTrabajadorCategoria { get; set; }

        

    }


    
public class DiasEconomicosDisfrutados: IncidenciaPermiso_stIncidenciaTrabajador
    {

        public int IdTrabajador { get; set; }
     
    }


    public class PartesProporcionalesUltimoContrato
    {

        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int Año { get; set; }
        public int IdTrabajador { get; set; }
    }
    public class PuntualidadYAsistenciaPerdidas
    {
        
        public int IdTrabajador { get; set; }
        public int Meses { get; set; }
    }

    public class NominasTotalesPorRelacionLaboral
    {

        public int TotalCerradas { get; set; }
        public int TotalNominas { get; set; }
    }

    public class IncidenciasControlNominas
    {
        public string EstructuraOrganica { get; set; }
        public string Nombre { get; set; }
        public int Cerradas { get; set; }
    }

    public partial class AlertasNomina : Alertas
    {
        public override void GeneraAlertas()
        {
            bdNovaEntities db = new bdNovaEntities();
            //DateTime hoy = DateTime.Now.Date;

            //int idkardex = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            //var tomados = db.Capacitacion_stParticipantes.Where(h => h.IdKardex == idkardex).Select(g => g.IdConvocatoriaCursosSedesAulas).ToList();
            //List<Capacitacion_stConvocatoriasCursosSedesAulas> cursos = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => tomados.Contains(r.IdConvocatoriaCursosSedesAulas)).ToList();
            var movimientos = db.vwNominaMovimientosTrabajadores.ToList();
            if (movimientos.Count > 0)
            {

                string elementos = "";
                foreach (var item in movimientos)
                {
                    UrlHelper u = new UrlHelper(HttpContext.Current.Request.RequestContext);
                    string ruta = u.Action("vMovimientosTrabajadores", "Nomina");

                    //Int64 idusuario = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
                    //Capacitacion_stParticipantes inscrito = db.Capacitacion_stParticipantes.Where(t => t.Capacitacion_stConvocatoriasCursosSedesAulas.IdConvocatoriaCursos == item.IdConvocatoriaCursos && t.IdKardex == idusuario).FirstOrDefault();
                    if (item.Movimiento == "BAJAS")
                    {
                        elementos = elementos += @"<li>
                                         <a href='" + ruta + @"'>
										<div style='style='font-size:24px'>
                                      <i class='fa fa-calendar-times-o' style='font-size:24px; color: red'></i>
                                        <span class='message'>
										" + item.Nombre + @" " + item.ApellidoPaterno + @" " + item.ApellidoMaterno + @" " + item.FechaInicio.ToString("yyyy/mm/dd") + @"-" + item.FechaTermino.Value.ToString("yyyy/mm/dd") + @"</span>
                                                </div>
										</a>
									</li>";
                    }
                    else
                    {
                        elementos = elementos += @"<li>
                                         <a href='" + ruta + @"'>
										<div style='style='font-size:24px'>
                                      <i class='fa fa-calendar-check-o' style='font-size:24px; color: green'></i>
                                        <span class='message'>
										" + item.Nombre + @" " + item.ApellidoPaterno + @" " + item.ApellidoMaterno + @" " + item.FechaInicio + @"-" + item.FechaTermino + @"</span>
                                        </div>
										</a>
									</li>";
                    }
                }

                alerta l0 = new alerta();
                l0.controlador = "";
                l0.accion = "";
                l0.icono = "fa fa-ellipsis-v";
                l0.mensaje = "";
                l0.numero = "";
                l0.idLi = "nomid_2018";
                l0.cssBadge = "";



                l0.ulsubmenu = "";

                this.ListaAlertas.Add(l0);

                alerta l1 = new alerta();
                l1.controlador = "Nomina";
                l1.accion = "Movimientos";
                l1.icono = "fa fa-bell-o";
                l1.mensaje = "Movimientos";
                l1.numero = movimientos.Count.ToString();
                l1.idLi = "nomid_781";
                l1.cssBadge = "badge badge-info m-animate-blink";



                l1.ulsubmenu = @"<ul class='dropdown-menu'>
							<li class='external'>
								<h3><span class='bold'> " + movimientos.Count + @"</span> Movimientos </h3>
								
							</li>
							<li>
								<ul class='dropdown-menu-list scrollable-menu' >
                                    
									" + elementos + @"
								</ul>
							</li>
						</ul>";

                this.ListaAlertas.Add(l1);


            }

        }
    }

    public class IsrGrupoString
    {
        public short IdIsrGrupo { get; set; }
        public string IsrGrupo { get; set; }
    }
    public class QuincenaMesString
    {
        public short IdQuincenaMes { get; set; }
        public string QuincenaMes { get; set; }
    }
    public class PlantillaNomina
    {
        public short IdPlantillaNomina { get; set; }
        public string Plantilla { get; set; }
    }

    public class CuotasImss
    {
        public string  ConvenioLaboral { get; set; }
        public string EncuadreProgramatico { get; set; }

        public string Proyecto { get; set; }
        public string Concepto { get; set; }

        public string TipoSubDeduccion { get; set; }

        public string DeduccionClasificacion { get; set; }

        

        public decimal Importe { get; set; }

        
    }

    public class CuotasImssPivot
    {
        public string ConvenioLaboral { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string EncuadreProgramatico { get; set; }

        public string DeduccionClasificacion { get; set; }

        

        public string Proyecto { get; set; }

        public decimal Patronal { get; set; }
        public decimal Obrera { get; set; }
        public decimal SubTotal { get; set; }

    
    }

    public class ImpuestosSobreNominasPivot
    {
        public string ConvenioLaboral { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string EncuadreProgramatico { get; set; }

        public string Proyecto { get; set; }

        public decimal NumeroTrabajadores { get; set; }
        public decimal Impuesto { get; set; }
        public decimal BaseGravable { get; set; }

        public decimal ImpuestoSobreNomina { get; set; }
    }
    public class Articulo36
    {

        public string ClaveFinanciamiento  { get; set; }
        
      public string  Categoria  { get; set; }
      public string  RelacionLaboral  { get; set; }
      public string  EstructuraOrganica  { get; set; }
      public decimal  CUM1  { get; set; }
      public decimal  CUM2  { get; set; }
      public decimal  CUM3  { get; set; }
      public decimal  CUM4  { get; set; }
      public decimal  CUM5  { get; set; }
      public decimal  CUM6  { get; set; }
      public decimal  CUM7  { get; set; }
      public decimal  CUM8  { get; set; }
      public decimal  CUM9  { get; set; }
      public decimal  CUM10  { get; set; }
      public decimal  CUM11  { get; set; }
      public decimal  CUM12  { get; set; }
      public decimal  TPM1  { get; set; }
      public decimal  TPM2  { get; set; }
      public decimal  TPM3  { get; set; }
      public decimal  TPM4  { get; set; }
      public decimal  TPM5  { get; set; }
      public decimal  TPM6  { get; set; }
      public decimal  TPM7  { get; set; }
      public decimal  TPM8  { get; set; }
      public decimal  TPM9  { get; set; }
      public decimal  TPM10  { get; set; }
      public decimal  TPM11  { get; set; }
      public decimal  TPM12  { get; set; }
      public decimal  TNM1  { get; set; }
      public decimal  TNM2  { get; set; }
      public decimal  TNM3  { get; set; }
      public decimal  TNM4  { get; set; }
      public decimal  TNM5  { get; set; }
      public decimal  TNM6  { get; set; }
      public decimal  TNM7  { get; set; }
      public decimal  TNM8  { get; set; }
      public decimal  TNM9  { get; set; }
      public decimal  TNM10  { get; set; }
      public decimal  TNM11  { get; set; }
      public decimal  TNM12  { get; set; }
      public decimal  TOTALNETO  { get; set; }
    }
        public class ImpuestosSobreNominas
    {
   

        public string ConvenioLaboral { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string EncuadreProgramatico { get; set; }

        public string Proyecto { get; set; }

        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }

        public decimal Deducciones { get; set; }
        public decimal Percepciones { get; set; }

        public decimal BaseGravable { get; set; }

        public decimal ImpuestoSobreNomina { get; set; }

        public Int32 IdTrabajador { get; set; }

        


    }
    public partial class Nomina_stNomina
    {
        //public static IEnumerable getIdQuincenaMes()
        //{
        //    bdNovaEntities db = new bdNovaEntities();
        //    return db.Nomina_stNomina.Select(g => new { g.IdQuincenaMes, g.Catalogos_ctQuincenaMes.QuincenaMes, g.Catalogos_ctMes.Mes }).ToList();
        //}

        public static string getBimestre(string fi, string ff)
        { 
            string regresa=fi +" al " +ff;
            var fc = DateTime.Parse(fi);
            var ft = DateTime.Parse(ff);

                if (fc.Month == 1 && ft.Month == 2)
                regresa = "1er BIMESTRE DEL " + fc.Year;
                else
                if (fc.Month == 3 && ft.Month == 4)
                regresa = "2o BIMESTRE DEL " + fc.Year;
            else
                if (fc.Month == 5 && ft.Month == 6)
                regresa = "3er BIMESTRE DEL " + fc.Year;

            else
                if (fc.Month == 7 && ft.Month == 8)
                regresa = "4o BIMESTRE DEL " + fc.Year;
            else
                if (fc.Month == 9 && ft.Month == 10)
                regresa = "5o BIMESTRE DEL " + fc.Year;
            else
                if (fc.Month == 11 && ft.Month == 12)
                regresa = "6o BIMESTRE DEL " + fc.Year;
            return regresa;
        }

        public static string getTrimestreMeses(string fi, string ff)
        {
            string regresa = "";
            var fc = DateTime.Parse(fi);
            var ft = DateTime.Parse(ff);

            if (fc.Month == 1 && ft.Month == 3)
                regresa = "1,2,3";
            else
            if (fc.Month == 4 && ft.Month == 6)
                regresa = "4,5,6";
            else
            if (fc.Month == 7 && ft.Month == 9)
                regresa = "7,8,9";

            else
            if (fc.Month == 10 && ft.Month == 12)
                regresa = "10,11,12";
            
            return regresa;
        }



        public List<CuotasImssPivot> getCuotasImss(List<CuotasImss> info)
        {
            List<CuotasImssPivot> resultado = new List<CuotasImssPivot>();

            var gruporelacion = info.GroupBy(a => new { a.ConvenioLaboral, a.EncuadreProgramatico, a.Proyecto}).Select(s => new { ConvenioLaboral = s.Key.ConvenioLaboral, EncuadreProgramatico = s.Key.EncuadreProgramatico, Proyecto = s.Key.Proyecto, DeduccionClasificacion = s.Max(r=> r.DeduccionClasificacion), Patronal = s.Sum(a => (a.TipoSubDeduccion!= "OBRERO" ? a.Importe: 0) ), Obrera = s.Sum(a => (a.TipoSubDeduccion == "OBRERO" ? a.Importe : 0)) }).ToList();

            var subtotales = info.GroupBy(a => new { a.EncuadreProgramatico, a.Proyecto }).Select(s => new { ConvenioLaboral = "SUBTOTAL", EncuadreProgramatico = s.Key.EncuadreProgramatico, Proyecto = s.Key.Proyecto, DeduccionClasificacion = s.Max(r => r.DeduccionClasificacion), Patronal = s.Sum(a => (a.TipoSubDeduccion != "OBRERO" ? a.Importe : 0)), Obrera = s.Sum(a => (a.TipoSubDeduccion == "OBRERO" ? a.Importe : 0)),SubTotal=s.Sum(d=> d.Importe) }).ToList();

            

            decimal subtotalbg = 0M;
            decimal subtotaltrabajadores = 0M;
            decimal subtotalisn = 0M;
            string convenio = "";
            int n = 0;
            int limite = gruporelacion.Count();
            foreach (var item in gruporelacion)
            {
                n++;
                if (n == 1)
                    convenio = item.ConvenioLaboral;

                if (convenio != item.ConvenioLaboral && n > 1)
                {





                    CuotasImssPivot registro2 = new CuotasImssPivot();

                    registro2.ConvenioLaboral = "TOTAL " + convenio;
                    registro2.EncuadreProgramatico = "";
                    registro2.Proyecto = "";

                    registro2.DeduccionClasificacion = "";

                    registro2.Patronal = subtotalbg;
                    registro2.Obrera = subtotalisn;
                    registro2.SubTotal = subtotalbg+ subtotalisn;

                    resultado.Add(registro2);


                    subtotalbg = 0;
                    subtotaltrabajadores = 0;

                    subtotalisn = 0;

                    convenio = item.ConvenioLaboral;
                }



                CuotasImssPivot registro = new CuotasImssPivot();
                registro.ConvenioLaboral = item.ConvenioLaboral;
                registro.DeduccionClasificacion = item.DeduccionClasificacion;

                registro.EncuadreProgramatico = item.EncuadreProgramatico;
                registro.Proyecto = item.Proyecto;
                
                registro.Patronal = item.Patronal;
                registro.Obrera = item.Obrera;
                registro.SubTotal = item.Patronal+ item.Obrera;

                resultado.Add(registro);

                subtotalbg = subtotalbg + item.Patronal;
                

                subtotalisn = subtotalisn + item.Obrera;

                if (n == limite)
                {


                    CuotasImssPivot registro2 = new CuotasImssPivot();
                    registro2.DeduccionClasificacion = "";
                    registro2.ConvenioLaboral = "TOTAL " + convenio;
                    registro2.EncuadreProgramatico = "";
                    registro2.Proyecto = "";
                    registro2.Patronal = subtotalbg;
                    registro2.Obrera = subtotalisn;
                    registro2.SubTotal = subtotalbg + subtotalisn;

                    resultado.Add(registro2);


                    subtotalbg = 0;
                    subtotaltrabajadores = 0;

                    subtotalisn = 0;

                    convenio = item.ConvenioLaboral;
                }

            }

            decimal totalpatronal = 0;
            decimal totalobrero = 0;
            decimal totalgral = 0;

            foreach (var item in subtotales)
            {
                CuotasImssPivot registro2 = new CuotasImssPivot();
                registro2.DeduccionClasificacion = item.DeduccionClasificacion;
                registro2.ConvenioLaboral = item.ConvenioLaboral;
                registro2.EncuadreProgramatico = item.EncuadreProgramatico;
                registro2.Proyecto = item.Proyecto;
                registro2.Patronal = item.Patronal;
                registro2.Obrera = item.Obrera;
                registro2.SubTotal = item.SubTotal;

                totalpatronal = totalpatronal + item.Patronal;
                totalobrero = totalobrero + item.Obrera;
               // totalgral = totalgral + totalpatronal + totalobrero;

                resultado.Add(registro2);
            }

            CuotasImssPivot registro5 = new CuotasImssPivot();
            registro5.DeduccionClasificacion = "";
            registro5.ConvenioLaboral = "TOTAL GENERAL";
            registro5.EncuadreProgramatico = "";
            registro5.Proyecto = "";
            registro5.Patronal = totalpatronal;
            registro5.Obrera = totalobrero;
            registro5.SubTotal = totalpatronal+ totalobrero;

            
            resultado.Add(registro5);

            return resultado;
        }
        public List<ImpuestosSobreNominasPivot> getImpuestosSobreNominas(List<ImpuestosSobreNominas> info)
        {
            List<ImpuestosSobreNominasPivot> resultado = new List<ImpuestosSobreNominasPivot>();

            var gruporelacion = info.GroupBy(a => new { a.ConvenioLaboral,  a.EncuadreProgramatico, a.Proyecto }).Select(s => new { ConvenioLaboral=s.Key.ConvenioLaboral, EncuadreProgramatico = s.Key.EncuadreProgramatico, Proyecto = s.Key.Proyecto,NumeroTrabajadores=s.Count(), BaseGravable = s.Sum(a=> a.BaseGravable), ImpuestoSobreNomina = s.Sum(a => a.ImpuestoSobreNomina) }).ToList();

            decimal subtotalbg = 0M;
            decimal subtotaltrabajadores = 0M;
            decimal subtotalisn = 0M;
            string convenio = "";
            int n = 0;
            int limite = gruporelacion.Count();

            decimal Totalbg = 0M;
            decimal Totaltrabajadores = 0M;
            decimal Totalisn = 0M;

            foreach (var item in gruporelacion)
            {
                n ++;
                if (n==1)
                    convenio = item.ConvenioLaboral;

                if (convenio != item.ConvenioLaboral && n > 1)
                {
                    


                  

                    ImpuestosSobreNominasPivot registro2 = new ImpuestosSobreNominasPivot();
                    
                    registro2.ConvenioLaboral = "TOTAL "+convenio;
                    registro2.EncuadreProgramatico = "";
                    registro2.Proyecto = "";
                    registro2.NumeroTrabajadores = subtotaltrabajadores;
                    registro2.BaseGravable = subtotalbg;
                    registro2.ImpuestoSobreNomina = subtotalisn;
                    registro2.Impuesto = .03M;

                    resultado.Add(registro2);


                    subtotalbg = 0;
                    subtotaltrabajadores = 0;

                    subtotalisn = 0;

                    convenio = item.ConvenioLaboral;
                }
            
                

                ImpuestosSobreNominasPivot registro = new ImpuestosSobreNominasPivot();
                registro.ConvenioLaboral = item.ConvenioLaboral;
          
                registro.EncuadreProgramatico = item.EncuadreProgramatico;
                registro.Proyecto = item.Proyecto;
                registro.NumeroTrabajadores = item.NumeroTrabajadores;
                registro.BaseGravable = item.BaseGravable;
                registro.ImpuestoSobreNomina = item.ImpuestoSobreNomina;
                registro.Impuesto = .03M;

                resultado.Add(registro);

                subtotalbg = subtotalbg + item.BaseGravable;
                subtotaltrabajadores = subtotaltrabajadores + item.NumeroTrabajadores;

                subtotalisn = subtotalisn + item.ImpuestoSobreNomina;

                Totalbg = Totalbg + item.BaseGravable;
                Totaltrabajadores = Totaltrabajadores + item.NumeroTrabajadores;
                Totalisn = Totalisn + item.ImpuestoSobreNomina;

                if (n == limite)
                {


                    ImpuestosSobreNominasPivot registro2 = new ImpuestosSobreNominasPivot();
               
                    registro2.ConvenioLaboral = "TOTAL " + convenio;
                    registro2.EncuadreProgramatico = "";
                    registro2.Proyecto = "";
                    registro2.NumeroTrabajadores = subtotaltrabajadores;
                    registro2.BaseGravable = subtotalbg;
                    registro2.ImpuestoSobreNomina = subtotalisn;
                    registro2.Impuesto = .03M;

                    resultado.Add(registro2);


                    subtotalbg = 0;
                    subtotaltrabajadores = 0;

                    subtotalisn = 0;

                    convenio = item.ConvenioLaboral;
                }



            }

            ImpuestosSobreNominasPivot registro5 = new ImpuestosSobreNominasPivot();

            registro5.ConvenioLaboral = "TOTAL GENERAL " ;
            registro5.EncuadreProgramatico = "";
            registro5.Proyecto = "";
            registro5.NumeroTrabajadores = Totaltrabajadores;
            registro5.BaseGravable = Totalbg;
            registro5.ImpuestoSobreNomina = Totalisn;
            registro5.Impuesto = .03M;

            resultado.Add(registro5);

            return resultado;
        }
        public List<Articulo36> getArticulo36(string fechainicio, string fechatermino)
        {
            var año = DateTime.Parse(fechainicio);
            string query = @" SELECT clavefinanciamiento,Categoria,RelacionLaboral,EstructuraOrganica,
MAX(CASE WHEN (Mes)=1 THEN costoUnitario ELSE 0 END) CUM1,
MAX(CASE WHEN (Mes)=2 THEN costoUnitario ELSE 0 END) CUM2,
MAX(CASE WHEN (Mes)=3 THEN costoUnitario ELSE 0 END) CUM3,

MAX(CASE WHEN (Mes)=4 THEN costoUnitario ELSE 0 END) CUM4,
MAX(CASE WHEN (Mes)=5 THEN costoUnitario ELSE 0 END) CUM5,
MAX(CASE WHEN (Mes)=6 THEN costoUnitario ELSE 0 END) CUM6,

MAX(CASE WHEN (Mes)=7 THEN costoUnitario ELSE 0 END) CUM7,
MAX(CASE WHEN (Mes)=8 THEN costoUnitario ELSE 0 END) CUM8,
MAX(CASE WHEN (Mes)=9 THEN costoUnitario ELSE 0 END) CUM9,

MAX(CASE WHEN (Mes)=10 THEN costoUnitario ELSE 0 END) CUM10,
MAX(CASE WHEN (Mes)=11 THEN costoUnitario ELSE 0 END) CUM11,
MAX(CASE WHEN (Mes)=12 THEN costoUnitario ELSE 0 END) CUM12,

SUM(CASE WHEN (Mes)=1 THEN TotalPlazas ELSE 0 END) TPM1,
SUM(CASE WHEN (Mes)=2 THEN TotalPlazas ELSE 0 END) TPM2,
SUM(CASE WHEN (Mes)=3 THEN TotalPlazas ELSE 0 END) TPM3,
SUM(CASE WHEN (Mes)=4 THEN TotalPlazas ELSE 0 END) TPM4,
SUM(CASE WHEN (Mes)=5 THEN TotalPlazas ELSE 0 END) TPM5,
SUM(CASE WHEN (Mes)=6 THEN TotalPlazas ELSE 0 END) TPM6,
SUM(CASE WHEN (Mes)=7 THEN TotalPlazas ELSE 0 END) TPM7,
SUM(CASE WHEN (Mes)=8 THEN TotalPlazas ELSE 0 END) TPM8,
SUM(CASE WHEN (Mes)=9 THEN TotalPlazas ELSE 0 END) TPM9,
SUM(CASE WHEN (Mes)=10 THEN TotalPlazas ELSE 0 END) TPM10,
SUM(CASE WHEN (Mes)=11 THEN TotalPlazas ELSE 0 END) TPM11,
SUM(CASE WHEN (Mes)=12 THEN TotalPlazas ELSE 0 END) TPM12,


SUM(CASE WHEN (Mes)=1 THEN Neto ELSE 0 END) TNM1,
SUM(CASE WHEN (Mes)=2 THEN Neto ELSE 0 END) TNM2,
SUM(CASE WHEN (Mes)=3 THEN Neto ELSE 0 END) TNM3,

SUM(CASE WHEN (Mes)=4 THEN Neto ELSE 0 END) TNM4,
SUM(CASE WHEN (Mes)=5 THEN Neto ELSE 0 END) TNM5,
SUM(CASE WHEN (Mes)=6 THEN Neto ELSE 0 END) TNM6,
SUM(CASE WHEN (Mes)=7 THEN Neto ELSE 0 END) TNM7,
SUM(CASE WHEN (Mes)=8 THEN Neto ELSE 0 END) TNM8,
SUM(CASE WHEN (Mes)=9 THEN Neto ELSE 0 END) TNM9,

SUM(CASE WHEN (Mes)=10 THEN Neto ELSE 0 END) TNM10,
SUM(CASE WHEN (Mes)=11 THEN Neto ELSE 0 END) TNM11,
SUM(CASE WHEN (Mes)=12 THEN Neto ELSE 0 END) TNM12,

SUM(Neto) TOTALNETO
 FROM ( 
SELECT  
clavefinanciamiento,
d.Categoria,z.RelacionLaboral,max(a.SueldoDiario)*30 as costoUnitario,COUNT( distinct a.IdConvenioLaboralTrabajadorCategoria) as TotalPlazas, month (q.FechaTermino) as Mes
,s.EstructuraOrganica,sum(a.SueldoNeto) as Neto
  FROM [Nomina_stNominaTrabajador] a
    inner join Nomina_stNomina q on q.IdNomina=a.IdNomina
  inner join Convenios_stConvenioLaboralTrabajadorCategoria b
  on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Plazas_stDistribucionPlazaCategoria c on b.IdDistribucionPlazaCategoria=c.IdDistribucionPlazaCategoria
 inner join Plazas_ctCategoria d on d.IdCategoria=c.IdCategoria
  inner join Nomina_stNominaTrabajadorEstatus j on j.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
  inner join Nomina_stNominaTrabajadorEstatusGrupo k on k.IdNominaTrabajadorEstatusGrupo=j.IdNominaTrabajadorEstatusGrupo
    inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral=d.IdRelacionConvenioLaboral
  
  inner join [Catalogos_ctRelacionLaboral] z on z.IdRelacionLaboral=g.IdRelacionLaboral
    inner join Catalogos_ctEstructuraOrganica s on s.IdEstructuraOrganica=b.IdEstructuraOrganica
    left join [Nomina_AjustePresupuestal] r on r.IdNomina=q.IdNomina
  left join [Nomina_ClaveFinanciamiento] y on r.idclavefinanciamiento=y.idclavefinanciamiento
   where
    k.EstatusNominaGrupo='PARA PAGO' 
     and ((q.FechaInicio>='" + fechainicio + "' and q.FechaTermino<='" + fechatermino + @"') or (q.FechaTermino='" + fechatermino + "' and year(q.FechaInicio)="+ año.Year + @"))
  group by clavefinanciamiento,d.Categoria,z.RelacionLaboral,s.EstructuraOrganica,month (q.FechaTermino) 
 ) AS Q
 GROUP BY clavefinanciamiento,Categoria,RelacionLaboral,EstructuraOrganica";
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            var articulo = (List<Articulo36>)dp.connection.Query<Articulo36>(query);
            dp.Close();

            return articulo;

    


        }
            public List<ImpuestosSobreNominas> getImpuestosSobreNominas(string fechainicio, string fechatermino)
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @" WITH percepciones
AS
(
SELECT 
uno.tipo,uno.ConvenioLaboral,
uno.RelacionConvenioLaboral,uno.EncuadreProgramatico,uno.Proyecto,uno.Nombre,uno.ApellidoPaterno
,uno.ApellidoMaterno,dos.PercepcionDeduccion,case when (uno.importe*.010)>dos.iMPORTE then (uno.importe*.010)-dos.iMPORTE else 0 end as Importe
,uno.IdTrabajador,uno.idEncuadreProgramatico
from (
SELECT 'PERCEPCION' AS TIPO,cl.ConvenioLaboral,
g.RelacionConvenioLaboral,q.EncuadreProgramatico,q.Proyecto,W.Nombre,W.ApellidoPaterno,W.ApellidoMaterno,t.Percepcion+' '+A.Concepto AS PercepcionDeduccion, sum (a.importe) as Importe
,P.IdTrabajador,Q.idEncuadreProgramatico
   FROM Percepciones_stNominaTrabajadorPercepciones a
  inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
  inner join Nomina_stNomina d on d.IdNomina=c.IdNomina
  inner join Percepciones_stPlantillaNominaPercepciones s on s.IdPlantillaNominaPercepcion=a.IdPlantillaNominaPercepcion
 inner join Percepciones_ctPercepcion t on t.IdPercepcion=s.IdPercepcion
 inner join Catalogos_ctGrupoPercepciones zz on zz.IdGrupoPercepcion=t.IdGrupoPercepcion
  inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina=d.IdPlantillaNomina
  inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral=f.IdRelacionConvenioLaboral
   inner join Nomina_stNominaTrabajadorEstatus j on j.IdNominaTrabajadorEstatus=c.IdNominaTrabajadorEstatus
  inner join Nomina_stNominaTrabajadorEstatusGrupo k on k.IdNominaTrabajadorEstatusGrupo=j.IdNominaTrabajadorEstatusGrupo
  inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria
  inner join [Catalogos_ctConvenioLaboral] cl on cl.IdConvenioLaboral=g.IdConvenioLaboral
  inner join Catalogos_ctEstructuraOrganica m on m.IdEstructuraOrganica=l.IdEstructuraOrganica
  INNER JOIN Catalogos_ctEncuadreProgramatico q on q.idmodalidadEstudio=m.idmodalidadEstudio
 inner  join Convenios_stConvenioLaboralTrabajador x on x.IdConvenioLaboralTrabajador=l.IdConvenioLaboralTrabajador
 inner join Kardex_ctTrabajador p on p.IdTrabajador=x.IdTrabajador
 inner  join Kardex_ctDatosPersonales w on w.IdKardex=p.IdKardex
  where k.EstatusNominaGrupo='PARA PAGO'   and t.Percepcion like '%SUELDO%'
AND d.EsCerrada=1 
  and (d.FechaInicio>='" + fechainicio + "' and d.FechaTermino<='" + fechatermino + @"')
    GROUP BY cl.ConvenioLaboral,g.RelacionConvenioLaboral,q.EncuadreProgramatico,q.Proyecto,W.Nombre,W.ApellidoPaterno,W.ApellidoMaterno,t.Percepcion,A.Concepto 
,P.IdTrabajador,Q.idEncuadreProgramatico
  ) AS UNO
  LEFT JOIN (

SELECT 'PERCEPCION' AS TIPO,cl.ConvenioLaboral,
g.RelacionConvenioLaboral,q.EncuadreProgramatico,q.Proyecto,W.Nombre,W.ApellidoPaterno,W.ApellidoMaterno,t.Percepcion+' '+A.Concepto AS PercepcionDeduccion, sum(a.importe) as Importe
,P.IdTrabajador,Q.idEncuadreProgramatico
   FROM Percepciones_stNominaTrabajadorPercepciones a
  inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
  inner join Nomina_stNomina d on d.IdNomina=c.IdNomina
  inner join Percepciones_stPlantillaNominaPercepciones s on s.IdPlantillaNominaPercepcion=a.IdPlantillaNominaPercepcion
 inner join Percepciones_ctPercepcion t on t.IdPercepcion=s.IdPercepcion
 inner join Catalogos_ctGrupoPercepciones zz on zz.IdGrupoPercepcion=t.IdGrupoPercepcion
  inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina=d.IdPlantillaNomina
  inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral=f.IdRelacionConvenioLaboral
   inner join Nomina_stNominaTrabajadorEstatus j on j.IdNominaTrabajadorEstatus=c.IdNominaTrabajadorEstatus
  inner join Nomina_stNominaTrabajadorEstatusGrupo k on k.IdNominaTrabajadorEstatusGrupo=j.IdNominaTrabajadorEstatusGrupo
  inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria
  inner join [Catalogos_ctConvenioLaboral] cl on cl.IdConvenioLaboral=g.IdConvenioLaboral
  inner join Catalogos_ctEstructuraOrganica m on m.IdEstructuraOrganica=l.IdEstructuraOrganica
  INNER JOIN Catalogos_ctEncuadreProgramatico q on q.idmodalidadEstudio=m.idmodalidadEstudio
 inner  join Convenios_stConvenioLaboralTrabajador x on x.IdConvenioLaboralTrabajador=l.IdConvenioLaboralTrabajador
 inner join Kardex_ctTrabajador p on p.IdTrabajador=x.IdTrabajador
 inner  join Kardex_ctDatosPersonales w on w.IdKardex=p.IdKardex
  where k.EstatusNominaGrupo='PARA PAGO'   and t.Percepcion like '%DESPENSA%'
AND d.EsCerrada=1 
  and (d.FechaInicio>='" + fechainicio + "' and d.FechaTermino<='" + fechatermino + @"')
    GROUP BY cl.ConvenioLaboral,g.RelacionConvenioLaboral,q.EncuadreProgramatico,q.Proyecto,W.Nombre,W.ApellidoPaterno,W.ApellidoMaterno,t.Percepcion,A.Concepto,Q.idEncuadreProgramatico
,P.IdTrabajador ) AS DOS ON UNO.IdTrabajador=DOS.IdTrabajador 
--AND UNO.EncuadreProgramatico=DOS.EncuadreProgramatico
  where (uno.importe*.010)>dos.iMPORTE
  
   union all 
  
SELECT 'PERCEPCION' AS TIPO,cl.ConvenioLaboral,
g.RelacionConvenioLaboral,q.EncuadreProgramatico,q.Proyecto,W.Nombre,W.ApellidoPaterno,W.ApellidoMaterno,t.Percepcion+' '+A.Concepto AS PercepcionDeduccion, a.importe
,P.IdTrabajador,Q.idEncuadreProgramatico
   FROM Percepciones_stNominaTrabajadorPercepciones a
  inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
  inner join Nomina_stNomina d on d.IdNomina=c.IdNomina
  inner join Percepciones_stPlantillaNominaPercepciones s on s.IdPlantillaNominaPercepcion=a.IdPlantillaNominaPercepcion
 inner join Percepciones_ctPercepcion t on t.IdPercepcion=s.IdPercepcion
 inner join Catalogos_ctGrupoPercepciones zz on zz.IdGrupoPercepcion=t.IdGrupoPercepcion
  inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina=d.IdPlantillaNomina
  inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral=f.IdRelacionConvenioLaboral
   inner join Nomina_stNominaTrabajadorEstatus j on j.IdNominaTrabajadorEstatus=c.IdNominaTrabajadorEstatus
  inner join Nomina_stNominaTrabajadorEstatusGrupo k on k.IdNominaTrabajadorEstatusGrupo=j.IdNominaTrabajadorEstatusGrupo
  inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria
  inner join [Catalogos_ctConvenioLaboral] cl on cl.IdConvenioLaboral=g.IdConvenioLaboral
  inner join Catalogos_ctEstructuraOrganica m on m.IdEstructuraOrganica=l.IdEstructuraOrganica
  INNER JOIN Catalogos_ctEncuadreProgramatico q on q.idmodalidadEstudio=m.idmodalidadEstudio
 inner  join Convenios_stConvenioLaboralTrabajador x on x.IdConvenioLaboralTrabajador=l.IdConvenioLaboralTrabajador
 inner join Kardex_ctTrabajador p on p.IdTrabajador=x.IdTrabajador
 inner  join Kardex_ctDatosPersonales w on w.IdKardex=p.IdKardex
  where k.EstatusNominaGrupo='PARA PAGO'  
AND d.EsCerrada=1 
  and (d.FechaInicio>='" + fechainicio + "' and d.FechaTermino<='" + fechatermino + @"')

 union all 
  
  SELECT 'DEDUCCION' AS TIPO,
cl.ConvenioLaboral, g.RelacionConvenioLaboral,q.EncuadreProgramatico,q.Proyecto,W.Nombre,W.ApellidoPaterno,W.ApellidoMaterno,t.Deduccion+' '+A.Concepto AS PercepcionDeduccion, a.importe
,P.IdTrabajador,Q.idEncuadreProgramatico
   FROM Deducciones_stNominaTrabajadorDeduccion a
  inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
  inner join Nomina_stNomina d on d.IdNomina=c.IdNomina
  inner join Deducciones_stPlantillaNominaDeducciones s on s.IdPlantillaNominaDeduccion=a.IdPlantillaNominaDeduccion
  inner join Deducciones_ctDeduccion t on t.IdDeduccion=s.IdDeduccion
  inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina=d.IdPlantillaNomina
  inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral=f.IdRelacionConvenioLaboral
   inner join Nomina_stNominaTrabajadorEstatus j on j.IdNominaTrabajadorEstatus=c.IdNominaTrabajadorEstatus
  inner join Nomina_stNominaTrabajadorEstatusGrupo k on k.IdNominaTrabajadorEstatusGrupo=j.IdNominaTrabajadorEstatusGrupo
  inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria
  inner join [Catalogos_ctConvenioLaboral] cl on cl.IdConvenioLaboral=g.IdConvenioLaboral
  inner join Catalogos_ctEstructuraOrganica m on m.IdEstructuraOrganica=l.IdEstructuraOrganica
  INNER JOIN Catalogos_ctEncuadreProgramatico q on q.idmodalidadEstudio=m.idmodalidadEstudio
 inner  join Convenios_stConvenioLaboralTrabajador x on x.IdConvenioLaboralTrabajador=l.IdConvenioLaboralTrabajador
 inner join Kardex_ctTrabajador p on p.IdTrabajador=x.IdTrabajador
 inner  join Kardex_ctDatosPersonales w on w.IdKardex=p.IdKardex
  where k.EstatusNominaGrupo='PARA PAGO'   and t.Deduccion<>'ISR' and t.Deduccion<>'IMSS'
AND d.EsCerrada=1 
  and (d.FechaInicio>='" + fechainicio + "' and d.FechaTermino<='" + fechatermino + @"')

  )
  
   select ConvenioLaboral,
RelacionConvenioLaboral,EncuadreProgramatico,Proyecto,Nombre,ApellidoPaterno
,ApellidoMaterno,SUM(case when TIPO='PERCEPCION' then (importe)else IMPORTE*-1 end) as BaseGravable,
SUM(case when TIPO='PERCEPCION' then (importe)else IMPORTE*-1 end)*.03 as ImpuestoSobreNomina
,IdTrabajador,idEncuadreProgramatico
	from percepciones
	group by ConvenioLaboral,
RelacionConvenioLaboral,EncuadreProgramatico,Proyecto,Nombre,ApellidoPaterno
,ApellidoMaterno
,IdTrabajador,idEncuadreProgramatico";

            var impuesto = (List<ImpuestosSobreNominas>)dp.connection.Query<ImpuestosSobreNominas>(query.ToString());

            dp.Close();
            return impuesto;
        }
        public List<CuotasImss> getCuotasImss(string fechainicio,string fechatermino,string tipo)
        {
            string ESINFONAVIT = "";

            if (tipo=="3")
            ESINFONAVIT = @" union all SELECT cl.ConvenioLaboral,zc.TipoCredito as Concepto,'OBRERO' TipoSubDeduccion,b.importe ,q.EncuadreProgramatico,q.Proyecto,zc.TipoCredito as DeduccionClasificacion 
FROM  Creditos_stNominaCreditoTrabajador b 
inner join Nomina_stNominaTrabajador c 
on c.IdNominaTrabajador=b.IdNominaTrabajador inner join Nomina_stNomina d on d.IdNomina=c.IdNomina 
inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina=d.IdPlantillaNomina 
inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral=f.IdRelacionConvenioLaboral 
 inner join Creditos_stCreditoTrabajador ct on ct.IdCreditoTrabajador=b.IdCreditoTrabajador
 inner join [Catalogos_ctTipoCredito] zc on zc.IdTipoCredito=ct.IdTipoCredito
inner join Nomina_stNominaTrabajadorEstatus j on j.IdNominaTrabajadorEstatus=c.IdNominaTrabajadorEstatus 
inner join Nomina_stNominaTrabajadorEstatusGrupo k on k.IdNominaTrabajadorEstatusGrupo=j.IdNominaTrabajadorEstatusGrupo 
inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria 
inner join Catalogos_ctEstructuraOrganica m on m.IdEstructuraOrganica=l.IdEstructuraOrganica 
INNER JOIN Catalogos_ctEncuadreProgramatico q on q.idmodalidadEstudio=m.idmodalidadEstudio 
inner join [Catalogos_ctConvenioLaboral] cl on cl.IdConvenioLaboral=g.IdConvenioLaboral 
 
where k.EstatusNominaGrupo='PARA PAGO' AND d.EsCerrada=1 and zc.TipoCredito='INFONAVIT' and 
   (d.FechaInicio>='" + fechainicio + "' and d.FechaTermino<='" + fechatermino + @"')

UNION ALL

SELECT cl.ConvenioLaboral,'INFONAVIT' as Concepto,'OBRERO' TipoSubDeduccion,b.importe ,q.EncuadreProgramatico,q.Proyecto,'INFONAVIT' as DeduccionClasificacion 
FROM  Deducciones_stNominaTrabajadorDeduccion b 
inner join Nomina_stNominaTrabajador c 
on c.IdNominaTrabajador=b.IdNominaTrabajador inner join Nomina_stNomina d on d.IdNomina=c.IdNomina 
inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina=d.IdPlantillaNomina 
inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral=f.IdRelacionConvenioLaboral 
inner join Nomina_stNominaTrabajadorEstatus j on j.IdNominaTrabajadorEstatus=c.IdNominaTrabajadorEstatus 
inner join Nomina_stNominaTrabajadorEstatusGrupo k on k.IdNominaTrabajadorEstatusGrupo=j.IdNominaTrabajadorEstatusGrupo 
inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria 
inner join Catalogos_ctEstructuraOrganica m on m.IdEstructuraOrganica=l.IdEstructuraOrganica 
INNER JOIN Catalogos_ctEncuadreProgramatico q on q.idmodalidadEstudio=m.idmodalidadEstudio 
inner join [Catalogos_ctConvenioLaboral] cl on cl.IdConvenioLaboral=g.IdConvenioLaboral 
 
where k.EstatusNominaGrupo='PARA PAGO' AND d.EsCerrada=1 and B.Concepto LIKE '%INFONAVIT%' 
  and (d.FechaInicio>='" + fechainicio + "' and d.FechaTermino<='" + fechatermino + @"') ";

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"SELECT ConvenioLaboral,EncuadreProgramatico,Proyecto,Concepto,TipoSubDeduccion,sum(Importe) as Importe,DeduccionClasificacion
from (
SELECT cl.ConvenioLaboral, h.Concepto,i.TipoSubDeduccion,a.importe
,q.EncuadreProgramatico,q.Proyecto,DeduccionClasificacion

  FROM [Deducciones_stNominaTrabajadorSubDeducciones] a
  inner join Deducciones_stNominaTrabajadorDeduccion b on a.IdNominaTrabajadorDeduccion=b.IdNominaTrabajadorDeduccion
  inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=b.IdNominaTrabajador
  inner join Nomina_stNomina d on d.IdNomina=c.IdNomina
  inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina=d.IdPlantillaNomina
  inner join Convenios_stRelacionConvenioLaboral g on g.IdRelacionConvenioLaboral=f.IdRelacionConvenioLaboral
  inner join Deducciones_ctSubDeduccion h on h.IdSubDeduccion=a.IdSubDeduccion
  inner join Deducciones_TipoSubDeduccion i on i.IdTipoSubDeduccion=h.IdTipoSubDeduccion
  inner join Nomina_stNominaTrabajadorEstatus j on j.IdNominaTrabajadorEstatus=c.IdNominaTrabajadorEstatus
  inner join Nomina_stNominaTrabajadorEstatusGrupo k on k.IdNominaTrabajadorEstatusGrupo=j.IdNominaTrabajadorEstatusGrupo
  inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica m on m.IdEstructuraOrganica=l.IdEstructuraOrganica
  INNER JOIN Catalogos_ctEncuadreProgramatico q on q.idmodalidadEstudio=m.idmodalidadEstudio
    inner join [Catalogos_ctConvenioLaboral] cl on cl.IdConvenioLaboral=g.IdConvenioLaboral
inner join [Deducciones_ctSubDeduccionClasificacion]  st on st.IdSubDeduccionClasificacion=h.IdSubDeduccionClasificacion
  where k.EstatusNominaGrupo='PARA PAGO'    
AND d.EsCerrada=1 and st.IdSubDeduccionClasificacion=" + tipo +@"
  and (d.FechaInicio>='" + fechainicio+"' and d.FechaTermino<='"+fechatermino+ @"') " + ESINFONAVIT + @"
  ) as f
  group by ConvenioLaboral, EncuadreProgramatico, Proyecto,Concepto,TipoSubDeduccion ,DeduccionClasificacion
  order by 1,2";

            
            var CuotasImss = (List<CuotasImss>)dp.connection.Query<CuotasImss>(query.ToString());

            dp.Close();
            return CuotasImss;
        }
        public static List<Catalogos_ctMes> GetMeses()
        {
            bdNovaEntities db = new bdNovaEntities();
            return (List<Catalogos_ctMes>)db.Catalogos_ctMes.ToList();
        }
        public static List<PlantillaNomina> GetPlantillaNomina()
        {
                        bdNovaEntities db = new bdNovaEntities();

            var ListaPlantillaNomina = (from a in db.Nomina_ctPlantillaNomina
                                    select new { a.IdPlantillaNomina, a.Plantilla }).ToList();
            List<PlantillaNomina> lqm = new List<PlantillaNomina>();

            foreach (var item in ListaPlantillaNomina)
            {
                PlantillaNomina qm = new PlantillaNomina();
                qm.IdPlantillaNomina = item.IdPlantillaNomina;
                qm.Plantilla = item.Plantilla;
                lqm.Add(qm);
            }
            return lqm;
        }

        public static List<IsrGrupoString> GetIsrGrupos()
        {
            bdNovaEntities db = new bdNovaEntities();
            var ListaIsrGrupo = (from a in db.Configuracion_stIsrGrupo
                                 select new { a.IdIsrGrupo, a.IsrGrupo, a.FechaInicio, a.FechaTermino }).ToList();
            List<IsrGrupoString> lisrg = new List<IsrGrupoString>();

            foreach (var item in ListaIsrGrupo)
            {
                IsrGrupoString isrg = new IsrGrupoString();

                isrg.IdIsrGrupo = item.IdIsrGrupo;
                isrg.IsrGrupo = item.IsrGrupo.Replace(" ", "_") + "(" + item.FechaInicio.ToShortDateString() + "_" + item.FechaTermino.ToShortDateString() + ")";
                lisrg.Add(isrg);
            }
            return lisrg;
        }
        public static List<QuincenaMesString> GetQuincenaMes()
        {
            bdNovaEntities db = new bdNovaEntities();
            var ListaQuincenaMes = (from a in db.Catalogos_ctQuincenaMes
                                    join b in db.Catalogos_ctMes on a.IdMes equals b.IdMes
                                    select new { a.IdQuincenaMes, a.QuincenaMes, b.Mes }).ToList();
            List<QuincenaMesString> lqm = new List<QuincenaMesString>();

            foreach (var item in ListaQuincenaMes)
            {
                QuincenaMesString qm = new QuincenaMesString();
                qm.IdQuincenaMes = item.IdQuincenaMes;
                qm.QuincenaMes = item.QuincenaMes + "(" + item.Mes + ")";
                lqm.Add(qm);
            }
            return lqm;
        }

        // static IEnumerable GetMeses()
        //{
        //    bdNovaEntities db = new bdNovaEntities();
        //    return from mes in db.Catalogos_ctMes select new { IdMesGeneracion = mes.IdMes, MesGeneracion =mes.Mes};
        //}
    }
}