﻿using Dapper;
using DevExpress.Export;
using DevExpress.Utils;
using DevExpress.Web;
using DevExpress.Web.Mvc;
using DevExpress.XtraPivotGrid;
using DevExpress.XtraPrinting;
using Nova.Models.Designpattern;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.UI.WebControls;

namespace Nova.Models
{
    //public string Proyecto { get; set; }
    //public string EstructuraOrganica { get; set; }
    //public string Usuario { get; set; }
    //public string EsConsolidada { get; set; }
    //public string Clase { get; set; }
    //public string PartidaGenerica { get; set; }
    //public string PartidaEspecifica { get; set; }
    //public string Partida { get; set; }
    //public string UnidadMedida { get; set; }
    //public string Producto { get; set; }
    //public string Mes { get; set; }
    //public string Componente { get; set; }
    //public decimal Precio { get; set; }
    //public int Cantidad { get; set; }
    //public decimal Total { get; set; }

    public class DatosNominaClass
    {
        public static List<ValorDatosNominaModel> getDatos(Int32 año, Int64 idNomina)
        {
            
            string query = "";

            if (año == 0)
                año = DateTime.Now.Year;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            List<ValorDatosNominaModel> ListaDatos= new List<ValorDatosNominaModel>();
            if (idNomina == 0)

            {
                var p = new DynamicParameters();
                p.Add("@Año", año);
                
                 ListaDatos = (List<ValorDatosNominaModel>)dp.connection.Query<ValorDatosNominaModel>("spNominaPercpecionesDeducciones",p, null, true, 0, System.Data.CommandType.StoredProcedure);
            }
            else
            {
                var p = new DynamicParameters();
                p.Add("@IdNomina", idNomina);
                 ListaDatos = (List<ValorDatosNominaModel>)dp.connection.Query<ValorDatosNominaModel>("spNominaPercpecionesDeduccionesPorNomina", p, null, true, 0, System.Data.CommandType.StoredProcedure);
            }

            string condicion = "";

            if (idNomina > 0)
                condicion = " and a.IdNomina=" + idNomina;
            query = @"SELECT   IdNominaTrabajador
      ,a.IdNomina
      ,IdConvenioLaboralTrabajadorCategoria
      ,SueldoBruto
      ,SueldoDiario
      ,SueldoNeto
      ,SueldoTransferencia
      ,SueldoMonedero
      ,IdTrabajadorCuentasTransferencia
      ,IdTrabajadorCuentasMonedero
      ,HorasSemanaMes
      ,HorasSemanaMesTrabajadas
      ,HorasExcedentes
      ,HorasTrabajadasExcedentes
      ,HorasInterinas
      ,HorasTrabajadasInterinas
      ,DiasEfectivosLaborados
      ,CostoPorHora
      ,CostoPorHoraExcedente
      ,CostoPorHorasInterinas
      ,SalarioDiarioIntegrado
      ,QuinquenioDiario
      ,MaterialDidacticoDiario
      ,SueldoBrutoQuinquenioDiario
      ,SumaPercepcionesVariables
      ,BaseGravable
      ,HorasEfectivasDeTrabajo
      ,EsHorarioSinCambios
      ,SalarioBrutoGravable
      ,SubsidioEmpleoMensual
      ,Isr
      ,IsrRdl
      ,Rdl
      ,CantidadSubsidioEmpleoMensual
      ,EsHorarioAnterior
      ,EsHorarioAjustado
      ,CostoEficienciaExcedente
      ,CostoMaterialDidactico
      ,CostoEficienciaJornada
      ,CostoMaterialDidacticoExcedente
      ,c.TipoNomina
      ,d.Plantilla
      ,b.Año
      ,e.QuincenaMes
      ,f.Mes
  FROM  Nomina_stNominaTrabajador a 
  inner join Nomina_stNomina b on a.IdNomina=b.IdNomina
  inner join Nomina_ctTipoNomina c on c.IdTipoNomina = b.IdTipoNomina
  inner join Nomina_ctPlantillaNomina d on d.IdPlantillaNomina = b.IdPlantillaNomina
  inner join Catalogos_ctQuincenaMes e on e.IdQuincenaMes =b.IdQuincenaMes
  inner join Catalogos_ctMes f on f.IdMes = e.IdMes
    
  where b.Año=year(GETDATE()) " + condicion;
            var calculostrabajadores = (List<NominaTrabajadorCalculosPivot>)dp.connection.Query<NominaTrabajadorCalculosPivot>(query);

            List<ValorDatosNominaModel> ListacalculosTrabajador = new List<ValorDatosNominaModel>();

            foreach (var item in calculostrabajadores)
            {
                Trabajadores trabajadoresvigentes = Trabajadores.Instance;
                var trabajador = trabajadoresvigentes.TrabajadoresVigentes.Where(f => f.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();


                ValorDatosNominaModel itemTrabajador = new ValorDatosNominaModel();

                if (trabajador != null)
                {

                    itemTrabajador.IdNominaTrabajador = trabajador.Nomina_stNominaTrabajador.FirstOrDefault().IdNominaTrabajador;
                    itemTrabajador.IdConvenioLaboralTrabajadorCategoria = trabajador.IdConvenioLaboralTrabajadorCategoria;
                    itemTrabajador.IdTrabajador = trabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    itemTrabajador.Tipo = "Cálculos";
                    //itemTrabajador.Concepto 
                    //itemTrabajador.Importe
                    itemTrabajador.Adscripcion = trabajador.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica;
                    itemTrabajador.UbicacionFisica = trabajador.Catalogos_ctEstructuraOrganica.EstructuraOrganica;
                    itemTrabajador.Nombre = trabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre;
                    itemTrabajador.ApellidoPaterno = trabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno;
                    itemTrabajador.ApellidoMaterno = trabajador.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
                    itemTrabajador.Categoria = trabajador.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria;
                    itemTrabajador.ConvenioLaboral = trabajador.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral;
                    itemTrabajador.RelacionLaboral = trabajador.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral;
                    itemTrabajador.FechaInicio = trabajador.FechaInicio;
                    itemTrabajador.FechaTermino = trabajador.FechaTermino;

                    itemTrabajador.TipoNomina = item.TipoNomina;
                    itemTrabajador.Plantilla = item.Plantilla;
                    itemTrabajador.Año = item.Año;
                    itemTrabajador.QuincenaMes = item.QuincenaMes;
                    itemTrabajador.Mes = item.Mes;
                    

                    string[] conceptos = {"SueldoBruto","SueldoDiario","SueldoNeto","SueldoTransferencia","SueldoMonedero","HorasSemanaMes","HorasSemanaMesTrabajadas","HorasExcedentes","HorasTrabajadasExcedentes","HorasInterinas","HorasTrabajadasInterinas","DiasEfectivosLaborados"
                            ,"CostoPorHora","CostoPorHoraExcedente","CostoPorHorasInterinas","SalarioDiarioIntegrado","QuinquenioDiario","MaterialDidacticoDiario","SueldoBrutoQuinquenioDiario"
                            ,"SumaPercepcionesVariables","BaseGravable","HorasEfectivasDeTrabajo","EsHorarioSinCambios","SalarioBrutoGravable","SubsidioEmpleoMensual"
                            ,"Isr","IsrRdl","Rdl","CantidadSubsidioEmpleoMensual"
                    };

                    foreach (var itemConcepto in conceptos)
                    {
                        ValorDatosNominaModel itemcalculo = new ValorDatosNominaModel();

                        itemcalculo = itemTrabajador.ShallowCopy();
                        CreafilaCalculo(itemConcepto, item, ref itemcalculo);
                        ListacalculosTrabajador.Add(itemcalculo);
                    }

                }

            }
            ListaDatos.AddRange(ListacalculosTrabajador);

            return ListaDatos;


        }


        public static void CreafilaCalculo(string campo, NominaTrabajadorCalculosPivot datos, ref ValorDatosNominaModel itemcalculo)
        {
            //  FieldInfo info=typeof(Nomina_stNominaTrabajador).GetField(campo);
            var valorcampo = GetPropValue(datos, campo);

            itemcalculo.Concepto = campo;
            itemcalculo.Importe = Nova.Libraries.ConvertToDecimal.ToDecimal(valorcampo);


        }

        public static string GetPropValue(object src, string propName)
        {
            return src.GetType().GetProperty(propName).GetValue(src, null).ToString();
        }

    }

    public class NominaTrabajadorPivot
    {
        static PivotGridSettings exportPivotGridSettings;
        static PivotGridSettings dataAwarePivotGridSettings;

        public static PivotGridSettings ExportPivotGridSettings
        {
            get
            {
                if (exportPivotGridSettings == null)
                    exportPivotGridSettings = CreatePivotGridSettings();
                return exportPivotGridSettings;
            }
        }
        public static PivotGridSettings DataAwarePivotGridSettings
        {
            get
            {
                if (dataAwarePivotGridSettings == null)
                    dataAwarePivotGridSettings = CreateDataAwarePivotGridSettings();
                return dataAwarePivotGridSettings;
            }
        }

        public static PivotGridSettings GetPivotGridExportSettings(PivotGridExportWYSIWYGOptions options)
        {
            PivotGridSettings exportSettings = ExportPivotGridSettings;
            exportSettings.SettingsExport.OptionsPrint.PrintHeadersOnEveryPage = options.PrintHeadersOnEveryPage;
            exportSettings.SettingsExport.OptionsPrint.PrintFilterHeaders = ConvertToDefaultBoolean(options.PrintFilterHeaders);
            exportSettings.SettingsExport.OptionsPrint.PrintColumnHeaders = ConvertToDefaultBoolean(options.PrintColumnHeaders);
            exportSettings.SettingsExport.OptionsPrint.PrintRowHeaders = ConvertToDefaultBoolean(options.PrintRowHeaders);
            exportSettings.SettingsExport.OptionsPrint.PrintDataHeaders = ConvertToDefaultBoolean(options.PrintDataHeaders);
            return exportSettings;
        }
        static PivotGridSettings CreatePivotGridSettingsBase()
        {
            PivotGridSettings settings = new PivotGridSettings();
            settings.Name = "pivotGrid";
            settings.CallbackRouteValues = new { Controller = "NominaPivot", Action = "PartialPivot" };
            settings.Width = Unit.Percentage(100);
            settings.OptionsView.HorizontalScrollBarMode = ScrollBarMode.Auto;
            settings.OptionsData.DataProcessingEngine = PivotDataProcessingEngine.LegacyOptimized;
            return settings;
        }
        static PivotGridSettings CreatePivotGridSettings()
        {
            PivotGridSettings settings = CreatePivotGridSettingsBase();

            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 0;
                field.Caption = "UbicacionFisica";
                field.FieldName = "UbicacionFisica";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 1;
                field.Caption = "Nombre";
                field.FieldName = "Nombre";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 1;
                field.Caption = "ApellidoPaterno";
                field.FieldName = "ApellidoPaterno";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 1;
                field.Caption = "ApellidoMaterno";
                field.FieldName = "ApellidoMaterno";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 2;
                field.Caption = "Adscripcion";
                field.FieldName = "Adscripcion";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 3;
                field.Caption = "Categoria";
                field.FieldName = "Categoria";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 4;
                field.Caption = "ConvenioLaboral";
                field.FieldName = "ConvenioLaboral";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 5;
                field.Caption = "FechaInicio";
                field.FieldName = "FechaInicio";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 6;
                field.Caption = "FechaTermino";
                field.FieldName = "FechaTermino";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 7;
                field.Caption = "RelacionLaboral";
                field.FieldName = "RelacionLaboral";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 8;
                field.Caption = "Mes";
                field.FieldName = "Mes";
            });

            settings.Fields.Add(field => {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 1;
                field.Caption = "TipoNomina";
                field.FieldName = "TipoNomina";

            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 2;
                field.Caption = "Año";
                field.FieldName = "Año";

            });

            settings.Fields.Add(field => {
                field.Area = PivotArea.ColumnArea;
                field.AreaIndex = 0;
                field.Caption = "Tipo";
                field.FieldName = "Tipo";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.ColumnArea;
                field.AreaIndex = 1;
                field.Caption = "Concepto";
                field.FieldName = "Concepto";
            });

            settings.Fields.Add(field => {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 0;
                field.Caption = "Plantilla";
                field.FieldName = "Plantilla";

            });
            
            settings.Fields.Add(field => {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 1;
                field.Caption = "QuincenaMes";
                field.FieldName = "QuincenaMes";

            });

            settings.Fields.Add(field => {
                field.Area = PivotArea.DataArea;
                field.AreaIndex = 0;
                field.Caption = "Importe";
                field.FieldName = "Importe";

            });


            return settings;
        }


        static PivotGridSettings CreateDataAwarePivotGridSettings()
        {
            PivotGridSettings settings = CreatePivotGridSettingsBase();

            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 0;
                field.Caption = "UbicacionFisica";
                field.FieldName = "UbicacionFisica";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 1;
                field.Caption = "Nombre";
                field.FieldName = "Nombre";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 1;
                field.Caption = "ApellidoPaterno";
                field.FieldName = "ApellidoPaterno";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 1;
                field.Caption = "ApellidoMaterno";
                field.FieldName = "ApellidoMaterno";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 2;
                field.Caption = "Adscripcion";
                field.FieldName = "Adscripcion";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 3;
                field.Caption = "Categoria";
                field.FieldName = "Categoria";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 4;
                field.Caption = "ConvenioLaboral";
                field.FieldName = "ConvenioLaboral";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 5;
                field.Caption = "FechaInicio";
                field.FieldName = "FechaInicio";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 6;
                field.Caption = "FechaTermino";
                field.FieldName = "FechaTermino";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 7;
                field.Caption = "RelacionLaboral";
                field.FieldName = "RelacionLaboral";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.FilterArea;
                field.AreaIndex = 8;
                field.Caption = "Mes";
                field.FieldName = "Mes";
            });

            settings.Fields.Add(field => {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 1;
                field.Caption = "TipoNomina";
                field.FieldName = "TipoNomina";

            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 2;
                field.Caption = "Año";
                field.FieldName = "Año";

            });

            settings.Fields.Add(field => {
                field.Area = PivotArea.ColumnArea;
                field.AreaIndex = 0;
                field.Caption = "Tipo";
                field.FieldName = "Tipo";
            });
            settings.Fields.Add(field => {
                field.Area = PivotArea.ColumnArea;
                field.AreaIndex = 1;
                field.Caption = "Concepto";
                field.FieldName = "Concepto";
            });

            settings.Fields.Add(field => {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 0;
                field.Caption = "Plantilla";
                field.FieldName = "Plantilla";

            });

            settings.Fields.Add(field => {
                field.Area = PivotArea.RowArea;
                field.AreaIndex = 1;
                field.Caption = "QuincenaMes";
                field.FieldName = "QuincenaMes";

            });

            settings.Fields.Add(field => {
                field.Area = PivotArea.DataArea;
                field.AreaIndex = 0;
                field.Caption = "Importe";
                field.FieldName = "Importe";

            });


            return settings;
        }
        static DefaultBoolean ConvertToDefaultBoolean(bool value)
        {
            return value ? DefaultBoolean.True : DefaultBoolean.False;
        }

        static Dictionary<PivotGridExportFormats, PivotGridExportType> exportTypes;
        static Dictionary<PivotGridExportFormats, PivotGridExportType> CreateExportTypes()
        {
            Dictionary<PivotGridExportFormats, PivotGridExportType> types = new Dictionary<PivotGridExportFormats, PivotGridExportType>();
            types.Add(PivotGridExportFormats.Pdf, new PivotGridExportType { Title = "Export to PDF", Method = PivotGridExtension.ExportToPdf });
            types.Add(PivotGridExportFormats.Excel, new PivotGridExportType { Title = "Export to XLSX", ExcelMethod = PivotGridExtension.ExportToXlsx });
            types.Add(PivotGridExportFormats.ExcelDataAware, new PivotGridExportType { Title = "Export to XLSX", ExcelMethod = PivotGridExtension.ExportToXlsx });
            types.Add(PivotGridExportFormats.Mht, new PivotGridExportType { Title = "Export to MHT", Method = PivotGridExtension.ExportToMht });
            types.Add(PivotGridExportFormats.Rtf, new PivotGridExportType { Title = "Export to RTF", Method = PivotGridExtension.ExportToRtf });
            types.Add(PivotGridExportFormats.Text, new PivotGridExportType { Title = "Export to TEXT", Method = PivotGridExtension.ExportToText });
            types.Add(PivotGridExportFormats.Html, new PivotGridExportType { Title = "Export to HTML", Method = PivotGridExtension.ExportToHtml });
            return types;
        }
        public static ActionResult GetExportActionResult(PivotGridExportOptions options, object data)
        {
            if (exportTypes == null)
                exportTypes = CreateExportTypes();

            PivotGridExportFormats format = options.ExportType;
            PivotGridSettings settings = GetPivotGridExportSettings(options.WYSIWYG);
            switch (format)
            {
                case PivotGridExportFormats.Excel:
                    return exportTypes[format].ExcelMethod(settings, data, new XlsxExportOptionsEx() { ExportType = ExportType.WYSIWYG });
                case PivotGridExportFormats.ExcelDataAware:
                    XlsxExportOptionsEx exportOptions = new XlsxExportOptionsEx() { ExportType = ExportType.DataAware };
                    exportOptions.AllowFixedColumnHeaderPanel = exportOptions.AllowFixedColumns = options.DataAware.AllowFixedColumnAndRowArea ? DefaultBoolean.True : DefaultBoolean.False;
                    exportOptions.AllowGrouping = options.DataAware.AllowGrouping ? DefaultBoolean.True : DefaultBoolean.False;
                    exportOptions.RawDataMode = options.DataAware.ExportRawData;
                    exportOptions.TextExportMode = options.DataAware.ExportDisplayText ? TextExportMode.Text : TextExportMode.Value;
                    return exportTypes[format].ExcelMethod(DataAwarePivotGridSettings, data, exportOptions);
                default:
                    return exportTypes[format].Method(settings, data);
            }
        }
        public delegate ActionResult PivotGridExportMethod(PivotGridSettings settings, object dataObject);
        public delegate ActionResult PivotGridDataAwareExportMethod(PivotGridSettings settings, object dataObject, XlsxExportOptions exportOptions);
        public class PivotGridExportType
        {
            public string Title { get; set; }
            public PivotGridExportMethod Method { get; set; }
            public PivotGridDataAwareExportMethod ExcelMethod { get; set; }
        }

    }
}