﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Mail;
using System.Threading.Tasks;
using System.Web;

namespace Nova.Models
{
    public class MstSoporteClass
    {
        private string CorreoEmisor = "soporte.tickets@cecyteo.edu.mx";
        private string KerCorreoEmisor = "@tecnologias@";
        //private string KerCorreoEmisor = ";Garciacruz;";

        private bdNovaEntities db = new bdNovaEntities();

        public Task EnviarMail(byte[] binaryPdf,string NumeroTicket, string CorreoTo,string HtmlBodyOfView)
        {
            return Task.Factory.StartNew(() =>
            {
                MailMessage msg = new MailMessage();
                msg.From = new MailAddress(CorreoEmisor);
                msg.To.Add(new MailAddress(CorreoTo));
                msg.Subject = "Servicio concluido, Ticket:"+ NumeroTicket +"";
                msg.IsBodyHtml = true;
                msg.Body = HtmlBodyOfView;
                //msg.Attachments.Add(new System.Net.Mail.Attachment());
                System.IO.MemoryStream memoryStream = new System.IO.MemoryStream(binaryPdf);
                msg.Attachments.Add(new Attachment(memoryStream, "Reporte_Ticket_"+NumeroTicket+".pdf"));

                SmtpClient client = new SmtpClient();
                client.Credentials = new NetworkCredential(CorreoEmisor, KerCorreoEmisor);
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                client.Send(msg);


            });

        }

        public Task EnviarMailUsuarioAsignado(string NumeroTicket, string CorreoTo, string HtmlBodyOfView)
        {
            return Task.Factory.StartNew(() =>
            {
                MailMessage msg = new MailMessage();
                msg.From = new MailAddress(CorreoEmisor);
                msg.To.Add(new MailAddress(CorreoTo));
                msg.Subject = "Asignación de Ticket número:" + NumeroTicket + "";
                msg.IsBodyHtml = true;
                msg.Body = HtmlBodyOfView;
                //msg.Attachments.Add(new System.Net.Mail.Attachment());
                

                SmtpClient client = new SmtpClient();
                client.Credentials = new NetworkCredential(CorreoEmisor, KerCorreoEmisor);
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                client.Send(msg);


            });

        }

        public Task EnviarMailMantenimientoOut(byte[] binaryPdf, string NumeroReporte, string CorreoTo, string HtmlBodyOfView)
        {
            return Task.Factory.StartNew(() =>
            {
                MailMessage msg = new MailMessage();
                msg.From = new MailAddress(CorreoEmisor);
                msg.To.Add(new MailAddress(CorreoTo));
                msg.Subject = "Servicio concluido, Reporte:" + NumeroReporte + "";
                msg.IsBodyHtml = true;
                msg.Body = HtmlBodyOfView;
                //msg.Attachments.Add(new System.Net.Mail.Attachment());
                System.IO.MemoryStream memoryStream = new System.IO.MemoryStream(binaryPdf);
                msg.Attachments.Add(new Attachment(memoryStream, "Reporte_Mantenimiento_" + NumeroReporte + ".pdf"));

                SmtpClient client = new SmtpClient();
                client.Credentials = new NetworkCredential(CorreoEmisor, KerCorreoEmisor);
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                client.Send(msg);


            });

        }

        public Task EnviarMailMantenimientoIn(byte[] binaryPdf, string NumeroReporte, string CorreoTo, string HtmlBodyOfView)
        {
            return Task.Factory.StartNew(() =>
            {
                MailMessage msg = new MailMessage();
                msg.From = new MailAddress(CorreoEmisor);
                msg.To.Add(new MailAddress(CorreoTo));
                msg.Subject = "Entrada a Servicio, Reporte:" + NumeroReporte + "";
                msg.IsBodyHtml = true;
                msg.Body = HtmlBodyOfView;
                //msg.Attachments.Add(new System.Net.Mail.Attachment());
                System.IO.MemoryStream memoryStream = new System.IO.MemoryStream(binaryPdf);
                msg.Attachments.Add(new Attachment(memoryStream, "Reporte_Entrada_Mantenimiento_" + NumeroReporte + ".pdf"));

                SmtpClient client = new SmtpClient();
                client.Credentials = new NetworkCredential(CorreoEmisor, KerCorreoEmisor);
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                client.Send(msg);


            });

        }

        public Task EnviarMailMantenimientoReparado(string NumeroReporte, string CorreoTo, string HtmlBodyOfView)
        {
            return Task.Factory.StartNew(() =>
            {
                MailMessage msg = new MailMessage();
                msg.From = new MailAddress(CorreoEmisor);
                msg.To.Add(new MailAddress(CorreoTo));
                msg.Subject = "Equipo Reparado, Reporte:" + NumeroReporte + "";
                msg.IsBodyHtml = true;
                msg.Body = HtmlBodyOfView;
                //msg.Attachments.Add(new System.Net.Mail.Attachment());
                //System.IO.MemoryStream memoryStream = new System.IO.MemoryStream(binaryPdf);
                //msg.Attachments.Add(new Attachment(memoryStream, "Reporte_Mantenimiento_" + NumeroReporte + ".pdf"));

                SmtpClient client = new SmtpClient();
                client.Credentials = new NetworkCredential(CorreoEmisor, KerCorreoEmisor);
                client.Host = "smtp.gmail.com";
                client.Port = 587;
                client.DeliveryMethod = SmtpDeliveryMethod.Network;
                client.EnableSsl = true;
                client.Send(msg);


            });

        }

    }
}