﻿using Nova.Models;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
namespace Nova.Models
{

public class TipoModalidad
    {
        //public short IdModalidad { get; set; }
        public string Modalidad { get; set; }

    }
    public class ModalidadSolicitudes
    {
        public string Modalidad { get; set; }
        public int Solicitudes { get; set; }
    }
    public class ModalidadAreaSolicitudes
    {
        public string Area { get; set; }
        public int Solicitudes { get; set; }
    }
    public class CentroEducativo
    {
        //public short IdModalidad { get; set; }
        public string Centro { get; set; }

    }

    public class CentrosEducativos
    {
        public string EstructuraOrganica { get; set; }
    }

    public class TotalProductosEntregas
    {
        public string CentroEducativo { get; set; }
        public string TipoMaterial { get; set; }
        public string Titulo { get; set; }
        public int Total { get; set; }
    }

   
    public class CentroSolicitudes
    {
        public string Area { get; set; }
        public int Solicitudes { get; set; }
    }

    public class SolicitudTrabajador
    {
     public   int IdSolicitud { get; set; }
     public string NombreTrabajador { get; set; }
     public string FechaSolicitud { get; set; }
     public string FechaAtencion { get; set; }
     public string AñoInicio { get; set; }
     public string AñoFin { get; set; }
     public string MesInicio { get; set; }
     public string MesFin { get; set; }
     public string Modalidad { get; set; }
     public string CentroEducativo { get; set; }
     public string VistoBueno { get; set; }
     public string Materia { get; set; }


    }
    public partial class MaterialDidactico_Solicitud
    {

        public static IEnumerable<SelectListItem> GetConvocatorias()
        {
            bdNovaEntities db = new bdNovaEntities();
            List<SelectListItem> roles = db.MaterialDidactico_ctConvocatoria.OrderByDescending(f=> f.FechaTermino)
                        .Select(x =>
                                new SelectListItem
                                {
                                    Value = x.IdConvocatoria.ToString(),
                                    Text = x.Convocatoria+" "+x.FechaInicio.ToString()+" - "+x.FechaTermino.ToString()
 
                                }).ToList();

            SelectListItem vacia =new  SelectListItem();
                                
                                    vacia.Value = "0";
                                    vacia.Text = "Todas";
                                    vacia.Selected = true;
            roles.Add(vacia);
            return new SelectList(roles, "Value", "Text");
        }
        public static List<MaterialDidactico_Solicitud> ObtenMaterialDidactico_Solicitud()
        {
            bdNovaEntities db = new bdNovaEntities();
            return (List<MaterialDidactico_Solicitud>)db.MaterialDidactico_Solicitud.ToList();
        }
        public static List<ModalidadSolicitudes> ObtenSolicitudesModalidad(int idconvocatoria)
        {
            bdNovaEntities db = new bdNovaEntities();
            List<ModalidadSolicitudes> listasolicitudes = new List<ModalidadSolicitudes>();

            if (idconvocatoria == 0)
            {
                var sm = from r in db.MaterialDidactico_Solicitud
                         where r.VistoBueno==true
                         orderby r.Modalidad
                         group r by new { r.Modalidad } into grp
                         select new { key = grp.Key, cnt = grp.Count() };
                
                int totalsolicitudes = 0;
                foreach (var item in sm)
                {
                    ModalidadSolicitudes sol = new ModalidadSolicitudes();
                    sol.Modalidad = item.key.Modalidad;
                    sol.Solicitudes = item.cnt;
                    totalsolicitudes = totalsolicitudes + sol.Solicitudes;
                    listasolicitudes.Add(sol);
                }
                ModalidadSolicitudes total = new ModalidadSolicitudes();
                total.Modalidad = "Total";
                total.Solicitudes = totalsolicitudes;
                listasolicitudes.Add(total);
            }
            else
            {
                var sm = from r in db.MaterialDidactico_Solicitud
                         where r.IdConvocatoria == idconvocatoria && r.VistoBueno == true
                         orderby r.Modalidad
                         group r by new { r.Modalidad } into grp
                         select new { key = grp.Key, cnt = grp.Count() };

                int totalsolicitudes = 0;
                foreach (var item in sm)
                {
                    ModalidadSolicitudes sol = new ModalidadSolicitudes();
                    sol.Modalidad = item.key.Modalidad;
                    sol.Solicitudes = item.cnt;
                    totalsolicitudes = totalsolicitudes + sol.Solicitudes;
                    listasolicitudes.Add(sol);
                }
                ModalidadSolicitudes total = new ModalidadSolicitudes();
                total.Modalidad = "Total";
                total.Solicitudes = totalsolicitudes;
                listasolicitudes.Add(total);
            }
            return listasolicitudes;
        }
        public static List<ModalidadAreaSolicitudes> ObtenSolicitudesModalidadArea(string modalidad, int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            if (id == 0)
            {
                List<ModalidadAreaSolicitudes> totales = db.MaterialDidactico_SolicitudDetalle.Where(w => w.MaterialDidactico_Solicitud.IdConvocatoria == id && w.MaterialDidactico_Solicitud.Modalidad == modalidad && w.EsAutorizada == true).GroupBy(r => new { r.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura }).Select(y => new ModalidadAreaSolicitudes { Area = y.Key.Asignatura, Solicitudes = 1 }).ToList();

                List<ModalidadAreaSolicitudes> finales = totales.GroupBy(r => r.Area).Select(y => new ModalidadAreaSolicitudes { Area = y.Key, Solicitudes = y.Count() }).ToList();

                ModalidadAreaSolicitudes sol = new ModalidadAreaSolicitudes();
                sol.Area = "Total";
                foreach (var item in finales)
                {

                    sol.Solicitudes = sol.Solicitudes + item.Solicitudes;
                }
                finales.Add(sol);

                return finales;
            }
            else
            {
                List<ModalidadAreaSolicitudes> totales = db.MaterialDidactico_SolicitudDetalle.Where(w => w.MaterialDidactico_Solicitud.Modalidad == modalidad && w.MaterialDidactico_Solicitud.IdConvocatoria==id &&  w.EsAutorizada==true).GroupBy(r => new { r.IdSolicitud, r.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura }).Select(y => new ModalidadAreaSolicitudes { Area = y.Key.Asignatura, Solicitudes = 1 }).ToList();

                List<ModalidadAreaSolicitudes> finales = totales.GroupBy(r => r.Area).Select(y => new ModalidadAreaSolicitudes { Area = y.Key, Solicitudes = y.Count() }).ToList();

                ModalidadAreaSolicitudes sol = new ModalidadAreaSolicitudes();
                sol.Area = "Total";
                foreach (var item in finales)
                {

                    sol.Solicitudes = sol.Solicitudes + item.Solicitudes;
                }
                finales.Add(sol);

                return finales;

            }
        }
        public static List<CentroSolicitudes> ObtenSolicitudesModalidadCentro(string centro,int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            if (id == 0)
            {
                List<CentroSolicitudes> totales = db.MaterialDidactico_SolicitudDetalle.Where(w => w.MaterialDidactico_Solicitud.CentroEducativo == centro && w.EsAutorizada == true).GroupBy(r => new { r.IdSolicitud, r.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura }).Select(y => new CentroSolicitudes { Area = y.Key.Asignatura, Solicitudes = 1 }).ToList();

                List<CentroSolicitudes> finales = totales.GroupBy(r => r.Area).Select(y => new CentroSolicitudes { Area = y.Key, Solicitudes = y.Count() }).ToList();

                CentroSolicitudes sol = new CentroSolicitudes();
                sol.Area = "Total";
                foreach (var item in finales)
                {

                    sol.Solicitudes = sol.Solicitudes + item.Solicitudes;
                }
                finales.Add(sol);

                return finales;
            }
            else
            {
                List<CentroSolicitudes> totales = db.MaterialDidactico_SolicitudDetalle.Where(w => w.EsAutorizada==true && w.MaterialDidactico_Solicitud.CentroEducativo == centro && w.MaterialDidactico_Solicitud.IdConvocatoria==id).GroupBy(r => new { r.IdSolicitud, r.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura }).Select(y => new CentroSolicitudes { Area = y.Key.Asignatura, Solicitudes = 1 }).ToList();

                List<CentroSolicitudes> finales = totales.GroupBy(r => r.Area).Select(y => new CentroSolicitudes { Area = y.Key, Solicitudes = y.Count() }).ToList();

                CentroSolicitudes sol = new CentroSolicitudes();
                sol.Area = "Total";
                foreach (var item in finales)
                {

                    sol.Solicitudes = sol.Solicitudes + item.Solicitudes;
                }
                finales.Add(sol);

                return finales;
            }
        }
        public static List<CentroSolicitudes> ObtenSolicitudesModalidadAreaCentro(string area,int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            if (id == 0)
            {
                List<CentroSolicitudes> totales = db.MaterialDidactico_SolicitudDetalle.Where(w => w.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura == area && w.EsAutorizada == true).GroupBy(r => new { r.IdSolicitud, r.MaterialDidactico_Solicitud.CentroEducativo }).Select(y => new CentroSolicitudes { Area = y.Key.CentroEducativo, Solicitudes = 1 }).ToList();

                List<CentroSolicitudes> finales = totales.GroupBy(r => r.Area).Select(y => new CentroSolicitudes { Area = y.Key, Solicitudes = y.Count() }).ToList();

                CentroSolicitudes sol = new CentroSolicitudes();
                sol.Area = "Total";
                foreach (var item in finales)
                {

                    sol.Solicitudes = sol.Solicitudes + item.Solicitudes;
                }
                finales.Add(sol);

                return finales;
            }
            else
            {
                List<CentroSolicitudes> totales = db.MaterialDidactico_SolicitudDetalle.Where(w => w.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura == area && w.MaterialDidactico_Solicitud.IdConvocatoria == id && w.EsAutorizada == true).GroupBy(r => new { r.IdSolicitud, r.MaterialDidactico_Solicitud.CentroEducativo }).Select(y => new CentroSolicitudes { Area = y.Key.CentroEducativo, Solicitudes = 1 }).ToList();

                List<CentroSolicitudes> finales = totales.GroupBy(r => r.Area).Select(y => new CentroSolicitudes { Area = y.Key, Solicitudes = y.Count() }).ToList();

                CentroSolicitudes sol = new CentroSolicitudes();
                sol.Area = "Total";
                foreach (var item in finales)
                {

                    sol.Solicitudes = sol.Solicitudes + item.Solicitudes;
                }
                finales.Add(sol);

                return finales;
            
            }
        }

        public static List<SolicitudTrabajador> ObtenSolicitudes(int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            var lista = from a in db.MaterialDidactico_Solicitud
                   join b in db.Kardex_ctTrabajador on a.IdTrabajador equals b.IdTrabajador
                   join c in db.Kardex_ctDatosPersonales on b.IdKardex equals c.IdKardex
                 orderby a.FechaSolicitud ascending
                 where (a.IdConvocatoria == id)
                                                        select  new
                   {
                      IdSolicitud = a.IdSolicitud,
                      NombreTrabajador = c.Nombre + " "+ c.ApellidoPaterno + " "+ c.ApellidoMaterno,
                      FechaSolicitud = a.FechaSolicitud,
                      FechaAtencion = a.FechaAtencion,
                     
                      Modalidad = a.Modalidad,
                      CentroEducativo = a.CentroEducativo,
                      VistoBueno=a.VistoBueno,
                   }  ;
            List<SolicitudTrabajador> listasolicitudes = new List<SolicitudTrabajador>();
            foreach (var item in lista)
            {
                SolicitudTrabajador sol = new SolicitudTrabajador();
                sol.IdSolicitud = item.IdSolicitud;
                sol.NombreTrabajador = item.NombreTrabajador;
                sol.FechaSolicitud = item.FechaSolicitud.ToString();
                sol.FechaAtencion = item.FechaAtencion.ToString();
                
                sol.Modalidad = item.Modalidad;
                sol.CentroEducativo = item.CentroEducativo;
                sol.VistoBueno= item.VistoBueno.ToString();

                string materia = db.MaterialDidactico_SolicitudDetalle.Where(r => r.IdSolicitud == item.IdSolicitud).Select(t => t.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura).FirstOrDefault();
                sol.Materia = materia;
                listasolicitudes.Add(sol);
            }
            return listasolicitudes;
        }
        public static List<SolicitudTrabajador> ObtenSolicitudesDocente(int idtrabajador)
        {
            bdNovaEntities db = new bdNovaEntities();
            var lista = from a in db.MaterialDidactico_Solicitud
                        join b in db.Kardex_ctTrabajador on a.IdTrabajador equals b.IdTrabajador
                        join c in db.Kardex_ctDatosPersonales on b.IdKardex equals c.IdKardex
                        where b.IdTrabajador==idtrabajador
                        select new
                        {
                            IdSolicitud = a.IdSolicitud,
                            NombreTrabajador = c.Nombre + " " + c.ApellidoPaterno + " " + c.ApellidoMaterno,
                            FechaSolicitud = a.FechaSolicitud,
                            FechaAtencion = a.FechaAtencion,
                          
                            Modalidad = a.Modalidad,
                            CentroEducativo = a.CentroEducativo,
                        };
            List<SolicitudTrabajador> listasolicitudes = new List<SolicitudTrabajador>();
            foreach (var item in lista)
            {
                SolicitudTrabajador sol = new SolicitudTrabajador();
                sol.IdSolicitud = item.IdSolicitud;
                sol.NombreTrabajador = item.NombreTrabajador;
                sol.FechaSolicitud = item.FechaSolicitud.ToString();
                sol.FechaAtencion = item.FechaAtencion.ToString();
               
                sol.Modalidad = item.Modalidad;
                sol.CentroEducativo = item.CentroEducativo;
                string materia = db.MaterialDidactico_SolicitudDetalle.Where(r => r.IdSolicitud == item.IdSolicitud).Select(t => t.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura).FirstOrDefault();
                sol.Materia = materia;

                listasolicitudes.Add(sol);
            }
            return listasolicitudes;
        }


        public static List<SolicitudTrabajador> ObtenSolicitudesUsuario(int idtrabajador,int idconvocatoria)
        {
           
            
            

            bdNovaEntities db = new bdNovaEntities();

            List<int> permisos = db.MaterialDidactico_stTrabajadorAsignatura.Where(r => r.IdTrabajador == idtrabajador).Select(o => o.IdAsignatura).ToList();

            var lista = from a in db.MaterialDidactico_Solicitud
                        join b in db.Kardex_ctTrabajador on a.IdTrabajador equals b.IdTrabajador
                        join c in db.Kardex_ctDatosPersonales on b.IdKardex equals c.IdKardex
                        join r in db.MaterialDidactico_SolicitudDetalle on a.IdSolicitud equals r.IdSolicitud
                        join t in db.MaterialDidactico_AsignaturaTitulo on r.IdAsignaturaTitulo equals t.IdAsignaturaTitulo
                        where permisos.Contains(t.IdAsignatura) && a.IdConvocatoria==idconvocatoria
                        group a by new
                        {
                            a.IdSolicitud,
                            c.Nombre,
                            c.ApellidoPaterno,
                            c.ApellidoMaterno,
                            a.FechaSolicitud,
                            a.FechaAtencion,

                            a.Modalidad,
                            a.CentroEducativo,
                            a.VistoBueno
                        }  into g
                        select new
                        {
                            IdSolicitud = g.Key.IdSolicitud,
                            NombreTrabajador = g.Key.Nombre + " " + g.Key.ApellidoPaterno + " " + g.Key.ApellidoMaterno,
                            FechaSolicitud = g.Key.FechaSolicitud,
                            FechaAtencion = g.Key.FechaAtencion,

                            Modalidad = g.Key.Modalidad,
                            CentroEducativo = g.Key.CentroEducativo,
                            VistoBueno = g.Key.VistoBueno,

                        };
            List<SolicitudTrabajador> listasolicitudes = new List<SolicitudTrabajador>();
            foreach (var item in lista)
            {
                SolicitudTrabajador sol = new SolicitudTrabajador();
                sol.IdSolicitud = item.IdSolicitud;
                sol.NombreTrabajador = item.NombreTrabajador;
                sol.FechaSolicitud = item.FechaSolicitud.ToString();
                sol.FechaAtencion = item.FechaAtencion.ToString();

                sol.Modalidad = item.Modalidad;
                sol.CentroEducativo = item.CentroEducativo;
                sol.VistoBueno = item.VistoBueno.ToString();
                string materia = db.MaterialDidactico_SolicitudDetalle.Where(r => r.IdSolicitud == item.IdSolicitud).Select(t => t.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura).FirstOrDefault();
                sol.Materia = materia;

                listasolicitudes.Add(sol);
            }
            return listasolicitudes;
        }

        public static List<SolicitudTrabajador> ObtenSolicitudesArea(string area,int id)
        {
            string modalidad = "EMSAD";
            if (area.IndexOf("plantel", 0, StringComparison.InvariantCultureIgnoreCase) > -1)
            {
                modalidad = "PLANTEL";
            }

            
            

            bdNovaEntities db = new bdNovaEntities();
            List<SolicitudTrabajador> listasolicitudes = new List<SolicitudTrabajador>();

            if (id == 0)
            {
                var lista = from a in db.MaterialDidactico_Solicitud
                            join b in db.Kardex_ctTrabajador on a.IdTrabajador equals b.IdTrabajador
                            join c in db.Kardex_ctDatosPersonales on b.IdKardex equals c.IdKardex
                            where a.Modalidad == modalidad
                            select new
                            {
                                IdSolicitud = a.IdSolicitud,
                                NombreTrabajador = c.Nombre + " " + c.ApellidoPaterno + " " + c.ApellidoMaterno,
                                FechaSolicitud = a.FechaSolicitud,
                                FechaAtencion = a.FechaAtencion,

                                Modalidad = a.Modalidad,
                                CentroEducativo = a.CentroEducativo,
                                VistoBueno = a.VistoBueno,

                            };
              
                foreach (var item in lista)
                {
                    SolicitudTrabajador sol = new SolicitudTrabajador();
                    sol.IdSolicitud = item.IdSolicitud;
                    sol.NombreTrabajador = item.NombreTrabajador;
                    sol.FechaSolicitud = item.FechaSolicitud.ToString();
                    sol.FechaAtencion = item.FechaAtencion.ToString();

                    sol.Modalidad = item.Modalidad;
                    sol.CentroEducativo = item.CentroEducativo;
                    sol.VistoBueno = item.VistoBueno.ToString();
                    string materia = db.MaterialDidactico_SolicitudDetalle.Where(r => r.IdSolicitud == item.IdSolicitud).Select(t => t.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura).FirstOrDefault();
                    sol.Materia = materia;

                    listasolicitudes.Add(sol);
                }
            }
            else
            {

                var lista = from a in db.MaterialDidactico_Solicitud
                            join b in db.Kardex_ctTrabajador on a.IdTrabajador equals b.IdTrabajador
                            join c in db.Kardex_ctDatosPersonales on b.IdKardex equals c.IdKardex
                            where a.Modalidad == modalidad && a.IdConvocatoria==id
                            select new
                            {
                                IdSolicitud = a.IdSolicitud,
                                NombreTrabajador = c.Nombre + " " + c.ApellidoPaterno + " " + c.ApellidoMaterno,
                                FechaSolicitud = a.FechaSolicitud,
                                FechaAtencion = a.FechaAtencion,

                                Modalidad = a.Modalidad,
                                CentroEducativo = a.CentroEducativo,
                                VistoBueno = a.VistoBueno,

                            };
              
                foreach (var item in lista)
                {
                    SolicitudTrabajador sol = new SolicitudTrabajador();
                    sol.IdSolicitud = item.IdSolicitud;
                    sol.NombreTrabajador = item.NombreTrabajador;
                    sol.FechaSolicitud = item.FechaSolicitud.ToString();
                    sol.FechaAtencion = item.FechaAtencion.ToString();

                    sol.Modalidad = item.Modalidad;
                    sol.CentroEducativo = item.CentroEducativo;
                    sol.VistoBueno = item.VistoBueno.ToString();
                    string materia = db.MaterialDidactico_SolicitudDetalle.Where(r => r.IdSolicitud == item.IdSolicitud).Select(t => t.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura).FirstOrDefault();
                    sol.Materia = materia;

                    listasolicitudes.Add(sol);
                }
            }


            return listasolicitudes;
        }
        public static List<MaterialDidactico_SolicitudDetalle> ObtenSolicitudPorID(int IdSolicitud)
        {
            bdNovaEntities db = new bdNovaEntities();
            return (List<MaterialDidactico_SolicitudDetalle>)db.MaterialDidactico_SolicitudDetalle.Where(x => x.IdSolicitud == IdSolicitud).ToList();

        }
        public static SolicitudTrabajador ObtenSolicitud(int IdSolicitud)
        {
            bdNovaEntities db = new bdNovaEntities();
           var lista = from a in db.MaterialDidactico_Solicitud
                   join b in db.Kardex_ctTrabajador on a.IdTrabajador equals b.IdTrabajador
                   join c in db.Kardex_ctDatosPersonales on b.IdKardex equals c.IdKardex
                   where a.IdSolicitud == IdSolicitud
                   select  new
                   {
                      IdSolicitud = a.IdSolicitud,
                      NombreTrabajador = c.Nombre + " "+ c.ApellidoPaterno + " "+ c.ApellidoMaterno,
                      FechaSolicitud = a.FechaSolicitud,
                      FechaAtencion = a.FechaAtencion,
                     
                      Modalidad = a.Modalidad,
                      CentroEducativo = a.CentroEducativo,
                   };
           SolicitudTrabajador sol = new SolicitudTrabajador();
            foreach (var item in lista)
            {
                sol.IdSolicitud = item.IdSolicitud;
                sol.NombreTrabajador = item.NombreTrabajador;
                sol.FechaSolicitud = item.FechaSolicitud.ToShortDateString();
                sol.FechaAtencion = item.FechaAtencion.ToString();
               
                sol.Modalidad = item.Modalidad;
                sol.CentroEducativo = item.CentroEducativo;
                string materia = db.MaterialDidactico_SolicitudDetalle.Where(r => r.IdSolicitud == item.IdSolicitud).Select(t => t.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_Asignaturas.Asignatura).FirstOrDefault();
                sol.Materia = materia;

            } return sol;

        }

        public static List<TotalProductosEntregas> Entregas(int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            
            if (id==0)

            return db.MaterialDidactico_SolicitudDetalle.Where(b => b.EsAutorizada == true).GroupBy(t => new { t.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_InventarioTitulo.MaterialDidactico_Titulo.Titulo, t.MaterialDidactico_Solicitud.CentroEducativo }).Select(r => new TotalProductosEntregas { Titulo = r.Key.Titulo, Total = r.Sum(a => a.CantidadAutorizada), TipoMaterial = r.Max(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_InventarioTitulo.MaterialDidactico_Titulo.MaterialDidactico_TipoMaterial.TipoMaterial), CentroEducativo =r.Key.CentroEducativo}  ).ToList();
            else
                return db.MaterialDidactico_SolicitudDetalle.Where(b => b.EsAutorizada == true && b.MaterialDidactico_Solicitud.IdConvocatoria==id).GroupBy(t => new { t.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_InventarioTitulo.MaterialDidactico_Titulo.Titulo, t.MaterialDidactico_Solicitud.CentroEducativo }).Select(r => new TotalProductosEntregas { Titulo = r.Key.Titulo, Total = r.Sum(a => a.CantidadAutorizada), TipoMaterial = r.Max(g => g.MaterialDidactico_AsignaturaTitulo.MaterialDidactico_InventarioTitulo.MaterialDidactico_Titulo.MaterialDidactico_TipoMaterial.TipoMaterial), CentroEducativo = r.Key.CentroEducativo }).ToList();

            
        }

        public static List<Catalogos_ctEstructuraOrganica> CentrosSinParticipar(int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            var vv = db.MaterialDidactico_SolicitudDetalle.Where(g => g.CantidadAutorizada > 0 && g.EsAutorizada == true && g.VistoBueno == true).Select(g => g.IdSolicitud).ToList();

            if (id == 0)
            {
                List<Nova.Models.Catalogos_ctEstructuraOrganica> centros = db.Catalogos_ctEstructuraOrganica.Where(r => r.EstructuraOrganica.Contains("PLANTEL N") || r.EstructuraOrganica.Contains("EMSAD N")).ToList();

                List<CentrosEducativos> centrossolicitud = db.MaterialDidactico_Solicitud.Select(r => new CentrosEducativos { EstructuraOrganica = r.CentroEducativo }).ToList();

                return centros.Where(y => !centrossolicitud.Any(p2 => p2.EstructuraOrganica == y.EstructuraOrganica)).OrderBy(g => g.EstructuraOrganica).ToList();
            }
            else
            {
                List<Nova.Models.Catalogos_ctEstructuraOrganica> centros = db.Catalogos_ctEstructuraOrganica.Where(r =>  r.EstructuraOrganica.Contains("PLANTEL N") || r.EstructuraOrganica.Contains("EMSAD N")).ToList();


                List<CentrosEducativos> centrossolicitud = db.MaterialDidactico_Solicitud.Where(v=> vv.Contains(v.IdSolicitud) &&  v.IdConvocatoria==id).Select(r => new CentrosEducativos { EstructuraOrganica = r.CentroEducativo }).ToList();

                return centros.Where(y => !centrossolicitud.Any(p2 => p2.EstructuraOrganica == y.EstructuraOrganica)).OrderBy(g => g.EstructuraOrganica).ToList();
            }

           
        }
        public static List<MaterialDidactico_AsignaturaTitulo> Material(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            if (id==0)
            return db.MaterialDidactico_AsignaturaTitulo.OrderBy(e => e.MaterialDidactico_Asignaturas.Asignatura).ToList();
            else
                return db.MaterialDidactico_AsignaturaTitulo.Where(f=> f.MaterialDidactico_InventarioTitulo.IdConvocatoria==id).OrderBy(e => e.MaterialDidactico_Asignaturas.Asignatura).ToList();
            
        }

    }
}

