﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public partial class MaterialDidactico_AsignaturaTitulo
    {
        public static List<MaterialDidactico_Titulo> ObtenMaterialDidactico_Titulo()
        {
            bdNovaEntities db = new bdNovaEntities();

            return (List<MaterialDidactico_Titulo>)db.MaterialDidactico_Titulo.ToList();
        }
        public static IEnumerable ObtenAsignaturas()
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.MaterialDidactico_Asignaturas.Select(h =>

                new
                {
                    h.IdAsignatura,
                    Asignatura = h.Asignatura,
                    Modal = h.MaterialDidactico_Modalidad.Modalidad,
                }).ToList().Select(h =>
                    new
                    {
                        h.IdAsignatura,
                        Asignatura = h.Asignatura + "(" + h.Modal + ")"
                    });


        }
        public static IEnumerable ObtenInventarioTitulo()
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.MaterialDidactico_InventarioTitulo.Select(h =>

                new
                {
                    h.IdInventarioTitulo,
                    Titulo = h.MaterialDidactico_Titulo.Titulo,
                    Saldo = h.Saldo,
                    Convocatoria = h.MaterialDidactico_ctConvocatoria.Convocatoria,
                    FechaInicio = h.MaterialDidactico_ctConvocatoria.FechaInicio,
                    FechaTermino = h.MaterialDidactico_ctConvocatoria.FechaTermino
                }).ToList().Select(h =>
                    new
                    {
                        h.IdInventarioTitulo,
                        InventarioTitulo = h.Titulo + " (Saldo=" + h.Saldo.ToString()+ " - "+h.Convocatoria+" - "+ h.FechaInicio.ToShortDateString() + "-" + h.FechaTermino.ToShortDateString() + ")"
                    });


        }

    }
}