﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using System.Web.Mvc;
using System.Data.SqlClient;
using System.Data.Entity.SqlServer;
using System.Data.Entity;
namespace Nova.Models
{
    public partial class Kardex_ctDatosPersonales : ValidacionModelos
    {

        public class CurriculumFiles
        {
            public CurriculumFiles() { }

            public int IdKardex { get; set; }
            public string Nombre { get; set; }
            public string ApellidoPaterno { get; set; }
            public string ApellidoMaterno { get; set; }
            public string FileName { get; set; }
            public string UbicacionFisica { get; set; }
            public string ConvenioLaboral { get; set; }
            public string NombreCompleto { get; set; }

        }
        public override ResultadoValidacion ValidaModelo()
        {

            CURP = CURP.ToUpper();
            Nombre = Nombre.ToUpper();
            ApellidoPaterno = ApellidoPaterno.ToUpper();
            ApellidoMaterno = ApellidoMaterno.ToUpper();
            Sexo = Sexo.ToUpper();

            RFC = RFC.ToUpper();
            Calle = Calle.ToUpper();


            Colonia = Colonia.ToUpper();






            string varCurp = getCurp(Nombre, ApellidoPaterno, ApellidoMaterno, FechaNacimiento.ToShortDateString(), Sexo, IdEstadoNacimiento).Substring(0, 14);
            //if (CURP!="OOMZ900501MOCRRL05")
            //if (varCurp.Substring(0, 13) != CURP.Substring(0, 13))
            //{
            //    parenresult.IsValid = false;
            //    parenresult.Mensaje = "Los datos de NOMBRE, APELLIDO PATERNO, APELLIDO MATERNO, FECHA DE NACIMIENTO,SEXO Y ESTADO DE NACIMIENTO  no coincide con la CURP ingresada: " + CURP.ToUpper() + ", corrija la información para poder continuar";
            //}
            //else
            //    if (varCurp.Substring(0, 10) != RFC.Substring(0, 10))
            //    {
            //        parenresult.IsValid = false;
            //        parenresult.Mensaje = "Los datos de NOMBRE, APELLIDO PATERNO, APELLIDO MATERNO, FECHA DE NACIMIENTO, no coincide con el RFC ingresado: " + RFC.ToUpper() + ", corrija la información para poder continuar";
            //    }

            if (CorreoElectronico ==null)
                CorreoElectronico = String.Empty;

            return parenresult;

        }


        public static string getJefeRecursosHumanos()
        {
            bdNovaEntities d = new bdNovaEntities();

            string resultado = "";
            //var w = ""; // d.spObtenCurp(nombre, app, apm, fechanac, sexo, estadonac).SingleOrDefault();
            var jefe= d.vwDatosAspirantesTrabajadores.Where(F=> F.UbicacionFisica=="DEPARTAMENTO DE RECURSOS HUMANOS" && F.Categoria=="JEFE DE DEPARTAMENTO" && F.EstatusTrabajador=="ALTA").FirstOrDefault();
            if (jefe != null)
                resultado = jefe.Nombre+" "+jefe.ApellidoPaterno+" "+jefe.ApellidoMaterno;
            //return w.ToString();

            return resultado;
        }

        public static int getIdJefeRecursosHumanos()
        {
            bdNovaEntities d = new bdNovaEntities();

            int resultado = 0;
            //var w = ""; // d.spObtenCurp(nombre, app, apm, fechanac, sexo, estadonac).SingleOrDefault();
            var jefe = d.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica == "DEPARTAMENTO DE RECURSOS HUMANOS" && F.Categoria == "JEFE DE DEPARTAMENTO" && F.EstatusTrabajador == "ALTA").FirstOrDefault();
            if (jefe != null)
                resultado = (int)jefe.IdConvenioLaboralTrabajadorCategoria;
            //return w.ToString();

            return resultado;
        }

        public static string getDirectorPlaneacion()
        {
            bdNovaEntities d = new bdNovaEntities();

            string resultado = "";
            //var w = ""; // d.spObtenCurp(nombre, app, apm, fechanac, sexo, estadonac).SingleOrDefault();
            var jefe = d.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica == "DIRECCIÓN DE PLANEACIÓN" && F.Categoria == "DIRECTOR DE ÁREA" && F.EstatusTrabajador == "ALTA").FirstOrDefault();
            if (jefe != null)
                resultado = jefe.Nombre + " " + jefe.ApellidoPaterno + " " + jefe.ApellidoMaterno;
            //return w.ToString();

            return resultado;
        }
        public static string getDirectorAdministrativo()
        {
            bdNovaEntities d = new bdNovaEntities();

            string resultado = "";
            //var w = ""; // d.spObtenCurp(nombre, app, apm, fechanac, sexo, estadonac).SingleOrDefault();
            var jefe = d.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica.Trim() == "DIRECCIÓN ADMINISTRATIVA" && F.Categoria.Trim() == "DIRECTOR DE ÁREA" && F.EstatusTrabajador.Trim() == "ALTA").FirstOrDefault();
            if (jefe != null)
                resultado = jefe.Nombre + " " + jefe.ApellidoPaterno + " " + jefe.ApellidoMaterno;
            //return w.ToString();

            return resultado;
        }

        public static string getDirectorGeneral()
        {
            bdNovaEntities d = new bdNovaEntities();

            string resultado = "";
            //var w = ""; // d.spObtenCurp(nombre, app, apm, fechanac, sexo, estadonac).SingleOrDefault();
            var jefe = d.vwDatosAspirantesTrabajadores.Where(F => F.UbicacionFisica == "DIRECCIÓN GENERAL" && F.Categoria == "DIRECTOR GENERAL" && F.EstatusTrabajador == "ALTA").FirstOrDefault();
            if (jefe != null)
                resultado = jefe.Nombre + " " + jefe.ApellidoPaterno + " " + jefe.ApellidoMaterno;
            //return w.ToString();

            return resultado;
        }


        public static string getCurp(string nombre, string app, string apm, string fechanac, string sexo, short estadonac)
        {
            bdNovaEntities d = new bdNovaEntities();

            //var w = ""; // d.spObtenCurp(nombre, app, apm, fechanac, sexo, estadonac).SingleOrDefault();
            return d.spObtenCurp(nombre, app, apm, fechanac, sexo, estadonac).SingleOrDefault().ToString();

            //return w.ToString();

        }

        //public static bool getProcesoCompletado(int id)
        //{
        //    bdNovaEntities d = new bdNovaEntities();

        //    bool regresa=d.Kardex_ctDatosPersonales.Where(e => e.IdKardex == id).Select(r => r.ProcesoCompletado).SingleOrDefault();

        //    return regresa;

        //}

        public static byte[] getFotografiapeliculas(int Id)
        {
            bdNovaEntities d = new bdNovaEntities();

            byte[] w = d.Cinedebates_ctPeliculas.Where(a => a.IdPelicula == Id).Select(s => s.Fotografia).SingleOrDefault();

            return w;

        }
        public static byte[] getFotografia2(int Id)
        {
            bdNovaEntities d = new bdNovaEntities();

            byte[] w = d.Cinedebates_ctPeliculas.Where(a => a.IdPelicula == Id).Select(s => s.Fotografia).SingleOrDefault();

            return w;

        }

        public static byte[] getFotografia(int Id)
        {
            bdNovaEntities d = new bdNovaEntities();

            byte[] w = d.Kardex_ctDatosPersonalesFotografias.Where(a => a.IdKardex == Id).Select(s => s.Fotografia).SingleOrDefault();

            return w;

        }

        public static string getFotografiaBase64(int Id)
        {
            bdNovaEntities d = new bdNovaEntities();

            byte[] w = d.Kardex_ctDatosPersonalesFotografias.Where(a => a.IdKardex == Id).Select(s => s.Fotografia).SingleOrDefault();

            string base64String = Convert.ToBase64String(w);

            if (string.IsNullOrEmpty(base64String))
                return string.Empty;
            else
            {
                var img = "data:image/jpg;charset=utf-8;base64," + base64String;
                return img;
            }



        }

       
        public static byte[] getFotografiaConvenio(int Id)
        {
            bdNovaEntities d = new bdNovaEntities();

            byte[] w = d.Convenios_stConvenioLaboralTrabajadorCategoria.Where(a => a.IdConvenioLaboralTrabajadorCategoria == Id).Select(s => s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_ctDatosPersonalesFotografias.FirstOrDefault().Fotografia).SingleOrDefault();

            return w;

        }

        public static List<SelectListItem> getNacionalidades()
        {

            List<SelectListItem> items = new List<SelectListItem>();

            items.Add(new SelectListItem { Text = "Seleccione la información", Value = "", Selected = true });

            items.Add(new SelectListItem { Text = "Mexicana", Value = "Mexicana" });

            items.Add(new SelectListItem { Text = "Extranjera", Value = "Extranjera" });


            return items;



        }

        public static List<SelectListItem> getTipodeSangre()
        {

            List<SelectListItem> items = new List<SelectListItem>();

            items.Add(new SelectListItem { Text = "Seleccione la información", Value = "", Selected = true });

            items.Add(new SelectListItem { Text = "O+", Value = "O+" });

            items.Add(new SelectListItem { Text = "O-", Value = "O-" });
            items.Add(new SelectListItem { Text = "A+", Value = "A+" });
            items.Add(new SelectListItem { Text = "A-", Value = "A-" });
            items.Add(new SelectListItem { Text = "B-", Value = "B-" });
            items.Add(new SelectListItem { Text = "B+", Value = "B+" });
            items.Add(new SelectListItem { Text = "AB-", Value = "AB-" });
            items.Add(new SelectListItem { Text = "AB+", Value = "AB+" });


            return items;



        }
        public static string getLocalidadMunicipioEstado(int IdEstado, int IdMunicipio, int IdLocalidad)
        {
            bdNovaEntities t = new bdNovaEntities();

            string w = t.vwLocalidades.Where(d => d.IdEstado == IdEstado && d.IdMpio == IdMunicipio && d.IdLocalidad == IdLocalidad).Select(f => f.Estado + ", " + f.Municipio + ", " + f.Localidad).SingleOrDefault();

            return w;

        }


        public static List<Kardex_stTrabajadorCuentas> GetCuentasPago(DbSet<Kardex_stTrabajadorCuentas> CuentasPago, int IdTrabajador)
        {
            return CuentasPago.Where(s => s.IdTrabajador == IdTrabajador).OrderByDescending(x => x.EsVigente).ToList();
        }



        public static IEnumerable<SelectListItem> getPaises()
        {
            bdNovaEntities db = new bdNovaEntities();
            SelectListItem x = new SelectListItem();

            var query =
                new SelectListItem[] { new SelectListItem { Value = "-1", Text = "Seleccione una información", Selected = true } }.AsEnumerable()
            .Union(from k in db.Catalogos_ctPais

                   select new SelectListItem { Value = SqlFunctions.StringConvert((double)k.IdPais), Text = k.Pais }

                        );

            return (IEnumerable<SelectListItem>)query.ToList();
        }


    }
}