﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Models
{
    public partial class Kardex_stDatosFamiliares : ValidacionModelos
    {

        public static List<SelectListItem> getEstadoCivil()
        {

            List<SelectListItem> items = new List<SelectListItem>();

            items.Add(new SelectListItem { Text = "Seleccione la información", Value = "", Selected = true });

            items.Add(new SelectListItem { Text = "SOLTERO", Value = "SOLTERO" });

            items.Add(new SelectListItem { Text = "CASADO", Value = "CASADO" });


            return items;



        }


        public static IQueryable getFamiliares(int IdKardex)
        {
            bdNovaEntities db = new bdNovaEntities();

            return from df in db.Kardex_stDatosFamiliares
                   where df.IdKardex == IdKardex
                  select new {df.IdKardexFamiliares, df.Nombre,df.ApellidoPaterno,df.ApellidoMaterno,df.Kardex_ctParentesco.Parentesco,df.TelefonoCelular,df.TelefonoParticular,df.AvisarEnCasoDeEmergencia,df.Kardex_ctDatosPersonales.IdKardex,df.FechaNacimiento};


        }

        public static List<Kardex_stDatosFamiliares> getListaFamiliares(int IdKardex)
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.Kardex_stDatosFamiliares.Where( d=> d.IdKardex == IdKardex).ToList();


        }


        public override ResultadoValidacion ValidaModelo()
        {
            

            if (AvisarEnCasoDeEmergencia==true)
            { 
                if (TelefonoCelular == null && TelefonoParticular== null)
                    
                    {
                        parenresult.Mensaje = "Ha elegido avisar en caso de emergencia a este familiar, por lo que es necesario especifique al menos un teléfono para poder comunicarnos con él";
                        parenresult.IsValid = false;

                    }

                
            }
           
            return parenresult;
        }
        


    }
}