﻿using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using Nova.Validation;


namespace Nova.Models
{
     [MetadataType(typeof(Configuracion_stIsrGrupoMetaData))]
    public partial class Configuracion_stIsrGrupo
    {
    }
     public class Configuracion_stIsrGrupoMetaData
     {

         [Required]
         [RegularExpression(@"^[A-Za-zÑñáéíóúÁÉÍÓÚ0-9]*$",ErrorMessage=" Únicamente letras y números por favor !!")]
         public string IsrGrupo { get; set; }
         [Required]
         public System.DateTime FechaInicio { get; set; }
         [Required]
         [DateGreaterThan("FechaInicio", "La fecha de término debe ser mayor que la fecha de inicio")]
         public object FechaTermino { get; set; }


     }

}