﻿using Nova.Models.Correo;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public class Kardex_SolicitudEvaluacionesDto : Kardex_SolicitudEvaluaciones
    {
        public bool TieneCita { get; set; } = false;
        public DateTime? FechaCita { get; set; }
        public TimeSpan? HoraCita { get; set; }
        public List<Kardex_stAspiranteProceso> TareasTerminadas { get; set; }

        public Kardex_SolicitudEvaluacionesDto (Kardex_SolicitudEvaluaciones solicitudEvaluaciones)
        : base()
        {
            // Copia todas las propiedades de la clase base (Kardex_SolicitudEvaluaciones)
            this.Kardex_ctDatosPersonales = solicitudEvaluaciones.Kardex_ctDatosPersonales;
            this.Catalogos_ctEstructuraOrganica = solicitudEvaluaciones.Catalogos_ctEstructuraOrganica;
            this.IdKardexSolicitudEvaluacion = solicitudEvaluaciones.IdKardexSolicitudEvaluacion;
            this.FechaSolicitud = solicitudEvaluaciones.FechaSolicitud;
            this.IdConvenioLaboralTrabajadorCategoriaRegistro = solicitudEvaluaciones.IdConvenioLaboralTrabajadorCategoriaRegistro;
            this.IdEstructuraOrganicaLaboraFisicamente = solicitudEvaluaciones.IdEstructuraOrganicaLaboraFisicamente;
            this.IdEstructuraOrganicaAdscripcion = solicitudEvaluaciones.IdEstructuraOrganicaAdscripcion;
            this.IdTipoSuplencia = solicitudEvaluaciones.IdTipoSuplencia;
            this.IdKardexCandidato = solicitudEvaluaciones.IdKardexCandidato;
            this.IdConvenioLaboralTrabajadorCategoriaaCubrir = solicitudEvaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir;
            this.IdCategoriaAspirante = solicitudEvaluaciones.IdCategoriaAspirante;
            this.FechaInicio = solicitudEvaluaciones.FechaInicio;
            this.FechaTermino = solicitudEvaluaciones.FechaTermino;
            this.NumeroOficio = solicitudEvaluaciones.NumeroOficio;
            this.Observaciones = solicitudEvaluaciones.Observaciones;
            this.IdEstatusContratacion = solicitudEvaluaciones.IdEstatusContratacion;
            this.IdAreaConocimiento = solicitudEvaluaciones.IdAreaConocimiento;
            this.IdRelacionLaboral = solicitudEvaluaciones.IdRelacionLaboral;
            this.HorasSemanaMes = solicitudEvaluaciones.HorasSemanaMes;
            this.CicloEscolar = solicitudEvaluaciones.CicloEscolar;

            // Inicializa la propiedad adicional de Kardex_SolicitudEvaluacionesDto
            this.TareasTerminadas = new List<Kardex_stAspiranteProceso>();
        }
    }

}
namespace Nova.Models.IngresoPersonal
{
    public enum AspiranteTareasContratacion
    {
        DatosPersonales,
        DatosAcademicos,
        ExpedienteDigital,
        InformacionAdicional
        , NotificarTareasCompletadas
        //,FormatoSeguroVida
        ,Cita
    }
    public static class IngresoPersonal
    {
        public static void enviaMailEncuesta(string baseUrl, long idkardsolicitudevaluacion)
        {
            bdNovaEntities bd = new bdNovaEntities();
            Kardex_SolicitudEvaluaciones solicitud = new Kardex_SolicitudEvaluaciones();

            solicitud = bd.Kardex_SolicitudEvaluaciones.Find(idkardsolicitudevaluacion);

            CorreoPersonalizado correo = new CorreoPersonalizado();

            correo.TituloCorreo = "Encuesta";
            correo.Nombre = $"{solicitud.Kardex_ctDatosPersonales.Nombre} {solicitud.Kardex_ctDatosPersonales.ApellidoPaterno} {solicitud.Kardex_ctDatosPersonales.ApellidoMaterno} ";


            correo.LinkUrl = baseUrl;

            correo.DestinatarioEmail = solicitud.Kardex_ctDatosPersonales.CorreoElectronico.Trim().ToLower();



            CorreoService.EnviarCorreoPersonalizado(correo, "~/Views/Correo/PlantillaEncuestaSatisfaccion.html");


        }

        public static void enviaMailNuevoIngreso(string baseUrl, long idkardsolicitudevaluacion)
        {
            bdNovaEntities bd = new bdNovaEntities();
            Kardex_SolicitudEvaluaciones solicitud = new Kardex_SolicitudEvaluaciones();

            solicitud = bd.Kardex_SolicitudEvaluaciones.Find(idkardsolicitudevaluacion);

            CorreoPersonalizado correo = new CorreoPersonalizado();

            correo.TituloCorreo = "Nuevo Ingreso";
            correo.Nombre = $"Nombre: {solicitud.Kardex_ctDatosPersonales.Nombre} {solicitud.Kardex_ctDatosPersonales.ApellidoPaterno} {solicitud.Kardex_ctDatosPersonales.ApellidoMaterno}.Telefono:{solicitud.Kardex_ctDatosPersonales.TelefonoCelular},{solicitud.Kardex_ctDatosPersonales.TelefonoCelular}, correo:{solicitud.Kardex_ctDatosPersonales.CorreoElectronico} ";


            correo.LinkUrl = baseUrl;

            correo.DestinatarioEmail = solicitud.Kardex_ctDatosPersonales.CorreoElectronico.Trim().ToLower();
            //correo.DestinatarioEmail = "evaluacion@cecyteo.edu.mx";

            correo.Firma = Kardex_ctDatosPersonales.getJefeRecursosHumanos();


            CorreoService.EnviarCorreoPersonalizado(correo, "~/Views/Correo/PlantillaNuevoIngreso.html");


        }

        public static void enviaResultadoEvaluacionNegativo(long idkardsolicitudevaluacion)
        {
            bdNovaEntities bd = new bdNovaEntities();
            Kardex_SolicitudEvaluaciones solicitud = new Kardex_SolicitudEvaluaciones();

            solicitud = bd.Kardex_SolicitudEvaluaciones.Find(idkardsolicitudevaluacion);
            var cita = bd.Kardex_CitasContratacion.Where(q => q.IdKardexSolicitudEvaluacion == solicitud.IdKardexSolicitudEvaluacion).FirstOrDefault();
            CorreoPersonalizado correo = new CorreoPersonalizado();

            correo.TituloCorreo = "Resultado de la evaluación";
            correo.Nombre = $"{solicitud.Kardex_ctDatosPersonales.Nombre} {solicitud.Kardex_ctDatosPersonales.ApellidoPaterno} {solicitud.Kardex_ctDatosPersonales.ApellidoMaterno} ";
            correo.DestinatarioEmail = "secretariageneral202226@gmail.com,srecursoshumanos202226@gmail.com,drhumanos@cecyteo.edu.mx";


            correo.Firma = "EDUARDO ALBERTO RICÁRDEZ NOBLE";
            correo.DirigidoA = "JULIO MARTIN DIAZ SANCHEZ";

            CorreoService.EnviarCorreoPersonalizado(correo, "~/Views/Correo/PlantillaResultadoEvaluacion.html");


        }

        public static void enviaMailConfirmacionCita(long idkardsolicitudevaluacion)
        {
            bdNovaEntities bd = new bdNovaEntities();
            Kardex_SolicitudEvaluaciones solicitud = new Kardex_SolicitudEvaluaciones();

            solicitud = bd.Kardex_SolicitudEvaluaciones.Find(idkardsolicitudevaluacion);
            var cita = bd.Kardex_CitasContratacion.Where(q => q.IdKardexSolicitudEvaluacion == solicitud.IdKardexSolicitudEvaluacion).FirstOrDefault();
            CorreoPersonalizado correo = new CorreoPersonalizado();

            correo.TituloCorreo = "Confirmación de cita";
            correo.Nombre = $"{solicitud.Kardex_ctDatosPersonales.Nombre} {solicitud.Kardex_ctDatosPersonales.ApellidoPaterno} {solicitud.Kardex_ctDatosPersonales.ApellidoMaterno} ";
            correo.DireccionFirma = " Calzada Porfirio Díaz 243, Colonia Reforma, Oaxaca, México. C.P. 68050";
            correo.Fecha = cita.FechaCita.ToString("dd/MM/yyyy");
            correo.Hora = cita.HoraCita.ToString(@"h\:mm");
            //correo.LinkUrl = baseUrl;
            correo.DestinatarioEmail = solicitud.Kardex_ctDatosPersonales.CorreoElectronico.Trim().ToLower();

            correo.Firma = Kardex_ctDatosPersonales.getJefeRecursosHumanos();

            CorreoService.EnviarCorreoPersonalizado(correo, "~/Views/Correo/PlantillaConfirmacionCita.html");


        }


        public static void enviaMailIngresoPersonal(string baseUrl, long idkardsolicitudevaluacion)
        {
            bdNovaEntities bd = new bdNovaEntities();
            Kardex_SolicitudEvaluaciones solicitud = new Kardex_SolicitudEvaluaciones();

            solicitud = bd.Kardex_SolicitudEvaluaciones.Find(idkardsolicitudevaluacion);

            CorreoPersonalizado correo = new CorreoPersonalizado();

            correo.TituloCorreo = "Bienvenido(a)";
            correo.Nombre = $"{solicitud.Kardex_ctDatosPersonales.Nombre} {solicitud.Kardex_ctDatosPersonales.ApellidoPaterno} {solicitud.Kardex_ctDatosPersonales.ApellidoMaterno} ";


            correo.LinkUrl = baseUrl;

            correo.DestinatarioEmail = solicitud.Kardex_ctDatosPersonales.CorreoElectronico.Trim().ToLower();
            //correo.DirigidoA = "JULIO MARTIN DIAZ SANCHEZ";
            correo.Firma = Kardex_ctDatosPersonales.getJefeRecursosHumanos();


            CorreoService.EnviarCorreoPersonalizado(correo, "~/Views/Correo/PlantillaBienvenidaContrato.html");


        }
        public static bool guardaTareaTerminada(long idkardexevaluacion, AspiranteTareasContratacion tarea)
        {
            bool r = true;
            bdNovaEntities db = new bdNovaEntities();
            var ntarea = Convert.ToInt32(tarea);

            var existe = db.Kardex_stAspiranteProceso.Where(q => q.Tarea == ntarea
              && q.IdKardexSolicitudEvaluacion == idkardexevaluacion).FirstOrDefault();
            if (existe == null)
            {

                Kardex_stAspiranteProceso model = new Kardex_stAspiranteProceso();
                model.IdKardexSolicitudEvaluacion = idkardexevaluacion;
                model.Tarea = Convert.ToInt32(tarea);
                model.FechaMovimiento = DateTime.Now;

                db.Kardex_stAspiranteProceso.Add(model);

                db.SaveChanges();
            }

            return r;
        }
        public static Kardex_SolicitudEvaluaciones ObtenKardexSolicitudEvaluaciones(string token)
        {
            long n = 0;
            bdNovaEntities db = new bdNovaEntities();
            Kardex_SolicitudEvaluaciones r;

            string decryptedQueryString = UrlEncryptor.DecryptQueryString(token);

            // Parsear los valores de la cadena de consulta
            var queryStringParams = HttpUtility.ParseQueryString(decryptedQueryString);
            //string calculatedHash = UrlEncryptor.GenerateHash(decryptedQueryString);

            // Comparar el hash recibido con el hash calculado
            //if (hash != calculatedHash)
            //{
            //    // El hash no coincide, la cadena de consulta ha sido alterada
            //    throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "No estas autorizado para realizar esta acción");

            //}
            // Recuperar los valores
            long id = int.Parse(queryStringParams["Id"]);


            try
            {
                //var data =token);
                //TSHAK.Components.SecureQueryString querystringSeguro = new TSHAK.Components.SecureQueryString(new byte[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 8 }, HttpUtility.UrlDecode(token));
                // TSHAK.Components.SecureQueryString querystringSeguro = new TSHAK.Components.SecureQueryString(new byte[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 8 }, token);
                //n = Convert.ToInt64(querystringSeguro["Id"].ToString());
                n = id;
                r = db.Kardex_SolicitudEvaluaciones.Find(n);

                if (r == null)

                    throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "No es valida la url solicitada");

                var control = db.Nomina_ContratosConfiguracion.Where(q => q.CicloEscolar == r.CicloEscolar).FirstOrDefault();
                if (control == null)
                    throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "No hay fechas aun configuradas para iniciar el proceso");


                //if (r.FechaSolicitud.AddMonths(1) < DateTime.Now)
                    if (r.FechaSolicitud.AddMonths(2) < DateTime.Now)
                    throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "El Proceso de selección ha finalizado");


            }
            catch (Exception e)
            {

                throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "No estas autorizado para realizar esta acción");
            }

            return r;
        }
    }
}