﻿using Dapper;
using DevExpress.CodeParser;
using DevExpress.DataProcessing.InMemoryDataProcessor;
using DevExpress.Web.ASPxHtmlEditor.Internal;
//using DocumentFormat.OpenXml.Bibliography;
//using DocumentFormat.OpenXml.Office2010.Excel;
using Nova.Libraries;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;
using Nova.Models.AsignarPlaza;
using DevExpress.XtraRichEdit.Import.Html;
//using DocumentFormat.OpenXml.Drawing.Charts;
using Nova.Models.Calculos;

namespace Nova.Models
{
    

    public partial class IncidenciaPermiso_stIncidenciaTrabajadorCentros
    {


        public string ObtenerNumerosQuincenas(string fechaInicioStr, string fechaTerminoStr)
        {
            // Convertir las cadenas de fecha a DateTime
            DateTime fechaInicio;
            DateTime fechaTermino;

            if (!DateTime.TryParse(fechaInicioStr, out fechaInicio) || !DateTime.TryParse(fechaTerminoStr, out fechaTermino))
            {
                throw new ArgumentException("Las fechas proporcionadas no son válidas.");
            }

            List<string> quincenas = new List<string>();

            DateTime fechaActual = fechaInicio;

            while (fechaActual <= fechaTermino)
            {
                // Definir las dos quincenas del mes
                DateTime quincena1Fin = new DateTime(fechaActual.Year, fechaActual.Month, 15);
                DateTime quincena2Inicio = new DateTime(fechaActual.Year, fechaActual.Month, 16);
                DateTime quincena2Fin = new DateTime(fechaActual.Year, fechaActual.Month, DateTime.DaysInMonth(fechaActual.Year, fechaActual.Month));

                // Revisar si la fechaInicio o fechaTermino caen dentro de la primera quincena
                if (fechaInicio <= quincena1Fin && fechaTermino >= quincena1Fin)
                {
                    quincenas.Add($"{fechaActual.Month * 2 - 1}"); // Quincena 1
                }

                // Revisar si la fechaInicio o fechaTermino caen dentro de la segunda quincena
                if (fechaInicio <= quincena2Fin && fechaTermino >= quincena2Inicio)
                {
                    quincenas.Add($"{fechaActual.Month * 2}"); // Quincena 2
                }

                // Avanzar al próximo mes
                fechaActual = fechaActual.AddMonths(1);
            }

            // Devolver las quincenas como una cadena separada por comas
            return string.Join(", ", quincenas);
        }



        public static List<dynamic> getIncidenciasGlobalesTodosCentros(string fip, string ftp)
        {
            List<dynamic> m = new List<dynamic>();

            

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";


            if (fip != null)
            {
                var IncidenciaPermiso_stIncidenciaTrabajadorCentros = new IncidenciaPermiso_stIncidenciaTrabajadorCentros();
                string quincenas = IncidenciaPermiso_stIncidenciaTrabajadorCentros.ObtenerNumerosQuincenas(fip, ftp);
                DateTime fil = DateTime.Parse(fip);
                string fi = fil.ToString("yyyMMdd");
                DateTime ftl = DateTime.Parse(ftp);
                string ft = ftl.ToString("yyyMMdd");
                string condicion = "where a.Quincena in ("+ quincenas +")";
               

                u = $@"
                        SELECT 
                            qq.IdEstructuraOrganica,
                            qq.EstructuraOrganica,
                            qq.AñoQuincenaNomina,
                            qq.TotalFaltas,
                            qq.TotalRetardos,
                            PivotTable.Quincena,
                            PivotTable.Año,
                            PivotTable.REVISADO,
                            PivotTable.AUTORIZADO,
                            PivotTable.CERRADO
                        FROM
                            (
                                SELECT 
                                    a.IdEstructuraOrganica,
                                    a.EstructuraOrganica,
                                    w.TotalFaltas,
                                    z.TotalRetardos,
                                    w.AñoQuincenaNomina,
                                    a.EsVigente
                                FROM 
                                    [Catalogos_ctEstructuraOrganica] a
                                LEFT JOIN 
                                    (
                                        SELECT 
                                            COUNT(t.IdTrabajador) AS TotalFaltas,
                                            t.IdEstructuraOrganicaFisica,
                                            SUM(CASE WHEN AñoParaNomina IS NOT NULL THEN 1 ELSE 0 END) AS ctaAñoNomina,
                                            MAX(CASE WHEN AñoParaNomina IS NOT NULL THEN CAST(AñoParaNomina AS NVARCHAR(8)) + '-' + CAST(QuincenaParaNomina AS NVARCHAR(8)) ELSE '' END) AS AñoQuincenaNomina
                                        FROM 
                                            IncidenciaPermiso_stIncidenciaTrabajador a
                                        INNER JOIN 
                                            Catalogos_ctTipoIncidencia b ON a.IdTipoIncidencia = b.IdTipoIncidencia
                                        INNER JOIN 
                                            Catalogos_ctTipoIncidenciaPermiso c ON b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                                        INNER JOIN 
                                            vwDatosAspirantesTrabajadoresHistorial t ON t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                                        INNER JOIN 
                                            [Incidencia_ctJustificacion] J ON J.IdIncidenciaJustificacion = A.IdIncidenciaJustificacion
                                        WHERE 
                                            c.TipoIncidenciaPermiso IN ('INCIDENCIA')  
                                            AND J.IncidenciaJustificacion NOT IN ('SUSPENSIÓN DE LABORES', 'VACACIONES')
                                            AND a.IdIncidenciaJustificacion = 0
                                            AND CAST(a.FechaInicio AS DATE) >= '{fi}' 
                                            AND CAST(a.FechaInicio AS DATE) <= '{ft}'  
                                            AND CAST(t.FechaInicio AS DATE) <= '{fi}'
                                        GROUP BY 
                                            t.IdEstructuraOrganicaFisica
                                    ) AS w ON w.IdEstructuraOrganicaFisica = a.IdEstructuraOrganica
                                LEFT JOIN 
                                                    (
                                                        SELECT 
                                                            COUNT(a.IdConvenioLaboralTrabajadorCategoria) AS TotalRetardos,
                                                            t.IdEstructuraOrganicaFisica
                                                        FROM 
                                                            IncidenciaPermiso_stIncidenciaTrabajador a
                                                        INNER JOIN 
                                                            Catalogos_ctTipoIncidencia b ON a.IdTipoIncidencia = b.IdTipoIncidencia
                                                        INNER JOIN 
                                                            Catalogos_ctTipoIncidenciaPermiso c ON b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
                                                        INNER JOIN 
                                                            vwDatosAspirantesTrabajadoresHistorial t ON t.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
                                                        WHERE 
                                                            c.TipoIncidenciaPermiso IN ('RETARDOS')  
                                                            AND CAST(a.FechaInicio AS DATE) >= '{fi}' 
                                                            AND CAST(a.FechaInicio AS DATE) <= '{ft}'
                                                            AND a.IdIncidenciaJustificacion = 0
                                                        GROUP BY 
                                                            t.IdEstructuraOrganicaFisica
                                                    ) AS z ON z.IdEstructuraOrganicaFisica = a.IdEstructuraOrganica
                                                WHERE 
                                                    a.EsVigente = 1
                                            ) AS qq
                                        LEFT JOIN 
                                            (
                                                SELECT 
                                                    a.IdEstructuraOrganica,
                                                    a.Quincena,
                                                    a.Año,
                                                    b.IncidenciasProcesosEstatus
                                                FROM 
                                                    IncidenciaPermiso_stIncidenciaTrabajadorProcesoEstatus a
                                                INNER JOIN 
                                                    IncidenciaPermiso_cProcesosEstatus b 
                                                    ON a.IdProcesosEstatus = b.IdProcesosEstatus
                                                    {condicion} 
                                            ) AS SourceTable
                                        PIVOT
                                        (
                                            MAX(IncidenciasProcesosEstatus)
                                            FOR IncidenciasProcesosEstatus IN ([REVISADO], [AUTORIZADO],[CERRADO])
                                        ) AS PivotTable
                                        ON qq.IdEstructuraOrganica = PivotTable.IdEstructuraOrganica
                                        ORDER BY 
                                            qq.EstructuraOrganica;

                ";



                m = (List<dynamic>)dp.connection.Query<dynamic>(u);
                dp.Close();
            }
            return m;
        }


    }

}