﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public class SaldosIncidenciasIncapacidades
    {
         

            public int IdTrabajador { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string Incidencia { get; set; }

        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string Categoria { get; set; }
        public string UbicacionFisica { get; set; }
        public decimal Saldo { get; set; }
        public decimal Total { get; set; }

    }
    public class IndicenciasConcentrado
    {
        [Key]
        public int IdIncidenciaTrabajador { get; set; }

        public int IdTrabajador { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public int Horas { get; set; }
        public string Nombre { get; set; }
        public string Categoria { get; set; }
        public string UbicacionFisica { get; set; }
        public string IdEstructuraOrganicaFisica { get; set; }
        public DateTime FechaInicio { get; set; }

        public Boolean EsFaltaDirecta { get; set; }


        public string Incidencia { get; set; }

        public string TipoIncidenciaPermiso { get; set; }

        public int IdEstructuraOrganica { get; set; }


        public string Registro { get; set; }
        public string EstructuraOrganica { get; set; }
        public string QuincenaParaNomina { get; set; }
        public string AñoParaNomina { get; set; }

    }

    public class AsistenciasTrabajador
    {
        [Key]
        public long IdRelojChecadorAsistencia { get; set; }
        public int IdTrabajador { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Categoria { get; set; }
        public string UbicacionFisica { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public string EstatusTrabajador { get; set; }
        public DateTime FechaAsistencia { get; set; }

        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public bool Autorizo { get; set; }
        public string NombreJustifico { get; set; }

        public string ApellidoPaternoJustifico { get; set; }
        public string ApellidoMaternoJustifico { get; set; }
        public string NombreAutorizo { get; set; }
        public string ApellidoPaternoAutorizo { get; set; }
        public string ApellidoMaternoAutorizo { get; set; }

        public int IdIncidenciaTrabajador { get; set; }
        public string IncidenciaJustificacion { get; set; }
        public string Nomenclatura { get; set; }
        public string Color { get; set; }
        public DateTime FechaJustificacion { get; set; }
        public DateTime FechaAutorizacion { get; set; }
        public string Incidencia { get; set; }
        public string NomenclaturaIncidencia { get; set; }
        public string ColorIncidencia { get; set; }
        public string NombreMes { get; set; }
        public string Mes { get; set; }
        public string Anio { get; set; }
        public string Horas { get; set; }


    }
    //public class Años
    //{
    //    public string IncidenciaJustificacion { get; set; }
    //    public string Nomenclatura { get; set; }
    //    public string Nomenclatura { get; set; }

    //}
    public class PermisosArea
    {
        public int idarea { get; set; }
        public DateTime fi { get; set; }
        public DateTime ff { get; set; }
    }
    public class LeyendasReporte
    {
        public string Incidencia { get; set; }
        public string Nomenclatura { get; set; }
    }

    public class TrabajadoresPermisos
    {
        public int Id { get; set; }
        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string Permiso { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
    }

    public class Años
    {
        public int IdAño { get; set; }
        public int Año { get; set; }

    }
    public class Quincena
    {
        public short IdQuincenaMes { get; set; }
        public string QuincenaMes { get; set; }

    }
    public class Pase
    {
        public DateTime Dia { get; set; }
        public System.TimeSpan TiempoFuera { get; set; }

    }
    public class Prima
    {
        public DateTime Dia { get; set; }

    }
    public class Falta
    {
        public DateTime Dia { get; set; }
        public short Horas { get; set; }


    }

    public class AreasUsuario
    {
        public int IdEstructuraOrganica { get; set; }
        public string EstructuraOrganica { get; set; }
        //        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
    }
    public class IncidenciaTrabajador
    {
        public Int64 IdIncidenciaTrabajador { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public int Horas { get; set; }
        public System.TimeSpan TiempoFuera { get; set; }

        public int IdTrabajador { get; set; }
        public string Trabajador { get; set; }
        public int DiasHorasIncidencia { get; set; }
        public int DiasEconomicos { get; set; }
        public Boolean EsJustificacionExtemporanea { get; set; }
        public string QuienAutorizo { get; set; }
        public string QuienJustifico { get; set; }
        public string QuienRegistro { get; set; }
        public string Incidencia { get; set; }
        public string Nomenclatura { get; set; }
        public string Color { get; set; }
        public string IncidenciaJustico { get; set; }
        public string NomenclaturaJustifico { get; set; }
        public string ColorJustifico { get; set; }
        public int IdNominaTrabajador { get; set; }
        public string EstructuraOrganica { get; set; }
        public string Categoria { get; set; }
        public string Observaciones { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public Boolean EsAplicada { get; set; }
        public Boolean Autorizo { get; set; }
        public string DescripcionJustificacion { get; set; }
        public DateTime FechaAutorizacion { get; set; }
        public DateTime FechaCreacion { get; set; }
        public DateTime FechaJustificacion { get; set; }
        public int IdIncidenciaJustificacion { get; set; }
        public Boolean EsCancelada { get; set; }
        public Boolean EsCerrada { get; set; }
        public string CURP { get; set; }
        public Boolean EsFaltaDirecta { get; set; }

        public Nullable <DateTime> FechaTerminoConvenio { get; set; }
        public int IdModalidadEstudio { get; set; }
        public string QuincenaParaNomina { get; set; }


    }
    public class VistaIncidenciaTrabajador
    {
        public int Id { get; set; }
        public string Trabajador { get; set; }
        public string Categoria { get; set; }
        public string RelacionLaboral { get; set; }
        public string ConvenioLaboral { get; set; }
        public Nullable  <DateTime> Ftc{ get; set; }
        public int IdModalidadEstudio { get; set; }

        public int D1 { get; set; }
        public int D2 { get; set; }
        public int D3 { get; set; }
        public int D4 { get; set; }
        public int D5 { get; set; }
        public int D6 { get; set; }
        public int D7 { get; set; }
        public int D8 { get; set; }
        public int D9 { get; set; }
        public int D10 { get; set; }
        public int D11 { get; set; }
        public int D12 { get; set; }
        public int D13 { get; set; }
        public int D14 { get; set; }
        public int D15 { get; set; }
        public int D16 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia1 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia2 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia3 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia4 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia5 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia6 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia7 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia8 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia9 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia10 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia11 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia12 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia13 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia14 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia15 { get; set; }
        public List<IncidenciaTrabajador> IncidenciasDia16 { get; set; }
        public int Faltas { get; set; }
        public int DiasEconomicos { get; set; }
        public Boolean PuntualidadAsistencia { get; set; }
        public string Observaciones { get; set; }

    }
    public class EstructuraIncidencias
    {
        public List<VistaIncidenciaTrabajador> InicidenciasTrabajadores { get; set; }
    }

    public partial class IncidenciaPermiso_stIncidenciaTrabajador
    {
        public static List<Incidencia_ctJustificacion> getTipoJustificacion()
        {
            bdNovaEntities db = new bdNovaEntities();

            List<Incidencia_ctJustificacion> listajustificacion = db.Incidencia_ctJustificacion.Where(z => z.IncidenciaJustificacion != "OMISIÓN DE SALIDA" && z.IncidenciaJustificacion != "OMISIÓN DE ENTRADA").ToList();

            return listajustificacion;
        }

        public static List<Catalogos_ctTipoIncidencia> getTipoIncidencia()
        {
            bdNovaEntities db = new bdNovaEntities();

            return (List<Catalogos_ctTipoIncidencia>)db.Catalogos_ctTipoIncidencia.ToList();
        }

        public static List<IndicenciasConcentrado> getIncidenciasPorMesa(int id=0)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = "";
            if (id > 0)
            {
                u = @"select * from (
                    
                    SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.RelacionLaboral,t.ConvenioLaboral,t.RelacionConvenioLaboral, a.Horas,
                    t.Nombre +' ' +t.ApellidoPaterno +' ' +t.ApellidoMaterno as Nombre ,t.Categoria,t.UbicacionFisica,t.IdEstructuraOrganicaFisica
                    ,a.FechaInicio,a.EsFaltaDirecta,b.Incidencia,c.TipoIncidenciaPermiso,QuincenaParaNomina,AñoParaNomina
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA','RETARDOS')  
 and EsCerrada=1 AND EsAplicada=0 and ((Autorizo=1 and a.IdIncidenciaJustificacion=0) or Autorizo=0 OR EsCancelada=1 ) 
) as uno
                    inner join (
                    SELECT  a.IdConvenioLaboralTrabajadorCategoria,q.IdEstructuraOrganica ,a.Nombre +' ' +a.ApellidoPaterno +' ' +a.ApellidoMaterno as Registro,q.EstructuraOrganica 
                     FROM Nomina_RelojChecadorControlUsuarios w
                    inner join Nomina_RelojChecadorAreas r on w.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join  Nomina_RelojChecadorAreasEstructuraOrganica s on s.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join Catalogos_ctEstructuraOrganica q on q.IdEstructuraOrganica=s.IdEstructuraOrganica
                    inner join vwDatosAspirantesTrabajadores  a on a.IdConvenioLaboralTrabajadorCategoria=w.IdConvenioLaboralTrabajadorCategoria
                    where a.IdConvenioLaboralTrabajadorCategoria=" + id + @"
                    ) as dos on uno.IdEstructuraOrganicaFisica=dos.IdEstructuraOrganica 
UNION ALL   
  
                    
                    select * from (
                    
                    SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.RelacionLaboral,t.ConvenioLaboral,t.RelacionConvenioLaboral, a.Horas,
                    t.Nombre +' ' +t.ApellidoPaterno +' ' +t.ApellidoMaterno as Nombre ,t.Categoria,t.UbicacionFisica,t.IdEstructuraOrganicaFisica
                    ,a.FechaInicio,a.EsFaltaDirecta,b.Incidencia,c.TipoIncidenciaPermiso,QuincenaParaNomina,AñoParaNomina
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 WHERE c.TipoIncidenciaPermiso in('PERCEPCION') 
 and EsCerrada=1 AND EsAplicada=0 and (Autorizo=1 and a.IdIncidenciaJustificacion>0 or (Autorizo=1 and EsFaltaDirecta=1 ))
 ) as uno
                    inner join (
                    SELECT  a.IdConvenioLaboralTrabajadorCategoria,q.IdEstructuraOrganica ,a.Nombre +' ' +a.ApellidoPaterno +' ' +a.ApellidoMaterno as Registro,q.EstructuraOrganica 
                     FROM Nomina_RelojChecadorControlUsuarios w
                    inner join Nomina_RelojChecadorAreas r on w.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join  Nomina_RelojChecadorAreasEstructuraOrganica s on s.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join Catalogos_ctEstructuraOrganica q on q.IdEstructuraOrganica=s.IdEstructuraOrganica
                    inner join vwDatosAspirantesTrabajadores  a on a.IdConvenioLaboralTrabajadorCategoria=w.IdConvenioLaboralTrabajadorCategoria
                    where a.IdConvenioLaboralTrabajadorCategoria=" + id + @"
                    ) as dos on uno.IdEstructuraOrganicaFisica=dos.IdEstructuraOrganica ";
            }
            else
            {

                u = @"select * from (
                    
                    SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.RelacionLaboral,t.ConvenioLaboral,t.RelacionConvenioLaboral, a.Horas,
                    t.Nombre +' ' +t.ApellidoPaterno +' ' +t.ApellidoMaterno as Nombre ,t.Categoria,t.UbicacionFisica,t.IdEstructuraOrganicaFisica
                    ,a.FechaInicio,a.EsFaltaDirecta,b.Incidencia,c.TipoIncidenciaPermiso,QuincenaParaNomina,AñoParaNomina
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA','RETARDOS')  
 and EsCerrada=1 AND EsAplicada=0 and ((Autorizo=1 and a.IdIncidenciaJustificacion=0) or Autorizo=0 OR EsCancelada=1 ) 
) as uno
                    inner join (
                    SELECT  a.IdConvenioLaboralTrabajadorCategoria,q.IdEstructuraOrganica ,a.Nombre +' ' +a.ApellidoPaterno +' ' +a.ApellidoMaterno as Registro,q.EstructuraOrganica 
                     FROM Nomina_RelojChecadorControlUsuarios w
                    inner join Nomina_RelojChecadorAreas r on w.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join  Nomina_RelojChecadorAreasEstructuraOrganica s on s.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join Catalogos_ctEstructuraOrganica q on q.IdEstructuraOrganica=s.IdEstructuraOrganica
                    inner join vwDatosAspirantesTrabajadores  a on a.IdConvenioLaboralTrabajadorCategoria=w.IdConvenioLaboralTrabajadorCategoria
                    
                    ) as dos on uno.IdEstructuraOrganicaFisica=dos.IdEstructuraOrganica 
UNION ALL   
  
                    
                    select * from (
                    
                    SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.RelacionLaboral,t.ConvenioLaboral,t.RelacionConvenioLaboral, a.Horas,
                    t.Nombre +' ' +t.ApellidoPaterno +' ' +t.ApellidoMaterno as Nombre ,t.Categoria,t.UbicacionFisica,t.IdEstructuraOrganicaFisica
                    ,a.FechaInicio,a.EsFaltaDirecta,b.Incidencia,c.TipoIncidenciaPermiso,QuincenaParaNomina,AñoParaNomina
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 WHERE c.TipoIncidenciaPermiso in('PERCEPCION') 
 and EsCerrada=1 AND EsAplicada=0 and (Autorizo=1 and a.IdIncidenciaJustificacion>0 or (Autorizo=1 and EsFaltaDirecta=1 ))
) as uno
                    inner join (
                    SELECT  a.IdConvenioLaboralTrabajadorCategoria,q.IdEstructuraOrganica ,a.Nombre +' ' +a.ApellidoPaterno +' ' +a.ApellidoMaterno as Registro,q.EstructuraOrganica 
                     FROM Nomina_RelojChecadorControlUsuarios w
                    inner join Nomina_RelojChecadorAreas r on w.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join  Nomina_RelojChecadorAreasEstructuraOrganica s on s.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join Catalogos_ctEstructuraOrganica q on q.IdEstructuraOrganica=s.IdEstructuraOrganica
                    inner join vwDatosAspirantesTrabajadores  a on a.IdConvenioLaboralTrabajadorCategoria=w.IdConvenioLaboralTrabajadorCategoria
                   
                    ) as dos on uno.IdEstructuraOrganicaFisica=dos.IdEstructuraOrganica ";
            }

            List<IndicenciasConcentrado> model = (List<IndicenciasConcentrado>)dp.connection.Query<IndicenciasConcentrado>(u);

            return model;
        }
        public static IEnumerable getConveniosLaborales(int id)
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
                 .Select(g => new { g.IdConvenioLaboralTrabajador, g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral, g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral }).ToList();
        }
        public static string getConvenioLaboral(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
                .Select(g => g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral).SingleOrDefault();

        }

        public static string getCategoria(int id)
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
                .Select(g => g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria).SingleOrDefault();

        }
        public static List<Años> GetAñosAsistencia()
        {
            bdNovaEntities db = new bdNovaEntities();
            List<Años> ListaAños = new List<Años>();
            //var laños = db.Nomina_RelojChecadorAsistencia.GroupBy(x => x.FechaAsistencia.Year).Select(y => new { año = y.Key }).ToList();
            var laños = db.Nomina_stNomina.GroupBy(x => x.FechaInicio.Year).Select(y => new { año = y.Key }).ToList();

            short i = 1;
            foreach (var item in laños)
            {
                Años unaño = new Años();
                unaño.IdAño = System.Convert.ToInt32(item.año);

                unaño.Año = item.año;
                ListaAños.Add(unaño);
            }
            return ListaAños;
        }
        public static List<AreasUsuario> GetAreasAdmin()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select c.IdEstructuraOrganica,max(d.EstructuraOrganica) as EstructuraOrganica from Nomina_RelojChecadorAreas a 
            left join Nomina_RelojChecadorControlUsuarios b
            on a.IdRelojChecadorAreas = b.IdRelojChecadorAreas
            left join Nomina_RelojChecadorAreasEstructuraOrganica c on c.idrelojchecadorareas=a.IdRelojChecadorAreas
            left join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
            group by c.IdEstructuraOrganica";
            List<AreasUsuario> listat = (List<AreasUsuario>)dp.connection.Query<AreasUsuario>(query);
            dp.Close();
            return listat.ToList();

        }

        public static List<AreasUsuario> GetAreasUsuario(int idcltc)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select c.IdEstructuraOrganica,max(d.EstructuraOrganica) as EstructuraOrganica  from Nomina_RelojChecadorAreas a 
            left join Nomina_RelojChecadorControlUsuarios b
            on a.IdRelojChecadorAreas = b.IdRelojChecadorAreas
            left join Nomina_RelojChecadorAreasEstructuraOrganica c on c.idrelojchecadorareas=a.IdRelojChecadorAreas
            left join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
            where b.IdConvenioLaboralTrabajadorCategoria=" + idcltc + " group by c.IdEstructuraOrganica";
            List<AreasUsuario> listat = (List<AreasUsuario>)dp.connection.Query<AreasUsuario>(query);
            dp.Close();
            return listat.ToList();

        }
        public static List<AreasUsuario> GetAreaDirector(int idcltc)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select b.IdEstructuraOrganica,b.EstructuraOrganica from Convenios_stConvenioLaboralTrabajadorCategoria a 
            inner join Catalogos_ctEstructuraOrganica b
            on a.IdEstructuraOrganica= b.IdEstructuraOrganica
            where a.IdConvenioLaboralTrabajadorCategoria=" + idcltc + "";
            List<AreasUsuario> listat = (List<AreasUsuario>)dp.connection.Query<AreasUsuario>(query);
            dp.Close();
            return listat.ToList();

        }

        public static List<Quincena> GetQuincenaMes()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select a.IdQuincenaMes,a.QuincenaMes+'-'+b.Mes as QuincenaMes from Catalogos_ctQuincenaMes a
            inner join Catalogos_ctMes b on a.IdMes = b.IdMes
            order by a.QuincenaMes";
            List<Quincena> listat = (List<Quincena>)dp.connection.Query<Quincena>(query);
            dp.Close();
            return listat.ToList();

        }
        public static List<Incidencia_ctJustificacion> GetLeyendas()
        {
            List<Incidencia_ctJustificacion> leyendas = new List<Incidencia_ctJustificacion>();
            Incidencia_ctJustificacion jus = new Incidencia_ctJustificacion();
            jus.IdIncidenciaJustificacion = 1;
            jus.Color = "#FFFFFF";
            jus.IncidenciaJustificacion = "CERRADA";
            jus.Nomenclatura = "RR";
            leyendas.Add(jus);

            Incidencia_ctJustificacion jus2 = new Incidencia_ctJustificacion();
            jus2.IdIncidenciaJustificacion = 2;
            jus2.Color = "#FFFFFF";
            jus2.IncidenciaJustificacion = "AUTORIZADA";
            jus2.Nomenclatura = "AA";
            leyendas.Add(jus2);

            Incidencia_ctJustificacion jus3 = new Incidencia_ctJustificacion();
            jus3.IdIncidenciaJustificacion = 3;
            jus3.Color = "#FFFFFF";
            jus3.IncidenciaJustificacion = "NO AUTORIZADA";
            jus3.Nomenclatura = "NN";
            leyendas.Add(jus3);

            Incidencia_ctJustificacion jus4 = new Incidencia_ctJustificacion();
            jus4.IdIncidenciaJustificacion = 4;
            jus4.Color = "#FFFFFF";
            jus4.IncidenciaJustificacion = "DEVOLUCIÓN";
            jus4.Nomenclatura = "DE";
            leyendas.Add(jus4);
            return leyendas;

        }

        public static List<IncidenciaTrabajador> GetIncidencias(int aaaa, short idestructura, short idqm)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query;

            query = @"select a.IdIncidenciaTrabajador,a.FechaInicio,a.FechaTermino,a.Horas,d.IdTrabajador,e.Nombre+' '+e.ApellidoPaterno+' '+e.ApellidoMaterno as Trabajador
,CASE WHEN j.RelacionLaboral='DOCENTE' then a.Horas else DATEDIFF(day, b.FechaInicio,a.FechaTermino) end as DiasHorasIncidencia
,CASE WHEN k.Incidencia='DÍAS ECONÓMICOS' then DATEDIFF(day, b.FechaInicio,a.FechaTermino) ELSE 0 end DiasEconomicos
,a.Observaciones,j.RelacionLaboral,a.EsAplicada,a.Autorizo,a.DescripcionJustificacion,a.EsJustificacionExtemporanea
,a.FechaAutorizacion,a.FechaCreacion,a.FechaJustificacion,ka.Nombre+' '+ka.ApellidoPaterno+' '+ka.ApellidoMaterno as QuienAutorizo
,kj.Nombre+' '+kj.ApellidoPaterno+' '+kj.ApellidoMaterno as QuienJustifico
,kr.Nombre+' '+kr.ApellidoPaterno+' '+kr.ApellidoMaterno as QuienRegistro
,dj.Incidencia as IncidenciaJustico,dj.Nomenclatura as NomenclaturaJustifico,dj.Color ColorJustifico
,a.IdNominaTrabajador,k.Incidencia,k.Nomenclatura,k.Color,f.EstructuraOrganica
from IncidenciaPermiso_stIncidenciaTrabajador a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador d on d.IdTrabajador = c.IdTrabajador
inner join Kardex_ctDatosPersonales e on d.IdKardex= e.IdKardex
inner join Catalogos_ctEstructuraOrganica f on b.IdEstructuraOrganica =f.IdEstructuraOrganica
inner join Plazas_stDistribucionPlazaCategoria g on b.IdDistribucionPlazaCategoria=g.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria h on g.IdCategoria=h.IdCategoria
inner join Convenios_stRelacionConvenioLaboral i on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctRelacionLaboral j on i.IdRelacionLaboral=j.IdRelacionLaboral
inner join Catalogos_ctTipoIncidencia k on a.IdTipoIncidencia=k.IdTipoIncidencia
--Autorizo
left join Convenios_stConvenioLaboralTrabajadorCategoria ca on a.IdConvenioLaboralTrabajadorCategoriaAutorizo=ca.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador la on la.IdConvenioLaboralTrabajador= ca.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador ta on ta.IdTrabajador=la.IdTrabajador
left join Kardex_ctDatosPersonales ka on ka.IdKardex = ta.IdKardex
--Justifico
left join Convenios_stConvenioLaboralTrabajadorCategoria cj on a.IdConvenioLaboralTrabajadorCategoriaJustifico=cj.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador lj on lj.IdConvenioLaboralTrabajador= cj.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador tj on tj.IdTrabajador=lj.IdTrabajador
left join Kardex_ctDatosPersonales kj on kj.IdKardex = tj.IdKardex
--Registro
left join Convenios_stConvenioLaboralTrabajadorCategoria cr on a.IdConvenioLaboralTrabajadorCategoriaRegistro=cr.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador lr on lr.IdConvenioLaboralTrabajador= cr.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador tr on tr.IdTrabajador=lr.IdTrabajador
left join Kardex_ctDatosPersonales kr on kr.IdKardex = tr.IdKardex
--Incidencia Justificación
left join Incidencia_ctJustificacion ij on ij.IdIncidenciaJustificacion = a.IdIncidenciaJustificacion
left join Catalogos_ctTipoIncidencia dj on dj.IdTipoIncidencia=ij.IdTipoIncidencia
where b.IdEstructuraOrganica=" + idestructura + " and YEAR(a.FechaInicio)=" + aaaa + " 2018 and k.IdTipoIncidenciaPermiso=3";
            List<IncidenciaTrabajador> listat = (List<IncidenciaTrabajador>)dp.connection.Query<IncidenciaTrabajador>(query);
            dp.Close();
            return listat.ToList();

        }



        public static List<AsistenciasTrabajador> getAsistencias(string fi = null, string ff = null, string areas = null, string id = null)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            List<AsistenciasTrabajador> AsistenciasTrabajador = new List<AsistenciasTrabajador>();
            string condicion = "";
            if (fi != null)
                condicion = "  CAST(a.FechaAsistencia  as date) >= CAST('" + fi + "'  as date) and CAST(a.FechaAsistencia  as date) <= CAST('" + ff + "'  as date)";

            if (areas != null)
                if (areas != "")
                    if (condicion != "")
                        condicion = condicion + "  and z.UbicacionFisica in (" + areas + ") ";
                    else
                        condicion = condicion + "  z.UbicacionFisica in (" + areas + ") ";


            if (id != null)
                if (id != "")
                    if (condicion != "")
                        condicion = condicion + "  and a.IdTrabajador =" + id;
                    else
                        condicion = condicion + "  a.IdTrabajador =" + id;

            string query = @"select 
a.IdTrabajador,z.Nombre,z.ApellidoPaterno,z.ApellidoMaterno
,z.Categoria,  z.UbicacionFisica,z.RelacionLaboral,z.ConvenioLaboral,z.EstatusTrabajador
,a.FechaAsistencia,e.FechaInicio,e.FechaTermino,Autorizo,
w.Nombre as NombreJustifico,w.ApellidoPaterno as ApellidoPaternoJustifico,w.ApellidoMaterno as ApellidoMaternoJustifico
,x.Nombre as NombreAutorizo,x.ApellidoPaterno as ApellidoPaternoAutorizo,x.ApellidoMaterno as ApellidoMaternoAutorizo
,e.IdIncidenciaTrabajador,q.IncidenciaJustificacion,q.Nomenclatura,q.Color
,e.FechaJustificacion,e.FechaAutorizacion
,s.Incidencia,s.Nomenclatura as NomenclaturaIncidencia,s.Color ColorIncidencia
,h.Mes NombreMes,Month(a.FechaAsistencia) as Mes,YEAR(a.FechaAsistencia) as anio
from Nomina_RelojChecadorAsistencia a
inner join vwDatosAspirantesTrabajadores z on a.IdTrabajador=z.IdTrabajador
left join IncidenciaPermiso_stIncidenciaTrabajador e 
on e.IdConvenioLaboralTrabajadorCategoria=z.IdConvenioLaboralTrabajadorCategoria
and a.FechaAsistencia=e.FechaInicio and a.FechaAsistencia=e.FechaTermino
left join vwDatosAspirantesTrabajadores w on w.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoriaJustifico
left join vwDatosAspirantesTrabajadores x on x.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoriaAutorizo
left join Incidencia_ctJustificacion q on q.IdIncidenciaJustificacion=e.IdIncidenciaJustificacion
left join Catalogos_ctTipoIncidencia s on s.IdTipoIncidencia=e.IdTipoIncidencia
left join Catalogos_ctMes h on h.IdMes=Month( a.FechaAsistencia)
where " + condicion + " order by z.UbicacionFisica,a.IdTrabajador, a.FechaAsistencia desc";
            AsistenciasTrabajador = (List<AsistenciasTrabajador>)dp.connection.Query<AsistenciasTrabajador>(query);

            dp.Close();
            //bdNovaEntities db = new bdNovaEntities();
            return AsistenciasTrabajador;
            //return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
            //    .Select(g => g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria).SingleOrDefault();

        }
        public static List<AsistenciasTrabajador> getAsistencias(int id, string fi = null, string ff = null)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            List<AsistenciasTrabajador> AsistenciasTrabajador = new List<AsistenciasTrabajador>();
            string condicion = "";
            if (fi != null)
                condicion = " and CAST(a.FechaAsistencia  as date) >= CAST('" + fi + "'  as date) and CAST(a.FechaAsistencia  as date) <= CAST('" + ff + "'  as date)";

            string query = @"select 
a.IdTrabajador,z.Nombre,z.ApellidoPaterno,z.ApellidoMaterno
,z.Categoria,  z.UbicacionFisica,z.RelacionLaboral,z.ConvenioLaboral,z.EstatusTrabajador
,a.FechaAsistencia,e.FechaInicio,e.FechaTermino,Autorizo,
w.Nombre as NombreJustifico,w.ApellidoPaterno as ApellidoPaternoJustifico,w.ApellidoMaterno as ApellidoMaternoJustifico
,x.Nombre as NombreAutorizo,x.ApellidoPaterno as ApellidoPaternoAutorizo,x.ApellidoMaterno as ApellidoMaternoAutorizo
,e.IdIncidenciaTrabajador,q.IncidenciaJustificacion,q.Nomenclatura,q.Color
,e.FechaJustificacion,e.FechaAutorizacion
,s.Incidencia,s.Nomenclatura as NomenclaturaIncidencia,s.Color ColorIncidencia
,h.Mes NombreMes,Month(a.FechaAsistencia) as Mes,YEAR(a.FechaAsistencia) as anio
,case when e.Horas is null then 0 else e.Horas end Horas
from Nomina_RelojChecadorAsistencia a
inner join vwDatosAspirantesTrabajadores z on a.IdTrabajador=z.IdTrabajador
left join IncidenciaPermiso_stIncidenciaTrabajador e 
on e.IdConvenioLaboralTrabajadorCategoria=z.IdConvenioLaboralTrabajadorCategoria
and a.FechaAsistencia=e.FechaInicio and a.FechaAsistencia=e.FechaTermino
left join vwDatosAspirantesTrabajadores w on w.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoriaJustifico
left join vwDatosAspirantesTrabajadores x on x.IdConvenioLaboralTrabajadorCategoria=e.IdConvenioLaboralTrabajadorCategoriaAutorizo
left join Incidencia_ctJustificacion q on q.IdIncidenciaJustificacion=e.IdIncidenciaJustificacion
left join Catalogos_ctTipoIncidencia s on s.IdTipoIncidencia=e.IdTipoIncidencia
left join Catalogos_ctMes h on h.IdMes=Month( a.FechaAsistencia)
where a.IdTrabajador=" + id.ToString() + condicion + " order by a.FechaAsistencia desc";
            AsistenciasTrabajador = (List<AsistenciasTrabajador>)dp.connection.Query<AsistenciasTrabajador>(query);

            dp.Close();
            //bdNovaEntities db = new bdNovaEntities();
            return AsistenciasTrabajador;
            //return db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(d => d.IdConvenioLaboralTrabajador == id)
            //    .Select(g => g.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria).SingleOrDefault();

        }

    }

}