﻿using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using Nova.Validation;


namespace Nova.Models
{
    
    [MetadataType(typeof(Deducciones_ctSubDeduccionMetaData))]
    public partial class Deducciones_ctSubDeduccion
    {



    }


    public class Deducciones_ctSubDeduccionMetaData
    {
        // [RequiredIf("Nombre","", ErrorMessage = "Debes de especificar el Nombre")]


        [Required]
        public object Concepto { get; set; }


        [Required]
        public object Dias { get; set; }

        [Required]
        public object IdTipoSubDeduccion { get; set; }

        [RegularExpression(@"^[0-9]{1,2}([\.\,][0-9]{1,5})?$", ErrorMessage = "El formato debe de ser : 99.99999")]
        public object Porcentaje { get; set; }

        [RegularExpression(@"^[0-9]{1,6}([\.\,][0-9]{1,2})?$", ErrorMessage = "El formato debe de ser : 99.99999")]
        public object CuotaFija { get; set; }

        [RegularExpression(@"^[0-9]{1,6}([\.\,][0-9]{1,2})?$", ErrorMessage = "El formato debe de ser : 99.99999")]
        public object VecesSalarioMinimo { get; set; }


    }
}