﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNet.SignalR;
using Microsoft.AspNet.SignalR.Hubs;

namespace Nova.Models.DashBoards
{
   

  
public static class SignalRHubContainer
    {
        private static Lazy<IHubContext> hub = new Lazy<IHubContext>(
            () => GlobalHost.ConnectionManager.GetHubContext<DashboardContratosHub>()
        );

        public static IHubContext Hub => hub.Value;
    }
    public class DashboardContratosHub:Hub
    {

        public async Task SendChartData(int estatusContratos, int sexoM, int sexoF, int relacionLaboral, int tipoSuplencia)
        {
            await Clients.All.SendAsync("ReceiveChartData", estatusContratos, sexoM, sexoF, relacionLaboral, tipoSuplencia);
        }

        public async Task SendChartDataGender(int estatusContratos, int sexoM, int sexoF)
        {
            await Clients.All.SendAsync("ReceiveChartDataGener", estatusContratos, sexoM, sexoF);
        }

        public async Task SendChartDataStatus(List<DatosGraficas> data)
        {
            
            await Clients.All.SendAsync("ReceiveChartDataStatus", data);
        }
        public async Task SendChartDatosPorAreaConocimientoCategoria(List<DatosGraficas> data) 
        {
            await Clients.All.SendAsync("ReceiveDatosPorAreaConocimientoCategoria", data);
        }

        public async Task SendValuesDatosAvance(DatosAvance data)
        {
            await Clients.All.SendAsync("ReceiveDatosAvance", data);
        }
    }
}
