﻿using Dapper;
using Nova.Libraries;
using Seguridad;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;


namespace Nova.Models
{

    public class TrabajadoresCorreos
    {


        public string Nombre { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string CorreoElectronico { get; set; }
        public string Categoria { get; set; }
        public string LaboraFisicamente { get; set; }
        public string Cursos { get; set; }


    }

    public class CarrerasTrabajador
    {


        public short IdCarrera { get; set; }


    }

    public partial class AlertasCapacitacion : Alertas
    {
        public override void GeneraAlertas()
        {
            bdNovaEntities db = new bdNovaEntities();
            DateTime hoy = DateTime.Now.Date;
            //List<Capacitacion_stConvocatoriasCursos> convocatorias = db.Capacitacion_stConvocatoriasCursos.Where(v => hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();
            List<Capacitacion_stConvocatoriasCursos> convocatorias = Capacitacion_stConvocatoriasCursosSedesAulas.getConvocagoriasDisponibles(Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador, Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.IdCategoria, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.IdRelacionLaboral, Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.IdConvenioLaboral, Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganicaPadre);

            if (convocatorias.Count > 0)
            {

                string elementos = "";
                foreach (var item in convocatorias)
                {
                    UrlHelper u = new UrlHelper(HttpContext.Current.Request.RequestContext);
                    string ruta = u.Action("Inscripcion", "CapacitacionAulas");

                    Int64 idusuario = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
                    Capacitacion_stParticipantes inscrito = db.Capacitacion_stParticipantes.Where(t => t.Capacitacion_stConvocatoriasCursosSedesAulas.IdConvocatoriaCursos == item.IdConvocatoriaCursos && t.IdKardex == idusuario).FirstOrDefault();
                    if (inscrito == null)
                    {

                        int l = item.Capacitacion_ctCurso.Curso.Length;
                        string mas = "";

                        if (l > 100)
                        {
                            l = item.Capacitacion_ctCurso.Curso.Length - 60;
                            mas = "...";
                        }
                        string curso = item.Capacitacion_ctCurso.Curso.Substring(0, l) + mas;


                        elementos = elementos += @"<li>
                                        <a href='" + ruta + @"' style='font-size:x-small;'>
										<span class='photo'>
										<i class='fa fa-plus'></i>
										</span>
										<span class='subject'>
										<span class='from'>
										" + curso + @"</span>
										<span class='time'>Inscríbete</span>
										</span>
										<span class='message'>
										" + item.FechaInicioCurso.ToShortDateString() + @"-" + item.FechaTerminoCurso.ToShortDateString() + @"</span>
										</a>
									</li>";
                    }
                    else
                    {
                        int l = item.Capacitacion_ctCurso.Curso.Length;
                        string mas ="";

                        if (l > 100)
                        {
                            l = item.Capacitacion_ctCurso.Curso.Length - 60;
                            mas = "...";
                        }
                        string curso = item.Capacitacion_ctCurso.Curso.Substring(0,l) + mas;


                        elementos = elementos += @"<li>
                                        <a href='" + ruta + @"' style='font-size:x-small;'>
										<span class='photo'>
										<i class='fa fa-heart'></i>
										</span>
										<span class='subject'>
										<span class='from'>
										" + curso + @"</span>
										<span class='label label-sm label-success' style='float:right;'>Inscrito</span>
										</span>
										<span class='message'>
										" + item.FechaInicioCurso.ToShortDateString() + @"-" + item.FechaTerminoCurso.ToShortDateString() + @"</span>
										</a>
									</li>";
                    }

                }

                alerta l1 = new alerta();
                l1.controlador = "Convocatoria";
                l1.accion = "Index";
                l1.icono = "fa fa-bell-o";
                l1.mensaje = "Convocatorias";
                l1.numero = "Cursos Disponibles " + convocatorias.Count.ToString();
                l1.idLi = "convid_1";



                l1.ulsubmenu = @"<ul class='dropdown-menu' style='z-index:9999;position: absolute;width: 400px;max-height:550px;overflow-y:auto;
                                    overflow-x:hidden;margin: 0px;padding-left:5px;'>
							<li class='external'>
								<h3><span class='bold'> " + convocatorias.Count + @"</span> Nuevo(s) Curso(s) </h3>
							</li>
							<li>
								<ul class='dropdown-menu-list' >
									" + elementos + @"
								</ul>
							</li>
						</ul>";

                this.ListaAlertas.Add(l1);


            }

        }
    }

    public partial class AlertasMisCursos : Alertas
    {
        public override void GeneraAlertas()
        {
            bdNovaEntities db = new bdNovaEntities();
            DateTime hoy = DateTime.Now.Date;

            int idkardex = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            var tomados = db.Capacitacion_stParticipantes.Where(h => h.IdKardex == idkardex).Select(g => g.IdConvocatoriaCursosSedesAulas).ToList();
            List<Capacitacion_stConvocatoriasCursosSedesAulas> cursos = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => tomados.Contains(r.IdConvocatoriaCursosSedesAulas)).OrderByDescending(o=>o.Capacitacion_stConvocatoriasCursos.FechaInicioCurso).ToList();

            if (cursos.Count > 0)
            {

                string elementos = "";
                foreach (var item in cursos)
                {
                    UrlHelper u = new UrlHelper(HttpContext.Current.Request.RequestContext);
                    string ruta = u.Action("MisCursos", "CapacitacionAulas");

                    Int64 idusuario = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
                    Capacitacion_stParticipantes inscrito = db.Capacitacion_stParticipantes.Where(t => t.Capacitacion_stConvocatoriasCursosSedesAulas.IdConvocatoriaCursos == item.IdConvocatoriaCursos && t.IdKardex == idusuario).FirstOrDefault();
                    if (inscrito == null)
                    {
                        elementos = elementos += @"<li>
                                        <a href='" + ruta + @"'>
										<span class='photo'>
										<i class='fa fa-plus'></i>
										</span>
										<span class='subject'>
										<span class='from'>
										" + item.Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso + @"</span>
										
										</span>
										<span class='message'>
										" + item.Capacitacion_stConvocatoriasCursos.FechaInicioCurso.ToShortDateString() + @"-" + item.Capacitacion_stConvocatoriasCursos.FechaTerminoCurso.ToShortDateString() + @"</span>
										</a>
									</li>";
                    }
                    else
                    {
                        elementos = elementos += @"<li>
                                        <a href='" + ruta + @"'>
										<span class='photo'>
										<i class='fa fa-heart'></i>
										</span>
										<span class='subject'>
										<span class='from'>
										" + item.Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso + @"</span>
										<span class='label label-sm label-success' style='float:right;'>Inscrito</span>
										</span>
										<span class='message'>
										" + item.Capacitacion_stConvocatoriasCursos.FechaInicioCurso.ToShortDateString() + @"-" + item.Capacitacion_stConvocatoriasCursos.FechaTerminoCurso.ToShortDateString() + @"</span>
										</a>
									</li>";
                    }

                }

                alerta l0 = new alerta();
                l0.controlador = "";
                l0.accion = "";
                l0.icono = "fa fa-ellipsis-v";
                l0.mensaje = "";
                l0.numero = "";
                l0.idLi = "convid_1998";
                l0.cssBadge = "";



                l0.ulsubmenu = "";

                this.ListaAlertas.Add(l0);

                alerta l1 = new alerta();
                l1.controlador = "CapacitacionAulas";
                l1.accion = "MisCursos";
                l1.icono = "fa fa-graduation-cap";
                l1.mensaje = "Convocatorias";
                l1.numero = "Mis Cursos " + cursos.Count.ToString();
                l1.idLi = "convid_781";
                l1.cssBadge = "badge badge-info";



                l1.ulsubmenu = @"<ul class='dropdown-menu'>
							<li class='external'>
								<h3><span class='bold'> " + cursos.Count + @"</span> Mi(s) Curso(s) </h3>
								
							</li>
							<li>
								<ul class='dropdown-menu-list' >
                                    
									" + elementos + @"
								</ul>
							</li>
						</ul>";

                this.ListaAlertas.Add(l1);


            }

        }
    }

    public sealed class CursosActivos
    {

        private static volatile CursosActivos instance;
        private static object syncRoot = new Object();

        private static bdNovaEntities db = new bdNovaEntities();
        private static bdAriesEntities dbAries = new bdAriesEntities();

        public List<Capacitacion_PersonalExcluidoConvocactoriaCursos> Capacitacion_PersonalPermitidoCursos;

        public List<Capacitacion_PersonalPermitidoAreaConocimiento> Capacitacion_PersonalPermitidoAreaConocimiento;

        public List<Capacitacion_PersonalPermitidoCategoria> Capacitacion_PersonalPermitidoCategoria;

        public List<Capacitacion_PersonalPermitidoEstructuraOrganica> Capacitacion_PersonalPermitidoEstructuraOrganica;

        public List<Capacitacion_PersonalPermitidoRelacionLaboral> Capacitacion_PersonalPermitidoRelacionLaboral;

        public List<Capacitacion_PersonalPermitidoConvenioLaboral> Capacitacion_PersonalPermitidoConvenioLaboral;

        public List<Capacitacion_PersonalPermitidoCarrera> Capacitacion_PersonalPermitidoCarrera;

        public List<Capacitacion_PersonalPermitidoAsesoria> Capacitacion_PersonalPermitidoAsesoria;
        public List<Capacitacion_PersonalPermitidoComplementaria> Capacitacion_PersonalPermitidoComplementaria;

        public List<Capacitacion_stConvocatoriasCursos> Capacitacion_stConvocatoriasCursos;

        public List<stHorario> stHorario;

        public List<stHorarioAsignaturaComplemento> stHorarioAsignaturaComplemento;

        public List<stHorarioComplemento> stHorarioComplemento;

        public List<stPlanEstudioAsignatura> stPlanEstudioAsignatura;


        

        public List<ctCarrera> ctCarrera;
        public List<ctPlanEstudio> CtPlanEstudio;

        public List<ctAsignatura> ctAsignatura;

        public List<Capacitacion_PersonalPermitidoAsignatura> Capacitacion_PersonalPermitidoAsignatura;

        public List<Capacitacion_PersonalPermitidoAsignaturaComplementaria> Capacitacion_PersonalPermitidoAsignaturaComplementaria;

        public List<Capacitacion_PersonalPermitidoRelacionConvenioLaboral> Capacitacion_PersonalPermitidoRelacionConvenioLaboral;


        private CursosActivos(bool SoloPrevios=true)
        {

            Libraries.DapperQuery dp = new Libraries.DapperQuery("bdNovaEntities");
            string query;
            query = @"use bdCtlEscSeg 
                        select bdCtlEscSeg.dbo.fnObtenCicloEscolarVigente(1) ";
            int _CicloEscolarVigente = dp.connection.ExecuteScalar<int>(query);
            dp.Close();
            query = @"use bdCtlEscSeg 
                        select bdCtlEscSeg.dbo.fnObtenCicloEscolarAnterior(1) ";
            int _CicloEscolarAnterior = dp.connection.ExecuteScalar<int>(query);
            dp.Close();

            DateTime hoy = DateTime.Now.Date;

            Capacitacion_PersonalPermitidoCursos = db.Capacitacion_PersonalExcluidoConvocactoriaCursos.ToList();
          
            Capacitacion_PersonalPermitidoAreaConocimiento = db.Capacitacion_PersonalPermitidoAreaConocimiento.Where(f => 
                  hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();


            Capacitacion_PersonalPermitidoCarrera = db.Capacitacion_PersonalPermitidoCarrera.Where(f => 
               hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoAsesoria = db.Capacitacion_PersonalPermitidoAsesoria.Where(f => 
             hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoComplementaria = db.Capacitacion_PersonalPermitidoComplementaria.Where(f =>  
             hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoCategoria = db.Capacitacion_PersonalPermitidoCategoria.Where(f =>  
                 hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoEstructuraOrganica = db.Capacitacion_PersonalPermitidoEstructuraOrganica.Where(f =>  
                     hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoRelacionLaboral = db.Capacitacion_PersonalPermitidoRelacionLaboral.Where(f =>  
                     hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoConvenioLaboral = db.Capacitacion_PersonalPermitidoConvenioLaboral.Where(f =>  
                    hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();


            Capacitacion_stConvocatoriasCursos = db.Capacitacion_stConvocatoriasCursos.Where(v => 
                hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

         
            stHorario = dbAries.stHorario.Where(r => r.Autorizado == true && (r.IdCicloEscolar == _CicloEscolarVigente || r.IdCicloEscolar == _CicloEscolarAnterior)).ToList();

            stHorarioAsignaturaComplemento = dbAries.stHorarioAsignaturaComplemento.Where(r => r.Autorizado == true && (r.IdCicloEscolar == _CicloEscolarVigente || r.IdCicloEscolar == _CicloEscolarAnterior)).ToList();

            stHorarioComplemento = dbAries.stHorarioComplemento.Where(r => r.Autorizado == true && (r.IdCicloEscolar == _CicloEscolarVigente || r.IdCicloEscolar == _CicloEscolarAnterior)).ToList();

            stPlanEstudioAsignatura = dbAries.stPlanEstudioAsignatura.ToList();

            ctCarrera = dbAries.ctCarrera.ToList();

            CtPlanEstudio = dbAries.ctPlanEstudio.ToList();

            ctAsignatura = dbAries.ctAsignatura.ToList();
        }

        private CursosActivos()
        {

            DateTime hoy = DateTime.Now.Date;

            Libraries.DapperQuery dp = new Libraries.DapperQuery("bdNovaEntities");
            string query;
            query = @"use bdCtlEscSeg 
                        select bdCtlEscSeg.dbo.fnObtenCicloEscolarVigente(1) ";
            int _CicloEscolarVigente = dp.connection.ExecuteScalar<int>(query);
            dp.Close();
            query = @"use bdCtlEscSeg 
                        select bdCtlEscSeg.dbo.fnObtenCicloEscolarAnterior(1) ";
            int _CicloEscolarAnterior = dp.connection.ExecuteScalar<int>(query);
            dp.Close();

            Capacitacion_PersonalPermitidoCursos = db.Capacitacion_PersonalExcluidoConvocactoriaCursos.ToList();

            Capacitacion_PersonalPermitidoAreaConocimiento = db.Capacitacion_PersonalPermitidoAreaConocimiento.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
                  && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();


            Capacitacion_PersonalPermitidoCarrera = db.Capacitacion_PersonalPermitidoCarrera.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
              && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoAsesoria = db.Capacitacion_PersonalPermitidoAsesoria.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
             && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoComplementaria = db.Capacitacion_PersonalPermitidoComplementaria.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
            && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoCategoria = db.Capacitacion_PersonalPermitidoCategoria.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
                 && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoEstructuraOrganica = db.Capacitacion_PersonalPermitidoEstructuraOrganica.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
                     && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoRelacionLaboral = db.Capacitacion_PersonalPermitidoRelacionLaboral.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
                     && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoConvenioLaboral = db.Capacitacion_PersonalPermitidoConvenioLaboral.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
                   && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();


            Capacitacion_stConvocatoriasCursos = db.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true
                && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoAsignatura = db.Capacitacion_PersonalPermitidoAsignatura.Where(v => v.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
              && hoy >= v.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

            Capacitacion_PersonalPermitidoAsignaturaComplementaria = db.Capacitacion_PersonalPermitidoAsignaturaComplementaria.Where(v => v.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
              && hoy >= v.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();


            Capacitacion_PersonalPermitidoRelacionConvenioLaboral = db.Capacitacion_PersonalPermitidoRelacionConvenioLaboral.Where(v => v.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
              && hoy >= v.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria).ToList();

         
             

            stHorario = dbAries.stHorario.Where(r => r.Autorizado == true && (r.IdCicloEscolar == _CicloEscolarVigente || r.IdCicloEscolar == _CicloEscolarAnterior  )).ToList();

            stHorarioAsignaturaComplemento = dbAries.stHorarioAsignaturaComplemento.Where(r => r.Autorizado == true && (r.IdCicloEscolar == _CicloEscolarVigente || r.IdCicloEscolar == _CicloEscolarAnterior)).ToList();

            stHorarioComplemento = dbAries.stHorarioComplemento.Where(r => r.Autorizado == true && (r.IdCicloEscolar == _CicloEscolarVigente || r.IdCicloEscolar == _CicloEscolarAnterior)).ToList();

            stPlanEstudioAsignatura = dbAries.stPlanEstudioAsignatura.ToList();

            ctCarrera = dbAries.ctCarrera.ToList();

            CtPlanEstudio = dbAries.ctPlanEstudio.ToList();

           
        }

        public static CursosActivos Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new CursosActivos();
                    }
                }

                return instance;
            }
        }



        public static CursosActivos previos
        {
            get
            {


                instance = new CursosActivos(false);

                return instance;
            }
        }

        public static CursosActivos Clean
        {
            get
            {


                instance = new CursosActivos();

                return instance;
            }
        }

    }

    public partial class Capacitacion_stConvocatoriasCursosSedesAulas : ValidacionModelos
    {
        public override ResultadoValidacion ValidaModelo()
        {

            if (Capacitacion_ctCoordinadores != null)
                if (Capacitacion_ctCoordinadores.FechaVencimientoCoordinador < DateTime.Now.Date)
                {
                    parenresult.IsValid = false;
                    parenresult.Mensaje = "Debe de asignar a un coordinador que este activo, o active al coordinador desde el menú correspondiente";
                }




            bdNovaEntities db = new bdNovaEntities();
            DateTime fi = Capacitacion_stConvocatoriasCursos.FechaInicioCurso;
            DateTime ft = Capacitacion_stConvocatoriasCursos.FechaTerminoCurso;

            Capacitacion_stConvocatoriasCursosSedesAulas horas = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(r => r.IdInstructor == IdInstructor && ((r.Capacitacion_stConvocatoriasCursos.FechaInicioCurso >= fi) || (fi <= r.Capacitacion_stConvocatoriasCursos.FechaTerminoCurso) || (ft >= r.Capacitacion_stConvocatoriasCursos.FechaInicioCurso && fi < r.Capacitacion_stConvocatoriasCursos.FechaInicioCurso))).FirstOrDefault();

            if (horas != null)
            {
                parenresult.IsValid = false;
                parenresult.Mensaje = "Hay un cruce de horarios para este instructor en la convocatoria  " + horas.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.Convocatoria + " para el curso " + horas.Capacitacion_stConvocatoriasCursos.Capacitacion_ctCurso.Curso + " del " + horas.Capacitacion_stConvocatoriasCursos.FechaInicioCurso.ToShortDateString() + " al " + horas.Capacitacion_stConvocatoriasCursos.FechaTerminoCurso.ToShortDateString();

            }

            //var aulasrepetidas = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(t => t.Capacitacion_stConvocatoriasCursos.IdConvocatoria == Capacitacion_stConvocatoriasCursos.IdConvocatoria &&
            //    (t.IdAulaSede == IdAulaSede)).ToList();

            //if (aulasrepetidas.Count > 0)
            //{
            //    parenresult.IsValid = false;
            //    parenresult.Mensaje = "Ya se asigno el aula a otro curso en la misma convocatoria";
            //}

            var gruposrepetidos = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(t =>
                t.IdConvocatoriaCursos == IdConvocatoriaCursos && t.Grupo == Grupo).ToList();

            if (gruposrepetidos.Count > 0)
            {
                parenresult.IsValid = false;
                parenresult.Mensaje = "Ya se asigno el grupo a otro curso del mismo tipo, en la misma convocatoria";
            }

            if (NumeroParticipantes <= 0)
            {
                parenresult.IsValid = false;
                parenresult.Mensaje = "El número de participantes debe de ser mayor que 0";
            }

            if (System.Convert.ToInt16(HorarioInicio.Substring(0, 2)) >= System.Convert.ToInt16(HorarioTermino.Substring(0, 2)))
            {
                parenresult.IsValid = false;
                parenresult.Mensaje = "La hora de término debe de ser mayor a la de inicio";
            }
            //var aula = db.ca.Where(t => t.IdAulaSede == IdAulaSede );

            //var sede = aula.Select(y => y.Capacitacion_stAulaSede.IdSede).ToList();



            if (IdAulaSede <= 0)
            {
                parenresult.IsValid = false;
                parenresult.Mensaje = "El número de participantes debe de ser mayor que 0";
            }

            return parenresult;

        }

        public static List<Capacitacion_stConvocatoriasCursosSedesAulas> getConvocagoriasDisponiblesPrevia(int idconvocatoria)
        {
            bdNovaEntities db = new bdNovaEntities();
            DateTime hoy = DateTime.Now.Date;

            var t = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(g => g.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.IdConvocatoria == idconvocatoria).ToList();
            return t;

        }
        public static List<Capacitacion_stConvocatoriasCursosSedesAulas> getConvocagoriasDisponibles()
        {
            bdNovaEntities db = new bdNovaEntities();
            DateTime hoy=DateTime.Now.Date;

            //var t=  db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(g => g.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria <= hoy &&
            //      g.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria >= hoy && g.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb==true).ToList();
            var t = db.Capacitacion_stConvocatoriasCursosSedesAulas.Where(g => g.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true).ToList();
            return t;

        }

        public static List<Capacitacion_stConvocatoriasCursos> getConvocagoriasDisponibles(int Idtrabajador, short IdEstructuraOrganica, short IdCategoria, short IdRelacionLaboral, short IdConvenioLaboral, short IdEstructuraOrganicaPadre,bool previa=false)
        {
            bdNovaEntities db = new bdNovaEntities();
            bdAriesEntities dbAries = new bdAriesEntities();
            DateTime hoy = DateTime.Now.Date;
            
            
            
            vwDatosAspirantesTrabajadores IdtrabajadorWM = db.vwDatosAspirantesTrabajadores.FirstOrDefault(t => t.IdTrabajador == Idtrabajador && 
            (t.RestringirMenu==null || t.Incidencia.Contains("INCAPACIDAD")));

            Libraries.DapperQuery dp = new Libraries.DapperQuery("bdNovaEntities");
            string query;
            query = string.Format( @"select IdPersonal from bdPersonal.dbo.ctPersonal where IdPersonalStatus=1 and IdNova ={0}", IdtrabajadorWM.IdKardex); 
            int? IdPersonal = dp.connection.ExecuteScalar<int?>(query);
            dp.Close();
            
            if (IdPersonal == null)
                IdPersonal = 0;

            var _convocatoriaVigente = db.Capacitacion_stConvocatoria.Where(x => x.PublicarEnWeb == true).FirstOrDefault();
            bool cumpleRelacion = false;
            if (_convocatoriaVigente != null)
            {
                string nombreConvocatoria = _convocatoriaVigente.Convocatoria?.ToUpper() ?? "";


                if (nombreConvocatoria.Contains("ADMINISTRATIVA"))
                {
                    // Validación para personal administrativo
                    cumpleRelacion = IdtrabajadorWM.RelacionConvenioLaboral == "ADMINISTRATIVO DEFINITIVO-BASE"
                                  || IdtrabajadorWM.RelacionConvenioLaboral == "ADMINISTRATIVO-BASE";
                }
                else if (nombreConvocatoria.Contains("DOCENTE"))
                {
                    // Validación para personal docente
                    cumpleRelacion = IdtrabajadorWM.RelacionConvenioLaboral == "DOCENTE-BASE"
                                  || IdtrabajadorWM.RelacionConvenioLaboral == "DOCENTE-DEFINITIVO SPD";
                } 
            }
            //if (IdtrabajadorWM.RelacionConvenioLaboral == "DOCENTE-BASE" || IdtrabajadorWM.RelacionConvenioLaboral == "DOCENTE-DEFINITIVO SPD")
            //if (IdtrabajadorWM.RelacionConvenioLaboral == "ADMINISTRATIVO DEFINITIVO-BASE" || IdtrabajadorWM.RelacionConvenioLaboral == "ADMINISTRATIVO-BASE")
            if(cumpleRelacion)
                {


                // Idtrabajador = 1170;


                CursosActivos cursosabiertos = CursosActivos.Instance;

                var trabajadoresPermitidosCursos = cursosabiertos.Capacitacion_PersonalPermitidoCursos.Where(t=>t.IdConvenioLaboralTrabajadorCategoria==IdtrabajadorWM.IdTrabajador).Select(y=>y.IdConvocatoriaCursos).ToList();

                //var ultimocicloescolar= dbAries.stCicloEscolar.OrderByDescending(f=> new {f.Inicio,f.IdModalidadEstudio}).Select(g=> g.IdCicloEscolar).Take(2).ToList();
                var areasconocimientotrabajador = cursosabiertos.stHorario.Where(r => r.IdEmpleado == IdPersonal).Select(b => b.stPlanEstudioAsignatura.ctAsignatura.IdAreaConocimiento).ToList();

                var asignaturastrabajador = cursosabiertos.stHorario.Where(r => r.IdEmpleado == IdPersonal).Select(b => b.IdPlanEstudioAsignatura).ToList();

                var ctasignaturastrabajador = cursosabiertos.stHorario.Where(r => r.IdEmpleado == IdPersonal).Select(b => b.stPlanEstudioAsignatura.IdAsignatura).ToList();

                var ctasignaturascomplementariatrabajador = cursosabiertos.stHorarioAsignaturaComplemento.Where(r => r.IdEmpleado == IdPersonal).Select(b => b.IdAsignaturaComplementaria).ToList();

                var tienecomplementarias = cursosabiertos.stHorarioAsignaturaComplemento.Where(h => h.IdEmpleado == IdPersonal).ToList();

                var tieneasesorias = cursosabiertos.stHorarioComplemento.Where(h => h.IdEmpleado == IdPersonal).ToList();


                var carreras = from a in cursosabiertos.stPlanEstudioAsignatura
                               where a.ctAsignatura.IdTipoComponente == 3
                               join ba in cursosabiertos.CtPlanEstudio
                              on a.IdPlanEstudio equals ba.IdPlanEstudio
                              into uno
                               from t in uno
                               join hu in cursosabiertos.ctCarrera
                              on t.IdCarrera equals hu.IdCarrera

                               where asignaturastrabajador.Contains(a.IdPlanEstudioAsignatura)


                               select new CarrerasTrabajador { IdCarrera = hu.IdCarrera };



                // List<CarrerasTrabajador> carr = carreras.ToList();

                //foreach (var item in carreras)
                //{
                //    CarrerasTrabajador r= new CarrerasTrabajador();
                //    r.IdCarrera =(short) item.IdCarrera;
                //    stcarreras.Add(r);
                //}





                //  Convenios_stConvenioLaboralTrabajadorCategoria usuarioactual = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(j => j.Convenios_stConvenioLaboralTrabajador.IdTrabajador == Idtrabajador).OrderByDescending(e=> e.FechaInicio).FirstOrDefault();

                //int IdEstructuraOrganica  = Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;

                //int IdEstructuraOrganica = usuarioactual.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;

                ////int IdCategoria= Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.IdCategoria;
                //int IdCategoria = usuarioactual.Plazas_stDistribucionPlazaCategoria.IdCategoria;

                //int IdRelacionLaboral = usuarioactual.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.IdRelacionLaboral;



                //var CursosPersonalPermitidoAreaConocimiento = db.Capacitacion_PersonalPermitidoAreaConocimiento.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
                //     && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria);

                //var CursosPersonalPermitidoCategoria = db.Capacitacion_PersonalPermitidoCategoria.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
                //     && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria);

                //var CursosPersonalPermitidoEstructuraOrganica = db.Capacitacion_PersonalPermitidoEstructuraOrganica.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
                //         && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria);

                //var CursosPersonalPermitidoRelacionlaboral = db.Capacitacion_PesonalPermitidoRelacionLaboral.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true
                //         && hoy >= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.FechaTerminoConvocatoria);


                var PersonalPermitidoAreaConocimiento = cursosabiertos.Capacitacion_PersonalPermitidoAreaConocimiento.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true && areasconocimientotrabajador.Contains(f.IdAreaConocimiento)).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoCarreras = cursosabiertos.Capacitacion_PersonalPermitidoCarrera.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true && carreras.Select(r => r.IdCarrera).Contains(f.IdCarrera)).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoCategoria = cursosabiertos.Capacitacion_PersonalPermitidoCategoria.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true && f.IdCategoria == IdCategoria).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoEstructuraOrganica = cursosabiertos.Capacitacion_PersonalPermitidoEstructuraOrganica.Where(f =>
                    f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true &&
                    (f.IdEstructuraOrganica == IdEstructuraOrganica)).Select(r => r.IdConvocatoriaCursos);
                //(f.IdEstructuraOrganica == IdEstructuraOrganica || f.IdEstructuraOrganica == IdEstructuraOrganicaPadre)).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoRelacionlaboral = cursosabiertos.Capacitacion_PersonalPermitidoRelacionLaboral.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true && f.IdRelacionLaboral == IdRelacionLaboral).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoConveniolaboral = cursosabiertos.Capacitacion_PersonalPermitidoConvenioLaboral.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true && f.IdConvenioLaboral == IdConvenioLaboral).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoComplementarias = cursosabiertos.Capacitacion_PersonalPermitidoComplementaria.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoAsesorias = cursosabiertos.Capacitacion_PersonalPermitidoAsesoria.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoAsignaturas = cursosabiertos.Capacitacion_PersonalPermitidoAsignatura.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true && ctasignaturastrabajador.Contains(f.IdAsignatura)).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoAsignaturasComplementaria = cursosabiertos.Capacitacion_PersonalPermitidoAsignaturaComplementaria.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true && ctasignaturascomplementariatrabajador.Contains(f.IdAsignaturaComplementaria)).Select(r => r.IdConvocatoriaCursos);

                var PersonalPermitidoRelacionConvenioLaboral = cursosabiertos.Capacitacion_PersonalPermitidoRelacionConvenioLaboral.Where(f => f.Capacitacion_stConvocatoriasCursos.Capacitacion_stConvocatoria.PublicarEnWeb == true && f.IdRelacionConvenioLaboral == IdtrabajadorWM.IdRelacionConvenioLaboral).Select(r => r.IdConvocatoriaCursos);

                //      List<Capacitacion_stConvocatoriasCursos> repositoriocursos = new List<Capacitacion_stConvocatoriasCursos>();


                //   var cursos1 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true
                // && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                //&& PersonalPermitidoAreaConocimiento.Contains(v.IdConvocatoriaCursos))
                // .ToList();

                //   var cursos2 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                //      && PersonalPermitidoCategoria.Contains(v.IdConvocatoriaCursos))
                //       .ToList();

                //   var cursos3 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                //      && PersonalPermitidoEstructuraOrganica.Contains(v.IdConvocatoriaCursos))
                //       .ToList();

                //   var cursos4 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                //      && PersonalPermitidoRelacionlaboral.Contains(v.IdConvocatoriaCursos))
                //       .ToList();

                //   var cursos5 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                //      && PersonalPermitidoConveniolaboral.Contains(v.IdConvocatoriaCursos))
                //       .ToList();
                List<Capacitacion_stConvocatoriasCursos> cursos1 = new List<Capacitacion_stConvocatoriasCursos>();

                //if (PersonalPermitidoAreaConocimiento!=null)
                cursos1 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true
                   && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                  && PersonalPermitidoAreaConocimiento.Contains(v.IdConvocatoriaCursos)

                  )
                   .ToList();

                List<Capacitacion_stConvocatoriasCursos> cursos8 = new List<Capacitacion_stConvocatoriasCursos>();
                cursos8 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true
                && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
               && PersonalPermitidoCarreras.Contains(v.IdConvocatoriaCursos)

               )
                .ToList();


                var cursos2 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                   && PersonalPermitidoCategoria.Contains(v.IdConvocatoriaCursos))
                    .ToList();

                var cursos3 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                   && PersonalPermitidoEstructuraOrganica.Contains(v.IdConvocatoriaCursos))
                    .ToList();

                var cursos4 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                   && PersonalPermitidoRelacionlaboral.Contains(v.IdConvocatoriaCursos))
                    .ToList();

                var cursos5 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                   && PersonalPermitidoConveniolaboral.Contains(v.IdConvocatoriaCursos))
                    .ToList();

                var cursos9 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                   && PersonalPermitidoAsignaturas.Contains(v.IdConvocatoriaCursos))
                    .ToList();

                var cursos10 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                  && PersonalPermitidoRelacionConvenioLaboral.Contains(v.IdConvocatoriaCursos))
                   .ToList();

                var cursos11 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
             && PersonalPermitidoAsignaturasComplementaria.Contains(v.IdConvocatoriaCursos))
              .ToList();

                var cursos12 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true
                && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
             && trabajadoresPermitidosCursos.Contains(v.IdConvocatoriaCursos)).ToList();

                List<Capacitacion_stConvocatoriasCursos> cursos6 = new List<Capacitacion_stConvocatoriasCursos>();

                if (tienecomplementarias.Count > 0)
                {
                    cursos6 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                      && PersonalPermitidoComplementarias.Contains(v.IdConvocatoriaCursos))
                       .ToList();
                }

                List<Capacitacion_stConvocatoriasCursos> cursos7 = new List<Capacitacion_stConvocatoriasCursos>();

                if (tieneasesorias.Count > 0)
                {
                    cursos7 = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true && hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                      && PersonalPermitidoAsesorias.Contains(v.IdConvocatoriaCursos))
                       .ToList();
                }

                //  var cursostotales = repositoriocursos.Select(r => r.IdConvocatoriaCursos).ToList();

                List<Capacitacion_stConvocatoriasCursos> cursos = cursosabiertos.Capacitacion_stConvocatoriasCursos.Where(v => v.Capacitacion_stConvocatoria.PublicarEnWeb == true &&
                    hoy >= v.Capacitacion_stConvocatoria.FechaInicioConvocatoria && hoy <= v.Capacitacion_stConvocatoria.FechaTerminoConvocatoria
                    && !(cursosabiertos.Capacitacion_PersonalPermitidoAreaConocimiento.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                    && !(cursosabiertos.Capacitacion_PersonalPermitidoCategoria.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                    && !(cursosabiertos.Capacitacion_PersonalPermitidoEstructuraOrganica.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                    && !(cursosabiertos.Capacitacion_PersonalPermitidoRelacionLaboral.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                    && !(cursosabiertos.Capacitacion_PersonalPermitidoConvenioLaboral.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                    && !(cursosabiertos.Capacitacion_PersonalPermitidoComplementaria.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                           && !(cursosabiertos.Capacitacion_PersonalPermitidoAsesoria.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                               && !(cursosabiertos.Capacitacion_PersonalPermitidoCarrera.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                               && !(cursosabiertos.Capacitacion_PersonalPermitidoAsignatura.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                               && !(cursosabiertos.Capacitacion_PersonalPermitidoAsignaturaComplementaria.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                               && !(cursosabiertos.Capacitacion_PersonalPermitidoRelacionConvenioLaboral.Select(b => b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                               && !(cursosabiertos.Capacitacion_PersonalPermitidoCursos.Select(b=>b.IdConvocatoriaCursos).Contains(v.IdConvocatoriaCursos))
                    )
                   .ToList();




                //List<Capacitacion_stConvocatoriasCursos> cursosOriginales = cursos;

                List<Capacitacion_stConvocatoriasCursos> consultaInterseccion1 = new List<Capacitacion_stConvocatoriasCursos>();

                List<Capacitacion_stConvocatoriasCursos> consultaOriginal = new List<Capacitacion_stConvocatoriasCursos>();

                consultaInterseccion1.AddRange(cursos1);
                consultaInterseccion1.AddRange(cursos2);
                consultaInterseccion1.AddRange(cursos3);
                consultaInterseccion1.AddRange(cursos4);
                consultaInterseccion1.AddRange(cursos5);
                consultaInterseccion1.AddRange(cursos6);
                consultaInterseccion1.AddRange(cursos7);
                consultaInterseccion1.AddRange(cursos8);
                consultaInterseccion1.AddRange(cursos9);

                consultaInterseccion1.AddRange(cursos10);
                consultaInterseccion1.AddRange(cursos11);
                consultaInterseccion1.AddRange(cursos12);



                consultaOriginal.AddRange(consultaInterseccion1);

                foreach (var item in consultaInterseccion1)
                {
                    //int totalrestricciones = cursosabiertos.Capacitacion_PersonalPermitidoAreaConocimiento.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    //int totalrestricciones2 = cursosabiertos.Capacitacion_PersonalPermitidoCategoria.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos && h.IdCategoria == IdCategoria).Count();
                    //int totalrestricciones3 = cursosabiertos.Capacitacion_PersonalPermitidoConvenioLaboral.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos && h.IdConvenioLaboral == IdConvenioLaboral).Distinct().Count();
                    //int totalrestricciones4 = cursosabiertos.Capacitacion_PersonalPermitidoEstructuraOrganica.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos && h.IdEstructuraOrganica == IdEstructuraOrganica).Count();
                    //int totalrestricciones5 = cursosabiertos.Capacitacion_PersonalPermitidoRelacionLaboral.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos && h.IdRelacionLaboral == IdRelacionLaboral).Count();
                    //int totalrestricciones6 = cursosabiertos.Capacitacion_PersonalPermitidoComplementaria.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).Count();
                    //int totalrestricciones7 = cursosabiertos.Capacitacion_PersonalPermitidoAsesoria.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).Count();
                    //int totalrestricciones8 = cursosabiertos.Capacitacion_PersonalPermitidoCarrera.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).Count();

                    int totalrestricciones = cursosabiertos.Capacitacion_PersonalPermitidoAreaConocimiento.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones2 = cursosabiertos.Capacitacion_PersonalPermitidoCategoria.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones3 = cursosabiertos.Capacitacion_PersonalPermitidoConvenioLaboral.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones4 = cursosabiertos.Capacitacion_PersonalPermitidoEstructuraOrganica.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones5 = cursosabiertos.Capacitacion_PersonalPermitidoRelacionLaboral.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones6 = cursosabiertos.Capacitacion_PersonalPermitidoComplementaria.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones7 = cursosabiertos.Capacitacion_PersonalPermitidoAsesoria.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones8 = cursosabiertos.Capacitacion_PersonalPermitidoCarrera.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones9 = cursosabiertos.Capacitacion_PersonalPermitidoAsignatura.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();

                    int totalrestricciones10 = cursosabiertos.Capacitacion_PersonalPermitidoRelacionConvenioLaboral.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones11 = cursosabiertos.Capacitacion_PersonalPermitidoAsignaturaComplementaria.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();
                    int totalrestricciones12 = cursosabiertos.Capacitacion_PersonalPermitidoCursos.Where(h => h.IdConvocatoriaCursos == item.IdConvocatoriaCursos).GroupBy(y => y.IdConvocatoriaCursos).Count();

                    int total = totalrestricciones + totalrestricciones2 + totalrestricciones3 + totalrestricciones4 + totalrestricciones5 + totalrestricciones6 + totalrestricciones7 + totalrestricciones8 + totalrestricciones9 + totalrestricciones10+ totalrestricciones11+ totalrestricciones12;
                    if (total > 0)
                        if (consultaInterseccion1.Where(g => g.IdConvocatoriaCursos == item.IdConvocatoriaCursos).Count() < total)
                            consultaOriginal.Remove(item);



                }

                cursos.AddRange(consultaOriginal);
                List<Capacitacion_stConvocatoriasCursos> cursoslistos = new List<Capacitacion_stConvocatoriasCursos>();
                var distintos = cursos.Select(t => t.IdConvocatoriaCursos).Distinct().ToList();

                foreach (int value in distintos)
                {
                    Capacitacion_stConvocatoriasCursos elem = cursos.Where(f => f.IdConvocatoriaCursos == value).FirstOrDefault();
                    cursoslistos.Add(elem);
                }


                //cursos.Union(cursos2);
                //cursos.Union(cursos3);
                //cursos.Union(cursos4);
                //cursos.Union(cursos5);

                //List<Capacitacion_stConvocatoriasCursos> consultaInterseccion1 = new List<Capacitacion_stConvocatoriasCursos>();
                //List<Capacitacion_stConvocatoriasCursos> consultaInterseccion2 = new List<Capacitacion_stConvocatoriasCursos>();
                //List<Capacitacion_stConvocatoriasCursos> consultaInterseccion3 = new List<Capacitacion_stConvocatoriasCursos>();
                //List<Capacitacion_stConvocatoriasCursos> consultaInterseccion4 = new List<Capacitacion_stConvocatoriasCursos>();
                //List<Capacitacion_stConvocatoriasCursos> consultaInterseccion5 = new List<Capacitacion_stConvocatoriasCursos>();

                //if (cursos1.Count>0)
                //{
                //    if (cursos2.Count>0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos1.Intersect(cursos2);
                //        if (interseccion1!=null)
                //            consultaInterseccion1.AddRange(interseccion1);
                //    }

                //    if (cursos3.Count>0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos1.Intersect(cursos3);
                //        if (interseccion1!=null)
                //            consultaInterseccion1.AddRange(interseccion1);
                //    }

                //    if (cursos4.Count>0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos1.Intersect(cursos4);
                //        if (interseccion1!=null)
                //            consultaInterseccion1.AddRange(interseccion1);
                //    }

                //    if (cursos5.Count>0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos1.Intersect(cursos5);
                //        if (interseccion1!=null)
                //            consultaInterseccion1.AddRange(interseccion1);
                //    }

                //}


                //if (cursos2.Count > 0)
                //{
                //    if (cursos3.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos2.Intersect(cursos3);
                //        if (interseccion1 != null)
                //            consultaInterseccion2.AddRange(interseccion1);
                //    }

                //    if (cursos4.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos2.Intersect(cursos4);
                //        if (interseccion1 != null)
                //            consultaInterseccion2.AddRange(interseccion1);
                //    }

                //    if (cursos5.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos2.Intersect(cursos5);
                //        if (interseccion1 != null)
                //            consultaInterseccion2.AddRange(interseccion1);
                //    }

                //    if (cursos1.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos2.Intersect(cursos1);
                //        if (interseccion1 != null)
                //            consultaInterseccion2.AddRange(interseccion1);
                //    }

                //}


                //if (cursos3.Count > 0)
                //{
                //    if (cursos1.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos3.Intersect(cursos1);
                //        if (interseccion1 != null)
                //            consultaInterseccion3.AddRange(interseccion1);
                //    }

                //    if (cursos4.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos3.Intersect(cursos4);
                //        if (interseccion1 != null)
                //            consultaInterseccion3.AddRange(interseccion1);
                //    }

                //    if (cursos5.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos3.Intersect(cursos5);
                //        if (interseccion1 != null)
                //            consultaInterseccion3.AddRange(interseccion1);
                //    }

                //    if (cursos2.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos3.Intersect(cursos2);
                //        if (interseccion1 != null)
                //            consultaInterseccion3.AddRange(interseccion1);
                //    }

                //}


                //if (cursos4.Count > 0)
                //{
                //    if (cursos1.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos4.Intersect(cursos1);
                //        if (interseccion1 != null)
                //            consultaInterseccion4.AddRange(interseccion1);
                //    }

                //    if (cursos3.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos4.Intersect(cursos3);
                //        if (interseccion1 != null)
                //            consultaInterseccion4.AddRange(interseccion1);
                //    }

                //    if (cursos5.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos4.Intersect(cursos5);
                //        if (interseccion1 != null)
                //            consultaInterseccion4.AddRange(interseccion1);
                //    }

                //    if (cursos2.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos4.Intersect(cursos2);
                //        if (interseccion1 != null)
                //            consultaInterseccion4.AddRange(interseccion1);
                //    }

                //}

                //if (cursos5.Count > 0)
                //{
                //    if (cursos1.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos5.Intersect(cursos1);
                //        if (interseccion1 != null)
                //            consultaInterseccion5.AddRange(interseccion1);
                //    }

                //    if (cursos3.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos5.Intersect(cursos3);
                //        if (interseccion1 != null)
                //            consultaInterseccion5.AddRange(interseccion1);
                //    }

                //    if (cursos4.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos5.Intersect(cursos4);
                //        if (interseccion1 != null)
                //            consultaInterseccion5.AddRange(interseccion1);
                //    }

                //    if (cursos2.Count > 0)
                //    {
                //        var interseccion1 = (List<Capacitacion_stConvocatoriasCursos>)cursos5.Intersect(cursos2);
                //        if (interseccion1 != null)
                //            consultaInterseccion5.AddRange(interseccion1);
                //    }

                //}

                //cursosOriginales.Union(consultaInterseccion1);
                //cursosOriginales.Union(consultaInterseccion2);
                //cursosOriginales.Union(consultaInterseccion3);
                //cursosOriginales.Union(consultaInterseccion4);
                //cursosOriginales.Union(consultaInterseccion5);



                var sedes = db.Capacitacion_stConvocatoriasCursosSedesAulas.Select(b => b.IdConvocatoriaCursos);

                var cursofinales = cursoslistos.Where(v => sedes.Contains(v.IdConvocatoriaCursos)).ToList();
                return (List<Capacitacion_stConvocatoriasCursos>)cursofinales;
            }
               else
                return  new List<Capacitacion_stConvocatoriasCursos>();

        }

        public static string DirigidoA(int IdConvocatoriaCursos)
        {
            string resultado = "Todo el personal";
            bdNovaEntities db = new bdNovaEntities();
            bdAriesEntities dbAries = new bdAriesEntities();

            var dirigoarea = db.Capacitacion_PersonalPermitidoAreaConocimiento.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).Select(l => l.IdAreaConocimiento).ToList();
            IEnumerable<string> arr_areas = dbAries.ctAreaConocimiento.Where(n => dirigoarea.Contains(n.IdAreaConocimiento)).Select(h => h.Nombre).ToArray();
            string areas = string.Join<string>(",", arr_areas);
            if (areas.Length > 0)
            {
                areas = "Docentes con áreas de conococimiento: " + areas;
            }

            var dirigocategorias = db.Capacitacion_PersonalPermitidoCategoria.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).Select(l => l.IdCategoria).ToList();
            IEnumerable<string> arr_categorias = db.Plazas_ctCategoria.Where(n => dirigocategorias.Contains(n.IdCategoria)).Select(h => h.Categoria).ToArray();
            string categorias = string.Join<string>(",", arr_categorias);
            if (categorias.Length > 0)
            {
                categorias = " Personal con las siguientes categorías: " + categorias;
            }

            var dirigoEstructuraOrganica = db.Capacitacion_PersonalPermitidoEstructuraOrganica.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).Select(l => l.IdEstructuraOrganica).ToList();
            IEnumerable<string> arr_EstructuraOrganica = db.Catalogos_ctEstructuraOrganica.Where(n => dirigoEstructuraOrganica.Contains(n.IdEstructuraOrganica)).GroupBy(r => r.EstructuraOrganica).Select(h => h.Key).Take(3).ToArray();
            string EstructuraOrganica = string.Join<string>(",", arr_EstructuraOrganica);
            if (EstructuraOrganica.Length > 0)
            {
                EstructuraOrganica = " Personal adscrito a: " + EstructuraOrganica+" ...";
            }

            var dirigoConvenioLaboral = db.Capacitacion_PersonalPermitidoConvenioLaboral.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).Select(l => l.IdConvenioLaboral).ToList();
            IEnumerable<string> arr_convenio = db.Capacitacion_PersonalPermitidoConvenioLaboral.Where(n => dirigoConvenioLaboral.Contains(n.IdConvenioLaboral)).GroupBy(r => r.Catalogos_ctConvenioLaboral.ConvenioLaboral).Select(h => h.Key).ToArray();
            string convenio = string.Join<string>(",", arr_convenio);
            if (convenio.Length > 0)
            {
                convenio = " Convenio Laboral : " + convenio;
            }


            var dirigoRelacionLaboral = db.Capacitacion_PersonalPermitidoRelacionLaboral.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).Select(l => l.IdRelacionLaboral).ToList();
            IEnumerable<string> arr_RelacionLaboral = db.Catalogos_ctRelacionLaboral.Where(n => dirigoRelacionLaboral.Contains(n.IdRelacionLaboral)).GroupBy(r => r.RelacionLaboral).Select(h => h.Key).ToArray();
            string RelacionLaboral = string.Join<string>(",", arr_RelacionLaboral);
            if (RelacionLaboral.Length > 0)
            {
                RelacionLaboral = " Personal de base: " + RelacionLaboral;
            }


            var dirigoComplementarias = db.Capacitacion_PersonalPermitidoComplementaria.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).ToList();
            string Complementarias = "";
            if (dirigoComplementarias.Count > 0)
            {
                Complementarias = " Personal con Asignaturas Complementarias ";
            }

            var dirigoAsesoria = db.Capacitacion_PersonalPermitidoAsesoria.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).ToList();
            string Asesoria = "";
            if (dirigoAsesoria.Count > 0)
            {
                Asesoria = " Personal con Asesorías ";
            }





            var dirigoCarrera = db.Capacitacion_PersonalPermitidoCarrera.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).Select(g => g.IdCarrera).ToList();
            IEnumerable<string> arr_Carrera = dbAries.ctCarrera.Where(n => dirigoCarrera.Contains(n.IdCarrera)).Select(h => h.Nombre).ToArray();
            string Carrera = string.Join<string>(",", arr_Carrera);


            if (Carrera.Length > 0)
            {
                Carrera = " Personal de las siguientes carreras : " + Carrera;
            }


            var dirigoAsignatura = db.Capacitacion_PersonalPermitidoAsignatura.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).Select(g => g.IdAsignatura).ToList();
            IEnumerable<string> arr_Asignatura = dbAries.ctAsignatura.Where(n => dirigoAsignatura.Contains(n.IdAsignatura)).Select(h => h.Nombre).ToArray();
            string Asignatura = string.Join<string>(",", arr_Asignatura);


            if (Asignatura.Length > 0)
            {
                Asignatura = " Personal que imparten las siguientes asignaturas: " + Asignatura;
            }


            var dirigoAsignaturaComplementaria = db.Capacitacion_PersonalPermitidoAsignaturaComplementaria.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).Select(g => g.IdAsignaturaComplementaria).ToList();
            IEnumerable<string> arr_AsignaturaComplementaria = dbAries.ctAsignaturaComplementaria.Where(n => dirigoAsignatura.Contains(n.IdAsignaturaComplementaria)).Select(h => h.Nombre).ToArray();
            string AsignaturaComplementaria = string.Join<string>(",", arr_Asignatura);


            if (AsignaturaComplementaria.Length > 0)
            {
                AsignaturaComplementaria = " Personal que imparten las siguientes asignaturas complementarias: " + AsignaturaComplementaria;
            }




            var dirigoRcl = db.Capacitacion_PersonalPermitidoRelacionConvenioLaboral.Where(v => v.IdConvocatoriaCursos == IdConvocatoriaCursos).Select(g => g.IdRelacionConvenioLaboral).ToList();
            IEnumerable<string> arr_RCL = db.Convenios_stRelacionConvenioLaboral.Where(n => dirigoRcl.Contains(n.IdRelacionConvenioLaboral)).GroupBy(r => r.RelacionConvenioLaboral).Select(h => h.Key).ToArray();

            string RCL = string.Join<string>(",", arr_RCL);


            if (RCL.Length > 0)
            {
                RCL = " Personal : " + RCL;
            }

            IEnumerable<string> dirigidoPersonalAutorizado = db.Capacitacion_PersonalExcluidoConvocactoriaCursos.Where(c => c.IdConvocatoriaCursos == IdConvocatoriaCursos).GroupBy(r => r.Mensaje).Select(h => h.Key).ToArray();

            string _personalautorizado = string.Join<string>(",", dirigidoPersonalAutorizado);

            if (_personalautorizado.Length > 0)
                _personalautorizado = " Personal con cursos anteriroes : " + _personalautorizado;

            if (areas.Length + categorias.Length + EstructuraOrganica.Length + RelacionLaboral.Length + convenio.Length + Complementarias.Length + Asesoria.Length + Carrera.Length+ Asignatura.Length +RCL.Length > 0 + _personalautorizado.Length)
            {
                resultado = areas + categorias + EstructuraOrganica + RelacionLaboral + convenio + Complementarias + Asesoria + Carrera+Asignatura+RCL+_personalautorizado;
            }

            
            return resultado;

        }

        public static int Inscritos(Int64 IdConvocatoriasCursosSedesAulas)
        {

            bdNovaEntities db = new bdNovaEntities();


            return db.Capacitacion_stParticipantes.Where(v => v.IdConvocatoriaCursosSedesAulas == IdConvocatoriasCursosSedesAulas &&
                v.EsCanceladoPorAdministrador == false).ToList().Count();



        }

        public static IEnumerable getCursos()
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Capacitacion_stConvocatoriasCursos.OrderByDescending(r => new { r.Capacitacion_stConvocatoria.FechaInicioConvocatoria, r.FechaInicioCurso }).ToList();
        }

        public static IEnumerable getCoordinadores()
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Capacitacion_ctCoordinadores.OrderBy(h => new { h.Kardex_ctDatosPersonales.ApellidoPaterno, h.Kardex_ctDatosPersonales.ApellidoMaterno, h.Kardex_ctDatosPersonales.Nombre }).ToList();
        }

        public static IEnumerable getAulas()
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Capacitacion_stAulaSede.OrderBy(r => new { r.Capacitacion_ctSede.Sede, r.Aula }).ToList();
        }
    }
}
