﻿using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using Nova.Validation;


namespace Nova.Models
{
     [MetadataType(typeof(Capacitacion_ctEmpresaMetaData))]
    public partial class Capacitacion_ctEmpresa
    {
    }
     public class Capacitacion_ctEmpresaMetaData
     {
         [Required]
         public string Empresa { get; set; }
         [Required]
         public string Direccion { get; set; }
         [Required]
         [RegularExpression(@"\d+", ErrorMessage = "Solo introduzca números.")]
         public string Telefono { get; set; }
         [Required]
         public string Contacto { get; set; }
         [Required]
         public string CorreoElectronico { get; set; }
         [Required]
         public string RFC { get; set; }
         [Required]
         [RegularExpression(@"\d{5}", ErrorMessage = "Solo introduzca solo 5 números.")]
         public string CodigoPostal { get; set; }
         [Required]
         public string ActividadPreponderante { get; set; }
         [Required]
         [RegularExpression(@"^[a-zA-Z_áéíóúñ\s]*$", ErrorMessage = "Solo introduzca letras.")]
         public string Estado { get; set; }
         [Required]
         [RegularExpression(@"^[a-zA-Z_áéíóúñ\s]*$", ErrorMessage = "Solo introduzca letras.")]
         public string Ciudad { get; set; }




     }

}