﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models
{
    public partial class Capacitacion_stConvocatoriasCursos : ValidacionModelos
    {
        public override ResultadoValidacion ValidaModelo()
        {
            bdNovaEntities bd = new bdNovaEntities();

            if (FechaInicioCurso <= bd.Capacitacion_stConvocatoria.Where(y=> y.IdConvocatoria==IdConvocatoria).Select(t=> t.FechaTerminoConvocatoria).FirstOrDefault())
                {
                    parenresult.IsValid = false;
                    parenresult.Mensaje = "La fecha de inicio del curso debe ser mayor que la fecha de término de la convocatoria";
                }



            return parenresult;

        }

        public static IEnumerable ObtenConvocatorias()
        {
            bdNovaEntities db = new bdNovaEntities();

            return db.Capacitacion_stConvocatoria.Select(h =>

                new
                {
                    h.IdConvocatoria,
                    Convoca = h.Convocatoria,
                    FechaInicio = h.FechaInicioConvocatoria,
                    FechaTermino = h.FechaTerminoConvocatoria,
                }).OrderByDescending(x=>x.FechaInicio).ToList().Select(h =>
                    new
                    {
                        h.IdConvocatoria,
                        Convocatoria = h.Convoca + "(" + h.FechaInicio.ToShortDateString() + "-" + h.FechaTermino.ToShortDateString() + ")"
                    });


        }
        public static IEnumerable ObtenCursos()
        {
            bdNovaEntities db = new bdNovaEntities();


            return  db.Capacitacion_ctCurso.Select(h =>

                new
                {
                    h.IdCurso,
                    Curso = h.Curso ,
                }).ToList().Select(h => 
                    new 
                    {
                      h.IdCurso,
                      Curso = h.Curso
                    });


        }

    }
}